/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef FRAMECONSUMER_H
#define FRAMECONSUMER_H

#include <string>
#include <map>

#include "liveMedia.hh"
#include "c_ptr.h"
#include "Timeval.h"
#include "MediaStreamHandler.h"

namespace videonext { namespace media {

class AudioVideoPlaybackController;

class FrameConsumer: public MediaSink {
public:
    
    FrameConsumer(UsageEnvironment& env, 
                  AudioVideoPlaybackController *c,
                  unsigned bufferSize,
                  unsigned decoderType,
                  StreamInfo *streamInfo);
    
    virtual ~FrameConsumer();
    
   /**
    * Init consumer. Must be called always after create object   
    * @return false if some kinds of errors was occured     
    */
    virtual bool init() = 0;
  
    /**
     * Clear current state. 
     */
    virtual void clear() {}

    /**
     * Decode (if neeeded) and display/play media frame
     * @param cpVideoFrame 
    */  
    virtual void playFrame(CPMediaFrame &cpMediaFrame, bool show) = 0;
    

    virtual void addData(unsigned char* data, unsigned dataSize,
                         const struct timeval &presentationTime,
                         bool parseOurHeader = true, const std::string* pObjectsData = nullptr);

    virtual void addExtraData(unsigned char* data, unsigned dataSize) {}

    void addData(CPMediaFrame &cpMediaFrame);

    virtual Boolean startPlaying(MediaSource& source,
                                 afterPlayingFunc* afterFunc,
                                 void* afterClientData);

protected:
        
    static void afterGettingFrame(void* clientData, unsigned frameSize,
                                  unsigned numTruncatedBytes,
                                  struct timeval presentationTime,
                                  unsigned durationInMicroseconds);
    
    void afterGettingFrame1(unsigned frameSize,
                            struct timeval presentationTime);
    
    virtual Boolean continuePlaying();
    
     /**
     * Assume 0 - I-frame...
     * @param frameType 
     */
    virtual void setFrameType(CPMediaFrame &cpMediaFrame) = 0;
        
 

protected:
 
   AudioVideoPlaybackController *fPlaybackController;
   unsigned char* fBuffer;
   unsigned fBufferSize;

   unsigned long fLastFrameNum;

   StreamInfo *fStreamInfo;
   unsigned fDecoderType;

protected:
    videonext::media::DelayInterval fRTPTimeDiff;
    bool fRTPTimeDiffPlus;

protected:
    RTPSource *fRtpSource;
        
};

}}
#endif

