/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef AUDIOFRAMECONSUMER_H
#define AUDIOFRAMECONSUMER_H

#include "neaacdec.h"

#include "liveMedia.hh"
#include "c_ptr.h"
#include "FrameConsumer.h"

namespace videonext { namespace media {

class AudioFrameConsumer: public FrameConsumer {
public:
  static AudioFrameConsumer* createNew(UsageEnvironment& env, 
                                       AudioVideoPlaybackController *controller,
                                       unsigned bufferSize,
                                       unsigned decoderType,
                                       StreamInfo *streamInfo);

   virtual bool init();
  

   virtual void addData(unsigned char* data, unsigned dataSize,
                        const struct timeval &presentationTime,
                        bool parseOurHeader = true, const std::string* pObjectsData = nullptr);

 
protected:
  AudioFrameConsumer(UsageEnvironment& env, 
                     AudioVideoPlaybackController *controller,
                     unsigned bufferSize,
                     unsigned decoderType,
                     StreamInfo *streamInfo);

      // called only by createNew()
  virtual ~AudioFrameConsumer();

  
  
protected:
   /**
    * Just play raw PCM data
    * @param cpMediaFrame 
    */  
    virtual void playFrame(CPMediaFrame &, bool show);
    
    virtual void setFrameType(CPMediaFrame &);
    
  
private:
  uint8_t* findHeader(uint8_t* data, unsigned dataSize);

private:
    NeAACDecHandle fDecoder;
    unsigned char *fSamplesBuf; 
   
};

}}

#endif

