#ifndef _VN_JSON_H_
#define _VN_JSON_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* Types: */
#define VN_JSON_FALSE  0
#define VN_JSON_TRUE   1
#define VN_JSON_NULL   2
#define VN_JSON_NUMBER 3
#define VN_JSON_STRING 4
#define VN_JSON_ARRAY  5
#define VN_JSON_OBJECT 6
	
typedef void vn_json_t;

vn_json_t *vn_json_parse(const char *value);

char *vn_json_print(vn_json_t *item);

void vn_json_destroy(vn_json_t *js);

int vn_json_get_type(vn_json_t *item);

int vn_json_get_array_size(vn_json_t *array);

vn_json_t *vn_json_get_array_item(vn_json_t *array, int item);

vn_json_t *vn_json_get_object_item(vn_json_t *object, const char *string);

vn_json_t *vn_json_next(vn_json_t *item);

vn_json_t *vn_json_prev(vn_json_t *item);

vn_json_t *vn_json_child(vn_json_t *item);

char *vn_json_get_name(vn_json_t *item);

char *vn_json_get_string(vn_json_t *item);

int vn_json_get_int(vn_json_t *item);

double vn_json_get_double(vn_json_t *item);


#ifdef __cplusplus
}
#endif


#endif /* _VN_JSON_H_ */
