/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 06/11/2014
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/
#ifndef _STREAMSTATS_H_
#define _STREAMSTATS_H_

#include "AdaptiveUsageEnvironment.h" 
#include "MediaStreamHandler.h" 

namespace videonext { namespace media {

class StreamStats
{
public:
    StreamStats(UsageEnvironment& env, RTPSource &rtpSource, StreamInfo &streamInfo,
                MediaStreamHandler &mediaStreamHandler);
    virtual ~StreamStats();

private:
    static void updateStatsTask(void* );
    void updateStats();                                                                                                 
    
private:
    UsageEnvironment &fEnv;
    RTPSource &fRtpSource;
    StreamInfo &fStreamInfo;
    MediaStreamHandler &fMediaStreamHandler;
    TaskToken fUpdateStatsTask;

private:
    int fPrevNumPacketsReceived;
    int fPrevNumPacketsLost;
    float fPrevNumKBytesReceived;
    struct timeval fPrevStatsTime;
};

}}


#endif /* _STREAMSTATS_H_ */
