/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 09/18/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef NET_IO_H                                                                                            
#define NET_IO_H

#include "osdep.h"
#include "MediaObjects.h"

namespace videonext { namespace media {


struct ResultStatus; // forward

int connect_socket(ResultStatus *result, const std::string &host, int port);

int recvline(int fd, char *vptr, int maxlen);

/** 
 * Performs HTTP GET request
 * 
 * @param request GET restring. Ex: "/login.php?username=123"
 * @param headers [in] headers to send 
 * @param sessionID [in][out] If not empty inserts in request, otherwise will be filled 
 * @param outputData [out] if not NULL store response data (w/o headers)
 * 
 */
void performHTTPGET(ResultStatus *result,
                    const std::string &host,
                    unsigned port,
                    const std::string &request, 
                    const DynaParams  *headers,
                    std::string *sessionID, 
                    std::string *outputData);


}}

#endif // NET_IO_H
