/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef VN_MEDIA_STREAM_PRODUCER_IMPL_H_
#define VN_MEDIA_STREAM_PRODUCER_IMPL_H_

#include <map>
#include "MediaStreamHandler.h"

namespace videonext { namespace media {    

class MediaStreamProducerImpl
{
public:
   MediaStreamProducerImpl(MediaStreamHandler *mediaStreamHandler, const std::string &url, 
                           unsigned cacheSize, unsigned streamId, bool streamOverTCP, unsigned bufferLen) 
        : url_(url), cacheSize_(cacheSize), streamOverTCP_(streamOverTCP), 
          playDirection_(0), mediaStreamHandler_(mediaStreamHandler), streamId_(streamId),
          decoderType_(0), serverVersion_(0), bufferLen_(bufferLen)
   {}
   
   virtual ~MediaStreamProducerImpl() {}

   virtual void open() = 0;

   virtual void play() = 0;

   virtual void pause() = 0;
    
   virtual void teardown() = 0;    

   virtual void setPlayDirection(int) = 0;
   
   virtual void setStepMode(bool) = 0;

   virtual void setSpeed(float) = 0;

   virtual void setJitterBufferLen(unsigned) = 0;
    
   virtual void jumpToTimestamp(int value, bool mark = true) = 0;

   virtual void moveToTimestamp(time_t) = 0;

   virtual void enableDecoding(unsigned type, PIXEL_FORMAT preferedPixelFormat) 
   {
      decoderType_ = type;
      preferedPixelFormat_ = preferedPixelFormat;
   }

   virtual void changeState(STREAM_STATE, int=0) = 0;

   virtual bool isPlayingArchive() = 0;

   virtual bool isStepMode() = 0;

   virtual void noteLiveness() {};

   virtual bool startRecording(const char* file_name, const std::map<std::string, std::string>& metadata) = 0;

   virtual bool endRecording() = 0;

public:

   unsigned serverVersion() {return serverVersion_;}

protected:
   std::string url_;
   unsigned cacheSize_;
   bool streamOverTCP_;    
   int playDirection_;
   MediaStreamHandler *mediaStreamHandler_;
   unsigned streamId_;
   unsigned decoderType_;
   PIXEL_FORMAT preferedPixelFormat_;
   unsigned serverVersion_;
   unsigned bufferLen_;
};

}}

#endif /*MEDIASTREAMPRODUCERIMPL_H_*/

