#ifndef VN_HTTP_MEDIA_STREAM_PRODUCER_IMPL_H_
#define VN_HTTP_MEDIA_STREAM_PRODUCER_IMPL_H_

#include "MediaStreamProducerImpl.h" 
#include "AdaptiveUsageEnvironment.h" 
#include "VideoFrameConsumer.h"
#include "AudioFrameConsumer.h"
#include <map>

namespace videonext { namespace media {

/**
 * HTTP media producer
 */
class HTTPMediaStreamProducerImpl : public MediaStreamProducerImpl
{
public:
   HTTPMediaStreamProducerImpl(MediaStreamHandler *mediaStreamHandler, const std::string &url, 
                               unsigned cacheSize, unsigned streamId);

   virtual ~HTTPMediaStreamProducerImpl();

public:

   // Redefined virtual functions
   virtual void open();

   virtual void play();

   virtual void pause() {}
    
   virtual void setStepMode(bool value) {}    

   virtual void setPlayDirection(int value) {}

   virtual void changeState(STREAM_STATE, int errorCode = 0);

   virtual void moveToTimestamp(time_t time) { jumpToTimestamp(time); }

   virtual void teardown() {stopped_ = true;}

   virtual void jumpToTimestamp(int value, bool mark = true) {};

   virtual void setSpeed(float speed) {}

   virtual void setJitterBufferLen(unsigned) {}
    
   virtual bool isPlayingArchive() { return false; }

   virtual bool isStepMode() { return false; }

   virtual bool startRecording(const char* file_name, const std::map<std::string, std::string>& metadata);

   virtual bool endRecording();

private:
    int  read_jpg(FILE*, uint8_t*, uint32_t);
    void receive_mjpg(int socket);


private:
   UsageEnvironment* env_;
   TaskScheduler* scheduler_;

   STREAM_STATE previousState_;

   bool stopped_;

   FrameConsumer *frameSink_; 
   AudioVideoPlaybackController *playbackController_;


};

}}


#endif /*VN_HTTP_MEDIA_STREAM_PRODUCER_IMPL_H_*/

