/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef _ADAPTIVE_USAGE_ENVIRONMENT_HH
#define _ADAPTIVE_USAGE_ENVIRONMENT_HH

/**
 * Extended BasicUsageEnvironment from live555
*/

#include "MediaStreamHandler.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#include "BasicUsageEnvironment0.hh"
#pragma GCC diagnostic pop

namespace videonext { namespace media {

class AdaptiveUsageEnvironment: public BasicUsageEnvironment0 {
public:
   static AdaptiveUsageEnvironment* createNew(TaskScheduler& taskScheduler, MediaStreamHandler *mediaStreamHandler);
   virtual ~AdaptiveUsageEnvironment();
  
   // redefined virtual functions:
   virtual int getErrno() const;

   virtual void setResultErrMsg(MsgString msg);

   virtual void reportBackgroundError();

   virtual UsageEnvironment& operator<<(char const* str);
   virtual UsageEnvironment& operator<<(int i);
   virtual UsageEnvironment& operator<<(unsigned u);
   virtual UsageEnvironment& operator<<(double d);
   virtual UsageEnvironment& operator<<(void* p);

public:
    void log(const char *msg, ...); 

    
protected:
    AdaptiveUsageEnvironment(TaskScheduler& taskScheduler, MediaStreamHandler *mediaStreamHandler);
      // called only by "createNew()" (or subclass constructors)

private:
   void log_i(MsgString msg); 
 
private:
   MediaStreamHandler *mediaStreamHandler_;
};

}}

#endif
