const {spawn} = require("child_process");
const {API} = require('./api');
const {Auth} = require('./auth');

// code page on windows can be differ from utf-8, then run "chcp 65001" in cmd before calling this scripts

const server = "dev1.videonext.net";
const username = "user";
const password = "topse";

const run = async () => {
	try {
		process.env.API_BACKEND = `https://${server}`;

		const api = new API();
		Auth.setAPI(api);
		await Auth.login({
			username: username,
			password: password
		});

		const {list} = await api.getObjectList({type: "camera", withAttributes: true});
		workList = list.filter((camera) => camera.attributes.STATUS === "ON")
		if (workList.length === 0) {
			throw "Camera list is empty";
		}			

		// select first camera from server
		const camera = workList[0];
		const obj = camera.obj;

		const {url} = await api.getMobileMediaURL({cameraid: obj});
		
		const arguments = ["-d", "-u", url];
		
		const command = spawn("simple_play", arguments, {shell: true});
		command.stdout.on("data", data => {
			console.log(`stdout: ${data}`);
		});

		command.stderr.on("data", data => {
			console.log(`stderr: ${data}`);
		});

		command.on('error', (error) => {
			console.log(`error: ${error.message}`);
		});

		command.on("close", code => {
			console.log(`child process exited with code ${code}`);
		});
	}
	catch (e) {
		console.error(e);
	}
};

run();




