const prompts = require('prompts');
const {API} = require('./api');
const {Auth} = require('./auth');
const path = require('path');

const binding_path = require('node-pre-gyp').find(path.resolve(path.join(__dirname, './package.json')));
const VN_Player = require('./VN_Player')

const test = async () => {
    const {server, username, password} = await prompts([{
        type: "text",
        name: 'server',
        message: 'server url (ex: dev1.videonext.net)',
        initial: 'test1.vsaas.videonext.net'
        //initial: 'dev1.videonext.net'
    },{
        type: "text",
        name: 'username',
        message: 'username',
        initial: 'realm_a9'
        //initial: 'realm_test'
    },{
        type: "text",
        name: 'password',
        message: 'password',
        initial: 'q1w2e3r4t5'
    }]);

    try {
        process.env.API_BACKEND = `https://${server}`;

        const api = new API();
        Auth.setAPI(api);
        await Auth.login({
            username: username,
            password: password
        });

        const {list} = await api.getObjectList({type: "camera", withAttributes: true});
		const workList = list.filter((camera) => camera.attributes.STATUS === "ON")
        if (workList.length === 0) {
            throw "Camera list is empty";
        }

        // select first camera from server
        const camera = workList[0];
        //const obj = 'a716b3e4-7fd9-11ea-aa14-00155dd9270b';
        const obj = camera.obj;
        //console.log("CAMERA: ", camera, obj);

        const {url} = await api.getMobileMediaURL({cameraid: obj});

        /*const new_frame = (...args) => {
            console.log(args);
        };*/
	let vn_player = this._native_vn_player = new VN_Player({objid: obj, vsync: false})
        vn_player.play(url);

        /**
         *
         * @param {number} time ms
         * @returns {Promise<number>}
         */
        function sleep(time) {
            return new Promise((resolve) => setTimeout(resolve, time));
        }

        sleep(5000).then(() => {
            // stop
            vn_player.teardown();
            vn_player = undefined
        });
    }
    catch (e) {
        console.error("Some error while test", e);
    }
};

test();
