const prompts = require('prompts');
const {API} = require('./api');
const {Auth} = require('./auth');

const path = require('path')
const binding_path = require('node-pre-gyp').find(path.resolve(path.join(__dirname,'./package.json')))
const VN_NativePlayer = require(binding_path).VN_Player

const test = async () => {
    const {server, username, password} = await prompts([{
        type: "text",
        name: 'server',
        message: 'server url (ex: dev1.videonext.net)',
        initial: 'dev1.videonext.net'
    },{
        type: "text",
        name: 'username',
        message: 'username',
        initial: 'user'
    },{
        type: "text",
        name: 'password',
        message: 'password',
        initial: 'topse'
    }]);

    try {
        process.env.API_BACKEND = `https://${server}`;

        const api = new API();
        Auth.setAPI(api);
        await Auth.login({
            username: username,
            password: password
        });

        const {list} = await api.getObjectList({type: "camera", withAttributes: true});
		workList = list.filter((camera) => camera.attributes.STATUS === "ON")
        if (workList.length === 0) {
            throw "Camera list is empty";
        }			

        // select first camera from server
        const camera = workList[0];
        const obj = camera.obj;

        const {url} = await api.getMobileMediaURL({cameraid: obj});

        const new_frame = (...args) => {
            console.log("new_frame", args);
        };
		const vn_player = this._native_vn_player = new VN_NativePlayer(new_frame, obj, false)
        vn_player.play(url);

        /**
         *
         * @param {number} time ms
         * @returns {Promise<number>}
         */
        function sleep(time) {
            return new Promise((resolve) => setTimeout(resolve, time));
        }

        sleep(60000).then(() => {
            // stop
            vn_player.teardown();
        });
    }
    catch (e) {
        console.error("Some error while test", e);
    }
};

test();
