const fetch = require('node-fetch');
global.fetch = fetch;
global.Headers = fetch.Headers;
global.Request = fetch.Request;

/**
 * AUTO-GENERATED FILE - DO NOT EDIT!!
 */

/**
 *
 * @param {{promise: boolean}} [parameters]
 * @constructor
 */
function API(parameters)
{
	this._cookie = {};
	this._parameters = Object.assign({
		getSession: null
	}, parameters);
}

module.exports = {API};

/**
 *
 * @param {string} funcName
 * @param {string} requestMethod
 * @param {Object} parameters
 * @param {Array} requiredParameters
 * @param {Array} encodeParameters
 * @returns {Promise<any>}
 * @private
 */
API.prototype._send = function(funcName, requestMethod, parameters, requiredParameters, encodeParameters) {
	return this._sendHTTP(funcName, requestMethod, parameters, requiredParameters, encodeParameters);
};

function parseCookies(response) {
	if (!response) return {};
	const cookies = {};
	const raw = response.headers.raw()['set-cookie'];
	if (!raw) return {};
	raw.forEach((entry) => {
		const parts = entry.split(';');
		const cookiePart = parts[0];
		const [key, value] = cookiePart.split('=');
		cookies[key] = value;
	});
	return cookies;
}

API.prototype._sendHTTP = function(funcName, requestMethod, parameters, requiredParameters, encodeParameters, resolve, reject) {
	return new Promise((resolve, reject) => {
		for (let i = 0; i < requiredParameters.length; i++)
		{
			let parameter = requiredParameters[i];
			if (typeof parameters[parameter] === "undefined")
			{
				reject({code: 400, message: "parameter '" + parameter + "' of function '" + funcName + "' should be specified", parameters});
				return;
			}
		}

		for (let parameter in parameters)
		{
			if (parameters[parameter] === null)
			{
				reject({code: 400, message: "parameter '" + parameter + "' of function '" + funcName + "' could not be null", parameters});
				return;
			}
		}

    let origin = process.env.API_BACKEND ;
    origin = origin.endsWith("/") ? origin.substring(0, origin.length - 1) : origin;
		let url = `${origin}/api/call/${funcName}`;

		let data = null;
		const headers = {
			'Accept': 'application/json'
		};
		let token = null;
		if (token) {
			headers['X-token'] = token;
		}

		const init = {
			method: requestMethod,
			cache: "no-store",
			credentials: 'include'
		};

		if (requestMethod === "GET")
		{

			for (let i = 0; i < encodeParameters.length; i++)
			{
				let parameter = encodeParameters[i];
				if (typeof parameters[parameter] !== "undefined")
				{
					parameters[parameter] = JSON.stringify(parameters[parameter]);
				}
			}

			let queryString = "";
			for (let parameter in parameters) {
				queryString += `${parameter}=${encodeURIComponent(parameters[parameter])}&`
			}
			url += "?" + queryString;
		} else {
			headers['Content-Type'] = "application/json; charset=utf-8";
			init.body = JSON.stringify(parameters);
		}
		headers['cookie'] = Object.entries(this._cookie).map(([key, value]) => `${key}=${value}`).join(";");
		init.headers = new Headers(headers);
		fetch(new Request(url, init))
			.then((response) => {
				this._cookie = Object.assign(this._cookie, parseCookies(response));

				const isOk = response.status >= 200 && response.status < 300 || response.status === 304;
				response.json()
					.then((json) => {
						if (isOk) {
							resolve(json, parameters);
						} else {
							const {code, error} = json;
							reject({code: code, message: error, parameters});
						}
					})
					.catch((e) => {
						response.text()
							.then((text) => {
								reject({code: response.status, message: text, parameters});
							})
							.catch((e) => {
								reject({code: response.status, message: e.message, parameters});
							});
					});
			})
			.catch((e) => {
				const code = 0;
				const message = e.message;
				reject({code, message, parameters});
			});
	});
};

/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getAttribute = function (parameters) {
	const funcName = "getAttribute";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj",
		"attribute"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getAttributes = function (parameters) {
	const funcName = "getAttributes";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.isReplicated = function (parameters) {
	const funcName = "isReplicated";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getStats = function (parameters) {
	const funcName = "getStats";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getAvatarKeyInfo = function (parameters) {
	const funcName = "getAvatarKeyInfo";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getBlockURL = function (parameters) {
	const funcName = "getBlockURL";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj",
		"blockId"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getBlocksInfo = function (parameters) {
	const funcName = "getBlocksInfo";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getIdentityAttribute = function (parameters) {
	const funcName = "getIdentityAttribute";
	const funcMethod = "GET";
	const requiredParameters = [
		"attribute"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getIdentityAttributes = function(){
	let parameters = {};
	const funcName = "getIdentityAttributes";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getObjectList = function (parameters = {}) {
	const funcName = "getObjectList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
		"objList",
		"filterAttributeList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getDeletedObjectList = function (parameters = {}) {
	const funcName = "getDeletedObjectList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getSetList = function (parameters = {}) {
	const funcName = "getSetList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
		"childObjList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getTemplates = function (parameters = {}) {
	const funcName = "getTemplates";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
		"objList",
		"attributes"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getTypes = function(){
	let parameters = {};
	const funcName = "getTypes";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getResourceTree = function(){
	let parameters = {};
	const funcName = "getResourceTree";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.cameraDiscovery = function (parameters) {
	const funcName = "cameraDiscovery";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj",
		"ticket",
		"parameters"
	];
	const arrayParameters = [
		"parameters"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.probeURL = function (parameters) {
	const funcName = "probeURL";
	const funcMethod = "GET";
	const requiredParameters = [
		"ticket",
		"url"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.probeONVIF = function (parameters) {
	const funcName = "probeONVIF";
	const funcMethod = "GET";
	const requiredParameters = [
		"ticket"
	];
	const arrayParameters = [
		"parameters"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getPermissionTypeList = function(){
	let parameters = {};
	const funcName = "getPermissionTypeList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventsInterval = function (parameters) {
	const funcName = "getEventsInterval";
	const funcMethod = "GET";
	const requiredParameters = [
		"start",
		"interval"
	];
	const arrayParameters = [
		"filter"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventsStatistics = function (parameters) {
	const funcName = "getEventsStatistics";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList",
		"beginTime",
		"endTime",
		"granularity"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.isEventExists = function (parameters) {
	const funcName = "isEventExists";
	const funcMethod = "GET";
	const requiredParameters = [
		"eventid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getTimezoneInformationList = function (parameters) {
	const funcName = "getTimezoneInformationList";
	const funcMethod = "GET";
	const requiredParameters = [
		"timezoneList"
	];
	const arrayParameters = [
		"timezoneList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getCertificateRequestInfo = function(){
	let parameters = {};
	const funcName = "getCertificateRequestInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getCertificateInfo = function(){
	let parameters = {};
	const funcName = "getCertificateInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getCertificateFullInfo = function(){
	let parameters = {};
	const funcName = "getCertificateFullInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getStorageUsage = function (parameters) {
	const funcName = "getStorageUsage";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList",
		"granularity"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getStorageUsageTotals = function (parameters) {
	const funcName = "getStorageUsageTotals";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getStorageUsageSpread = function (parameters) {
	const funcName = "getStorageUsageSpread";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getNodeStorageUsageTotal = function (parameters = {}) {
	const funcName = "getNodeStorageUsageTotal";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getSystemStatus = function(){
	let parameters = {};
	const funcName = "getSystemStatus";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getAvatarStatus = function (parameters = {}) {
	const funcName = "getAvatarStatus";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getAuditRecords = function (parameters = {}) {
	const funcName = "getAuditRecords";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
		"categories"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getAuditCategories = function(){
	let parameters = {};
	const funcName = "getAuditCategories";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getEventPriorities = function(){
	let parameters = {};
	const funcName = "getEventPriorities";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getServerTime = function(){
	let parameters = {};
	const funcName = "getServerTime";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getObjectOnScheduleList = function (parameters = {}) {
	const funcName = "getObjectOnScheduleList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getUnusedPosturesList = function (parameters) {
	const funcName = "getUnusedPosturesList";
	const funcMethod = "GET";
	const requiredParameters = [
		"scheduleid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getScheduleInfo = function (parameters = {}) {
	const funcName = "getScheduleInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventSource = function (parameters) {
	const funcName = "getEventSource";
	const funcMethod = "GET";
	const requiredParameters = [
		"scheduleid",
		"datefrom",
		"dateto"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getAnalyticsSchema = function(){
	let parameters = {};
	const funcName = "getAnalyticsSchema";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getSessionList = function (parameters = {}) {
	const funcName = "getSessionList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getMediaURL = function (parameters = {}) {
	const funcName = "getMediaURL";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getMobileMediaURL = function (parameters) {
	const funcName = "getMobileMediaURL";
	const funcMethod = "GET";
	const requiredParameters = [
		"cameraid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getMediaTicket = function (parameters) {
	const funcName = "getMediaTicket";
	const funcMethod = "GET";
	const requiredParameters = [
		"cameraid",
		"transport"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getSubTicket = function(){
	let parameters = {};
	const funcName = "getSubTicket";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getSDP = function (parameters) {
	const funcName = "getSDP";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj",
		"sdp"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.authorizationManager = function (parameters) {
	const funcName = "authorizationManager";
	const funcMethod = "GET";
	const requiredParameters = [
		"objid",
		"streamtype"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getExportTicket = function (parameters) {
	const funcName = "getExportTicket";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj",
		"start",
		"end"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getCameraLog = function (parameters) {
	const funcName = "getCameraLog";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getPosturesInfo = function (parameters) {
	const funcName = "getPosturesInfo";
	const funcMethod = "GET";
	const requiredParameters = [
		"scheduleid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getStorageCoverage = function (parameters) {
	const funcName = "getStorageCoverage";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList",
		"startTime",
		"endTime",
		"granularity"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getVersionControlInformation = function(){
	let parameters = {};
	const funcName = "getVersionControlInformation";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getVersionInformation = function(){
	let parameters = {};
	const funcName = "getVersionInformation";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getBranding = function(){
	let parameters = {};
	const funcName = "getBranding";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getCameraModelList = function(){
	let parameters = {};
	const funcName = "getCameraModelList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getVCADetails = function(){
	let parameters = {};
	const funcName = "getVCADetails";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getOV6Details = function(){
	let parameters = {};
	const funcName = "getOV6Details";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getLastTargets = function(){
	let parameters = {};
	const funcName = "getLastTargets";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getTargetRelatedZone = function (parameters) {
	const funcName = "getTargetRelatedZone";
	const funcMethod = "GET";
	const requiredParameters = [
		"targetId"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.findHomography = function (parameters) {
	const funcName = "findHomography";
	const funcMethod = "GET";
	const requiredParameters = [
		"source",
		"destination"
	];
	const arrayParameters = [
		"source",
		"destination"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getCloudStorageStatus = function (parameters) {
	const funcName = "getCloudStorageStatus";
	const funcMethod = "GET";
	const requiredParameters = [
		"provider"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getAnnounceEventList = function(){
	let parameters = {};
	const funcName = "getAnnounceEventList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.countAnnouncedEvents = function(){
	let parameters = {};
	const funcName = "countAnnouncedEvents";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventInfo = function (parameters) {
	const funcName = "getEventInfo";
	const funcMethod = "GET";
	const requiredParameters = [
		"eventId"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getAnnounceRoleUserList = function(){
	let parameters = {};
	const funcName = "getAnnounceRoleUserList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getCameraDowntime = function (parameters) {
	const funcName = "getCameraDowntime";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList",
		"startTime",
		"endTime"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getCameraDowntimeSummary = function (parameters) {
	const funcName = "getCameraDowntimeSummary";
	const funcMethod = "GET";
	const requiredParameters = [
		"objList",
		"startTime",
		"endTime",
		"granularity"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.testLDAP = function(){
	let parameters = {};
	const funcName = "testLDAP";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventSourceParametersList = function (parameters) {
	const funcName = "getEventSourceParametersList";
	const funcMethod = "GET";
	const requiredParameters = [
		"id"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getEventPolicyList = function(){
	let parameters = {};
	const funcName = "getEventPolicyList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventSourceWorkflowList = function (parameters) {
	const funcName = "getEventSourceWorkflowList";
	const funcMethod = "GET";
	const requiredParameters = [
		"eventpolicy_id",
		"eventsource_id"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getEventPolicy = function (parameters) {
	const funcName = "getEventPolicy";
	const funcMethod = "GET";
	const requiredParameters = [
		"id"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.hasConnectToLicenseServer = function(){
	let parameters = {};
	const funcName = "hasConnectToLicenseServer";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getContentDeliveryDetails = function (parameters) {
	const funcName = "getContentDeliveryDetails";
	const funcMethod = "GET";
	const requiredParameters = [
		"avatar"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getSMWriterConf = function(){
	let parameters = {};
	const funcName = "getSMWriterConf";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.getPoliciesForDevice = function (parameters) {
	const funcName = "getPoliciesForDevice";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.readDictionary = function (parameters) {
	const funcName = "readDictionary";
	const funcMethod = "GET";
	const requiredParameters = [
		"name"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getGuiList = function(){
	let parameters = {};
	const funcName = "getGuiList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getAvatarGlobalSettings = function(){
	let parameters = {};
	const funcName = "getAvatarGlobalSettings";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.purgeAvatarQueue = function (parameters) {
	const funcName = "purgeAvatarQueue";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.iperfCheck = function (parameters) {
	const funcName = "iperfCheck";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.rebootAvatar = function (parameters) {
	const funcName = "rebootAvatar";
	const funcMethod = "GET";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.canAddSatelliteUser = function (parameters) {
	const funcName = "canAddSatelliteUser";
	const funcMethod = "GET";
	const requiredParameters = [
		"name"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getInfo = function(){
	let parameters = {};
	const funcName = "getInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getFacialVer = function(){
	let parameters = {};
	const funcName = "getFacialVer";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getNodeInfo = function(){
	let parameters = {};
	const funcName = "getNodeInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getCameraTemplate = function(){
	let parameters = {};
	const funcName = "getCameraTemplate";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getLoginInfo = function(){
	let parameters = {};
	const funcName = "getLoginInfo";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.logout = function(){
	let parameters = {};
	const funcName = "logout";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.version = function(){
	let parameters = {};
	const funcName = "version";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getStamp = function(){
	let parameters = {};
	const funcName = "getStamp";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.getNode = function (parameters = {}) {
	const funcName = "getNode";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getLanguageList = function(){
	let parameters = {};
	const funcName = "getLanguageList";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.getAvatarMinVersion = function(){
	let parameters = {};
	const funcName = "getAvatarMinVersion";
	const funcMethod = "GET";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.addObject = function (parameters) {
	const funcName = "addObject";
	const funcMethod = "POST";
	const requiredParameters = [
		"type",
		"attributes"
	];
	const arrayParameters = [
		"attributes"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.deleteObject = function (parameters) {
	const funcName = "deleteObject";
	const funcMethod = "POST";
	const requiredParameters = [
		"objList"
	];
	const arrayParameters = [
		"objList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.setAttributes = function (parameters = {}) {
	const funcName = "setAttributes";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
		"objList",
		"attributes"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.setStatAttributes = function (parameters = {}) {
	const funcName = "setStatAttributes";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
		"objList",
		"attributes"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setIdentityAttributes = function (parameters) {
	const funcName = "setIdentityAttributes";
	const funcMethod = "POST";
	const requiredParameters = [
		"attributes"
	];
	const arrayParameters = [
		"attributes"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.deleteBlocks = function (parameters) {
	const funcName = "deleteBlocks";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj",
		"blockIdList"
	];
	const arrayParameters = [
		"blockIdList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setBlock = function (parameters) {
	const funcName = "setBlock";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.changeObjectList = function (parameters) {
	const funcName = "changeObjectList";
	const funcMethod = "POST";
	const requiredParameters = [
		"parentobj"
	];
	const arrayParameters = [
		"addList",
		"removeList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setPermission = function (parameters) {
	const funcName = "setPermission";
	const funcMethod = "POST";
	const requiredParameters = [
		"roleid",
		"setid",
		"permission"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setSpecialCredentials = function (parameters) {
	const funcName = "setSpecialCredentials";
	const funcMethod = "POST";
	const requiredParameters = [
		"roleid",
		"credentials"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.invokeMethod = function (parameters) {
	const funcName = "invokeMethod";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj",
		"methodname"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.createCertificateRequest = function (parameters) {
	const funcName = "createCertificateRequest";
	const funcMethod = "POST";
	const requiredParameters = [
		"requestParameters"
	];
	const arrayParameters = [
		"requestParameters"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.installCertificate = function (parameters) {
	const funcName = "installCertificate";
	const funcMethod = "POST";
	const requiredParameters = [
		"certificate"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.addAuditRecord = function (parameters) {
	const funcName = "addAuditRecord";
	const funcMethod = "POST";
	const requiredParameters = [
		"category",
		"paramsJSON"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.saveObjectsOnSchedule = function (parameters) {
	const funcName = "saveObjectsOnSchedule";
	const funcMethod = "POST";
	const requiredParameters = [
		"scheduleid",
		"oldobjlist",
		"objlist"
	];
	const arrayParameters = [
		"oldobjlist",
		"objlist"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.releasePosture = function (parameters) {
	const funcName = "releasePosture";
	const funcMethod = "POST";
	const requiredParameters = [
		"scheduleid",
		"postureid",
		"timecardid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setScheduleInfo = function (parameters) {
	const funcName = "setScheduleInfo";
	const funcMethod = "POST";
	const requiredParameters = [
		"scheduleInfo"
	];
	const arrayParameters = [
		"scheduleInfo"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.convertScheduleInfoToEventSource = function (parameters) {
	const funcName = "convertScheduleInfoToEventSource";
	const funcMethod = "POST";
	const requiredParameters = [
		"scheduleid",
		"scheduleInfo",
		"datefrom",
		"dateto"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.stopSession = function (parameters = {}) {
	const funcName = "stopSession";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setPassword = function (parameters) {
	const funcName = "setPassword";
	const funcMethod = "POST";
	const requiredParameters = [
		"userid",
		"password"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.changePassword = function (parameters) {
	const funcName = "changePassword";
	const funcMethod = "POST";
	const requiredParameters = [
		"currentPassword",
		"newPassword"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.setMetadataInfo = function (parameters) {
	const funcName = "setMetadataInfo";
	const funcMethod = "POST";
	const requiredParameters = [
		"metaname",
		"ttl",
		"color",
		"font",
		"style",
		"height",
		"align",
		"valign"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.submitAction = function (parameters) {
	const funcName = "submitAction";
	const funcMethod = "POST";
	const requiredParameters = [
		"name",
		"parameters",
		"properties"
	];
	const arrayParameters = [
		"parameters",
		"properties",
		"actions"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.announceEventToRole = function (parameters) {
	const funcName = "announceEventToRole";
	const funcMethod = "POST";
	const requiredParameters = [
		"eventid",
		"roleid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.announceEventToUser = function (parameters) {
	const funcName = "announceEventToUser";
	const funcMethod = "POST";
	const requiredParameters = [
		"eventid",
		"useridList"
	];
	const arrayParameters = [
		"useridList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.markAnnounceEventAsRead = function (parameters) {
	const funcName = "markAnnounceEventAsRead";
	const funcMethod = "POST";
	const requiredParameters = [
		"eventList"
	];
	const arrayParameters = [
		"eventList"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.registerOpenVPNClient = function (parameters) {
	const funcName = "registerOpenVPNClient";
	const funcMethod = "POST";
	const requiredParameters = [
		"csr"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.addEventPolicy = function (parameters) {
	const funcName = "addEventPolicy";
	const funcMethod = "POST";
	const requiredParameters = [
		"name",
		"description",
		"eventsource_workflow_parameters",
		"eventpolicystorage"
	];
	const arrayParameters = [
		"eventsource_workflow_parameters",
		"eventpolicystorage"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.editEventPolicy = function (parameters) {
	const funcName = "editEventPolicy";
	const funcMethod = "POST";
	const requiredParameters = [
		"id",
		"name",
		"description",
		"eventsource_workflow_parameters",
		"eventpolicystorage"
	];
	const arrayParameters = [
		"eventsource_workflow_parameters",
		"eventpolicystorage"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.deleteEventPolicy = function (parameters) {
	const funcName = "deleteEventPolicy";
	const funcMethod = "POST";
	const requiredParameters = [
		"id"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.acceptLicense = function(){
	let parameters = {};
	const funcName = "acceptLicense";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.activateSerialNumber = function (parameters) {
	const funcName = "activateSerialNumber";
	const funcMethod = "POST";
	const requiredParameters = [
		"serialNumber"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.createPCID = function (parameters) {
	const funcName = "createPCID";
	const funcMethod = "POST";
	const requiredParameters = [
		"serialNumber"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.activateAvatar = function (parameters) {
	const funcName = "activateAvatar";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.updateAvatar = function (parameters) {
	const funcName = "updateAvatar";
	const funcMethod = "POST";
	const requiredParameters = [
		"attributes"
	];
	const arrayParameters = [
		"attributes"
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.updateAvatarKey = function (parameters) {
	const funcName = "updateAvatarKey";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.updateAvatarSystem = function (parameters) {
	const funcName = "updateAvatarSystem";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.updateAllAvatarSystems = function(){
	let parameters = {};
	const funcName = "updateAllAvatarSystems";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.migrateAvatar = function (parameters) {
	const funcName = "migrateAvatar";
	const funcMethod = "POST";
	const requiredParameters = [
		"oldAvatarId",
		"newAvatarId"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.syncConf = function (parameters) {
	const funcName = "syncConf";
	const funcMethod = "POST";
	const requiredParameters = [
		"realmid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @returns {Promise<any>}
 */
API.prototype.flushRedisCache = function(){
	let parameters = {};
	const funcName = "flushRedisCache";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.changeRole = function (parameters) {
	const funcName = "changeRole";
	const funcMethod = "POST";
	const requiredParameters = [
		"roleid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} [parameters]
 * @returns {Promise<any>}
 */
API.prototype.changeUser = function (parameters = {}) {
	const funcName = "changeUser";
	const funcMethod = "POST";
	const requiredParameters = [
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.addSatelliteUser = function (parameters) {
	const funcName = "addSatelliteUser";
	const funcMethod = "POST";
	const requiredParameters = [
		"name"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.createVmxObjects = function (parameters) {
	const funcName = "createVmxObjects";
	const funcMethod = "POST";
	const requiredParameters = [
		"realmid"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.login = function (parameters) {
	const funcName = "login";
	const funcMethod = "POST";
	const requiredParameters = [
		"name",
		"credentials"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
/**
 * @param {Object} parameters
 * @returns {Promise<any>}
 */
API.prototype.registerAvatar = function (parameters) {
	const funcName = "registerAvatar";
	const funcMethod = "POST";
	const requiredParameters = [
		"obj",
		"public_key"
	];
	const arrayParameters = [
	];
	return this._send(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
};
