const CryptoJS = require("crypto-js");
const Auth = {
	password: "",
	user: {obj: null, name: ""},
	role: {obj: null, name: ""},
	realm: {obj: null, name: ""},
	api: null,
	LoginingPromise: null,
	setAPI: function (api) {
		Auth.api = api;
	},
	isLoggedIn: function () {
	},
	login: function ({username, password, realmid = undefined}) {
		return new Promise((resolve, reject) => {
			if (username && password) {
				Auth.user.name = username;
				Auth.password = password;
			} else {
				reject({message: "Specify login and password"});
				return;
			}

			Auth.api.getLoginInfo()
				.then((response) => {
					let encryptionKey = response.loginInfo.encryptionKey;
					let LDAP_AUTHENTICATION = response.loginInfo.LDAP_AUTHENTICATION;

					let tmpHash = CryptoJS.SHA512(Auth.password).toString(CryptoJS.enc.Hex);
					let credentials = CryptoJS.SHA512(encryptionKey + tmpHash + encryptionKey).toString(CryptoJS.enc.Hex);

					let data = {
						name: Auth.user.name,
						credentials: credentials
					};

					if (LDAP_AUTHENTICATION) {
						data.password = Auth.password;
					}

					if (realmid) {
						data.realmid = realmid;
					}

					/*
					let url = window.location.href;
					let match = url.match(/^[^?]+([?]*.*)$/);
					if (match[1]) {
						let _options = m.parseQueryString(match[1]);
						if (_options.redirect) {
							data.redirect = _options.redirect;
						}
					}
					*/

					Auth.api.login(data)
						.then((response) => {
							Auth.user = Object.assign({}, response.info.user);
							Auth.role = Object.assign({}, response.info.role);
							Auth.realm = Object.assign({}, response.info.realm);
							Auth.redirect = response.redirect;

							// Auth.LoginingPromise = null;
							resolve();
						})
						.catch((e) => {
							reject(e);
						})
				})
				.catch((e) => {
					reject(e)
				});
		});
	},
	logout: function () {
		return Auth.api.logout();
	}
};

module.exports = {Auth};
