const YUVBuffer = require('yuv-buffer')
const EventEmitter = require('events').EventEmitter
//const fs = require('fs')

const path = require('path')
const binding_path = require('node-pre-gyp').find(path.resolve(path.join(__dirname,'./package.json')))
const VN_NativePlayer = require(binding_path).VN_Player

// sleep time expects milliseconds
function sleep (time) {
    return new Promise((resolve) => setTimeout(resolve, time));
}

class VN_Player {
    constructor(yuvCanvas, objid, cell_w, cell_h, scale, vsync) {
        this._emitter = new EventEmitter()

        // next variables MUST be available for the draw() function
        var frame
        var player = this
        var _yuvCanvas = this._yuvCanvas = yuvCanvas

        function draw(time) {
            //console.log('DRAW', this.reqId, window)
            if(frame !== undefined
                && vn_player !== undefined
                && vn_player.is_new_frame_ready())
            {
                console.log(`[${objid}] new frame is ready`)
                _yuvCanvas.drawFrame(frame)
                player.updateStatistics()
            }
            window.requestAnimationFrame(draw)
        }

        this._emitter.on('new_frame', (w, h, y_stride, u_stride, v_stride) => {
            if(w === undefined) {
                if(vsync)
                    return
                console.log(`[${objid}] new_frame`)
                if(this._frame !== undefined) {
                    if(this._yuvCanvas !== undefined && !vsync) {
                        this._yuvCanvas.drawFrame(this._frame)
                        this.updateStatistics()
                    }
                    /**
                     * For DEBUG purposes
                     *
                    if(this.cnt < 10) {
                        let fd = fs.openSync(`/tmp/${this.cnt}.yuv`, 'w')
                        //fs.writeFileSync(`/tmp/${this.cnt}.y`, this._frame.y.bytes)
                        //fs.writeFileSync(`/tmp/${this.cnt}.u`, this._frame.u.bytes)
                        //fs.writeFileSync(`/tmp/${this.cnt}.v`, this._frame.v.bytes)
                        fs.writeSync(fd, this._frame.y.bytes)
                        fs.writeSync(fd, this._frame.u.bytes)
                        fs.writeSync(fd, this._frame.v.bytes)
                        fs.closeSync(fd)
                        this.cnt++
                    }*/
                }
                return
            }

            if(this._frame === undefined) {
                console.log(`[${objid}] new_frame ${w}x${h}, ${y_stride}, ${u_stride}, ${v_stride}`)
                this._format = YUVBuffer.format({
                    width: w*1,
                    height: h*1,
                    chromaWidth: Math.round(w/2),
                    chromaHeight: Math.round(h/2),
                    displayWidth: scale ? cell_w : w*1,
                    displayHeight: scale ? cell_h : h*1
                    //cropWidth: w*1
                })

                this._frame = YUVBuffer.frame(this._format,
                    YUVBuffer.lumaPlane(this._format, undefined, y_stride),
                    YUVBuffer.chromaPlane(this._format, undefined, u_stride),
                    YUVBuffer.chromaPlane(this._format, undefined, v_stride))
                this._native_vn_player.set_img_buffer(this._frame.y.bytes,
                    this._frame.u.bytes,
                    this._frame.v.bytes)
                frame = this._frame
            }

            if(this._yuvCanvas !== undefined && !vsync) {
                this._yuvCanvas.drawFrame(this._frame)
                this.updateStatistics()
            }
        });

        var vn_player = this._native_vn_player = new VN_NativePlayer(this._emitter.emit.bind(this._emitter), objid, vsync)
        if(vsync)
            window.requestAnimationFrame(draw)
    }

    updateStatistics() {
        // Empty here. Add useful logic in the derived classes
    }

    play(url) {
        console.log("Let's play url:", url)
        this._native_vn_player.play(url)
    }

    teardown() {
        this._native_vn_player.teardown()
        if(this._yuvCanvas !== undefined) {
            sleep(1000).then(() => {
                //vn_player.teardown();
            });
            this._yuvCanvas.clear()
        }
    }
};

module.exports = VN_Player;
