import { UUID } from "./types";

export enum MSEMediaPlayerError {
  VIDEO_UNAVAILABLE = 10100,
  AUDIO_UNAVAILABLE = 10101,
  INVALID_REQUEST = 10102,
  INTERNAL_ERROR = 10200,

  NOT_AUTHORIZED = 51080,
  AVATAR_OFFLINE = 51081,
  BROKEN_ON_AVATAR_SIDE = 51082,
  STREAM_STOPPED_UNEXPECTEDLY = 51083, // restart 0s
  LIVE_NOT_OPENED_NOT_ENOUGH_AVATAR_VSAAS_BANDWIDTH = 51086,
  LIVE_STOPPED_NOT_ENOUGH_AVATAR_VSAAS_BANDWIDTH = 51087,
  STREAM_STOPPED_NOT_ENOUGH_AVATAR_LOCAL_BANDWIDTH = 51088,
  CRITICAL = 51089,  // TODO = handle this on ajax calls

  MSE_PLAYER_SOURCE_BUFFER_ERROR = 52000,
  MSE_PLAYER_UNSUPPORTED_CODEC = 52001,

  END_OF_ARCHIVE = 10005,
  END_OF_STREAM = 10001,
  END_OF_CHUNK = 10004
}

export enum MSEMediaPlayerStream {
  DIGEST = "0",
  FULL = "1"
}

export enum MSEMediaPlayerTransport {
  WEBSOCKET = "websocket",
  WEBRTC = "webrtc"
}

export enum MSEMediaPlayerConnection {
  LOCAL = "local",
  CLOUD = "cloud",
  AUTO = "auto"
}

export enum MSEMediaPlayerMetadataType {
  ALL = "all",
  TRIGGERED = "triggered",
  NONE = "none"
}

export enum MSEMediaPlayerStatus {
  STOP = 0,
  PLAY = 1,
  INITIALIZING = 2,
  // PLAY_START_2 = 2,
  PAUSE = 3,
  PAUSING = 4
}

export type MSEMediaPlayerParameters = {
  logger?: Console,
  node?: HTMLElement,
  connectionType?: MSEMediaPlayerConnection
};

// TODO: check if some parameters not optional
export type MSEMediaPlayerInitParameters = {
  cacheSize?: number, // size of cache in MB
  obj?: UUID,
  time?: number,
  streamid?: MSEMediaPlayerStream,
  isMetaDataDraw?: boolean,
  metadataType?: MSEMediaPlayerMetadataType,
  connectionType?: MSEMediaPlayerConnection,
  showControlsOnPause?: boolean,
  showPauseButton?: boolean,
  idleTimeout?: number,
  muted?: boolean,
  disableLocalTransport?: boolean
};

export type StreamParams = {
  mime: string,
  width: number,
  height: number
}
