export type Metadata = {
  kind: string,
  list: MetadataVisual,
  pts: string,
  type: "result",
  vae: string,
  ver: number
}

export type Box = [x: number, y: number, width: number, height: number];

export type VisualPrimitives = {
  box?: Box,
  polygon?: number[],
  text?: string | string[], // if array render new element from new line
  emotions?: string
}

export type Visual = {
  [label: string]: VisualPrimitives[]
}

export type VisualOpt = {
  opt?: {
    def: string[],
    box?: Box,
    pp?:  [x: number, y: number], // Projection Point
    geo?: [lat: number, lng: number, alt?: number]
  },
  "Bounding box"?: [{
    box: Box
  }],
  Geo?: [{
    text: string[],
    lat: [string],
    lng: [string],
    alt: [string]
  }],
  Angles?: [{
    text: string[],
    yaw: [string],
    pitch: [string],
    roll: [string]
  }]
}

export type MetadataVisual = {
  [id: string]: {
    trig?: boolean,
    visual?: Visual & VisualOpt
  }
}
