import {UUID} from "@solid/types/types";
import {Metadata} from "@solid/types/metadata";

export type Message = {
  code?: number,
  error?: string,
  event?: "EOA" | "EOS" | "EOC",
  mime?: string,
  size?: {
    width: number,
    height: number
  }
  c?: number,
  s?: number,
  md5?: string,
  n?: number,
  pts?: string | string[],
  metadata?: Metadata[],
  key?: boolean
};

export type InitEventWithState = {
  type: "CMD_INIT"
} & InitEvent;
export type InitEvent = {
  cmd: "init",
  objid: UUID,
  streamid: string,
  ticket: string,
  params: {
    audio?: boolean,
    fast?: boolean,
    raw?: boolean,
    startTime?: number, // pts
    endTime?: number // pts
  }
}

export type PlayEventWithState = {
  type: "CMD_PLAY"
} & InitEvent;
export type PlayEvent = {
  cmd: "play",
  params: {}
}

export type PauseEventWithState = {
  type: "CMD_PAUSE"
} & InitEvent;
export type PauseEvent = {
  cmd: "pause"
}

export type IdleEventWithState = {
  type: "IDLE"
} & InitEvent;
export type IdleEvent = {}

export type MimeEventWithState = {
  type: "MIME"
} & InitEvent;
export type MimeEvent = {
  mime: string,
  size: {
    width: number,
    height: number
  }
}

export type CodeEventWithState = {
  type: "CODE"
} & InitEvent;
export type CodeEvent = {
  code?: number,
  error: string
}

export type WaitEventWithState = {
  type: "WAIT"
} & InitEvent;
export type WaitEvent = {}

export type PtsEventWithState = {
  type: "PTS"
} & InitEvent;
export type PtsEvent = {
  pts: string | string[],
  key?: boolean,
  metadata?: Metadata[],
  init_segment_size?: number
}

export type EventEventWithState = {
  type: "EVENT"
} & InitEvent;
export type EventEvent = {
  event: "EOA" | "EOS" | "EOC"
}

export type BinaryEventWithState = {
  type: "BINARY"
} & InitEvent;
export type BinaryEvent = {
  data: ArrayBuffer
}

