/**
 * @version :$
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

import {Log} from "@solid/libs/log";
import $ from "jquery";
import {TimeLineData, TimeLineDataList, TimeLineTrack, TimeLineType, VisTimeLine} from "../vistimeline";
import {DataCoverage} from "./Coverage";
import {Granularity} from "@solid/types/coverage";

import "./style.css";

class VisTimeLineTest extends VisTimeLine {
	time: number = 0;
}

let timeline1: VisTimeLineTest = null!;
let timeline2: VisTimeLineTest = null!;
let timeline3: VisTimeLineTest = null!;

const storageSize = 10; // days
const startDate = new Date();
startDate.setDate(startDate.getDate() - storageSize);
const dataCoverage = new DataCoverage();
dataCoverage.generate(startDate.getTime(), Date.now(), 2);

let multiTrackCount = 2;
let multiTrackCoverage: DataCoverage[] = [];

function generateTrackCoverage() {
  const coverage = new DataCoverage();
  coverage.generate(startDate.getTime(), Date.now(), 2);
  multiTrackCoverage.push(coverage);
}

generateTrackCoverage();

$(document).ready(function () {
	Log.isDebug = false;

	let isDebug = true;

	timeline1 = new VisTimeLineTest({
		node: document.querySelector("#timeline_1"),
		type: TimeLineType.MULTI_LINE,
		isDebug: isDebug
	});

	timeline1.init().then(function () {
		timeline1.setParameters({
			selection: {fixed: false},
			scale: {granularity: Granularity.min}
		});

		$("#hide1").on("click", function () {
			$(".timeline_wrapper").css("visibility", "hidden");
		});

		$("#show1").on("click", function () {
			$(".timeline_wrapper").css("visibility", "visible");
		});

		$("#setTime1").on("click", function () {
			let date = new Date();
			timeline1.setTime(date.getTime(), true);
		})
			.trigger("click");

		$("#getTime1").on("click", function () {
			let time = timeline1.getTime();
			if (time) {
				let date = new Date(time);
				let timeStr = "time " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();
				Log.warning(timeStr);
			}
		});

		$("#setSelection1").on("click", function () {
			timeline1.setSelection(timeline1.time - 300000, timeline1.time + 600000, true);
		});

		$("#clearSelection1").on("click", function () {
			timeline1.clearSelection();
		});

		$("#getSelectionParameters1").on("click", function () {
			Log.info(JSON.stringify(timeline1.getSelectionParameters()));
		});

		$("#timezoneoffset1").on("change", function () {
			let value = String($(this).val());
			let parameters = {
				timezone: ''
			};
			parameters.timezone = value;
			timeline1.setParameters(parameters);
			Log.warning(timeline1.setTime(Date.now(), false));
		});
	});

	timeline1.onGetData = function (line: string, beginTime: number, endTime: number, granularity: Granularity) {
		Log.info("onGetData " + new Date(beginTime) + " " + new Date(endTime) + " " + granularity);

		/*
		let maxMinutes = screen.width / 36; // 36px for 1min
		beginTime -= maxMinutes * 60 * 1000;
		endTime += maxMinutes * 60 * 1000;
		*/

		granularity = Granularity.chunk;
		let list = getData(dataCoverage, beginTime, endTime, granularity, 1, false);
		this.setData(line, [{name: "", rows: list}]);
	};

	timeline2 = new VisTimeLineTest({
		node: document.querySelector("#timeline_2"),
		type: TimeLineType.SLIM,
		isDebug: isDebug
	});

	/*timeline2.init().then(function () {
		timeline2.setParameters({
			selection: {
				fixed: true,
				sticky: true
			},
			scale: {granularity: Granularity.hour}
		});

		$("#setTime2").on("click", function () {
			timeline2.setTime(Date.now(), true);
		})
			.trigger("click");

		$("#setSelection2").on("click", function () {
			timeline2.setSelection(timeline2.time - 0.5 * 3600 * 1000, timeline2.time + 0.5 * 3600 * 1000, true);
		});

		$("#clearSelection2").on("click", function () {
			timeline2.clearSelection();
		});

		$("#getSelectionParameters2").on("click", function () {
			Log.info(JSON.stringify(timeline2.getSelectionParameters()));
		});
	});*/

	timeline2.onGetData = function (line: string, beginTime: number, endTime: number, granularity: Granularity) {
		Log.info("onGetData");

		let list = getData(dataCoverage, beginTime, endTime, granularity, 1, true);
		this.setData(line, [{name: "", rows: list}]);
	};

	timeline3 = new VisTimeLineTest({
		node: document.querySelector("#timeline_3"),
		type: TimeLineType.MULTI_TRACK,
		isDebug: isDebug,
		hideSelection: true,
		showTime: true,
		options: { zoomable: true }
	});

	timeline3.init().then(function () {
		timeline3.setParameters({
			selection: {fixed: false},
			scale: {granularity: Granularity.min}
		});

		$("#setTime3").on("click", function () {
			let date = new Date();
			timeline3.setTime(date.getTime(), true);
		})
			.trigger("click");

		$("#getTime3").on("click", function () {
			let time = timeline3.getTime();
			if (time) {
				let date = new Date(time);
				let timeStr = "time " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();
				Log.warning(timeStr);
			}
		});

		$("#selectTrack3").on("click", function () {
			timeline3.selectTrack(random(0, multiTrackCount - 1));
		});

		$("#unselectTrack3").on("click", function () {
			timeline3.selectTrack(-1);
		});

		$("#getSelectedTrack3").on("click", function () {
			Log.info("Selected track: " + timeline3.selectedTrack());
		});

		$("#setGrayedTracks3").on("click", function () {
			const tracks = new Array<number>(random(1, multiTrackCount - 2));
			for (let i = 0; i < tracks.length; i++) {
				tracks[i] = random(0, multiTrackCount - 1);
			}
			timeline3.setGrayedTracks(tracks);
		});

		$("#clearGrayedTracks3").on("click", function () {
			timeline3.setGrayedTracks([]);
		});

    $("#addTrack").on("click", function () {
      multiTrackCount++;
      generateTrackCoverage();
      timeline3.updateData();
    });
	});

	timeline3.onGetData = function (line: string, beginTime: number, endTime: number, granularity: Granularity) {
		Log.info("onGetData " + new Date(beginTime) + " " + new Date(endTime) + " " + granularity);

		granularity = Granularity.chunk;

    const indexToName = {
      "0": "1",
      "1": "Some Long String",
    };

		const tracks: TimeLineTrack[] = [];
		for (let i = 0; i < multiTrackCount; i++) {
			const list = getData(multiTrackCoverage[i], beginTime, endTime, granularity, 1, false);
			tracks.push({ name: indexToName[i] ?? `Device ${i + 1}`, rows: list});
		}
		this.setData(line, tracks);
	};

	timeline1.onTimeChange = timeline2.onTimeChange = timeline3.onTimeChange = function (time: number, changedByUser: boolean) {
		Log.info("onTimeChange " + new Date(time) + " " + changedByUser);
		this.time = time;
	};

	timeline1.onSelectionChange = timeline2.onSelectionChange = function (line: string, beginTime: number, endTime: number) {
		let wasCleared = (!beginTime && !endTime);
		if (wasCleared) {
			Log.error(line + " selection is empty");
			return;
		}

		let date = new Date();

		date.setTime(beginTime);
		let beginTimeStr = "beginTime " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();

		date.setTime(endTime);
		let endTimeStr = "endTime " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();

		Log.warning(line + " " + beginTimeStr + " " + endTimeStr);
	};

	timeline3.onTrackSelected = function(index: number) {
		Log.info("onTrackSelected " + index);
	}

	let getData = function (dataCoverage: DataCoverage, beginTime: number, endTime: number, granularity: Granularity, multiplier: number, log: boolean): TimeLineData[] {
		let time = performance.now();

		let date = new Date();
		date.setTime(beginTime);

		const dataList = dataCoverage.get(beginTime, endTime, granularity);

		const stream2class = [
			"low-resolution-chunk",
			"high-resolution-chunk",
		];

		const list: TimeLineData[] = [];
		for (let stream = 0; stream < dataList.length; stream++) {
			const list2: TimeLineDataList = {};
			for (const timestamp in dataList[stream]) {
				let className: string = "";
				if (dataList[stream][timestamp].isPartialChunk) {
					className = "partial-chunk";
				} else
				if (dataList[stream][timestamp].isEvent) {
					className = "event";
				} else {
					className = stream2class[stream];
				}

				list2[timestamp] = {
					...dataList[stream][timestamp],
					className: className
				}
			}

			list.push({
				list: list2,
				granularity: granularity
			})
		}

		list[list.length - 1].isEvent = true;

		console.log('getData', `${performance.now() - time}ms`);

		return list;
	};

	function random(min: number, max: number): number { // min and max included
		return Math.floor(Math.random() * (max - min + 1) + min);
	}
});
