import {fusebox, pluginPostCSS, sparky} from "@libs/fuse-box";
import {pluginTypeChecker, TypeChecker} from "fuse-box-typechecker";
import {IPublicConfig} from "@libs/fuse-box/config/IConfig";

const fuseConfig: IPublicConfig = {
  sourceMap: {
    project: true,
    vendor: true,
    css: true
  },
  cache: {
    enabled: true,
    root: "build/.cache/browser"
  },
  modules: [
    "./modules"
  ],
  plugins: [
    pluginPostCSS("*.css")
  ]
};

class Context {}
const { task, rm } = sparky<Context>(Context);

task('build', async (context) => {
  fuseConfig.target = "browser";
  fuseConfig.entry = "./vistimeline.ts";
  fuseConfig.watcher = false;
  fuseConfig.devServer = false;
  fuseConfig.hmr = false;
  const fuse = fusebox(fuseConfig);

  fuse.runDev({
    uglify: false,
    bundles: {
      distRoot: "build/browser",
      cssSplitting: false,
      app: "app.js"
    }
  });
});

task('typecheck', async (context) => {
  // get typechecker, se under options for more info
  const typeChecker = TypeChecker({
    homeDir: "./",
    printFirstRun: true,
    isPlugin: false,
    tsConfigJsonContent: {},
      tsConfig: './tsconfig.json',
      basePath: './',
      name: 'TypeChecker TimeLine'
  });

  typeChecker.printSettings();
  typeChecker.inspectAndPrint();
});

task('test', async (context) => {
  fuseConfig.target = "browser";
  fuseConfig.entry = "test/index.ts";
  fuseConfig.webIndex = {
    publicPath: "./",
    template: 'test/test.html'
  };
  fuseConfig.devServer = {
    httpServer: {
      port: 4446,
    },
    hmrServer: {
      port: 4447
    }
  };
  fuseConfig.hmr = {
    enabled: true
  };
  fuseConfig.watcher = {
    root: "./"
  };
  fuseConfig.plugins && fuseConfig.plugins.push(
      pluginTypeChecker({
        tsConfig: './tsconfig.json',
        name: 'TypeChecker TimeLine'
      })
  );

  const fuse = fusebox(fuseConfig);
  fuse.runDev({
    uglify: false,
    bundles: {
      distRoot: "build/browser",
      cssSplitting: true,
      app: "app.js",
      vendor: "vendor.js"
    }
  });
});

task("clean", async () => {
  console.log("Removing build ...");
  await rm("build");
});

