import React, {useEffect, useRef} from "react";
import {MetaDataRender, MetaDataRenderAttrs} from "@solid/player/metadatarender";
import m from "mithril";

type MetadataProps = MetaDataRenderAttrs;

const Metadata = (props: MetadataProps) => {
  const drawNodeRef = useRef<HTMLDivElement>(null!);

  const {list, size, metadataType, time} = props;
  useEffect(() => {
    try {
      m.render(drawNodeRef.current, m(MetaDataRender, {metadataType, list, size, time}));
    }
    catch (e) {
      console.error("Metadata render error:", e);
    }
  }, [metadataType, list, size, time]);

  return (
    <div ref={drawNodeRef}/>
  );
};

export default Metadata;
