/**
 * AUTO-GENERATED FILE - DO NOT EDIT!!
 */
import {fetch as crossFetch, Request as crossRequest, Headers as crossHeaders} from "cross-fetch";
import { isNode } from "./utils";

let get: {fetch: typeof fetch, Request: typeof Request, Headers: typeof Headers} = {
  fetch: crossFetch,
  Request: crossRequest,
  Headers: crossHeaders
}
if (globalThis.fetch && !isNode()) {
  get = {
    fetch: globalThis.fetch.bind(globalThis),
    Request: globalThis.Request,
    Headers: globalThis.Headers
  }
}

export type APIResponse = {
  code: number,
  error: string,
  [key: string]: any
}

type ApiParameters = {
  backend?: string
}

export class API {
  _parameters: ApiParameters;

  lastResponseHeaders: { [header: string]: string[] } | null = null;

  headers: { [header: string]: string } = {};

  constructor(parameters: ApiParameters = {}) {
    this._parameters = Object.assign({
    }, parameters);
  }

  _send<T>(funcName: string, requestMethod: string, parameters: { [key: string]: any }, requiredParameters: string[], encodeParameters: string[]): Promise<APIResponse & T> {
    return this._sendHTTP<T>(funcName, requestMethod, parameters, requiredParameters, encodeParameters);
  }

  _sendHTTP<T>(funcName: string, requestMethod: string, parameters: { [key: string]: any }, requiredParameters: string[], encodeParameters: string[]): Promise<APIResponse & T> {
    return new Promise((resolve, reject) => {
      for (let i = 0; i < requiredParameters.length; i++) {
        let parameter = requiredParameters[i];
        if (typeof parameters[parameter] === "undefined") {
          reject({
            code: 400,
            message: "parameter '" + parameter + "' of function '" + funcName + "' should be specified",
            parameters
          });
          return;
        }
      }

      for (let parameter in parameters) {
        if (parameters[parameter] === null) {
          reject({
            code: 400,
            message: "parameter '" + parameter + "' of function '" + funcName + "' could not be null",
            parameters
          });
          return;
        }
      }

      let origin = this._parameters.backend ?? (!globalThis.location || globalThis.location.origin.startsWith("file") ? process.env.API_BACKEND || "" : "");
      origin = origin.endsWith("/") ? origin.substring(0, origin.length - 1) : origin;
      let url = `${origin}/api/call/${funcName}`;

      const headers = {
        'Accept': 'application/json'
      };

      const init: RequestInit = {
        method: requestMethod,
        cache: "no-store",
        credentials: 'include',
      };

      if (requestMethod === "GET") {
        for (let i = 0; i < encodeParameters.length; i++) {
          let parameter = encodeParameters[i];
          if (typeof parameters[parameter] !== "undefined") {
            parameters[parameter] = JSON.stringify(parameters[parameter]);
          }
        }

        let queryString = "";
        for (let parameter in parameters) {
          queryString += `${parameter}=${encodeURIComponent(parameters[parameter])}&`;
        }
        url += "?" + queryString;
      } else {
        headers['Content-Type'] = "application/json; charset=utf-8";
        init.body = JSON.stringify(parameters);
      }

      if (this.headers) {
        for (let header in this.headers) {
          headers[header] = this.headers[header];
        }
      }

      init.headers = new get.Headers(headers);
      get.fetch(new get.Request(url, init))
        .then((response) => {
          const isOk = response.status >= 200 && response.status < 300 || response.status === 304;
          response.json()
            .then((json) => {
              if (isOk) {
                // @ts-ignore
                if (response.headers && response.headers.raw) {
                  // @ts-ignore
                  this.lastResponseHeaders = Object.assign({}, response.headers.raw());
                }
                resolve(json);
              } else {
                const { code, error } = json;
                reject({
                  code: code,
                  message: error,
                  parameters
                });
              }
            })
            .catch((e) => {
              response.text()
                .then((text) => {
                  reject({
                    code: response.status,
                    message: text,
                    parameters
                  });
                })
                .catch((e) => {
                  reject({
                    code: response.status,
                    message: e.message,
                    parameters
                  });
                });
            });
        })
        .catch((e) => {
          const code = 0;
          const message = e.message;
          reject({
            code,
            message,
            parameters
          });
        });
    });
  }

  addHeaders(headers: { [header: string]: string }) {
    this.headers = headers;
  }

  getAttribute<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getAttribute";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj",
      "attribute"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAttributes<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getAttributes";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  isReplicated<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "isReplicated";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "objList"
    ];
    const arrayParameters: string[] = [
      "objList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getStats<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getStats";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAvatarKeyInfo<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getAvatarKeyInfo";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getBlockURL<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getBlockURL";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj",
      "blockId"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getBlocksInfo<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getBlocksInfo";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getIdentityAttribute<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getIdentityAttribute";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "attribute"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getIdentityAttributes<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getIdentityAttributes";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getObjectList<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getObjectList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "objList",
      "filterAttributeList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getObject<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getObject";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getDeletedObjectList<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getDeletedObjectList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSetList<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getSetList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "childObjList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getTemplates<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getTemplates";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "objList",
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getTypes<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getTypes";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getResourceTree<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getResourceTree";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  cameraDiscovery<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "cameraDiscovery";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj",
      "ticket",
      "parameters"
    ];
    const arrayParameters: string[] = [
      "parameters"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  probeURL<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "probeURL";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "ticket",
      "url"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  probeONVIF<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "probeONVIF";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "ticket"
    ];
    const arrayParameters: string[] = [
      "parameters"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getPermissionTypeList<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getPermissionTypeList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getEventsStatistics<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getEventsStatistics";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "objList",
      "beginTime",
      "endTime",
      "granularity"
    ];
    const arrayParameters: string[] = [
      "objList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  isEventExists<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "isEventExists";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "eventid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getTimezoneInformationList<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getTimezoneInformationList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "timezoneList"
    ];
    const arrayParameters: string[] = [
      "timezoneList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getStorageUsage<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getStorageUsage";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "objList",
      "granularity"
    ];
    const arrayParameters: string[] = [
      "objList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSystemStatus<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getSystemStatus";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAvatarStatus<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getAvatarStatus";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "objList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAuditRecords<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getAuditRecords";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "categories"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAuditCategories<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getAuditCategories";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getEventPriorities<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getEventPriorities";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getServerTime<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getServerTime";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAnalyticsSchema<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getAnalyticsSchema";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSessionList<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getSessionList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getMediaURL<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getMediaURL";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getMobileMediaURL<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getMobileMediaURL";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "cameraid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getMediaTicket<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getMediaTicket";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "cameraid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSubTicket<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getSubTicket";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSDP<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getSDP";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj",
      "sdp"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  authorizationManager<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "authorizationManager";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "objid",
      "streamtype"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getExportTicket<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getExportTicket";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj",
      "start",
      "end"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getCameraLog<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getCameraLog";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getVersionInformation<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getVersionInformation";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getRealmBranding<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getRealmBranding";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getCameraModelList<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getCameraModelList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getLastTargets<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getLastTargets";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getTargetRelatedZone<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getTargetRelatedZone";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "targetId"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  findHomography<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "findHomography";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "source",
      "destination"
    ];
    const arrayParameters: string[] = [
      "source",
      "destination"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAnnounceRoleUserList<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getAnnounceRoleUserList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  testLDAP<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "testLDAP";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getEventPolicyList<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getEventPolicyList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getEventPolicy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getEventPolicy";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "id"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getContentDeliveryDetails<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getContentDeliveryDetails";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "avatar"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSMWriterConf<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getSMWriterConf";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getGuiList<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getGuiList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAvatarGlobalSettings<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getAvatarGlobalSettings";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  purgeAvatarQueue<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "purgeAvatarQueue";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  iperfCheck<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "iperfCheck";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  rebootAvatar<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "rebootAvatar";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  canAddSatelliteUser<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "canAddSatelliteUser";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "name"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getInfo<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getInfo";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getFacialVer<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getFacialVer";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getNodeInfo<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getNodeInfo";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getCameraTemplate<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getCameraTemplate";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getDisplayServerLog<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getDisplayServerLog";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "avatarId"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getLabels<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getLabels";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getHierarchies<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getHierarchies";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getActions<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getActions";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getManuals<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getManuals";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  isLicenseAccepted<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "isLicenseAccepted";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getLicense<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getLicense";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAvatarList<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getAvatarList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "parameters"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getObjects<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "getObjects";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "type2attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  check<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "check";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getLoginInfo<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getLoginInfo";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  logout<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "logout";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  version<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "version";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getStamp<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getStamp";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getNode<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getNode";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "avatarid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getLanguageList<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getLanguageList";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAvatarMinVersion<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getAvatarMinVersion";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getPublicKeys<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getPublicKeys";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSSPPlansHTML<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getSSPPlansHTML";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getSSPEnabled<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getSSPEnabled";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getAvatarKeyState<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getAvatarKeyState";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getTrial<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getTrial";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getTrialHtml<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "getTrialHtml";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
      "name"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getLinkUpdateInfo<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getLinkUpdateInfo";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getParameters<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getParameters";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  getBranding<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "getBranding";
    const funcMethod = "GET";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  addObject<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "addObject";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "type",
      "attributes"
    ];
    const arrayParameters: string[] = [
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  deleteObject<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "deleteObject";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "objList"
    ];
    const arrayParameters: string[] = [
      "objList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setAttributes<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "setAttributes";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "objList",
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setStatAttributes<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "setStatAttributes";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
      "objList",
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setIdentityAttributes<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setIdentityAttributes";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "attributes"
    ];
    const arrayParameters: string[] = [
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  deleteBlocks<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "deleteBlocks";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj",
      "blockIdList"
    ];
    const arrayParameters: string[] = [
      "blockIdList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setBlock<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setBlock";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  changeObjectList<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "changeObjectList";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "parentobj"
    ];
    const arrayParameters: string[] = [
      "addList",
      "removeList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setPermission<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setPermission";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "parentId",
      "childId",
      "permission"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setSpecialCredentials<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setSpecialCredentials";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "roleid",
      "credentials"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  addAuditRecord<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "addAuditRecord";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "category",
      "paramsJSON"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  stopSession<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "stopSession";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setPassword<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setPassword";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "userid",
      "password"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  changePassword<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "changePassword";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "currentPassword",
      "newPassword"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setMetadataInfo<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setMetadataInfo";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "metaname",
      "ttl",
      "color",
      "font",
      "style",
      "height",
      "align",
      "valign"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  addEventPolicy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "addEventPolicy";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "name",
      "description",
      "eventsource_workflow_parameters",
      "eventpolicystorage"
    ];
    const arrayParameters: string[] = [
      "eventsource_workflow_parameters",
      "eventpolicystorage"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  editEventPolicy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "editEventPolicy";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id",
      "name",
      "description",
      "eventsource_workflow_parameters",
      "eventpolicystorage"
    ];
    const arrayParameters: string[] = [
      "eventsource_workflow_parameters",
      "eventpolicystorage"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  deleteEventPolicy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "deleteEventPolicy";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  acceptLicense<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "acceptLicense";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  activateAvatar<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "activateAvatar";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateAvatar<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "updateAvatar";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "attributes"
    ];
    const arrayParameters: string[] = [
      "attributes"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateAvatarKey<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "updateAvatarKey";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateAvatarSystem<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "updateAvatarSystem";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  upgradeAvatarSystem<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "upgradeAvatarSystem";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateAllAvatarSystems<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "updateAllAvatarSystems";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  migrateAvatar<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "migrateAvatar";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "oldAvatarId",
      "newAvatarId"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  syncConf<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "syncConf";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "realmid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  flushRedisCache<T>(): Promise<APIResponse & T> {
    const parameters = {};
    const funcName = "flushRedisCache";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  changeRole<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "changeRole";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "roleid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  changeUser<T>(parameters: { [key: string]: any } = {}): Promise<APIResponse & T> {
    const funcName = "changeUser";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  addSatelliteUser<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "addSatelliteUser";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "name"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  createVmxObjects<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "createVmxObjects";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "realmid"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  controlDisplayServer<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "controlDisplayServer";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "avatarId",
      "cmd"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  createLabels<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "createLabels";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "labelList"
    ];
    const arrayParameters: string[] = [
      "labelList"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  deleteLabel<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "deleteLabel";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  addLabel<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "addLabel";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj",
      "idList"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  removeLabel<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "removeLabel";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj",
      "idList"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  changeLabelName<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "changeLabelName";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id",
      "name"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  createHierarchy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "createHierarchy";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "name"
    ];
    const arrayParameters: string[] = [
      "tree"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateHierarchy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "updateHierarchy";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id",
      "tree"
    ];
    const arrayParameters: string[] = [
      "tree"
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  deleteHierarchy<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "deleteHierarchy";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  changeHierarchyName<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "changeHierarchyName";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "id",
      "name"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateSTime<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "updateSTime";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  updateRTime<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "updateRTime";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  setActiveVaeConfig<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "setActiveVaeConfig";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj",
      "vaeEngine",
      "configName"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  resendEmailConfirm<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "resendEmailConfirm";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  verify<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "verify";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "code"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  login<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "login";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "name"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  registerAvatar<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "registerAvatar";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "obj",
      "public_key"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  restorePassword<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "restorePassword";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "secret",
      "password"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  activateEmail<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "activateEmail";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "secret",
      "password"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

  passwordEmail<T>(parameters: { [key: string]: any }): Promise<APIResponse & T> {
    const funcName = "passwordEmail";
    const funcMethod = "POST";
    const requiredParameters: string[] = [
      "email"
    ];
    const arrayParameters: string[] = [
    ];
    return this._send<T>(funcName, funcMethod, parameters, requiredParameters, arrayParameters);
  }

}
