/* eslint-disable import/no-extraneous-dependencies */
import React from "react";
import { Image } from "semantic-ui-react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import PageWrapper from "components/PageWrapper";
import ConfirmCode from "components/ConfirmCode";
import { origin } from "core/api";
import { useStore } from "@core/store";
import { Activity, ActivityItem, ActivityItemProps } from "components/Activity";
import useLogout from "@core/useLogout";

import "./style.css";

const ConfirmCodePage = () => {
  const { store: { branding } } = useStore();
  const { logout } = useLogout();

  const items: React.ReactElement<ActivityItemProps, typeof ActivityItem>[] = [
    <ActivityItem key="Logout" name="" holdSideBar icon={<FontAwesomeIcon icon="sign-out-alt" onClick={() => logout()}/>} />
  ];

  return (
    <div className="page-wrapper">
      <div className="wrapper-logout">
        <Activity isSideBarVisible={false}>
          {items}
        </Activity>
      </div>
      <PageWrapper>
        <div className="left-side-confirm">
          <Image src={`${origin}${branding?.LOGIN_BACKGROUND_PATH ?? ""}`} fluid/>
        </div>
        <div className="right-side-confirm">
          <ConfirmCode/>
        </div>
      </PageWrapper>
    </div>
  );
};

export default ConfirmCodePage;
