/* eslint-disable import/no-extraneous-dependencies */
import React from "react";
import { Image } from "semantic-ui-react";
import PageWrapper from "components/PageWrapper";
import AccountRecovery from "components/AccountRecovery";
import {origin} from "core/api";
import { useStore } from "@core/store";

import "./style.css";

const AccountRecoveryPage = () => {
  const { store: { branding } } = useStore();

  return (
    <PageWrapper>
      <div className="left-side-recovery">
        <Image src={`${origin}${branding?.LOGIN_BACKGROUND_PATH ?? ""}`} fluid/>
      </div>
      <div className="right-side-recovery">
        <AccountRecovery/>
      </div>
    </PageWrapper>
  );
};

export default AccountRecoveryPage;
