import type { GraphQLResolveInfo, GraphQLScalarType, GraphQLScalarTypeConfig } from 'graphql';
import type { ClientContext } from 'graphql/resolvers';
import { gql } from '@apollo/client';
import * as Apollo from '@apollo/client';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type RequireFields<T, K extends keyof T> = Omit<T, K> & { [P in K]-?: NonNullable<T[P]> };
const defaultOptions = {} as const;
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  /** String representation of date/time in UTC zone, conforms to ISO 8601 */
  DateTime: Date;
  /** The `JSON` scalar type represents JSON values as specified by [ECMA-404](http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-404.pdf). */
  JSON: any;
  /** The `JSONObject` scalar type represents JSON objects as specified by [ECMA-404](http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-404.pdf). */
  JSONObject: any;
  UUID: string;
};

export type AccessLevel = {
  __typename?: 'AccessLevel';
  description: Scalars['String'];
  level: Scalars['String'];
  order: Scalars['Int'];
};

export type AcknowledgeAuditEntryInput = {
  categoryId: Scalars['String'];
  context: Scalars['ID'];
  external?: InputMaybe<Scalars['Boolean']>;
  modifiedAt: Scalars['DateTime'];
  note?: InputMaybe<Scalars['String']>;
  triggeredAt: Scalars['DateTime'];
  witnesses: Array<Scalars['String']>;
};

/** Entry for multiple acknowledge */
export type AcknowledgementEntry = {
  context: Scalars['ID'];
  triggeredAt: Scalars['DateTime'];
};

export type Action = {
  __typename?: 'Action';
  accessLevel: AccessLevel;
  action: Scalars['String'];
  description: Scalars['String'];
  deviceFunctionalAspectTypes: Array<DeviceFunctionalAspectType>;
  resourceTypes: Array<RealmObjectType>;
};

export enum ActivityId {
  About = 'About',
  Access = 'Access',
  Devices = 'Devices',
  Settings = 'Settings'
}

export type AodRequest = {
  __typename?: 'AodRequest';
  avatarId: Scalars['ID'];
  completedAt?: Maybe<Scalars['DateTime']>;
  createdAt: Scalars['DateTime'];
  deviceId: Scalars['ID'];
  downloaded?: Maybe<Scalars['Int']>;
  endTime: Scalars['DateTime'];
  eta?: Maybe<Scalars['Int']>;
  eventId?: Maybe<Scalars['ID']>;
  expiredAt?: Maybe<Scalars['DateTime']>;
  files?: Maybe<AodRequestFiles>;
  id: Scalars['ID'];
  note?: Maybe<Scalars['String']>;
  realmId: Scalars['ID'];
  size?: Maybe<Scalars['Int']>;
  startTime: Scalars['DateTime'];
  status: AodRequestStatus;
  streamNumber: Scalars['Int'];
  type?: Maybe<AodRequestType>;
  updatedAt?: Maybe<Scalars['DateTime']>;
  userId: Scalars['ID'];
};

export type AodRequestFiles = {
  __typename?: 'AodRequestFiles';
  expired: Scalars['DateTime'];
  list: Array<AodRequestFilesListEntry>;
};

export type AodRequestFilesListEntry = {
  __typename?: 'AodRequestFilesListEntry';
  endTime: Scalars['DateTime'];
  href: Scalars['String'];
  size: Scalars['Int'];
  startTime: Scalars['DateTime'];
};

export type AodRequestFilter = {
  /**  time interval in hours from the current one for which you need to receive updates  */
  interval: Scalars['Int'];
};

export type AodRequestInput = {
  endTime: Scalars['DateTime'];
  isPrivate?: InputMaybe<Scalars['Boolean']>;
  obj: Scalars['ID'];
  startTime: Scalars['DateTime'];
};

export enum AodRequestStatus {
  Canceled = 'CANCELED',
  Completed = 'COMPLETED',
  Exporting = 'EXPORTING',
  Failed = 'FAILED',
  Paused = 'PAUSED',
  Processing = 'PROCESSING',
  Queued = 'QUEUED'
}

export enum AodRequestType {
  Auto = 'Auto',
  Manual = 'Manual'
}

export type AppStore = {
  __typename?: 'AppStore';
  branding?: Maybe<Branding>;
  select?: Maybe<ObjUuid>;
  session: Session;
  socketEvent?: Maybe<SocketEvent>;
  workspace: Workspace;
};

export type AppStoreInput = {
  branding?: InputMaybe<BrandingInput>;
  select?: InputMaybe<ObjUuidInput>;
  session?: InputMaybe<SessionInput>;
  socketEvent?: InputMaybe<SocketEventInput>;
  workspace?: InputMaybe<WorkspaceInput>;
};

export type ArchiveBoundary = {
  __typename?: 'ArchiveBoundary';
  boundary?: Maybe<Scalars['DateTime']>;
  timeInsideGap: Scalars['Boolean'];
};

export type ArchiveCoverage = {
  __typename?: 'ArchiveCoverage';
  coverage: Array<ArchiveCoverageItem>;
  partialCoverage: Array<ArchiveCoverageItem>;
  ttl: Array<ArchiveCoverageTtl>;
};

export type ArchiveCoverageItem = {
  __typename?: 'ArchiveCoverageItem';
  deviceId: Scalars['ID'];
  streamNumber: Scalars['Int'];
  time: Scalars['Int'];
};

export type ArchiveCoverageTtl = {
  __typename?: 'ArchiveCoverageTTL';
  deviceId: Scalars['ID'];
  ttl: Scalars['Int'];
};

/** Aspect Health settings and status */
export type AspectHealth = {
  __typename?: 'AspectHealth';
  /** importance of the aspect for the device health (CRITICAL/NORMAL/...) */
  gravity: Fa_HealthGravity;
  /** Status can take values from HealthStatus enum (from "core") */
  healthStatus: HealthStatus;
  /** timeout (seconds) before declaring aspect unhealthy */
  livenessTimeout: Scalars['Int'];
  /** timeout (seconds) after start before aspect is expected to perform normally */
  readinessTimeout: Scalars['Int'];
};

/** Aspect Health settings and status */
export type AspectHealthFilter = {
  /** importance of the aspect for the device health (CRITICAL/NORMAL/...) */
  gravity?: InputMaybe<Fa_HealthGravity>;
  /** Status can take values from HealthStatus enum (from "core") */
  healthStatus?: InputMaybe<HealthStatus>;
};

export enum AspectSensorCategory {
  Door = 'Door',
  Fence = 'Fence',
  None = 'None'
}

export enum AspectSensorModel {
  Generic = 'Generic',
  Hikvision = 'Hikvision'
}

export type AssociatedGatewayDevice = {
  __typename?: 'AssociatedGatewayDevice';
  /**  List of Overcast devices mapped to gateway device id  */
  associatedDevices: Array<Scalars['String']>;
  /**  Gateway device id  */
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type AssociatedGatewayDeviceInput = {
  associatedDevices: Array<Scalars['String']>;
  id: Scalars['ID'];
};

/**
 * Audit entries are organized by Categories.
 * This is done in the way where the particular audit message is not reported by the actual message, but by numeric category.
 * One category entry may contain the parameterized message for multiple local languages in 'digest' attribute
 */
export type AuditCategory = {
  __typename?: 'AuditCategory';
  /**  JSON stored in a string, encoding parametrized messages for various localities, i.e. '{"en-us": "%1 stream request"}'  */
  digest: Scalars['String'];
  /**  Numeric ID in underlying implementation  */
  id: Scalars['ID'];
  /**  categories grouped by scope, parent is NULL for the first level category that cannot have events   */
  parent?: Maybe<Scalars['ID']>;
  /**  Field contains the info for generic identification  */
  shortName: Scalars['String'];
};

/** Audit entry provides the information for one audit event */
export type AuditEntry = {
  __typename?: 'AuditEntry';
  /**  The reference to the AuditCategory applicable to this particular entry  */
  category: AuditCategory;
  /**  Unique identifier for the Audit Event, uses UUIDv1 with timestamp part always equal to triggeredAt(!)  */
  context: Scalars['ID'];
  /**  Event Acknowledgement  */
  isAcknowledged: Scalars['Boolean'];
  /**  The audit message, which is properly applies parameters (like client language settings and event parameters) into the audit category message template  */
  message: Scalars['String'];
  /**  Audit Entry may contain zero or more metadata classifiers attached, these contain the normalized metadata categories and can be used for grouping/searching  */
  metadata: Array<MetaEntry>;
  /**  Date/Time when event was last updated, matches to triggeredAt for events never updated  */
  modifiedAt: Scalars['DateTime'];
  /**  Event Note  */
  note?: Maybe<Scalars['String']>;
  /** Audit Entry may contain one or more attached snapshots, only one of thm will be marked as 'default' and will have a quick access path when retrieving multiple audit entries  */
  snapshots: Array<AuditSnapshot>;
  /**  Date/Time when Event happened, it is not necessarily when it was registered  */
  triggeredAt: Scalars['DateTime'];
  /**  The list of RealmObjects (typically Device entries) witnessing the context of this Audit Event/Entry  */
  witnesses: Array<RealmObject>;
};

export type AuditEntryEvent = AuditEntry | ErrorInfo;

/** Audit entries filter data. */
export type AuditEntryFilter = {
  /**  List of Audit Category IDs. If not specified, entries from all categories are returned  */
  categories?: InputMaybe<Array<Scalars['ID']>>;
  /**  From date-time. If not specified, last hour is assumed  */
  from?: InputMaybe<Scalars['DateTime']>;
  /**  If limit is not specified, 100 is assumed. Limit cannot be more than 100  */
  limit?: InputMaybe<Scalars['Int']>;
  /**  If start is not specified, 0 is assumed  */
  start?: InputMaybe<Scalars['Int']>;
  /**  To date-time. If not specified, current time is assumed  */
  to?: InputMaybe<Scalars['DateTime']>;
  /**  List of Realm Object IDs  */
  witnesses: Array<Scalars['ID']>;
};

export type AuditEntryInput = {
  context: Scalars['ID'];
  isAcknowledged: Scalars['Boolean'];
  message: Scalars['String'];
  modifiedAt: Scalars['DateTime'];
  note?: InputMaybe<Scalars['String']>;
  snapshots: Array<AuditSnapshotInput>;
  triggeredAt: Scalars['DateTime'];
  witnesses: Array<RealmObjectInput>;
};

/**
 * AuditEntry can have zero, one or more snapshots attached to it.
 * Snapshot[s] provide the visual queues for the Audit Entry/Event visualization for the end-user.
 * Only one of these snapshots will have 'default' property marked as true, and it will be provided when requesting multiple entries with snapshots included.
 * It is possible to get the remaining snapshots when running query for individual AuditEntry.id.
 */
export type AuditSnapshot = {
  __typename?: 'AuditSnapshot';
  /** Flag if particular snapshot is a default one to be shown with an Event */
  default: Scalars['Boolean'];
  /** Snapshot, base64 encoded into String */
  snapshot: Scalars['String'];
  /** Tags allow to keep additional convenience annotations and are stored as Key->Value mappings */
  tags: Array<KeyValue>;
  /** Type is provided by VAE and is not intended for end-user consumption, it is ID-like */
  type: Scalars['String'];
};

export type AuditSnapshotInput = {
  default: Scalars['Boolean'];
  snapshot: Scalars['String'];
  tags: Array<KeyValueInput>;
  type: Scalars['String'];
};

export enum AuthType {
  HttpBasic = 'HTTP_BASIC',
  HttpDigest = 'HTTP_DIGEST',
  NoAuth = 'NO_AUTH'
}

export type AvatarMetric = {
  __typename?: 'AvatarMetric';
  /**  Dimension  */
  dimension: MetricDimension;
  /**  Metric name  */
  key: AvatarMetricName;
  /**  Description of metric  */
  name: Scalars['String'];
};

export enum AvatarMetricName {
  ChannelArchiveScheduledBytes = 'CHANNEL_ARCHIVE_SCHEDULED_BYTES',
  ChannelJitterMs = 'CHANNEL_JITTER_MS',
  /**  Channel statistics  */
  ChannelRttMs = 'CHANNEL_RTT_MS',
  ChannelSentArchiveBps = 'CHANNEL_SENT_ARCHIVE_BPS',
  ChannelSentLiveBps = 'CHANNEL_SENT_LIVE_BPS',
  /**  Channel bandwidth statistics  */
  ChannelTotalInboundBps = 'CHANNEL_TOTAL_INBOUND_BPS',
  CpuIdle = 'CPU_IDLE',
  CpuIowait = 'CPU_IOWAIT',
  /**  Cpu statistics  */
  CpuUsage = 'CPU_USAGE',
  DiskIoPct = 'DISK_IO_PCT',
  LocalStreamingArchiveBps = 'LOCAL_STREAMING_ARCHIVE_BPS',
  LocalStreamingClientsCount = 'LOCAL_STREAMING_CLIENTS_COUNT',
  /**  Local media downloads  */
  LocalStreamingLiveBps = 'LOCAL_STREAMING_LIVE_BPS',
  /**  Memory statistics  */
  MemFreePct = 'MEM_FREE_PCT'
}

export enum BaseDeviceType {
  Avatar = 'AVATAR',
  Camera = 'CAMERA',
  Gateway = 'GATEWAY',
  Sensor = 'SENSOR'
}

export enum BasicAccessConfiguration {
  LimitedAudioSupport = 'limitedAudioSupport',
  LimitedAuditAccess = 'limitedAuditAccess',
  LimitedExportTime = 'limitedExportTime',
  LimitedGisAccess = 'limitedGISAccess',
  LimitedImportCamerasAccess = 'limitedImportCamerasAccess',
  LimitedMonitorCount = 'limitedMonitorCount',
  LimitedRealmAdministration = 'limitedRealmAdministration',
  LimitedReportsAccess = 'limitedReportsAccess',
  LimitedSetsAccess = 'limitedSetsAccess',
  LimitedSpeedList = 'limitedSpeedList',
  LimitedVideoAnalyticsAccess = 'limitedVideoAnalyticsAccess',
  LimitedZonesAccess = 'limitedZonesAccess'
}

export enum BoundaryFind {
  Next = 'NEXT',
  Prev = 'PREV'
}

export type BrandInfo = {
  __typename?: 'BrandInfo';
  iconUrl: Scalars['String'];
  logoUrl: Scalars['String'];
  name: Scalars['String'];
  shortName: Scalars['String'];
  website: Scalars['String'];
};

export type Branding = {
  __typename?: 'Branding';
  CRM_REGISTRATION_URL: Scalars['String'];
  ICON_PATH: Scalars['String'];
  LOGIN_BACKGROUND_PATH: Scalars['String'];
  LOGIN_FOOTER_COLOR: Scalars['String'];
  LOGO_PATH: Scalars['String'];
  OEM_BRAND: Scalars['String'];
  OEM_BRAND_NAME: Scalars['String'];
  OEM_COMPANY_LONG: Scalars['String'];
  OEM_COMPANY_PHONE: Scalars['String'];
  OEM_COMPANY_PHONE_INTERNATIONAL: Scalars['String'];
  OEM_COMPANY_QUICKSTART: Scalars['String'];
  OEM_COMPANY_SHORT: Scalars['String'];
  OEM_COMPANY_SUPPORT_PHONE: Scalars['String'];
  OEM_COMPANY_SUPPORT_URL: Scalars['String'];
  OEM_COMPANY_URL: Scalars['String'];
  OEM_COPYRIGHT: Scalars['String'];
  OEM_COPYRIGHT_MATRIX: Scalars['String'];
  OEM_STYLE: Scalars['String'];
  OEM_SUPPORT_EMAIL: Scalars['String'];
  OEM_TRADEMARKS: Scalars['String'];
  QUICK_START_GUIDE_PATH: Scalars['String'];
  crmRegistrationUrl?: Maybe<Scalars['String']>;
  iconPath?: Maybe<Scalars['String']>;
  loginBackgroundPath?: Maybe<Scalars['String']>;
  loginFooterColor?: Maybe<Scalars['String']>;
  logoPath?: Maybe<Scalars['String']>;
  oemBrand?: Maybe<Scalars['String']>;
  oemBrandName?: Maybe<Scalars['String']>;
  oemCompanyLong?: Maybe<Scalars['String']>;
  oemCompanyPhone?: Maybe<Scalars['String']>;
  oemCompanyPhoneInternational?: Maybe<Scalars['String']>;
  oemCompanyQuickstart?: Maybe<Scalars['String']>;
  oemCompanyShort?: Maybe<Scalars['String']>;
  oemCompanySupportPhone?: Maybe<Scalars['String']>;
  oemCompanySupportUrl?: Maybe<Scalars['String']>;
  oemCompanyUrl?: Maybe<Scalars['String']>;
  oemCopyright?: Maybe<Scalars['String']>;
  oemCopyrightMatrix?: Maybe<Scalars['String']>;
  oemStyle?: Maybe<Scalars['String']>;
  oemSupportEmail?: Maybe<Scalars['String']>;
  oemTrademarks?: Maybe<Scalars['String']>;
  quickStartGuidePath?: Maybe<Scalars['String']>;
};

export type BrandingInput = {
  CRM_REGISTRATION_URL: Scalars['String'];
  ICON_PATH: Scalars['String'];
  LOGIN_BACKGROUND_PATH: Scalars['String'];
  LOGIN_FOOTER_COLOR: Scalars['String'];
  LOGO_PATH: Scalars['String'];
  OEM_BRAND: Scalars['String'];
  OEM_BRAND_NAME: Scalars['String'];
  OEM_COMPANY_LONG: Scalars['String'];
  OEM_COMPANY_PHONE: Scalars['String'];
  OEM_COMPANY_PHONE_INTERNATIONAL: Scalars['String'];
  OEM_COMPANY_QUICKSTART: Scalars['String'];
  OEM_COMPANY_SHORT: Scalars['String'];
  OEM_COMPANY_SUPPORT_PHONE: Scalars['String'];
  OEM_COMPANY_SUPPORT_URL: Scalars['String'];
  OEM_COMPANY_URL: Scalars['String'];
  OEM_COPYRIGHT: Scalars['String'];
  OEM_COPYRIGHT_MATRIX: Scalars['String'];
  OEM_STYLE: Scalars['String'];
  OEM_SUPPORT_EMAIL: Scalars['String'];
  OEM_TRADEMARKS: Scalars['String'];
  QUICK_START_GUIDE_PATH: Scalars['String'];
};

export type CameraLog = {
  __typename?: 'CameraLog';
  message: Scalars['String'];
  severity: LogSeverity;
  time: Scalars['DateTime'];
};

export type CameraMetric = {
  __typename?: 'CameraMetric';
  /**  FA id  */
  dfaId: Scalars['Int'];
  /**  Dimension  */
  dimension: MetricDimension;
  /**  Metric name  */
  key: CameraMetricName;
  /**  Description of metric  */
  name: Scalars['String'];
};

export enum CameraMetricName {
  /**  Camera media bit-rate, per stream. History on camera media streams bitrate  */
  Bitrate = 'BITRATE',
  /**  Percentage of LINK storage utilized by devices and streams. History on scheduled and on-demand media requested to be delivered to the cloud  */
  CloudArchiveBps = 'CLOUD_ARCHIVE_BPS',
  CloudArchiveModBps = 'CLOUD_ARCHIVE_MOD_BPS',
  CloudLiveBps = 'CLOUD_LIVE_BPS',
  CloudLiveModBps = 'CLOUD_LIVE_MOD_BPS',
  /**  History on camera media streams utilizing LINK local storage  */
  LinkStoragePct = 'LINK_STORAGE_PCT',
  LocalArchiveModBps = 'LOCAL_ARCHIVE_MOD_BPS',
  LocalLiveModBps = 'LOCAL_LIVE_MOD_BPS',
  /**  Status, Errors and Warnings. History on processors status changes (count) */
  Status = 'STATUS',
  StreamFps = 'STREAM_FPS',
  /**  Percentage of media requested for on-demand and scheduled delivery. Media stream statistics  */
  StreamGop = 'STREAM_GOP',
  StreamJitter = 'STREAM_JITTER',
  StreamRestarts = 'STREAM_RESTARTS',
  StreamRtpPckLoss = 'STREAM_RTP_PCK_LOSS'
}

export type CameraWidgetProps = {
  __typename?: 'CameraWidgetProps';
  deviceId: Scalars['ID'];
  index: Scalars['Int'];
  name: Scalars['String'];
  time?: Maybe<Scalars['Int']>;
  viewId: Scalars['String'];
};

export type CameraWidgetPropsInput = {
  deviceId: Scalars['ID'];
  index: Scalars['Int'];
  name: Scalars['String'];
  time?: InputMaybe<Scalars['Int']>;
  viewId: Scalars['String'];
};

export type ChangeCurrentPasswordInput = {
  currentPassword: Scalars['String'];
  newPassword: Scalars['String'];
};

export type ChangePasswordInput = {
  currentPassword: Scalars['String'];
  newPassword: Scalars['String'];
  userId: Scalars['ID'];
};

export type ChannelBenchmark = {
  __typename?: 'ChannelBenchmark';
  error?: Maybe<Scalars['String']>;
  startedAt?: Maybe<Scalars['DateTime']>;
  tcpDown?: Maybe<ChannelStatistics>;
  tcpUp?: Maybe<ChannelStatistics>;
};

export type ChannelStatistics = {
  __typename?: 'ChannelStatistics';
  bitsPerSecond?: Maybe<Scalars['Float']>;
  bytes?: Maybe<Scalars['Int']>;
  maxRtt?: Maybe<Scalars['Int']>;
  maxSndCwnd?: Maybe<Scalars['Int']>;
  meanRtt?: Maybe<Scalars['Int']>;
  minRtt?: Maybe<Scalars['Int']>;
  retransmits?: Maybe<Scalars['Int']>;
};

export enum ChannelStatus {
  DelayedCatchup = 'DELAYED_CATCHUP',
  DelayedDegraded = 'DELAYED_DEGRADED',
  Ontime = 'ONTIME'
}

export type CreateResult = {
  __typename?: 'CreateResult';
  id: Scalars['ID'];
  warning?: Maybe<Scalars['String']>;
  warningFields?: Maybe<Array<WarningField>>;
};

export type CreatingView = {
  __typename?: 'CreatingView';
  layout?: Maybe<Scalars['String']>;
  layoutJSON?: Maybe<Scalars['String']>;
  name: Scalars['String'];
  selectedWidget?: Maybe<WidgetInfo>;
  template?: Maybe<Scalars['String']>;
  viewId: Scalars['String'];
  widgets?: Maybe<Array<WidgetInfo>>;
};

export type CreatingViewInput = {
  layout?: InputMaybe<Scalars['String']>;
  layoutJSON?: InputMaybe<Scalars['String']>;
  name: Scalars['String'];
  selectedWidget?: InputMaybe<WidgetInfoInput>;
  template?: InputMaybe<Scalars['String']>;
  viewId: Scalars['String'];
  widgets?: InputMaybe<Array<WidgetInfoInput>>;
};

/** Current Realm */
export type CurrentRealm = RealmObject & {
  __typename?: 'CurrentRealm';
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Object ID (UUID) */
  id: Scalars['ID'];
  imageMapConfig?: Maybe<Scalars['String']>;
  /** Max duration of the video to upload in minutes */
  maxDownloadLength?: Maybe<Scalars['Int']>;
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Object name */
  name: Scalars['String'];
  sharedViews?: Maybe<Scalars['String']>;
  type: RealmObjectType;
};

export type CurrentRealmInput = {
  id: Scalars['ID'];
  imageMapConfig?: InputMaybe<Scalars['String']>;
  sharedViews?: InputMaybe<Scalars['String']>;
};

/** Functional Aspect descriptor for "Avatar" aspect. */
export type Dfa_Avatar = DeviceFunctionalAspect & {
  __typename?: 'DFA_Avatar';
  apiKey?: Maybe<Scalars['String']>;
  avatarLoad?: Maybe<Scalars['Int']>;
  channelBenchmark?: Maybe<ChannelBenchmark>;
  channelStatus?: Maybe<ChannelStatus>;
  channelTurnaroundTime?: Maybe<StatTime>;
  deliveryQueue?: Maybe<Scalars['Int']>;
  deliveryQueueUploadTime?: Maybe<Scalars['Int']>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  dsConfiguredState?: Maybe<DsConfiguredState>;
  dsRunningState?: Maybe<DsRunningState>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  encryptionKey?: Maybe<EncryptionKeyInfo>;
  /**  internal use only  */
  extended?: Maybe<Scalars['JSONObject']>;
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  isLink?: Maybe<Scalars['Boolean']>;
  lastStatusUpdate?: Maybe<Scalars['DateTime']>;
  localStorage?: Maybe<LocalStorage>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  packetArrivalJitterTime?: Maybe<StatTime>;
  platform?: Maybe<Scalars['String']>;
  pushEventEndPoint?: Maybe<Scalars['String']>;
  software?: Maybe<SoftwareInfo>;
  statusUpdateInterval?: Maybe<Scalars['Int']>;
  storageUsage?: Maybe<StorageUsage>;
  supportsReboot?: Maybe<Scalars['Boolean']>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  turnaroundTime?: Maybe<Scalars['Int']>;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  upTime?: Maybe<Scalars['Int']>;
  uploadBandwidthCap?: Maybe<Scalars['Float']>;
  vaeImageUpdate?: Maybe<Scalars['Boolean']>;
  vaeUpdates?: Maybe<Array<VaeUpdate>>;
  vmxVideoStreamingMode?: Maybe<VmxVideoStreamingMode>;
  webRtcEnabled?: Maybe<Scalars['Boolean']>;
};

export type Dfa_Gateway = DeviceFunctionalAspect & {
  __typename?: 'DFA_Gateway';
  /**  Associated devices  */
  associatedGatewayDevices: Array<AssociatedGatewayDevice>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  Full list of Lenel devices  */
  devices: Array<GatewayProbeDevice>;
  /**  Full list of Lenel directories  */
  directories: Array<GatewayDirectory>;
  /**  Current Lenel directory  */
  directory: GatewayDirectory;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Full list of Lenel events  */
  events: Array<GatewayProbeEvent>;
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Lenel version  */
  lenelVersion: Scalars['String'];
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  /**  OpenID Connect token  */
  oidcToken?: Maybe<Scalars['String']>;
  /**  Associated events  */
  subscribedEvents: Array<GatewayEvent>;
  /**  Source template from which aspect was created. Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.  */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
};

/**
 * Functional Aspect descriptor for "Live Media" aspects.
 * Each media stream (video/audio) receives a separate DFA descriptor.
 */
export type Dfa_Media = DeviceFunctionalAspect & {
  __typename?: 'DFA_Media';
  FPS?: Maybe<Scalars['Float']>;
  URL?: Maybe<Scalars['String']>;
  audioCodec?: Maybe<Scalars['String']>;
  averageFPS?: Maybe<Scalars['Float']>;
  averageGOP?: Maybe<Scalars['Float']>;
  averageInterArrivalJitter?: Maybe<Scalars['Float']>;
  cloudArchive: MediaArchiveOption;
  codec?: Maybe<Scalars['String']>;
  /**  Statistic  */
  consumedSpace?: Maybe<Scalars['Float']>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  Archive settings  */
  edgeArchive: MediaArchiveOption;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  frameRate?: Maybe<Scalars['Float']>;
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  liveBitrate?: Maybe<Scalars['Float']>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  onvifProfile?: Maybe<Scalars['String']>;
  onvifProfiles?: Maybe<Scalars['JSONObject']>;
  rtpPacketLost?: Maybe<Scalars['Int']>;
  /**  Streams in social networks  */
  sharedStream?: Maybe<Array<StreamShare>>;
  spaceUsageDay?: Maybe<Scalars['Float']>;
  spaceUsageHour?: Maybe<Scalars['Float']>;
  /**  Stream properties  */
  streamType: MediaStreamType;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  uptime?: Maybe<Scalars['Int']>;
  videoCodec?: Maybe<Scalars['String']>;
  videoHeight?: Maybe<Scalars['Int']>;
  videoSize?: Maybe<Scalars['String']>;
  videoWidth?: Maybe<Scalars['Int']>;
};

/** Functional Aspect descriptor for "PTZ" aspect. */
export type Dfa_Ptz = DeviceFunctionalAspect & {
  __typename?: 'DFA_PTZ';
  /**  Set of supported command classes (for future, currently is not used)  */
  cmdClassSupport?: Maybe<Array<Ptz_Class>>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  ptzConfig?: Maybe<Scalars['String']>;
  /**  PTZ options */
  ptzPanInverted?: Maybe<Scalars['Boolean']>;
  ptzTiltInverted?: Maybe<Scalars['Boolean']>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
};

/** Functional Aspect descriptor for Sensors aspects. */
export type Dfa_Sensor = DeviceFunctionalAspect & {
  __typename?: 'DFA_Sensor';
  /**  Device ids which assigned to sensor  */
  associatedDevices?: Maybe<Array<Scalars['String']>>;
  /**  Sensor category (like Door, Fence)  */
  category?: Maybe<AspectSensorCategory>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Sensor model  */
  model?: Maybe<Scalars['String']>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  /**  Sensor events with description  */
  sensorEvents?: Maybe<Array<SensorEvent>>;
  /**  Sensor serial number  */
  serial?: Maybe<Scalars['String']>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  /**  Selected types of sensor events  */
  userEvents?: Maybe<Array<Scalars['String']>>;
};

/**
 * Functional Aspect descriptor for Analytics aspects.
 * Typically, these Aspects are Analytics performed by VAE.
 */
export type Dfa_Vae = DeviceFunctionalAspect & {
  __typename?: 'DFA_VAE';
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  /**  Active VAE config  */
  vaeConfig?: Maybe<VaeConfigFull>;
  /**  VAE features for VAE configurator  */
  vaeFeatures?: Maybe<Array<Scalars['String']>>;
};

export enum DsConfiguredState {
  Off = 'OFF',
  On = 'ON'
}

export enum DsRunningState {
  Running = 'RUNNING',
  Stopped = 'STOPPED'
}

export type DefaultGeoPosition = {
  __typename?: 'DefaultGeoPosition';
  lat: Scalars['Float'];
  lng: Scalars['Float'];
};

export type DeliveryPriorityInput = {
  deliveryPriority: Scalars['Int'];
  deviceId: Scalars['ID'];
};

/**
 * Device descriptor.
 * Device always belongs to a Realm and has some base configuration shared to device functional aspects.
 */
export type Device = RealmObject & {
  __typename?: 'Device';
  /**  Acknowledging for event witch detected by analytic modules  */
  acknowledgeRequired?: Maybe<Scalars['Boolean']>;
  /** Functional aspects (like "media", "events", ...) */
  aspects: Array<DeviceFunctionalAspect>;
  /**  Cloud direct  */
  cloudDirect: Scalars['Boolean'];
  /** General device settings */
  config: DeviceBaseConfig;
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Strategies for content delivery */
  delivery?: Maybe<Scalars['String']>;
  deliveryPriority?: Maybe<Scalars['Int']>;
  /** Do not use, for internal use only */
  deviceType?: Maybe<BaseDeviceType>;
  enabled: Scalars['Boolean'];
  /** Advanced Camera Settings */
  eventType?: Maybe<DeviceEventType>;
  healthStatus: HealthStatus;
  /** Device ID (UUID) */
  id: Scalars['ID'];
  /** Optional location as specified by user */
  location?: Maybe<Scalars['String']>;
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Device name */
  name: Scalars['String'];
  /** Avatar, DVR, external system */
  platform?: Maybe<Device>;
  /** GEO position */
  position?: Maybe<LatLng>;
  /** Camera Stream Settings */
  rtpOverTcp?: Maybe<Scalars['Boolean']>;
  rtpTime?: Maybe<Scalars['Boolean']>;
  /** Optional set for authorization policy definition simplification */
  set?: Maybe<Array<ObjectDescriptor>>;
  storageConfig?: Maybe<DeviceStorageConfig>;
  type: RealmObjectType;
  version: Scalars['String'];
  /** Optional zone for authorization policy definition simplification */
  zone?: Maybe<ObjectDescriptor>;
};

/**
 * Generic device configuration settings.
 * These are shared between multiple DeviceFunctionalAspect entries device may have.
 */
export type DeviceBaseConfig = {
  __typename?: 'DeviceBaseConfig';
  configType: DeviceBaseConfigType;
  connect: NetworkConnectDescriptor;
  firmware?: Maybe<Scalars['String']>;
  make?: Maybe<Scalars['String']>;
  model?: Maybe<Scalars['String']>;
  onvifServices?: Maybe<Scalars['String']>;
};

export type DeviceBaseConfigInput = {
  configType: DeviceBaseConfigType;
  connect: NetworkConnectDescriptorInput;
  firmware?: InputMaybe<Scalars['String']>;
  make?: InputMaybe<Scalars['String']>;
  model?: InputMaybe<Scalars['String']>;
  onvifServices?: InputMaybe<Scalars['String']>;
};

/** The paradigm in which device is managed. */
export enum DeviceBaseConfigType {
  /** Demo */
  Demo = 'DEMO',
  /** Gateway */
  Gateway = 'GATEWAY',
  /** On-board */
  Onboard = 'ONBOARD',
  /** Using ONVIF standard */
  Onvif = 'ONVIF',
  /** Sensor */
  Sensor = 'SENSOR',
  /** Using URI */
  Url = 'URL'
}

export enum DeviceCommand {
  AvatarChannelBenchmark = 'AVATAR_CHANNEL_BENCHMARK',
  AvatarDsActivate = 'AVATAR_DS_ACTIVATE',
  AvatarDsDeactivate = 'AVATAR_DS_DEACTIVATE',
  AvatarDsStart = 'AVATAR_DS_START',
  AvatarDsStop = 'AVATAR_DS_STOP',
  AvatarReboot = 'AVATAR_REBOOT',
  AvatarUpdateKey = 'AVATAR_UPDATE_KEY',
  AvatarUpdateSoftware = 'AVATAR_UPDATE_SOFTWARE',
  AvatarUpgradeSoftware = 'AVATAR_UPGRADE_SOFTWARE'
}

export enum DeviceEventType {
  Alert = 'alert',
  Information = 'information'
}

/**
 * Functional Aspect is a descriptor of the abstract functionality.
 * Zero, one or more Aspects may be attached to the Device.
 * Aspects are presented for the easy reasoning what kind of functionality particular device
 * can provide and description of what particular Aspect is and if it is operational.
 */
export type DeviceFunctionalAspect = {
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Aspect name, suitable for GUI presentation. In most cases derived from the template name.  */
  name: Scalars['String'];
  /**  Source template from which aspect was created. Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.  */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
};

/**
 * Functional Aspect is a descriptor of the abstract functionality.
 * Zero, one or more Aspects may be attached to the Device.
 * Aspects are presented for the easy reasoning what kind of functionality particular device
 * can provide and description of what particular Aspect is and if it is operational.
 */
export type DeviceFunctionalAspectFilter = {
  /** True if aspect is enabled for the device */
  enabled?: InputMaybe<Scalars['Boolean']>;
  /** Aspect Health settings and status */
  health?: InputMaybe<AspectHealthFilter>;
  /** Aspect name, suitable for GUI presentation */
  name?: InputMaybe<Scalars['String']>;
  /** ID of source template from which aspect was created. */
  templateId?: InputMaybe<Scalars['String']>;
  /** Aspect type (video/analytic/etc..) */
  type?: InputMaybe<DeviceFunctionalAspectType>;
};

export type DeviceFunctionalAspectInput = {
  URL?: InputMaybe<Scalars['String']>;
  /**  Device ids which assigned Sensor  */
  associatedDevices?: InputMaybe<Array<Scalars['String']>>;
  /**  Associated devices  */
  associatedGatewayDevices?: InputMaybe<Array<AssociatedGatewayDeviceInput>>;
  /**  Sensor category (like Door, Fence)  */
  category?: InputMaybe<AspectSensorCategory>;
  cloudArchive?: InputMaybe<MediaArchiveOption>;
  /**  Set of supported command classes (for future, currently is not used)  */
  cmdClassSupport?: InputMaybe<Array<Ptz_Class>>;
  codec?: InputMaybe<Scalars['String']>;
  /**  Lenel devices list  */
  devices?: InputMaybe<Array<GatewayDeviceInput>>;
  /**  Lenel directories list  */
  directories?: InputMaybe<Array<GatewayDirectoryInput>>;
  /**  Current Lenel directory id  */
  directoryId?: InputMaybe<Scalars['String']>;
  /**  Live/Archive settings  */
  edgeArchive?: InputMaybe<MediaArchiveOption>;
  /** True if aspect is enabled for the device */
  enabled: Scalars['Boolean'];
  /**  Lenel events list  */
  events?: InputMaybe<Array<GatewayEventInput>>;
  frameRate?: InputMaybe<Scalars['Float']>;
  id: Scalars['ID'];
  /** Actual instances of aspects on the same device which produce inputs for the aspect. */
  inputAspectIDs: Array<Scalars['ID']>;
  lenelVersion?: InputMaybe<Scalars['String']>;
  /**  Sensor model  */
  model?: InputMaybe<Scalars['String']>;
  /** Aspect name, suitable for GUI presentation. In most cases derived from the template name. */
  name: Scalars['String'];
  /**  OpenID Connect token  */
  oidcToken?: InputMaybe<Scalars['String']>;
  onvifProfile?: InputMaybe<Scalars['String']>;
  onvifProfiles?: InputMaybe<Scalars['JSONObject']>;
  ptzConfig?: InputMaybe<Scalars['String']>;
  ptzPanInverted?: InputMaybe<Scalars['Boolean']>;
  ptzTiltInverted?: InputMaybe<Scalars['Boolean']>;
  pushEventEndPoint?: InputMaybe<Scalars['String']>;
  /**  Sensor events with description  */
  sensorEvents?: InputMaybe<Array<SensorEventInput>>;
  /**  Sensor serial number  */
  serial?: InputMaybe<Scalars['String']>;
  /**  RTMP urls for sharing stream in social networks  */
  sharedStream?: InputMaybe<Array<Scalars['String']>>;
  statusUpdateInterval?: InputMaybe<Scalars['Int']>;
  /**  Stream properties  */
  streamType?: InputMaybe<MediaStreamType>;
  /**  Associated events  */
  subscribedEvents?: InputMaybe<Array<SubscribedGatewayEventInput>>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  templateId: Scalars['String'];
  uploadBandwidthCap?: InputMaybe<Scalars['Float']>;
  /**  Selected types of sensor events  */
  userEvents?: InputMaybe<Array<Scalars['String']>>;
  /**  Changed configurations names  */
  vaeConfigChangedNames?: InputMaybe<Array<Scalars['String']>>;
  /**  Active VAE config name  */
  vaeConfigName?: InputMaybe<Scalars['String']>;
  /**  Subscribed VAE features  */
  vaeFeatures?: InputMaybe<Array<Scalars['String']>>;
  vaeImageUpdate?: InputMaybe<Scalars['Boolean']>;
  videoHeight?: InputMaybe<Scalars['Int']>;
  videoWidth?: InputMaybe<Scalars['Int']>;
  vmxVideoStreamingMode?: InputMaybe<VmxVideoStreamingMode>;
  webRtcEnabled?: InputMaybe<Scalars['Boolean']>;
};

/** Functional Aspect types */
export enum DeviceFunctionalAspectType {
  Avatar = 'AVATAR',
  Gateway = 'GATEWAY',
  Media = 'MEDIA',
  Ptz = 'PTZ',
  Sensor = 'SENSOR',
  Vae = 'VAE'
}

export type DeviceInput = {
  /** Acknowledging for event witch detected by analytic modules */
  acknowledgeRequired?: InputMaybe<Scalars['Boolean']>;
  /** Functional aspects (like "media", "events", ...) */
  aspects?: InputMaybe<Array<DeviceFunctionalAspectInput>>;
  /** General device settings */
  config: DeviceBaseConfigInput;
  deliveryPriority?: InputMaybe<Scalars['Int']>;
  enabled: Scalars['Boolean'];
  /** Camera Setting */
  eventType?: InputMaybe<DeviceEventType>;
  /** Optional location as specified by user */
  location?: InputMaybe<Scalars['String']>;
  /** Device name */
  name: Scalars['String'];
  /** Avatar, DVR, external system */
  platformId?: InputMaybe<Scalars['ID']>;
  /** GEO position */
  position?: InputMaybe<LatLngInput>;
  rtpOverTcp?: InputMaybe<Scalars['Boolean']>;
  rtpTime?: InputMaybe<Scalars['Boolean']>;
  /** Optional set for authorization policy definition simplification */
  setId?: InputMaybe<Array<Scalars['ID']>>;
  storageConfig?: InputMaybe<DeviceStorageConfigInput>;
  /** Optional zone for authorization policy definition simplification */
  zoneId?: InputMaybe<Scalars['ID']>;
};

export type DeviceProbe = {
  __typename?: 'DeviceProbe';
  /** Functional aspects (like "media", "events", ...) */
  aspects: Array<DeviceFunctionalAspect>;
  config: DeviceBaseConfig;
  name?: Maybe<Scalars['String']>;
  /** Default value for follow rtp time */
  rtpTime?: Maybe<Scalars['Boolean']>;
  /** Video snapshots for Video aspects */
  snapshots: Array<Scalars['String']>;
};

export type DeviceProbeInput = {
  configType: DeviceBaseConfigType;
  connect: NetworkConnectDescriptorInput;
  platformId?: InputMaybe<Scalars['ID']>;
  sensorModel?: InputMaybe<Scalars['String']>;
};

export type DeviceStorageConfig = {
  __typename?: 'DeviceStorageConfig';
  storagePool: StoragePool;
};

export type DeviceStorageConfigInput = {
  storagePoolId: Scalars['ID'];
};

export type DeviceTemplate = {
  __typename?: 'DeviceTemplate';
  make: Scalars['String'];
  models: Array<DeviceTemplateModel>;
};

export type DeviceTemplateModel = {
  __typename?: 'DeviceTemplateModel';
  model: Scalars['String'];
  url: Scalars['String'];
};

export type EmailAddresses = {
  from?: InputMaybe<Scalars['String']>;
  to?: InputMaybe<Scalars['String']>;
};

export enum EmailAuth {
  No = 'NO',
  Pass = 'PASS'
}

export type EncryptionKeyInfo = {
  __typename?: 'EncryptionKeyInfo';
  isValid?: Maybe<Scalars['Boolean']>;
  issuedAt?: Maybe<Scalars['DateTime']>;
};

export type ErrorInfo = {
  __typename?: 'ErrorInfo';
  createdAt: Scalars['DateTime'];
  error: Scalars['String'];
};

export type EventInfo = {
  __typename?: 'EventInfo';
  entry: AuditEntry;
  hasSnapshots: Scalars['Boolean'];
};

export type EventInfoInput = {
  entry: AuditEntryInput;
  hasSnapshots: Scalars['Boolean'];
};

/**
 * Health Gravity defines how aspect health is reflected on device health (how to roll health statuses up).
 * Each individual Aspect operation status can take values from HealthStatus enum (from "core").
 */
export enum Fa_HealthGravity {
  /** If aspect with BEST_EFFORT gravity is DEAD, it is rolling up as NORMAL (not DEGRADED or BROKEN) */
  BestEffort = 'BEST_EFFORT',
  /** If aspect with CRITICAL gravity is DEAD, entire device is considered to be BROKEN */
  Critical = 'CRITICAL',
  /** If aspect with NORMAL gravity is DEAD, it is rolling up as DEGRADED (not BROKEN) */
  Normal = 'NORMAL'
}

export type Feature = {
  __typename?: 'Feature';
  desc: FeatureDesc;
  name: Scalars['String'];
  unitsSubscribed: Scalars['Float'];
  unitsUsed: Scalars['Float'];
};

/** Used to list available features */
export type FeatureDesc = {
  __typename?: 'FeatureDesc';
  displayName: Scalars['String'];
  name: Scalars['String'];
  type: FeatureType;
  unitType: Scalars['String'];
};

export type FeatureInput = {
  name: Scalars['String'];
  unitsSubscribed: Scalars['Float'];
};

export enum FeatureType {
  Default = 'DEFAULT',
  Storagepool = 'STORAGEPOOL'
}

export type Filter = {
  /** Features names we should filter */
  features?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** Realm IDs we should filter */
  realms?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** Array of two DateTime: From - To */
  streamUsagePeriod?: InputMaybe<StreamUsagePeriod>;
  /** If we should return usage. Increases response time greatly! */
  usage?: InputMaybe<Scalars['Boolean']>;
};

/**
 * System-defined templates to instantiate device functional aspects.
 * A template must be created for each aspect kind used in the system.
 * For example, every kind of analytics aspect must have a registered template.
 */
export type FunctionalAspectTemplate = {
  __typename?: 'FunctionalAspectTemplate';
  baseFeature?: Maybe<Scalars['String']>;
  defaultFeature?: Maybe<Scalars['String']>;
  engine?: Maybe<Scalars['String']>;
  features?: Maybe<Array<VaeFeature>>;
  /** Unique template ID, a readable constant for machine interpretation, like 'video', 'audio', etc. */
  id: Scalars['String'];
  /** Aspect name, suitable for GUI presentation */
  name: Scalars['String'];
  /** Display order of the aspect */
  order: Scalars['Int'];
  /** Aspect type (video/analytic/etc..) */
  type: DeviceFunctionalAspectType;
};

export type GeoLayer = {
  __typename?: 'GEOLayer';
  data: Scalars['String'];
  mime: Scalars['String'];
  name: Scalars['String'];
};

export type GeoLayerInput = {
  data: Scalars['String'];
  mime: Scalars['String'];
  name: Scalars['String'];
};

export type GeoLayers = {
  __typename?: 'GEOLayers';
  geoLayers: Array<GeoLayer>;
};

export type GeoLayersInput = {
  geoLayers: Array<GeoLayerInput>;
};

export type GatewayDeviceInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayDirectoriesProbe = {
  __typename?: 'GatewayDirectoriesProbe';
  deviceProbe: DeviceProbe;
  directories: Array<GatewayDirectory>;
};

export type GatewayDirectoriesProbeInput = {
  connect: NetworkConnectDescriptorInput;
  model: GatewayModel;
  platformId: Scalars['String'];
};

export type GatewayDirectory = {
  __typename?: 'GatewayDirectory';
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayDirectoryInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayEvent = {
  __typename?: 'GatewayEvent';
  id: Scalars['ID'];
  name: Scalars['String'];
  type: Scalars['String'];
};

export type GatewayEventInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
  type: Scalars['String'];
};

export enum GatewayModel {
  Lenel = 'Lenel'
}

export type GatewayProbe = {
  __typename?: 'GatewayProbe';
  devices: Array<GatewayProbeDevice>;
  events: Array<GatewayProbeEvent>;
};

export type GatewayProbeDevice = {
  __typename?: 'GatewayProbeDevice';
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayProbeEvent = {
  __typename?: 'GatewayProbeEvent';
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayProbeInput = {
  connect: NetworkConnectDescriptorInput;
  directoryId: Scalars['String'];
  model: GatewayModel;
  platformId: Scalars['String'];
  token?: InputMaybe<Scalars['String']>;
  version: Scalars['String'];
};

/** Generic Realm object */
export type GenericObject = RealmObject & {
  __typename?: 'GenericObject';
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Object ID (UUID) */
  id: Scalars['ID'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Object name */
  name: Scalars['String'];
  type: RealmObjectType;
};

export type GenericObjectInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
  type: RealmObjectType;
};

export type Group = RealmObject & {
  __typename?: 'Group';
  createdAt?: Maybe<Scalars['DateTime']>;
  id: Scalars['ID'];
  isSystemManaged: Scalars['Boolean'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  policies: Array<Policy>;
  type: RealmObjectType;
  users: Array<User>;
};

export type GroupInput = {
  addPolicyIds?: InputMaybe<Array<Scalars['ID']>>;
  addUserIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removePolicyIds?: InputMaybe<Array<Scalars['ID']>>;
  removeUserIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type Gui = {
  __typename?: 'Gui';
  description: Scalars['String'];
  /**  GUI ID (UUID)  */
  id: Scalars['ID'];
  /**  GUI name  */
  name: Scalars['String'];
  url: Scalars['String'];
};

/**
 * Individual item health status.
 * If item was not enabled, status is always assumed to be OFF.
 * For enabled items, values are PENDING | NORMAL | DEGRADED | BROKEN
 */
export enum HealthStatus {
  Broken = 'BROKEN',
  Degraded = 'DEGRADED',
  Normal = 'NORMAL',
  Off = 'OFF',
  Pending = 'PENDING'
}

export type Hierarchy = {
  __typename?: 'Hierarchy';
  id: Scalars['ID'];
  level: HierarchyLevel;
  name: Scalars['String'];
};

export type HierarchyInput = {
  id: Scalars['ID'];
  level?: InputMaybe<HierarchyLevelInput>;
  name?: InputMaybe<Scalars['String']>;
};

export type HierarchyLevel = {
  __typename?: 'HierarchyLevel';
  id: Scalars['ID'];
  labelIds: Array<Scalars['ID']>;
  levels?: Maybe<Array<HierarchyLevel>>;
  name: Scalars['String'];
};

export type HierarchyLevelInput = {
  id: Scalars['ID'];
  labelIds: Array<Scalars['ID']>;
  levels: Array<HierarchyLevelInput>;
  name: Scalars['String'];
};

export type IdentityAttribute = {
  __typename?: 'IdentityAttribute';
  contactUs: Scalars['String'];
};

export type ImageMap = {
  __typename?: 'ImageMap';
  base64: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  objects: Array<ImageMapObject>;
  order: Scalars['Int'];
};

export type ImageMapConfig = {
  __typename?: 'ImageMapConfig';
  sets: Array<ImageMapSet>;
};

export type ImageMapInput = {
  base64: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  objects: Array<ImageMapObjectInput>;
  order: Scalars['Int'];
};

export type ImageMapLayer = {
  __typename?: 'ImageMapLayer';
  id: Scalars['ID'];
  maps: Array<ImageMap>;
  name: Scalars['String'];
};

export type ImageMapLayerInput = {
  id: Scalars['ID'];
  maps: Array<ImageMapInput>;
  name: Scalars['String'];
};

export type ImageMapObject = {
  __typename?: 'ImageMapObject';
  id: Scalars['ID'];
  objectId: Scalars['ID'];
  position: Position;
};

export type ImageMapObjectInput = {
  id: Scalars['ID'];
  objectId: Scalars['ID'];
  position: PositionInput;
};

export type ImageMapSet = {
  __typename?: 'ImageMapSet';
  id: Scalars['ID'];
  layers: Array<ImageMapLayer>;
  name: Scalars['String'];
};

export type ImageMapSetInput = {
  id: Scalars['ID'];
  layers: Array<ImageMapLayerInput>;
  name: Scalars['String'];
};

export enum ImageMapUpdateAction {
  DeleteLayer = 'DELETE_LAYER',
  DeleteObject = 'DELETE_OBJECT',
  DeleteSet = 'DELETE_SET',
  InsertLayer = 'INSERT_LAYER',
  InsertObject = 'INSERT_OBJECT',
  InsertSet = 'INSERT_SET',
  RenameLayer = 'RENAME_LAYER',
  RenameSet = 'RENAME_SET',
  UpdateLayer = 'UPDATE_LAYER',
  UpdateMap = 'UPDATE_MAP',
  UpdateObject = 'UPDATE_OBJECT',
  UpdateSet = 'UPDATE_SET'
}

export type ImageMapUpdateNotification = {
  __typename?: 'ImageMapUpdateNotification';
  action: ImageMapUpdateAction;
  layer?: Maybe<ImageMapLayer>;
  layerId?: Maybe<Scalars['ID']>;
  layerName?: Maybe<Scalars['String']>;
  map?: Maybe<ImageMap>;
  mapId?: Maybe<Scalars['ID']>;
  object?: Maybe<ImageMapObject>;
  objectId?: Maybe<Scalars['ID']>;
  realmId: Scalars['String'];
  set?: Maybe<ImageMapSet>;
  setId?: Maybe<Scalars['ID']>;
  setName?: Maybe<Scalars['String']>;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};

/** Generic Key->Value data */
export type KeyValue = {
  __typename?: 'KeyValue';
  key: Scalars['String'];
  value: Scalars['String'];
};

export type KeyValueInput = {
  key: Scalars['String'];
  value: Scalars['String'];
};

export type Label = {
  __typename?: 'Label';
  id: Scalars['ID'];
  name: Scalars['String'];
  objects: Array<LabelObject>;
  type: LabelType;
};

export type LabelInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
  objectIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type LabelObject = {
  __typename?: 'LabelObject';
  objectId: Scalars['ID'];
  type: RealmObjectType;
};

export type LabelOrHierarchyUpdate = {
  __typename?: 'LabelOrHierarchyUpdate';
  itemIds: Array<Scalars['ID']>;
  realmId: Scalars['ID'];
  type: LabelOrHierarchyUpdateType;
};

export enum LabelOrHierarchyUpdateType {
  Delete = 'DELETE',
  Insert = 'INSERT',
  Update = 'UPDATE'
}

export enum LabelType {
  Label = 'LABEL',
  Set = 'SET',
  Zone = 'ZONE'
}

export type Language = {
  __typename?: 'Language';
  description: Scalars['String'];
  direction: Scalars['String'];
  tag: Scalars['String'];
};

export type Languages = {
  __typename?: 'Languages';
  languages?: Maybe<Array<Language>>;
};

export type LatLng = {
  __typename?: 'LatLng';
  alt?: Maybe<Scalars['Float']>;
  lat: Scalars['Float'];
  lng: Scalars['Float'];
};

export type LatLngInput = {
  alt?: InputMaybe<Scalars['Float']>;
  lat?: InputMaybe<Scalars['Float']>;
  lng?: InputMaybe<Scalars['Float']>;
};

export type License = {
  __typename?: 'License';
  isAccepted: Scalars['Boolean'];
  text: Scalars['String'];
};

export type LocalStorage = {
  __typename?: 'LocalStorage';
  enabled: Scalars['Boolean'];
  pool: PoolLocalStorage;
  strategy: Scalars['String'];
  ver: Scalars['String'];
};

export type LocalStorageInput = {
  enabled: Scalars['Boolean'];
  pool: PoolLocalStorageInput;
  strategy: Scalars['String'];
  ver: Scalars['String'];
};

export enum LogSeverity {
  Debug = 'DEBUG',
  Error = 'ERROR',
  Fatal = 'FATAL',
  Info = 'INFO',
  Warn = 'WARN'
}

export enum MediaArchiveOption {
  Continuous = 'CONTINUOUS',
  Events = 'EVENTS',
  Live = 'LIVE',
  None = 'NONE',
  Schedule = 'SCHEDULE'
}

export enum MediaStreamType {
  Audio = 'AUDIO',
  Video = 'VIDEO'
}

/** Meta Classifier holds the single 'interpreted' value and may contain additional key-value attributes */
export type MetaClassifier = {
  __typename?: 'MetaClassifier';
  attributes: Array<KeyValue>;
  value: Scalars['String'];
};

/** Metadata entry, identified by Key, holds Classifier */
export type MetaEntry = {
  __typename?: 'MetaEntry';
  key: Scalars['String'];
  metaClass: MetaClassifier;
};

export enum MetricDimension {
  Bps = 'bps',
  Bytes = 'bytes',
  Fps = 'fps',
  Ms = 'ms',
  Pcs = 'pcs',
  Pct = 'pct',
  Status = 'status'
}

export type ModifiedByInfo = {
  __typename?: 'ModifiedByInfo';
  realmId: Scalars['ID'];
  userId: Scalars['ID'];
};

export type Mutation = {
  __typename?: 'Mutation';
  /**  accept End User License Agreement  */
  acceptLicense: Scalars['Boolean'];
  /**  acknowledge event  */
  acknowledgeAuditEntry: Scalars['Boolean'];
  /**  acknowledge event - deprecated  */
  acknowledgeEvent: Scalars['Boolean'];
  /**  activate avatar  */
  activateAvatar?: Maybe<Scalars['Boolean']>;
  /**  activate email  */
  activateEmail?: Maybe<Scalars['Boolean']>;
  /**  add new realm subscription  */
  addSubscription?: Maybe<RealmSubscription>;
  /**  cancel AOD request  */
  aodCancel?: Maybe<Scalars['Boolean']>;
  /**  pause AOD request  */
  aodPause?: Maybe<Scalars['Boolean']>;
  /**  resume AOD request  */
  aodResume?: Maybe<Scalars['Boolean']>;
  /**  add new AOD request  */
  aodSubmit: Array<AodRequest>;
  /**  assign labels to object  */
  assignLabels: Scalars['Boolean'];
  /**  acknowledgement multiple events  */
  auditEntriesAcknowledgment: Scalars['Boolean'];
  /**  change current password  */
  changeCurrentPassword?: Maybe<Scalars['Boolean']>;
  /**  change delivery priority  */
  changeDeliveryPriority: Scalars['Boolean'];
  /**  change config of local storage for avatar  */
  changeLocalStorage: Scalars['Boolean'];
  /**  change user password  */
  changePassword: Scalars['Boolean'];
  /**  create avatar API key  */
  createAvatarApiKey: Scalars['Boolean'];
  /**  add new device  */
  createDevice: CreateResult;
  /**  add new gateway device  */
  createGatewayDevice: CreateResult;
  /**  create group  */
  createGroup: CreateResult;
  /**  create new policy  */
  createPolicy: CreateResult;
  /**  create new policy statement  */
  createPolicyStatement: CreateResult;
  /**  add new sensor device  */
  createSensorDevice: CreateResult;
  /**  create set  */
  createSet: CreateResult;
  /**  create new user  */
  createUser: CreateResult;
  /**  add new VAE config  */
  createVaeConfig: Scalars['Boolean'];
  /**  create new zone  */
  createZone: CreateResult;
  /**  delete device  */
  deleteDevice: Scalars['Boolean'];
  /**  delete group  */
  deleteGroup: Scalars['Boolean'];
  /**  delete hierarchy  */
  deleteHierarchy: Scalars['Boolean'];
  /**  delete image map layer  */
  deleteImageMapLayer: Scalars['Boolean'];
  /**  delete image map layer  */
  deleteImageMapObject: Scalars['Boolean'];
  /**  delete image map set  */
  deleteImageMapSet: Scalars['Boolean'];
  /**  delete label  */
  deleteLabel: Scalars['Boolean'];
  /**  delete policy  */
  deletePolicy: Scalars['Boolean'];
  /**  delete policy statement  */
  deletePolicyStatement: Scalars['Boolean'];
  /**  delete set  */
  deleteSet: Scalars['Boolean'];
  /**  delete realm subscription  */
  deleteSubscription?: Maybe<Scalars['Int']>;
  /**  delete user  */
  deleteUser: Scalars['Boolean'];
  /**  delete VAE config  */
  deleteVaeConfig: Scalars['Boolean'];
  /**  delete zone  */
  deleteZone: Scalars['Boolean'];
  /**  perform device command  */
  deviceCommand: Scalars['Boolean'];
  /**  acknowledgement multiple events - deprecated  */
  eventsAcknowledgement: Scalars['Boolean'];
  /**  add new hierarchy  */
  insertHierarchy: Hierarchy;
  /**  add new layer to image map  */
  insertImageMapLayer: Scalars['Boolean'];
  /**  add new object to image map  */
  insertImageMapObject: Scalars['Boolean'];
  /**  add new image map set  */
  insertImageMapSet: Scalars['Boolean'];
  /**  add new labels  */
  insertLabels: Array<Label>;
  /**  modify realm subscription  */
  modifySubscription?: Maybe<RealmSubscription>;
  /**  Working with preset positions. Preset positions are stored in cameras  */
  ptzPreset: Scalars['Boolean'];
  /**  Center camera to position  */
  ptzRel: Scalars['Boolean'];
  /**  Move (or change zoom, focus, iris, etc.) camera with specific speed  */
  ptzSpeed: Scalars['Boolean'];
  /**  Move (or change zoom, focus, iris, etc.) camera step by step  */
  ptzStep: Scalars['Boolean'];
  /**  purge Avatar queue  */
  purgeAvatarQueue: Scalars['Boolean'];
  /**  regenerate avatar API key  */
  regenerateAvatarApiKey: Scalars['Boolean'];
  /**  remove avatar API key  */
  removeAvatarApiKey: Scalars['Boolean'];
  /**  remove labels from object  */
  removeLabels: Scalars['Boolean'];
  /**  rename image map layer  */
  renameImageMapLayer: Scalars['Boolean'];
  /**  rename image map set  */
  renameImageMapSet: Scalars['Boolean'];
  /**  rename VAE config  */
  renameVaeConfig: Scalars['Boolean'];
  /**  restore password  */
  restorePassword?: Maybe<Scalars['Boolean']>;
  /**  set user password, password will be marked as expired  */
  setPassword: Scalars['Boolean'];
  setStore: Scalars['Boolean'];
  /**  set current user realm  */
  setUserRealm: Scalars['Boolean'];
  /**  unblock user  */
  unblockUser: Scalars['Boolean'];
  /**  set current realm parameters  */
  updateCurrentRealm: Scalars['Boolean'];
  /**  update device  */
  updateDevice: UpdateResult;
  /**  store geo layers  */
  updateGeoLayers?: Maybe<Scalars['Boolean']>;
  /**  update group  */
  updateGroup: Scalars['Boolean'];
  /**  update hierarchy  */
  updateHierarchy: Scalars['Boolean'];
  /**  update image map  */
  updateImageMap: Scalars['Boolean'];
  /**  update image map layer  */
  updateImageMapLayer: Scalars['Boolean'];
  /**  update image map layer  */
  updateImageMapObject: Scalars['Boolean'];
  /**  update image map set  */
  updateImageMapSet: Scalars['Boolean'];
  /**  update label  */
  updateLabel: Scalars['Boolean'];
  /**  update policy  */
  updatePolicy: Scalars['Boolean'];
  /**  update policy statement  */
  updatePolicyStatement: Scalars['Boolean'];
  /**  update device position  */
  updatePosition: Scalars['Boolean'];
  /**  update current realm  */
  updateRealm?: Maybe<Scalars['Boolean']>;
  /**  update set  */
  updateSet: Scalars['Boolean'];
  /**  SOLID config specific, not public  */
  updateSolidConfig: Scalars['Boolean'];
  /**  SOLID config specific, not public  */
  updateSolidConfigCurrentView: Scalars['Boolean'];
  /**  update user  */
  updateUser: Scalars['Boolean'];
  /**  update zone  */
  updateZone: Scalars['Boolean'];
  /**  validate add realm subscription  */
  validateAddSubscription?: Maybe<Scalars['Int']>;
  /**  validate email  */
  validateEmail?: Maybe<Scalars['Boolean']>;
  /**  validate modify realm subscription  */
  validateModifySubscription?: Maybe<Scalars['Int']>;
  /**  verify code  */
  verifyCode?: Maybe<Scalars['Boolean']>;
};


export type MutationAcknowledgeAuditEntryArgs = {
  entry: AcknowledgeAuditEntryInput;
};


export type MutationAcknowledgeEventArgs = {
  context: Scalars['ID'];
  note?: InputMaybe<Scalars['String']>;
  triggeredAt: Scalars['DateTime'];
};


export type MutationActivateAvatarArgs = {
  avatarId: Scalars['ID'];
};


export type MutationActivateEmailArgs = {
  input: SecretPassword;
};


export type MutationAddSubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationAodCancelArgs = {
  requestIds: Array<Scalars['ID']>;
};


export type MutationAodPauseArgs = {
  requestId: Scalars['ID'];
};


export type MutationAodResumeArgs = {
  requestId: Scalars['ID'];
};


export type MutationAodSubmitArgs = {
  input: AodRequestInput;
};


export type MutationAssignLabelsArgs = {
  ids: Array<Scalars['ID']>;
  objectId: Scalars['ID'];
};


export type MutationAuditEntriesAcknowledgmentArgs = {
  entries: Array<AcknowledgeAuditEntryInput>;
};


export type MutationChangeCurrentPasswordArgs = {
  input: ChangeCurrentPasswordInput;
};


export type MutationChangeDeliveryPriorityArgs = {
  devices: Array<DeliveryPriorityInput>;
};


export type MutationChangeLocalStorageArgs = {
  id: Scalars['ID'];
  input: LocalStorageInput;
};


export type MutationChangePasswordArgs = {
  input: ChangePasswordInput;
};


export type MutationCreateAvatarApiKeyArgs = {
  id: Scalars['ID'];
};


export type MutationCreateDeviceArgs = {
  device: DeviceInput;
};


export type MutationCreateGatewayDeviceArgs = {
  device: DeviceInput;
};


export type MutationCreateGroupArgs = {
  group: GroupInput;
};


export type MutationCreatePolicyArgs = {
  policy: PolicyInput;
};


export type MutationCreatePolicyStatementArgs = {
  policyId: Scalars['ID'];
  statement: PolicyStatementInput;
};


export type MutationCreateSensorDeviceArgs = {
  device: DeviceInput;
};


export type MutationCreateSetArgs = {
  set: SetInput;
};


export type MutationCreateUserArgs = {
  user: UserInput;
};


export type MutationCreateVaeConfigArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
};


export type MutationCreateZoneArgs = {
  zone: ZoneInput;
};


export type MutationDeleteDeviceArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteGroupArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteHierarchyArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteImageMapLayerArgs = {
  layerId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationDeleteImageMapObjectArgs = {
  objectId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationDeleteImageMapSetArgs = {
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationDeleteLabelArgs = {
  id: Scalars['ID'];
};


export type MutationDeletePolicyArgs = {
  id: Scalars['ID'];
};


export type MutationDeletePolicyStatementArgs = {
  statementId: Scalars['ID'];
};


export type MutationDeleteSetArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteSubscriptionArgs = {
  id: Scalars['String'];
};


export type MutationDeleteUserArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteVaeConfigArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
};


export type MutationDeleteZoneArgs = {
  id: Scalars['ID'];
};


export type MutationDeviceCommandArgs = {
  command: DeviceCommand;
  id: Scalars['ID'];
};


export type MutationEventsAcknowledgementArgs = {
  entries: Array<AcknowledgementEntry>;
};


export type MutationInsertHierarchyArgs = {
  hierarchy: HierarchyInput;
};


export type MutationInsertImageMapLayerArgs = {
  layer: ImageMapLayerInput;
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationInsertImageMapObjectArgs = {
  mapId: Scalars['ID'];
  object: ImageMapObjectInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationInsertImageMapSetArgs = {
  set: ImageMapSetInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationInsertLabelsArgs = {
  labels: Array<LabelInput>;
};


export type MutationModifySubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationPtzPresetArgs = {
  id: Scalars['ID'];
  input: Ptz_PresetInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPtzRelArgs = {
  id: Scalars['ID'];
  input: Ptz_RelInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPtzSpeedArgs = {
  id: Scalars['ID'];
  input: Ptz_SpeedInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPtzStepArgs = {
  id: Scalars['ID'];
  input: Ptz_StepInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPurgeAvatarQueueArgs = {
  id: Scalars['ID'];
};


export type MutationRegenerateAvatarApiKeyArgs = {
  id: Scalars['ID'];
};


export type MutationRemoveAvatarApiKeyArgs = {
  id: Scalars['ID'];
};


export type MutationRemoveLabelsArgs = {
  ids: Array<Scalars['ID']>;
  objectId: Scalars['ID'];
};


export type MutationRenameImageMapLayerArgs = {
  layerId: Scalars['ID'];
  name: Scalars['String'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationRenameImageMapSetArgs = {
  name: Scalars['String'];
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationRenameVaeConfigArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
  newName: Scalars['String'];
};


export type MutationRestorePasswordArgs = {
  input: SecretPassword;
};


export type MutationSetPasswordArgs = {
  input: SetPasswordInput;
};


export type MutationSetStoreArgs = {
  store: AppStoreInput;
};


export type MutationSetUserRealmArgs = {
  realmId: Scalars['ID'];
  userName: Scalars['String'];
};


export type MutationUnblockUserArgs = {
  id: Scalars['ID'];
};


export type MutationUpdateCurrentRealmArgs = {
  realm: CurrentRealmInput;
};


export type MutationUpdateDeviceArgs = {
  device: DeviceInput;
  id: Scalars['ID'];
};


export type MutationUpdateGeoLayersArgs = {
  input: GeoLayersInput;
};


export type MutationUpdateGroupArgs = {
  group: GroupInput;
  id: Scalars['ID'];
};


export type MutationUpdateHierarchyArgs = {
  hierarchy: HierarchyInput;
};


export type MutationUpdateImageMapArgs = {
  map: ImageMapInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateImageMapLayerArgs = {
  layer: ImageMapLayerInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateImageMapObjectArgs = {
  object: ImageMapObjectInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateImageMapSetArgs = {
  set: ImageMapSetInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateLabelArgs = {
  label: LabelInput;
};


export type MutationUpdatePolicyArgs = {
  id: Scalars['ID'];
  policy: PolicyInput;
};


export type MutationUpdatePolicyStatementArgs = {
  statement: PolicyStatementInput;
  statementId: Scalars['ID'];
};


export type MutationUpdatePositionArgs = {
  id: Scalars['ID'];
  position: LatLngInput;
};


export type MutationUpdateRealmArgs = {
  realmInput: RealmInput;
};


export type MutationUpdateSetArgs = {
  id: Scalars['ID'];
  set: SetInput;
};


export type MutationUpdateSolidConfigArgs = {
  solidConfig?: InputMaybe<Scalars['String']>;
  userId: Scalars['ID'];
};


export type MutationUpdateSolidConfigCurrentViewArgs = {
  input: SolidConfigCurrentViewInput;
};


export type MutationUpdateUserArgs = {
  id: Scalars['ID'];
  user: UserInput;
};


export type MutationUpdateZoneArgs = {
  id: Scalars['ID'];
  zone: ZoneInput;
};


export type MutationValidateAddSubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationValidateEmailArgs = {
  addresses: EmailAddresses;
};


export type MutationValidateModifySubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationVerifyCodeArgs = {
  code: Scalars['String'];
};

export type NetworkConnectDescriptor = {
  __typename?: 'NetworkConnectDescriptor';
  /** Complete URL to camera stream for URL config type */
  URL?: Maybe<Scalars['String']>;
  authType: AuthType;
  /** IP/host for ONVIF config type */
  host?: Maybe<Scalars['String']>;
  /** Password for ONVIF config type */
  pass?: Maybe<Scalars['String']>;
  /** HTTP port for ONVIF config type */
  port?: Maybe<Scalars['Int']>;
  /** Protocol for gateway */
  protocol?: Maybe<ProtocolType>;
  /** RTSP port for ONVIF config type */
  rtspPort?: Maybe<Scalars['Int']>;
  /** Username for ONVIF config type */
  user?: Maybe<Scalars['String']>;
};

export type NetworkConnectDescriptorInput = {
  URL?: InputMaybe<Scalars['String']>;
  authType: AuthType;
  host?: InputMaybe<Scalars['String']>;
  pass?: InputMaybe<Scalars['String']>;
  port?: InputMaybe<Scalars['Int']>;
  protocol?: InputMaybe<ProtocolType>;
  rtspPort?: InputMaybe<Scalars['Int']>;
  user?: InputMaybe<Scalars['String']>;
};

export type NumericReport = {
  __typename?: 'NumericReport';
  /**  Unix timestamp, sec  */
  time: Scalars['Int'];
  /**  Metric value  */
  value: Scalars['Float'];
};

export type ObjUuid = {
  __typename?: 'ObjUUID';
  obj: Scalars['UUID'];
};

export type ObjUuidAndName = {
  __typename?: 'ObjUUIDAndName';
  isAdmin: Scalars['Boolean'];
  name: Scalars['String'];
  obj: Scalars['UUID'];
};

export type ObjUuidAndNameInput = {
  name: Scalars['String'];
  obj: Scalars['UUID'];
};

export type ObjUuidInput = {
  obj: Scalars['UUID'];
};

export enum ObjectAction {
  AddLink = 'ADD_LINK',
  Create = 'CREATE',
  Delete = 'DELETE',
  RemoveLink = 'REMOVE_LINK',
  Status = 'STATUS',
  Update = 'UPDATE'
}

/** Object descriptor to provide access to basic object info only */
export type ObjectDescriptor = {
  __typename?: 'ObjectDescriptor';
  /** Object ID (UUID) */
  id: Scalars['ID'];
  isSystemManaged?: Maybe<Scalars['Boolean']>;
  /** Object name */
  name: Scalars['String'];
  type: RealmObjectType;
};

export type ObjectUpdateEvent = {
  __typename?: 'ObjectUpdateEvent';
  action: ObjectAction;
  childObjects?: Maybe<Array<Scalars['ID']>>;
  healthStatus?: Maybe<HealthStatus>;
  id: Scalars['ID'];
  realmId: Scalars['ID'];
  systemStatus?: Maybe<SystemStatus>;
  time: Scalars['Float'];
  type: Scalars['String'];
};

export type ObjectUpdateFilter = {
  actions?: InputMaybe<Array<ObjectAction>>;
  type?: InputMaybe<Scalars['String']>;
};

export type Owner = {
  __typename?: 'Owner';
  createdAt: Scalars['DateTime'];
  displayName: Scalars['String'];
  email?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  updatedAt: Scalars['DateTime'];
};

export type OwnerInput = {
  displayName: Scalars['String'];
  email?: InputMaybe<Scalars['String']>;
  id?: InputMaybe<Scalars['ID']>;
  password?: InputMaybe<Scalars['String']>;
};

export enum Ptz_Class {
  /**  Support for absolute positioning in camera-mount-relative system of coordinates  */
  PtzAbsolute = 'PTZ_ABSOLUTE',
  /**  Continuous and speed controls  */
  PtzContinous = 'PTZ_CONTINOUS',
  /**  Click-On-Screen  */
  PtzCos = 'PTZ_COS',
  /**  Support for absolute positioning in geo-coordinates  */
  PtzGeoAbsolute = 'PTZ_GEO_ABSOLUTE',
  /**  PTZ Presents support  */
  PtzPresets = 'PTZ_PRESETS',
  /**  Step controls  */
  PtzStep = 'PTZ_STEP'
}

/**  will be executed first method  */
export type Ptz_PresetInput = {
  /**  Delete preset position, 1..100  */
  clear?: InputMaybe<Scalars['Int']>;
  /**  Goto preset position, 1..100  */
  goto?: InputMaybe<Scalars['Int']>;
  /**  Save current position, 1..100  */
  save?: InputMaybe<Scalars['Int']>;
};

export type Ptz_RelInput = {
  /**  Video resolution  */
  size: Ptz_RelSizeInput;
  /**  Center camera to x,y position (based on video resolution)  */
  xy: Array<Scalars['Int']>;
};

export type Ptz_RelSizeInput = {
  height: Scalars['Int'];
  width: Scalars['Int'];
};

/**  will be executed first method  */
export type Ptz_SpeedInput = {
  /**  Focus with speed, -100...100  */
  focus?: InputMaybe<Scalars['Int']>;
  /**  Gain with speed, -100...100  */
  gain?: InputMaybe<Scalars['Int']>;
  /**  Iris with speed, -100...100  */
  iris?: InputMaybe<Scalars['Int']>;
  /**  Move with speeds for pan and tilt, [-100..100,-100..100]. ex: [10, 30]  */
  pt?: InputMaybe<Array<Scalars['Int']>>;
  /**  Zoom in/out with speed, -100...100  */
  z?: InputMaybe<Scalars['Int']>;
};

export enum Ptz_StepFocus {
  Far = 'far',
  Near = 'near'
}

export enum Ptz_StepGain {
  Down = 'down',
  Up = 'up'
}

/**  will be executed first method  */
export type Ptz_StepInput = {
  focus?: InputMaybe<Ptz_StepFocus>;
  gain?: InputMaybe<Ptz_StepGain>;
  iris?: InputMaybe<Ptz_StepIris>;
  move?: InputMaybe<Ptz_StepMove>;
  zoom?: InputMaybe<Ptz_StepZoom>;
};

export enum Ptz_StepIris {
  Close = 'close',
  Open = 'open'
}

/**  Do one step in specific direction  */
export enum Ptz_StepMove {
  Down = 'down',
  Downleft = 'downleft',
  Downright = 'downright',
  Left = 'left',
  Right = 'right',
  Up = 'up',
  Upleft = 'upleft',
  Upright = 'upright'
}

export enum Ptz_StepZoom {
  In = 'in',
  Out = 'out'
}

export type Policy = RealmObject & {
  __typename?: 'Policy';
  createdAt?: Maybe<Scalars['DateTime']>;
  groups: Array<Group>;
  id: Scalars['ID'];
  isSystemManaged: Scalars['Boolean'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  statements: Array<PolicyStatement>;
  type: RealmObjectType;
};

export type PolicyInput = {
  addToGroupIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removeFromGroupIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type PolicyStatement = {
  __typename?: 'PolicyStatement';
  actions: Array<Scalars['String']>;
  allResources: Scalars['Boolean'];
  effect: StatementEffect;
  id: Scalars['ID'];
  name: Scalars['String'];
  resources: Array<ObjectDescriptor>;
};

export type PolicyStatementInput = {
  actions?: InputMaybe<Array<Scalars['String']>>;
  addResourceIds?: InputMaybe<Array<Scalars['ID']>>;
  allResources?: InputMaybe<Scalars['Boolean']>;
  effect?: InputMaybe<StatementEffect>;
  name?: InputMaybe<Scalars['String']>;
  removeResourceIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type PoolLocalStorage = {
  __typename?: 'PoolLocalStorage';
  enforce: Scalars['String'];
  path: Scalars['String'];
  size: Scalars['String'];
};

export type PoolLocalStorageInput = {
  enforce: Scalars['String'];
  path: Scalars['String'];
  size: Scalars['String'];
};

export type Position = {
  __typename?: 'Position';
  x: Scalars['Int'];
  y: Scalars['Int'];
};

export type PositionInput = {
  x: Scalars['Int'];
  y: Scalars['Int'];
};

export enum ProtocolType {
  Http = 'HTTP',
  Https = 'HTTPS'
}

export type Query = {
  __typename?: 'Query';
  /**  get list of access levels  */
  accessLevels: Array<AccessLevel>;
  /**  get list of actions  */
  actions: Array<Action>;
  /**  get AOD (Archive on Demand) requests by id  */
  aodGet: Array<AodRequest>;
  /**  get list AOD (Archive on Demand) requests  */
  aodGetList: Array<AodRequest>;
  /**  get list of updated AOD (Archive on Demand) requests  */
  aodGetUpdatedList: Array<AodRequest>;
  /**  get information about device archive coverage boundaries  */
  archiveBoundary: ArchiveBoundary;
  /**  get information about device archive coverage  */
  archiveCoverage: ArchiveCoverage;
  /**  get list of aspects templates  */
  aspectTemplates: Array<FunctionalAspectTemplate>;
  /**  get list of audit categories  */
  auditCategories: Array<AuditCategory>;
  /**  get list of audit events  */
  auditEntries: Array<AuditEntry>;
  /**  get list of avalilable features  */
  availableFeatures?: Maybe<Array<FeatureDesc>>;
  /**  Get a description and all possible metrics for avatar/link  */
  avatarMetrics: Array<AvatarMetric>;
  /**  Get the required avatar/link report  */
  avatarReport: Array<NumericReport>;
  /**  get brand information  */
  branding?: Maybe<Branding>;
  /**  get camera log  */
  cameraLog: Array<CameraLog>;
  /**  Get a description and all possible metrics for current camera  */
  cameraMetrics: Array<CameraMetric>;
  /**  Get the required camera report  */
  cameraReport: Array<Report>;
  /**  get information about current realm  */
  currentRealm: CurrentRealm;
  /**  get device by id  */
  device?: Maybe<Device>;
  /**  get device functional aspects by aspect type  */
  deviceFunctionalAspectsByAspectTypes: Array<DeviceFunctionalAspect>;
  /**  get list of device templates  */
  deviceTemplates: Array<DeviceTemplate>;
  /**  get list of devices  */
  devices: Array<Device>;
  /**  get list of devices by aspect type  */
  devicesByAspectTypes: Array<Device>;
  /**  get list of devices by id  */
  devicesByIds: Array<Device>;
  /**  discover devices  */
  discoverDevices: Array<DeviceProbe>;
  /**  check is email can be send  */
  emailCanBeSend?: Maybe<Scalars['Boolean']>;
  /**  get stored geo layers  */
  geoLayers?: Maybe<GeoLayers>;
  /**  get group by id  */
  group?: Maybe<Group>;
  /**  get list of groups  */
  groups: Array<Group>;
  /**  get list guis  */
  guis: Array<Gui>;
  /**  get list of hierarchies  */
  hierarchies: Array<Hierarchy>;
  /**  get hierarchy by id  */
  hierarchy?: Maybe<Hierarchy>;
  /**  get 'contact us' information  */
  identityAttribute?: Maybe<IdentityAttribute>;
  /**  get image map config  */
  imageMapConfig: ImageMapConfig;
  /**  get image map image  */
  imageMapImage: Scalars['String'];
  /**  get label by id  */
  label?: Maybe<Label>;
  /**  get list of labels  */
  labels: Array<Label>;
  /**  get list of labels for object  */
  labelsForObject: Array<Label>;
  /**  get languages list  */
  languages?: Maybe<Languages>;
  /**  get End User License Agreement  */
  license: License;
  /**  get config of local storage for avatar by id  */
  localStorage?: Maybe<LocalStorage>;
  /**  get list of policies  */
  policies: Array<Policy>;
  /**  get policy by id  */
  policy?: Maybe<Policy>;
  /**  probe device  */
  probeDevice: DeviceProbe;
  /**  get gateway devices and directories  */
  probeGateway: GatewayProbe;
  /**  get gateway directories  */
  probeGatewayDirectories: GatewayDirectoriesProbe;
  /**  probe sensor device  */
  probeSensorDevice: DeviceProbe;
  /**  get current realm  */
  realm?: Maybe<Realm>;
  /**  get realm object by id  */
  realmObject?: Maybe<RealmObject>;
  /**  get list of realm objects  */
  realmObjects: Array<RealmObject>;
  /**  get realm subscription by id  */
  realmSubscription: RealmSubscription;
  /**  get list of realm subscriptions  */
  realmSubscriptions?: Maybe<Array<RealmSubscription>>;
  /**  get list of entries require acknowledge  */
  requireAcknowledgeEntries: Array<AuditEntry>;
  /**  get server time  */
  serverTime: Scalars['DateTime'];
  /**  simple call to continue session  */
  sessionInfo?: Maybe<Scalars['Boolean']>;
  /**  get set by id  */
  set?: Maybe<Set>;
  /**  get list of sets  */
  sets: Array<Set>;
  /**  SOLID config specific, not public  */
  solidConfig?: Maybe<Scalars['String']>;
  /**  get list of storage pools  */
  storagePools: Array<StoragePool>;
  /**  get state of used local storage space for avatar by id  */
  storageUsage?: Maybe<StorageUsage>;
  store: AppStore;
  /**  get system parameters (app version, google map keys, etc )  */
  systemParameters?: Maybe<SystemParameters>;
  /**  get system status  */
  systemStatus: SystemStatusInfo;
  /**  get user by id  */
  user?: Maybe<User>;
  /**  get info about user */
  userInfo: UserInfo;
  /**  get list of user realms  */
  userRealms: Array<RealmObject>;
  /**  get list of users  */
  users: Array<User>;
  /**  get list of VAE configs for device with id  */
  vaeConfigs: Array<VaeConfigBrief>;
  /**  get list of VAE templates for device with id  */
  vaeTemplates: Array<FunctionalAspectTemplate>;
  /**  get zone by id  */
  zone?: Maybe<Zone>;
  /**  get list of zones  */
  zones: Array<Zone>;
};


export type QueryAodGetArgs = {
  endTime: Scalars['DateTime'];
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
};


export type QueryAodGetListArgs = {
  endTime: Scalars['DateTime'];
  startTime: Scalars['DateTime'];
};


export type QueryAodGetUpdatedListArgs = {
  updatedFrom: Scalars['DateTime'];
};


export type QueryArchiveBoundaryArgs = {
  find: BoundaryFind;
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
  streamNumbers: Array<Scalars['Int']>;
};


export type QueryArchiveCoverageArgs = {
  endTime: Scalars['DateTime'];
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
};


export type QueryAuditEntriesArgs = {
  filter: AuditEntryFilter;
};


export type QueryAvatarReportArgs = {
  from: Scalars['DateTime'];
  id: Scalars['ID'];
  metricName: AvatarMetricName;
  to: Scalars['DateTime'];
};


export type QueryCameraLogArgs = {
  deviceId: Scalars['ID'];
};


export type QueryCameraMetricsArgs = {
  from?: InputMaybe<Scalars['DateTime']>;
  id: Scalars['ID'];
  to?: InputMaybe<Scalars['DateTime']>;
};


export type QueryCameraReportArgs = {
  dfaId: Scalars['Int'];
  from: Scalars['DateTime'];
  id: Scalars['ID'];
  metricName: CameraMetricName;
  to: Scalars['DateTime'];
};


export type QueryDeviceArgs = {
  id: Scalars['ID'];
};


export type QueryDeviceFunctionalAspectsByAspectTypesArgs = {
  types: Array<DeviceFunctionalAspectFilter>;
};


export type QueryDevicesByAspectTypesArgs = {
  types: Array<DeviceFunctionalAspectFilter>;
};


export type QueryDevicesByIdsArgs = {
  ids: Array<Scalars['ID']>;
};


export type QueryDiscoverDevicesArgs = {
  platformId: Scalars['ID'];
};


export type QueryGroupArgs = {
  id: Scalars['ID'];
};


export type QueryHierarchyArgs = {
  id: Scalars['ID'];
};


export type QueryImageMapConfigArgs = {
  lazyLoadImages?: InputMaybe<Scalars['Boolean']>;
  version: Scalars['String'];
};


export type QueryImageMapImageArgs = {
  mapId: Scalars['ID'];
  version: Scalars['String'];
};


export type QueryLabelArgs = {
  id: Scalars['ID'];
};


export type QueryLabelsForObjectArgs = {
  objectId: Scalars['ID'];
};


export type QueryLocalStorageArgs = {
  deviceId: Scalars['ID'];
};


export type QueryPolicyArgs = {
  id: Scalars['ID'];
};


export type QueryProbeDeviceArgs = {
  input: DeviceProbeInput;
};


export type QueryProbeGatewayArgs = {
  input: GatewayProbeInput;
};


export type QueryProbeGatewayDirectoriesArgs = {
  input: GatewayDirectoriesProbeInput;
};


export type QueryProbeSensorDeviceArgs = {
  input: DeviceProbeInput;
};


export type QueryRealmObjectArgs = {
  id: Scalars['ID'];
};


export type QueryRealmSubscriptionArgs = {
  adminLogin?: InputMaybe<Scalars['String']>;
  filter?: InputMaybe<Filter>;
  id?: InputMaybe<Scalars['ID']>;
};


export type QueryRealmSubscriptionsArgs = {
  filter?: InputMaybe<Filter>;
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
};


export type QueryRequireAcknowledgeEntriesArgs = {
  filter: AuditEntryFilter;
};


export type QuerySetArgs = {
  id: Scalars['ID'];
};


export type QuerySolidConfigArgs = {
  userId: Scalars['ID'];
};


export type QueryStorageUsageArgs = {
  deviceId: Scalars['ID'];
};


export type QueryUserArgs = {
  id: Scalars['ID'];
};


export type QueryVaeConfigsArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
};


export type QueryVaeTemplatesArgs = {
  deviceId: Scalars['ID'];
};


export type QueryZoneArgs = {
  id: Scalars['ID'];
};

/** Realm base type */
export type Realm = {
  __typename?: 'Realm';
  adminEmail?: Maybe<Scalars['String']>;
  auditTtl?: Maybe<Scalars['String']>;
  avatarLocalStreaming?: Maybe<Scalars['Boolean']>;
  createdAt?: Maybe<Scalars['DateTime']>;
  emailAuth?: Maybe<EmailAuth>;
  emailEnabled?: Maybe<Scalars['Boolean']>;
  emailFrom?: Maybe<Scalars['String']>;
  emailHost?: Maybe<Scalars['String']>;
  emailPass?: Maybe<Scalars['String']>;
  emailPort?: Maybe<Scalars['Int']>;
  emailTls?: Maybe<Scalars['Boolean']>;
  emailUser?: Maybe<Scalars['String']>;
  emailValidated?: Maybe<Scalars['Boolean']>;
  id: Scalars['ID'];
  jitterBufferLength?: Maybe<Scalars['Int']>;
  /**  realm settings  */
  maxDownloadTime?: Maybe<Scalars['Int']>;
  maxScheduledDeliveryDelay?: Maybe<Scalars['Int']>;
  maxVideoPlayers?: Maybe<Scalars['Int']>;
  mfAuth?: Maybe<Scalars['Boolean']>;
  name: Scalars['String'];
  playerIdleTimeout?: Maybe<Scalars['Int']>;
  realmObjects?: Maybe<Array<RealmObject>>;
  resellerParent?: Maybe<Reseller>;
  updatedAt?: Maybe<Scalars['DateTime']>;
  warnVideoPlayers?: Maybe<Scalars['Int']>;
};

export type RealmInput = {
  adminEmail?: InputMaybe<Scalars['String']>;
  auditTtl?: InputMaybe<Scalars['String']>;
  avatarLocalStreaming?: InputMaybe<Scalars['Boolean']>;
  emailAuth?: InputMaybe<EmailAuth>;
  emailEnabled?: InputMaybe<Scalars['Boolean']>;
  emailFrom?: InputMaybe<Scalars['String']>;
  emailHost?: InputMaybe<Scalars['String']>;
  emailPass?: InputMaybe<Scalars['String']>;
  emailPort?: InputMaybe<Scalars['Int']>;
  emailTls?: InputMaybe<Scalars['Boolean']>;
  emailUser?: InputMaybe<Scalars['String']>;
  emailValidated?: InputMaybe<Scalars['Boolean']>;
  id: Scalars['ID'];
  jitterBufferLength?: InputMaybe<Scalars['Int']>;
  maxDownloadTime?: InputMaybe<Scalars['Int']>;
  maxScheduledDeliveryDelay?: InputMaybe<Scalars['Int']>;
  maxVideoPlayers?: InputMaybe<Scalars['Int']>;
  mfAuth?: InputMaybe<Scalars['Boolean']>;
  name: Scalars['String'];
  playerIdleTimeout?: InputMaybe<Scalars['Int']>;
  warnVideoPlayers?: InputMaybe<Scalars['Int']>;
};

export type RealmObject = {
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Object ID (UUID) */
  id: Scalars['ID'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Object name */
  name: Scalars['String'];
  type: RealmObjectType;
};

export type RealmObjectInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
};

export enum RealmObjectType {
  Device = 'DEVICE',
  Group = 'GROUP',
  /** Generic Realm object */
  Object = 'OBJECT',
  Policy = 'POLICY',
  /** Realm */
  Realm = 'REALM',
  Set = 'SET',
  Statement = 'STATEMENT',
  User = 'USER',
  Zone = 'ZONE'
}

/**
 * This the customer's Subscription object
 *
 * Extracted from the Realm object to its own thing
 */
export type RealmSubscription = {
  __typename?: 'RealmSubscription';
  createdAt: Scalars['DateTime'];
  features: Array<Feature>;
  id: Scalars['ID'];
  owner: Owner;
  periodExpiresAt: Scalars['DateTime'];
  periodStartedAt: Scalars['DateTime'];
  simpleui?: Maybe<Scalars['Boolean']>;
  status: SubscriptionStatus;
  storagePools: Array<SubStoragePool>;
  title: Scalars['String'];
  type?: Maybe<RealmSubscriptionType>;
  updatedAt: Scalars['DateTime'];
};

export type RealmSubscriptionInput = {
  features?: InputMaybe<Array<FeatureInput>>;
  id?: InputMaybe<Scalars['ID']>;
  owner?: InputMaybe<OwnerInput>;
  periodExpiresAt?: InputMaybe<Scalars['DateTime']>;
  periodStartedAt?: InputMaybe<Scalars['DateTime']>;
  simpleui?: InputMaybe<Scalars['Boolean']>;
  storagePools?: InputMaybe<Array<SubStoragePoolInput>>;
  title?: InputMaybe<Scalars['String']>;
  type?: InputMaybe<RealmSubscriptionType>;
};

export enum RealmSubscriptionType {
  Production = 'production',
  SelfManaged = 'self_managed'
}

export type Report = NumericReport | StatusReport;

/**
 * extend type User {
 *     resellerDomains: [Reseller!]!
 * }
 */
export type Reseller = {
  __typename?: 'Reseller';
  brandInfo?: Maybe<BrandInfo>;
  children: Array<Reseller>;
  createdAt?: Maybe<Scalars['DateTime']>;
  displayName: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  owner?: Maybe<User>;
  parent?: Maybe<Reseller>;
  realms: Array<Realm>;
  updatedAt?: Maybe<Scalars['DateTime']>;
};

export type SecretPassword = {
  password: Scalars['String'];
  secret: Scalars['String'];
};

export type SensorEvent = {
  __typename?: 'SensorEvent';
  description: Scalars['String'];
  type: Scalars['String'];
};

export type SensorEventInput = {
  description: Scalars['String'];
  type: Scalars['String'];
};

export type Session = {
  __typename?: 'Session';
  info?: Maybe<UserInfo>;
  isAdmin: Scalars['Boolean'];
  isLoggedIn: Scalars['Boolean'];
};

export type SessionCloseEvent = {
  __typename?: 'SessionCloseEvent';
  reason: SessionCloseReason;
  sessionId: Scalars['String'];
};

export enum SessionCloseReason {
  SessionExpired = 'SESSION_EXPIRED',
  SessionTerminated = 'SESSION_TERMINATED'
}

export type SessionInfo = {
  __typename?: 'SessionInfo';
  realm: ObjUuidAndName;
  role: ObjUuidAndName;
  user: ObjUuidAndName;
};

export type SessionInfoInput = {
  realm: ObjUuidAndNameInput;
  role: ObjUuidAndNameInput;
  user: ObjUuidAndNameInput;
};

export type SessionInput = {
  info?: InputMaybe<UserInfoInput>;
  isAdmin?: InputMaybe<Scalars['Boolean']>;
  isLoggedIn?: InputMaybe<Scalars['Boolean']>;
};

export type Set = RealmObject & {
  __typename?: 'Set';
  createdAt?: Maybe<Scalars['DateTime']>;
  devices: Array<ObjectDescriptor>;
  id: Scalars['ID'];
  isSystemManaged: Scalars['Boolean'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  type: RealmObjectType;
};

export type SetInput = {
  addDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removeDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type SetPasswordInput = {
  newPassword: Scalars['String'];
  userId: Scalars['ID'];
};

export type SharedViewsUpdateEvent = {
  __typename?: 'SharedViewsUpdateEvent';
  modifiedBy: ModifiedByInfo;
  sharedViews?: Maybe<Scalars['String']>;
};

export type SocketEvent = {
  __typename?: 'SocketEvent';
  timeStamp: Scalars['Int'];
  type: SocketEventType;
};

export type SocketEventInput = {
  timeStamp: Scalars['Int'];
  type: SocketEventType;
};

export enum SocketEventType {
  Error = 'Error',
  Reconnected = 'Reconnected'
}

export type SoftwareInfo = {
  __typename?: 'SoftwareInfo';
  lastUpdateSucceeded?: Maybe<Scalars['Boolean']>;
  lastUpdateTime?: Maybe<Scalars['DateTime']>;
  updateAvailable?: Maybe<Scalars['Boolean']>;
  version?: Maybe<Scalars['String']>;
};

/**  SOLID config specific  */
export type SolidConfigCurrentViewInput = {
  currentViewId?: InputMaybe<Scalars['String']>;
  recentViewIds?: InputMaybe<Array<Scalars['String']>>;
  userId: Scalars['ID'];
  version: Scalars['String'];
  windowProps?: InputMaybe<Scalars['JSON']>;
};

export type SolidConfigUpdateEvent = {
  __typename?: 'SolidConfigUpdateEvent';
  solidConfig?: Maybe<Scalars['String']>;
  userId: Scalars['ID'];
};

/**  If array is empty we should not make any limitation  */
export type SolidConfiguration = {
  __typename?: 'SolidConfiguration';
  activities: Array<ActivityId>;
  config: Scalars['JSON'];
  views: Array<ViewConfig>;
  widgets: Array<WidgetConfig>;
};

export type SolidConfigurationInput = {
  activities: Array<ActivityId>;
  config: Scalars['JSON'];
  views: Array<ViewConfigInput>;
  widgets: Array<WidgetConfigInput>;
};

export type StatTime = {
  __typename?: 'StatTime';
  avg: Scalars['Float'];
  max: Scalars['Float'];
  min: Scalars['Float'];
};

export enum StatementEffect {
  Allow = 'ALLOW',
  Deny = 'DENY'
}

export enum StatusMetric {
  Degraded = 'DEGRADED',
  Disabled = 'DISABLED',
  Offline = 'OFFLINE',
  Online = 'ONLINE',
  Warnings = 'WARNINGS'
}

export type StatusReport = {
  __typename?: 'StatusReport';
  /**  Status unix timestamp, sec  */
  time: Scalars['Int'];
  /**  Status metric value  */
  value: StatusMetric;
};

export type StoragePool = {
  __typename?: 'StoragePool';
  id: Scalars['ID'];
  name: Scalars['String'];
  ttlHours: Scalars['Int'];
};

export type StorageUsage = {
  __typename?: 'StorageUsage';
  free?: Maybe<Scalars['Float']>;
  localStorageVolume?: Maybe<Scalars['Float']>;
  requiredVolume?: Maybe<Scalars['Float']>;
};

export type StreamShare = {
  __typename?: 'StreamShare';
  error?: Maybe<Scalars['String']>;
  id: Scalars['Int'];
  status?: Maybe<HealthStatus>;
  url: Scalars['String'];
};

export type StreamUsagePeriod = {
  from: Scalars['DateTime'];
  to: Scalars['DateTime'];
};

export type SubStoragePool = {
  __typename?: 'SubStoragePool';
  features: Array<Feature>;
  id: Scalars['ID'];
  name: Scalars['String'];
  /** Duration in hours */
  ttlHrs: Scalars['Int'];
};

export type SubStoragePoolInput = {
  features: Array<FeatureInput>;
  id?: InputMaybe<Scalars['ID']>;
  name: Scalars['String'];
  /** Duration in hours */
  ttlHrs: Scalars['Int'];
};

export type SubscribedGatewayEventInput = {
  id: Scalars['ID'];
  type: Scalars['String'];
};

export type Subscription = {
  __typename?: 'Subscription';
  aodUpdate?: Maybe<Array<AodRequest>>;
  /**  subscribe to new audit events  */
  auditEntries: AuditEntryEvent;
  /**  subscribe to hierarchies for updates  */
  hierarchyUpdate: LabelOrHierarchyUpdate;
  /**  subscribe to image map for updates  */
  imageMapUpdate: ImageMapUpdateNotification;
  /**  subscribe to labels for updates  */
  labelUpdate: LabelOrHierarchyUpdate;
  /**  internal use only, subscribe to object updates  */
  objectUpdate: ObjectUpdateEvent;
  /**  internal use only, subscribe for session close  */
  sessionClose: SessionCloseEvent;
  /**  internal use only, subscribe to shared view updates  */
  sharedViewsUpdate: SharedViewsUpdateEvent;
  /**  SOLID config specific, not public  */
  solidConfigUpdate: SolidConfigUpdateEvent;
};


export type SubscriptionAodUpdateArgs = {
  filter: AodRequestFilter;
};


export type SubscriptionAuditEntriesArgs = {
  filter: AuditEntryFilter;
};


export type SubscriptionImageMapUpdateArgs = {
  version: Scalars['String'];
};


export type SubscriptionObjectUpdateArgs = {
  filter?: InputMaybe<ObjectUpdateFilter>;
};

export enum SubscriptionStatus {
  Active = 'ACTIVE',
  Hibernate = 'HIBERNATE'
}

export type SystemParameters = {
  __typename?: 'SystemParameters';
  geoDefaultPosition?: Maybe<DefaultGeoPosition>;
  googleMapsApiKey?: Maybe<Scalars['String']>;
  googleYouTubeApiKey?: Maybe<Scalars['String']>;
  googleYouTubePlaylistId?: Maybe<Scalars['String']>;
  mapDefaultLayer?: Maybe<Scalars['String']>;
  solidAppVersion?: Maybe<Scalars['String']>;
  updatesHost?: Maybe<Scalars['String']>;
};

export enum SystemStatus {
  Alert = 'ALERT',
  Broken = 'BROKEN',
  Critical = 'CRITICAL',
  Offline = 'OFFLINE',
  Online = 'ONLINE',
  Starting = 'STARTING',
  Stopping = 'STOPPING'
}

export type SystemStatusInfo = {
  __typename?: 'SystemStatusInfo';
  description?: Maybe<Scalars['String']>;
  reasons: Array<SystemStatusReason>;
  status: SystemStatus;
};

export type SystemStatusReason = {
  __typename?: 'SystemStatusReason';
  message: Scalars['String'];
  object?: Maybe<SystemStatusReasonObject>;
};

export type SystemStatusReasonObject = {
  __typename?: 'SystemStatusReasonObject';
  /** Object ID (UUID) */
  id: Scalars['ID'];
  /** Object name */
  name: Scalars['String'];
  type: Scalars['String'];
};

export enum UnitType {
  Gb = 'Gb',
  Unit = 'Unit'
}

export type UpdateResult = {
  __typename?: 'UpdateResult';
  updated: Scalars['Boolean'];
  warning?: Maybe<Scalars['String']>;
  warningFields?: Maybe<Array<WarningField>>;
};

export type User = RealmObject & {
  __typename?: 'User';
  createdAt?: Maybe<Scalars['DateTime']>;
  email?: Maybe<Scalars['String']>;
  emailConfirmed?: Maybe<Scalars['Boolean']>;
  groups: Array<Group>;
  id: Scalars['ID'];
  loggedOnAt?: Maybe<Scalars['DateTime']>;
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  sendNotification?: Maybe<Scalars['Boolean']>;
  type: RealmObjectType;
};

export type UserData = {
  __typename?: 'UserData';
  id: Scalars['String'];
  isAdmin: Scalars['Boolean'];
  name: Scalars['String'];
  solidConfiguration: SolidConfiguration;
};

export type UserDataInput = {
  id: Scalars['String'];
  isAdmin: Scalars['Boolean'];
  name: Scalars['String'];
  solidConfiguration: SolidConfigurationInput;
};

export type UserInfo = {
  __typename?: 'UserInfo';
  realm: CurrentRealm;
  user: UserData;
};

export type UserInfoInput = {
  realm: GenericObjectInput;
  user: UserDataInput;
};

export type UserInput = {
  addToGroupIds?: InputMaybe<Array<Scalars['ID']>>;
  confirmPassword?: InputMaybe<Scalars['String']>;
  email?: InputMaybe<Scalars['String']>;
  name?: InputMaybe<Scalars['String']>;
  password?: InputMaybe<Scalars['String']>;
  removeFromGroupIds?: InputMaybe<Array<Scalars['ID']>>;
  sendNotification?: InputMaybe<Scalars['Boolean']>;
};

export enum VmxVideoStreamingMode {
  Auto = 'AUTO',
  Local = 'LOCAL'
}

export type VaeConfigBrief = {
  __typename?: 'VaeConfigBrief';
  description: Scalars['String'];
  name: Scalars['String'];
};

export type VaeConfigFull = {
  __typename?: 'VaeConfigFull';
  configuration: Scalars['JSONObject'];
  description: Scalars['String'];
  name: Scalars['String'];
};

export type VaeFeature = {
  __typename?: 'VaeFeature';
  exclusive?: Maybe<Scalars['Boolean']>;
  id: Scalars['String'];
  name: Scalars['String'];
  order: Scalars['Int'];
};

export type VaeUpdate = {
  __typename?: 'VaeUpdate';
  log?: Maybe<Array<Scalars['String']>>;
  name: Scalars['String'];
  status: VaeUpdateStatus;
  version?: Maybe<Scalars['String']>;
};

export enum VaeUpdateStatus {
  Error = 'ERROR',
  Ok = 'OK'
}

export type ViewConfig = {
  __typename?: 'ViewConfig';
  config: Scalars['JSON'];
  viewId: ViewId;
};

export type ViewConfigInput = {
  config: Scalars['JSON'];
  viewId: ViewId;
};

export enum ViewId {
  AvatarActivation = 'AvatarActivation',
  Avatars = 'Avatars',
  Cameras = 'Cameras',
  DeviceAudit = 'DeviceAudit',
  EditMap = 'EditMap',
  Gateways = 'Gateways',
  Groups = 'Groups',
  Hierarchy = 'Hierarchy',
  Labels = 'Labels',
  LinkProvision = 'LinkProvision',
  ManageAvatars = 'ManageAvatars',
  ManageAvatarsFacial = 'ManageAvatarsFacial',
  ManageAvatarsLpr = 'ManageAvatarsLPR',
  NotificationPolicies = 'NotificationPolicies',
  Policies = 'Policies',
  QuickStart = 'QuickStart',
  RealmSettings = 'RealmSettings',
  Reports = 'Reports',
  Sensors = 'Sensors',
  Sets = 'Sets',
  Subscription = 'Subscription',
  TrainingVideos = 'TrainingVideos',
  UserAudit = 'UserAudit',
  Users = 'Users',
  VideoWalls = 'VideoWalls',
  Zones = 'Zones'
}

export type WarningField = {
  __typename?: 'WarningField';
  field?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

export type WidgetConfig = {
  __typename?: 'WidgetConfig';
  config: Scalars['JSON'];
  widgetId: WidgetId;
};

export type WidgetConfigInput = {
  config: Scalars['JSON'];
  widgetId: WidgetId;
};

export enum WidgetId {
  AdminAvatars = 'AdminAvatars',
  AdminDevices = 'AdminDevices',
  AdminGateways = 'AdminGateways',
  AdminSensors = 'AdminSensors',
  ArchiveEventList = 'ArchiveEventList',
  ArchiveViewer = 'ArchiveViewer',
  AvatarProvision = 'AvatarProvision',
  CameraLive = 'CameraLive',
  DeviceList = 'DeviceList',
  DownloadManager = 'DownloadManager',
  EventDetails = 'EventDetails',
  EventList = 'EventList',
  EventVideo = 'EventVideo',
  GeoMap = 'GEOMap',
  Groups = 'Groups',
  HierarchyEdit = 'HierarchyEdit',
  ImageMap = 'ImageMap',
  LabelEdit = 'LabelEdit',
  LinkProvision = 'LinkProvision',
  ManageAvatars = 'ManageAvatars',
  NotificationPolicies = 'NotificationPolicies',
  Policies = 'Policies',
  QuickStart = 'QuickStart',
  RealmSettings = 'RealmSettings',
  Reports = 'Reports',
  Sets = 'Sets',
  Subscription = 'Subscription',
  Timeline = 'Timeline',
  TrainingVideos = 'TrainingVideos',
  Users = 'Users',
  VideoTouring = 'VideoTouring',
  VideoWalls = 'VideoWalls',
  Vmx = 'VMX',
  WatchlistFacial = 'WatchlistFacial',
  WatchlistLpr = 'WatchlistLPR',
  Zones = 'Zones'
}

export type WidgetInfo = {
  __typename?: 'WidgetInfo';
  index: Scalars['Int'];
  propsJSON?: Maybe<Scalars['String']>;
  widgetId: Scalars['String'];
};

export type WidgetInfoInput = {
  index: Scalars['Int'];
  propsJSON?: InputMaybe<Scalars['String']>;
  widgetId: Scalars['String'];
};

export type Workspace = {
  __typename?: 'Workspace';
  cameraWidgetProps?: Maybe<Array<CameraWidgetProps>>;
  creatingViews?: Maybe<Array<CreatingView>>;
  event?: Maybe<EventInfo>;
  localViewsJSON?: Maybe<Scalars['String']>;
  sharedViewsJSON?: Maybe<Scalars['String']>;
  solidConfigJSON?: Maybe<Scalars['String']>;
  updatedEvent?: Maybe<AuditEntry>;
};

export type WorkspaceInput = {
  cameraWidgetProps?: InputMaybe<Array<CameraWidgetPropsInput>>;
  creatingViews?: InputMaybe<Array<CreatingViewInput>>;
  event?: InputMaybe<EventInfoInput>;
  localViewsJSON?: InputMaybe<Scalars['String']>;
  sharedViewsJSON?: InputMaybe<Scalars['String']>;
  solidConfigJSON?: InputMaybe<Scalars['String']>;
  updatedEvent?: InputMaybe<AuditEntryInput>;
};

export type Zone = RealmObject & {
  __typename?: 'Zone';
  createdAt?: Maybe<Scalars['DateTime']>;
  devices: Array<ObjectDescriptor>;
  id: Scalars['ID'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  type: RealmObjectType;
};

export type ZoneInput = {
  addDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removeDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type AodRequestFieldsFragment = { __typename?: 'AodRequest', id: string, realmId: string, avatarId: string, deviceId: string, userId: string, status: AodRequestStatus, startTime: Date, endTime: Date, streamNumber: number, createdAt: Date, expiredAt?: Date | null, size?: number | null, downloaded?: number | null, type?: AodRequestType | null, eta?: number | null, note?: string | null, files?: { __typename?: 'AodRequestFiles', expired: Date, list: Array<{ __typename?: 'AodRequestFilesListEntry', href: string, size: number, startTime: Date, endTime: Date }> } | null };

export type AodListQueryVariables = Exact<{
  startTime: Scalars['DateTime'];
  endTime: Scalars['DateTime'];
}>;


export type AodListQuery = { __typename?: 'Query', aodGetList: Array<{ __typename?: 'AodRequest', id: string, realmId: string, avatarId: string, deviceId: string, userId: string, status: AodRequestStatus, startTime: Date, endTime: Date, streamNumber: number, createdAt: Date, expiredAt?: Date | null, size?: number | null, downloaded?: number | null, type?: AodRequestType | null, eta?: number | null, note?: string | null, files?: { __typename?: 'AodRequestFiles', expired: Date, list: Array<{ __typename?: 'AodRequestFilesListEntry', href: string, size: number, startTime: Date, endTime: Date }> } | null }> };

export type AodUpdatedListQueryVariables = Exact<{
  updatedFrom: Scalars['DateTime'];
}>;


export type AodUpdatedListQuery = { __typename?: 'Query', aodGetUpdatedList: Array<{ __typename?: 'AodRequest', id: string, realmId: string, avatarId: string, deviceId: string, userId: string, status: AodRequestStatus, startTime: Date, endTime: Date, streamNumber: number, createdAt: Date, expiredAt?: Date | null, size?: number | null, downloaded?: number | null, type?: AodRequestType | null, eta?: number | null, note?: string | null, files?: { __typename?: 'AodRequestFiles', expired: Date, list: Array<{ __typename?: 'AodRequestFilesListEntry', href: string, size: number, startTime: Date, endTime: Date }> } | null }> };

export type AodSubmitMutationVariables = Exact<{
  input: AodRequestInput;
}>;


export type AodSubmitMutation = { __typename?: 'Mutation', aodSubmit: Array<{ __typename?: 'AodRequest', id: string, realmId: string, avatarId: string, deviceId: string, userId: string, status: AodRequestStatus, startTime: Date, endTime: Date, streamNumber: number, createdAt: Date, expiredAt?: Date | null, size?: number | null, downloaded?: number | null, type?: AodRequestType | null, eta?: number | null, note?: string | null, files?: { __typename?: 'AodRequestFiles', expired: Date, list: Array<{ __typename?: 'AodRequestFilesListEntry', href: string, size: number, startTime: Date, endTime: Date }> } | null }> };

export type AodPauseMutationVariables = Exact<{
  requestId: Scalars['ID'];
}>;


export type AodPauseMutation = { __typename?: 'Mutation', aodPause?: boolean | null };

export type AodResumeMutationVariables = Exact<{
  requestId: Scalars['ID'];
}>;


export type AodResumeMutation = { __typename?: 'Mutation', aodResume?: boolean | null };

export type AodCancelMutationVariables = Exact<{
  requestIds: Array<Scalars['ID']>;
}>;


export type AodCancelMutation = { __typename?: 'Mutation', aodCancel?: boolean | null };

export type AodUpdateSubscriptionVariables = Exact<{
  filter: AodRequestFilter;
}>;


export type AodUpdateSubscription = { __typename?: 'Subscription', aodUpdate?: Array<{ __typename?: 'AodRequest', id: string, realmId: string, avatarId: string, deviceId: string, userId: string, status: AodRequestStatus, startTime: Date, endTime: Date, streamNumber: number, createdAt: Date, expiredAt?: Date | null, size?: number | null, downloaded?: number | null, type?: AodRequestType | null, eta?: number | null, note?: string | null, files?: { __typename?: 'AodRequestFiles', expired: Date, list: Array<{ __typename?: 'AodRequestFilesListEntry', href: string, size: number, startTime: Date, endTime: Date }> } | null }> | null };

export type AuditEntryFieldsFragment = { __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> };

export type AuditEntryMetadataFieldsFragment = { __typename?: 'AuditEntry', metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> };

export type AuditEntrySnapshotFieldsFragment = { __typename?: 'AuditEntry', snapshots: Array<{ __typename?: 'AuditSnapshot', type: string, default: boolean, snapshot: string, tags: Array<{ __typename?: 'KeyValue', key: string, value: string }> }> };

export type AuditCategoriesQueryVariables = Exact<{ [key: string]: never; }>;


export type AuditCategoriesQuery = { __typename?: 'Query', auditCategories: Array<{ __typename?: 'AuditCategory', id: string, parent?: string | null, shortName: string }> };

export type AuditEntriesQueryVariables = Exact<{
  filter: AuditEntryFilter;
}>;


export type AuditEntriesQuery = { __typename?: 'Query', auditEntries: Array<{ __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> }> };

export type RequireAcknowledgeWithSnapshotsEntriesQueryVariables = Exact<{
  filter: AuditEntryFilter;
}>;


export type RequireAcknowledgeWithSnapshotsEntriesQuery = { __typename?: 'Query', requireAcknowledgeEntries: Array<{ __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, snapshots: Array<{ __typename?: 'AuditSnapshot', type: string, default: boolean, snapshot: string, tags: Array<{ __typename?: 'KeyValue', key: string, value: string }> }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> }> };

export type RequireAcknowledgeEntriesQueryVariables = Exact<{
  filter: AuditEntryFilter;
}>;


export type RequireAcknowledgeEntriesQuery = { __typename?: 'Query', requireAcknowledgeEntries: Array<{ __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> }> };

export type AuditEntriesWithSnapshotsQueryVariables = Exact<{
  filter: AuditEntryFilter;
}>;


export type AuditEntriesWithSnapshotsQuery = { __typename?: 'Query', auditEntries: Array<{ __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, snapshots: Array<{ __typename?: 'AuditSnapshot', type: string, default: boolean, snapshot: string, tags: Array<{ __typename?: 'KeyValue', key: string, value: string }> }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> }> };

export type AuditEntriesTimeQueryVariables = Exact<{
  filter: AuditEntryFilter;
}>;


export type AuditEntriesTimeQuery = { __typename?: 'Query', auditEntries: Array<{ __typename?: 'AuditEntry', context: string, triggeredAt: Date, witnesses: Array<{ __typename?: 'CurrentRealm', id: string } | { __typename?: 'Device', id: string } | { __typename?: 'GenericObject', id: string } | { __typename?: 'Group', id: string } | { __typename?: 'Policy', id: string } | { __typename?: 'Set', id: string } | { __typename?: 'User', id: string } | { __typename?: 'Zone', id: string }> }> };

export type AuditEntriesSubscriptionSubscriptionVariables = Exact<{
  filter: AuditEntryFilter;
}>;


export type AuditEntriesSubscriptionSubscription = { __typename?: 'Subscription', auditEntries: { __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, snapshots: Array<{ __typename?: 'AuditSnapshot', type: string, default: boolean, snapshot: string, tags: Array<{ __typename?: 'KeyValue', key: string, value: string }> }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> } | { __typename?: 'ErrorInfo', error: string, createdAt: Date } };

export type AcknowledgeEventMutationVariables = Exact<{
  entry: AcknowledgeAuditEntryInput;
}>;


export type AcknowledgeEventMutation = { __typename?: 'Mutation', acknowledgeAuditEntry: boolean };

export type EventsAcknowledgementMutationVariables = Exact<{
  entries: Array<AcknowledgeAuditEntryInput>;
}>;


export type EventsAcknowledgementMutation = { __typename?: 'Mutation', auditEntriesAcknowledgment: boolean };

export type CurrentRealmQueryVariables = Exact<{ [key: string]: never; }>;


export type CurrentRealmQuery = { __typename?: 'Query', currentRealm: { __typename?: 'CurrentRealm', id: string, sharedViews?: string | null } };

export type UpdateCurrentRealmMutationVariables = Exact<{
  realm: CurrentRealmInput;
}>;


export type UpdateCurrentRealmMutation = { __typename?: 'Mutation', updateCurrentRealm: boolean };

export type SharedViewsUpdateSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type SharedViewsUpdateSubscription = { __typename?: 'Subscription', sharedViewsUpdate: { __typename?: 'SharedViewsUpdateEvent', sharedViews?: string | null } };

export type SessionCloseSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type SessionCloseSubscription = { __typename?: 'Subscription', sessionClose: { __typename?: 'SessionCloseEvent', sessionId: string, reason: SessionCloseReason } };

export type DeviceFieldsFragment = { __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, acknowledgeRequired?: boolean | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> };

export type StatTimeFieldsFragment = { __typename?: 'StatTime', avg: number, max: number, min: number };

export type DevicePlayerFieldsFragment = { __typename?: 'Device', id: string, name: string, cloudDirect: boolean, aspects: Array<{ __typename?: 'DFA_Avatar', enabled: boolean } | { __typename?: 'DFA_Gateway', enabled: boolean } | { __typename?: 'DFA_Media', streamType: MediaStreamType, enabled: boolean } | { __typename?: 'DFA_PTZ', enabled: boolean } | { __typename?: 'DFA_Sensor', enabled: boolean } | { __typename?: 'DFA_VAE', enabled: boolean }>, platform?: { __typename?: 'Device', aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null } | { __typename?: 'DFA_Gateway' } | { __typename?: 'DFA_Media' } | { __typename?: 'DFA_PTZ' } | { __typename?: 'DFA_Sensor' } | { __typename?: 'DFA_VAE' }> } | null };

export type SetsFieldsFragment = { __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null };

export type ConnectFieldsFragment = { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null };

export type DeviceConfigFieldsFragment = { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } };

export type StorageConfigFieldsFragment = { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } };

export type StoragePoolFieldsFragment = { __typename?: 'StoragePool', id: string, name: string, ttlHours: number };

type AspectFields_Dfa_Avatar_Fragment = { __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Gateway_Fragment = { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Media_Fragment = { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Ptz_Fragment = { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Sensor_Fragment = { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Vae_Fragment = { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

export type AspectFieldsFragment = AspectFields_Dfa_Avatar_Fragment | AspectFields_Dfa_Gateway_Fragment | AspectFields_Dfa_Media_Fragment | AspectFields_Dfa_Ptz_Fragment | AspectFields_Dfa_Sensor_Fragment | AspectFields_Dfa_Vae_Fragment;

export type AspectHealthFieldsFragment = { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus };

export type AspectTemplateFieldsFragment = { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null };

export type DeviceProbeFieldsFragment = { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> };

export type LocalStorageFieldsFragment = { __typename?: 'LocalStorage', enabled: boolean, strategy: string, ver: string, pool: { __typename?: 'PoolLocalStorage', path: string, size: string, enforce: string } };

export type GetDeviceSharedStreamQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type GetDeviceSharedStreamQuery = { __typename?: 'Query', device?: { __typename?: 'Device', aspects: Array<{ __typename?: 'DFA_Avatar' } | { __typename?: 'DFA_Gateway' } | { __typename?: 'DFA_Media', sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, status?: HealthStatus | null, error?: string | null }> | null } | { __typename?: 'DFA_PTZ' } | { __typename?: 'DFA_Sensor' } | { __typename?: 'DFA_VAE' }> } | null };

export type GetLocalStorageConfigQueryVariables = Exact<{
  deviceId: Scalars['ID'];
}>;


export type GetLocalStorageConfigQuery = { __typename?: 'Query', localStorage?: { __typename?: 'LocalStorage', enabled: boolean, strategy: string, ver: string, pool: { __typename?: 'PoolLocalStorage', path: string, size: string, enforce: string } } | null };

export type DeviceListFieldsFragment = { __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, deviceType?: BaseDeviceType | null };

export type DeviceListByAspectTypesQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type DeviceListByAspectTypesQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, deviceType?: BaseDeviceType | null }> };

export type DevicesByAspectTypesQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type DevicesByAspectTypesQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, acknowledgeRequired?: boolean | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }> };

export type DeviceReportFieldsFragment = { __typename?: 'Device', id: string, name: string, healthStatus: HealthStatus, config: { __typename?: 'DeviceBaseConfig', model?: string | null, configType: DeviceBaseConfigType, connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, type: DeviceFunctionalAspectType, enabled: boolean, software?: { __typename?: 'SoftwareInfo', lastUpdateTime?: Date | null } | null } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Media', codec?: string | null, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType, enabled: boolean }>, platform?: { __typename?: 'Device', name: string } | null };

export type DevicesByAspectTypesReportQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type DevicesByAspectTypesReportQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, healthStatus: HealthStatus, config: { __typename?: 'DeviceBaseConfig', model?: string | null, configType: DeviceBaseConfigType, connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, type: DeviceFunctionalAspectType, enabled: boolean, software?: { __typename?: 'SoftwareInfo', lastUpdateTime?: Date | null } | null } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Media', codec?: string | null, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType, enabled: boolean }>, platform?: { __typename?: 'Device', name: string } | null }> };

export type DeviceShortFieldsFragment = { __typename?: 'Device', id: string, name: string, location?: string | null, enabled: boolean, healthStatus: HealthStatus, deliveryPriority?: number | null, deviceType?: BaseDeviceType | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null, URL?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', cloudArchive: MediaArchiveOption, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }>, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null };

export type SensorListFieldsFragment = { __typename?: 'Device', id: string, name: string, enabled: boolean, location?: string | null, healthStatus: HealthStatus, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null } } };

export type GatewayListFieldsFragment = { __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, platform?: { __typename?: 'Device', id: string, name: string } | null, aspects: Array<{ __typename?: 'DFA_Avatar', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, name: string, associatedDevices: Array<string> }> } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> };

export type SensorListByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type SensorListByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, location?: string | null, healthStatus: HealthStatus, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null } } }> };

export type GatewayListByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type GatewayListByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, platform?: { __typename?: 'Device', id: string, name: string } | null, aspects: Array<{ __typename?: 'DFA_Avatar', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, name: string, associatedDevices: Array<string> }> } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> }> };

export type DeviceWithPlatformByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type DeviceWithPlatformByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, platform?: { __typename?: 'Device', id: string } | null }> };

export type DeviceWitnessesByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type DeviceWitnessesByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, deviceType?: BaseDeviceType | null, platform?: { __typename?: 'Device', id: string } | null }> };

export type DevicesByAspectTypesShortQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter>;
}>;


export type DevicesByAspectTypesShortQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, location?: string | null, enabled: boolean, healthStatus: HealthStatus, deliveryPriority?: number | null, deviceType?: BaseDeviceType | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null, URL?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', cloudArchive: MediaArchiveOption, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }>, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null }> };

export type DeviceQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeviceQuery = { __typename?: 'Query', device?: { __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, acknowledgeRequired?: boolean | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> } | null };

export type DeviceForPlayerQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeviceForPlayerQuery = { __typename?: 'Query', device?: { __typename?: 'Device', id: string, name: string, cloudDirect: boolean, aspects: Array<{ __typename?: 'DFA_Avatar', enabled: boolean } | { __typename?: 'DFA_Gateway', enabled: boolean } | { __typename?: 'DFA_Media', streamType: MediaStreamType, enabled: boolean } | { __typename?: 'DFA_PTZ', enabled: boolean } | { __typename?: 'DFA_Sensor', enabled: boolean } | { __typename?: 'DFA_VAE', enabled: boolean }>, platform?: { __typename?: 'Device', aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null } | { __typename?: 'DFA_Gateway' } | { __typename?: 'DFA_Media' } | { __typename?: 'DFA_PTZ' } | { __typename?: 'DFA_Sensor' } | { __typename?: 'DFA_VAE' }> } | null } | null };

export type DevicesByIdsQueryVariables = Exact<{
  ids: Array<Scalars['ID']>;
}>;


export type DevicesByIdsQuery = { __typename?: 'Query', devicesByIds: Array<{ __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, acknowledgeRequired?: boolean | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }> };

export type DeviceNameQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeviceNameQuery = { __typename?: 'Query', device?: { __typename?: 'Device', id: string, name: string } | null };

export type ArchiveCoverageQueryVariables = Exact<{
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
  endTime: Scalars['DateTime'];
}>;


export type ArchiveCoverageQuery = { __typename?: 'Query', archiveCoverage: { __typename?: 'ArchiveCoverage', coverage: Array<{ __typename?: 'ArchiveCoverageItem', deviceId: string, streamNumber: number, time: number }>, partialCoverage: Array<{ __typename?: 'ArchiveCoverageItem', deviceId: string, streamNumber: number, time: number }>, ttl: Array<{ __typename?: 'ArchiveCoverageTTL', deviceId: string, ttl: number }> }, aodGet: Array<{ __typename?: 'AodRequest', id: string, deviceId: string, startTime: Date, endTime: Date, streamNumber: number, status: AodRequestStatus }> };

export type ArchiveBoundaryQueryVariables = Exact<{
  ids: Array<Scalars['ID']>;
  streamNumbers: Array<Scalars['Int']>;
  startTime: Scalars['DateTime'];
  find: BoundaryFind;
}>;


export type ArchiveBoundaryQuery = { __typename?: 'Query', archiveBoundary: { __typename?: 'ArchiveBoundary', boundary?: Date | null, timeInsideGap: boolean } };

export type ProbeDeviceQueryVariables = Exact<{
  input: DeviceProbeInput;
}>;


export type ProbeDeviceQuery = { __typename?: 'Query', probeDevice: { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> } };

export type DiscoverDevicesQueryVariables = Exact<{
  platformId: Scalars['ID'];
}>;


export type DiscoverDevicesQuery = { __typename?: 'Query', discoverDevices: Array<{ __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }> };

export type ProbeSensorQueryVariables = Exact<{
  input: DeviceProbeInput;
}>;


export type ProbeSensorQuery = { __typename?: 'Query', probeSensorDevice: { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> } };

export type StoragePoolsQueryVariables = Exact<{ [key: string]: never; }>;


export type StoragePoolsQuery = { __typename?: 'Query', storagePools: Array<{ __typename?: 'StoragePool', id: string, name: string, ttlHours: number }> };

export type AspectTemplatesQueryVariables = Exact<{ [key: string]: never; }>;


export type AspectTemplatesQuery = { __typename?: 'Query', aspectTemplates: Array<{ __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }> };

export type DeviceTemplatesQueryVariables = Exact<{ [key: string]: never; }>;


export type DeviceTemplatesQuery = { __typename?: 'Query', deviceTemplates: Array<{ __typename?: 'DeviceTemplate', make: string, models: Array<{ __typename?: 'DeviceTemplateModel', model: string, url: string }> }> };

export type VaeTemplatesQueryVariables = Exact<{
  deviceId: Scalars['ID'];
}>;


export type VaeTemplatesQuery = { __typename?: 'Query', vaeTemplates: Array<{ __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }> };

export type CameraLogQueryVariables = Exact<{
  deviceId: Scalars['ID'];
}>;


export type CameraLogQuery = { __typename?: 'Query', cameraLog: Array<{ __typename?: 'CameraLog', time: Date, severity: LogSeverity, message: string }> };

export type VaeConfigsQueryVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
}>;


export type VaeConfigsQuery = { __typename?: 'Query', vaeConfigs: Array<{ __typename?: 'VaeConfigBrief', name: string }> };

export type ProbeGatewayDirectoriesQueryVariables = Exact<{
  input: GatewayDirectoriesProbeInput;
}>;


export type ProbeGatewayDirectoriesQuery = { __typename?: 'Query', probeGatewayDirectories: { __typename?: 'GatewayDirectoriesProbe', deviceProbe: { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }> } };

export type ProbeGatewayQueryVariables = Exact<{
  input: GatewayProbeInput;
}>;


export type ProbeGatewayQuery = { __typename?: 'Query', probeGateway: { __typename?: 'GatewayProbe', devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }> } };

export type CreateGatewayMutationVariables = Exact<{
  device: DeviceInput;
}>;


export type CreateGatewayMutation = { __typename?: 'Mutation', createGatewayDevice: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type CreateSensorMutationVariables = Exact<{
  device: DeviceInput;
}>;


export type CreateSensorMutation = { __typename?: 'Mutation', createSensorDevice: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type CreateDeviceMutationVariables = Exact<{
  device: DeviceInput;
}>;


export type CreateDeviceMutation = { __typename?: 'Mutation', createDevice: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdateDeviceMutationVariables = Exact<{
  id: Scalars['ID'];
  device: DeviceInput;
}>;


export type UpdateDeviceMutation = { __typename?: 'Mutation', updateDevice: { __typename?: 'UpdateResult', updated: boolean, warning?: string | null, warningFields?: Array<{ __typename?: 'WarningField', field?: string | null, value?: string | null }> | null } };

export type UpdatePositionMutationVariables = Exact<{
  id: Scalars['ID'];
  position: LatLngInput;
}>;


export type UpdatePositionMutation = { __typename?: 'Mutation', updatePosition: boolean };

export type DeleteDeviceMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteDeviceMutation = { __typename?: 'Mutation', deleteDevice: boolean };

export type DeviceCommandMutationVariables = Exact<{
  id: Scalars['ID'];
  command: DeviceCommand;
}>;


export type DeviceCommandMutation = { __typename?: 'Mutation', deviceCommand: boolean };

export type ChangeDeliveryPriorityMutationVariables = Exact<{
  devices: Array<DeliveryPriorityInput>;
}>;


export type ChangeDeliveryPriorityMutation = { __typename?: 'Mutation', changeDeliveryPriority: boolean };

export type CreateVaeConfigMutationVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
}>;


export type CreateVaeConfigMutation = { __typename?: 'Mutation', createVaeConfig: boolean };

export type RenameVaeConfigMutationVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
  newName: Scalars['String'];
}>;


export type RenameVaeConfigMutation = { __typename?: 'Mutation', renameVaeConfig: boolean };

export type DeleteVaeConfigMutationVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
}>;


export type DeleteVaeConfigMutation = { __typename?: 'Mutation', deleteVaeConfig: boolean };

export type PurgeAvatarQueueMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type PurgeAvatarQueueMutation = { __typename?: 'Mutation', purgeAvatarQueue: boolean };

export type PtzStepMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_StepInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzStepMutation = { __typename?: 'Mutation', ptzStep: boolean };

export type PtzSpeedMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_SpeedInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzSpeedMutation = { __typename?: 'Mutation', ptzSpeed: boolean };

export type PtzPresetMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_PresetInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzPresetMutation = { __typename?: 'Mutation', ptzPreset: boolean };

export type PtzRelMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_RelInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzRelMutation = { __typename?: 'Mutation', ptzRel: boolean };

export type ChangeLocalStorageConfigMutationVariables = Exact<{
  id: Scalars['ID'];
  input: LocalStorageInput;
}>;


export type ChangeLocalStorageConfigMutation = { __typename?: 'Mutation', changeLocalStorage: boolean };

export type CreateAvatarApiKeyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type CreateAvatarApiKeyMutation = { __typename?: 'Mutation', createAvatarApiKey: boolean };

export type RegenerateAvatarApiKeyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type RegenerateAvatarApiKeyMutation = { __typename?: 'Mutation', regenerateAvatarApiKey: boolean };

export type RemoveAvatarApiKeyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type RemoveAvatarApiKeyMutation = { __typename?: 'Mutation', removeAvatarApiKey: boolean };

export type GetGuisQueryVariables = Exact<{ [key: string]: never; }>;


export type GetGuisQuery = { __typename?: 'Query', guis: Array<{ __typename?: 'Gui', id: string, name: string, url: string, description: string }> };

export type LabelFieldsFragment = { __typename?: 'Label', id: string, name: string, type: LabelType, objects: Array<{ __typename?: 'LabelObject', objectId: string, type: RealmObjectType }> };

export type LabelsQueryVariables = Exact<{ [key: string]: never; }>;


export type LabelsQuery = { __typename?: 'Query', labels: Array<{ __typename?: 'Label', id: string, name: string, type: LabelType, objects: Array<{ __typename?: 'LabelObject', objectId: string, type: RealmObjectType }> }> };

export type LabelQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type LabelQuery = { __typename?: 'Query', label?: { __typename?: 'Label', id: string, name: string, type: LabelType, objects: Array<{ __typename?: 'LabelObject', objectId: string, type: RealmObjectType }> } | null };

export type LabelsForObjectQueryVariables = Exact<{
  objectId: Scalars['ID'];
}>;


export type LabelsForObjectQuery = { __typename?: 'Query', labelsForObject: Array<{ __typename?: 'Label', id: string, name: string, type: LabelType, objects: Array<{ __typename?: 'LabelObject', objectId: string, type: RealmObjectType }> }> };

export type HierarchyLevelFieldsFragment = { __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string> };

export type HierarchyLevelRecursiveFragment = { __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string> }> | null }> | null }> | null }> | null };

export type HierarchyFieldsFragment = { __typename?: 'Hierarchy', id: string, name: string, level: { __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string> }> | null }> | null }> | null }> | null } };

export type HierarchiesQueryVariables = Exact<{ [key: string]: never; }>;


export type HierarchiesQuery = { __typename?: 'Query', hierarchies: Array<{ __typename?: 'Hierarchy', id: string, name: string, level: { __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string> }> | null }> | null }> | null }> | null } }> };

export type HierarchyQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type HierarchyQuery = { __typename?: 'Query', hierarchy?: { __typename?: 'Hierarchy', id: string, name: string, level: { __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string> }> | null }> | null }> | null }> | null } } | null };

export type InsertLabelsMutationVariables = Exact<{
  labels: Array<LabelInput>;
}>;


export type InsertLabelsMutation = { __typename?: 'Mutation', insertLabels: Array<{ __typename?: 'Label', id: string, name: string, type: LabelType, objects: Array<{ __typename?: 'LabelObject', objectId: string, type: RealmObjectType }> }> };

export type UpdateLabelMutationVariables = Exact<{
  label: LabelInput;
}>;


export type UpdateLabelMutation = { __typename?: 'Mutation', updateLabel: boolean };

export type DeleteLabelMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteLabelMutation = { __typename?: 'Mutation', deleteLabel: boolean };

export type AssignLabelsMutationVariables = Exact<{
  objectId: Scalars['ID'];
  ids: Array<Scalars['ID']>;
}>;


export type AssignLabelsMutation = { __typename?: 'Mutation', assignLabels: boolean };

export type RemoveLabelsMutationVariables = Exact<{
  objectId: Scalars['ID'];
  ids: Array<Scalars['ID']>;
}>;


export type RemoveLabelsMutation = { __typename?: 'Mutation', removeLabels: boolean };

export type InsertHierarchyMutationVariables = Exact<{
  hierarchy: HierarchyInput;
}>;


export type InsertHierarchyMutation = { __typename?: 'Mutation', insertHierarchy: { __typename?: 'Hierarchy', id: string, name: string, level: { __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string>, levels?: Array<{ __typename?: 'HierarchyLevel', id: string, name: string, labelIds: Array<string> }> | null }> | null }> | null }> | null } } };

export type UpdateHierarchyMutationVariables = Exact<{
  hierarchy: HierarchyInput;
}>;


export type UpdateHierarchyMutation = { __typename?: 'Mutation', updateHierarchy: boolean };

export type DeleteHierarchyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteHierarchyMutation = { __typename?: 'Mutation', deleteHierarchy: boolean };

export type LabelOrHierarchyUpdateFieldsFragment = { __typename?: 'LabelOrHierarchyUpdate', type: LabelOrHierarchyUpdateType, itemIds: Array<string> };

export type LabelUpdateSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type LabelUpdateSubscription = { __typename?: 'Subscription', labelUpdate: { __typename?: 'LabelOrHierarchyUpdate', type: LabelOrHierarchyUpdateType, itemIds: Array<string> } };

export type HierarchyUpdateSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type HierarchyUpdateSubscription = { __typename?: 'Subscription', hierarchyUpdate: { __typename?: 'LabelOrHierarchyUpdate', type: LabelOrHierarchyUpdateType, itemIds: Array<string> } };

export type LicenseTextQueryVariables = Exact<{ [key: string]: never; }>;


export type LicenseTextQuery = { __typename?: 'Query', license: { __typename?: 'License', text: string } };

export type LicenseAcceptedQueryVariables = Exact<{ [key: string]: never; }>;


export type LicenseAcceptedQuery = { __typename?: 'Query', license: { __typename?: 'License', isAccepted: boolean } };

export type AcceptLicenseMutationVariables = Exact<{ [key: string]: never; }>;


export type AcceptLicenseMutation = { __typename?: 'Mutation', acceptLicense: boolean };

export type StoreQueryVariables = Exact<{ [key: string]: never; }>;


export type StoreQuery = { __typename?: 'Query', store: { __typename?: 'AppStore', session: { __typename?: 'Session', isAdmin: boolean, isLoggedIn: boolean, info?: { __typename?: 'UserInfo', realm: { __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType, maxDownloadLength?: number | null }, user: { __typename?: 'UserData', id: string, name: string, isAdmin: boolean, solidConfiguration: { __typename?: 'SolidConfiguration', config: any, activities: Array<ActivityId>, widgets: Array<{ __typename?: 'WidgetConfig', widgetId: WidgetId, config: any }>, views: Array<{ __typename?: 'ViewConfig', viewId: ViewId, config: any }> } } } | null }, select?: { __typename?: 'ObjUUID', obj: string } | null, workspace: { __typename?: 'Workspace', solidConfigJSON?: string | null, localViewsJSON?: string | null, sharedViewsJSON?: string | null, event?: { __typename?: 'EventInfo', hasSnapshots: boolean, entry: { __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, snapshots: Array<{ __typename?: 'AuditSnapshot', type: string, default: boolean, snapshot: string, tags: Array<{ __typename?: 'KeyValue', key: string, value: string }> }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> } } | null, updatedEvent?: { __typename?: 'AuditEntry', context: string, message: string, triggeredAt: Date, modifiedAt: Date, isAcknowledged: boolean, note?: string | null, category: { __typename?: 'AuditCategory', id: string, shortName: string, digest: string }, witnesses: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }>, snapshots: Array<{ __typename?: 'AuditSnapshot', type: string, default: boolean, snapshot: string, tags: Array<{ __typename?: 'KeyValue', key: string, value: string }> }>, metadata: Array<{ __typename?: 'MetaEntry', key: string, metaClass: { __typename?: 'MetaClassifier', value: string, attributes: Array<{ __typename?: 'KeyValue', key: string, value: string }> } }> } | null, creatingViews?: Array<{ __typename?: 'CreatingView', viewId: string, name: string, template?: string | null, layout?: string | null, layoutJSON?: string | null, widgets?: Array<{ __typename?: 'WidgetInfo', widgetId: string, index: number, propsJSON?: string | null }> | null, selectedWidget?: { __typename?: 'WidgetInfo', widgetId: string, index: number, propsJSON?: string | null } | null }> | null, cameraWidgetProps?: Array<{ __typename?: 'CameraWidgetProps', viewId: string, index: number, deviceId: string, name: string, time?: number | null }> | null }, socketEvent?: { __typename?: 'SocketEvent', type: SocketEventType, timeStamp: number } | null, branding?: { __typename?: 'Branding', CRM_REGISTRATION_URL: string, ICON_PATH: string, LOGIN_BACKGROUND_PATH: string, LOGIN_FOOTER_COLOR: string, LOGO_PATH: string, OEM_BRAND: string, OEM_BRAND_NAME: string, OEM_COMPANY_LONG: string, OEM_COMPANY_PHONE: string, OEM_COMPANY_PHONE_INTERNATIONAL: string, OEM_COMPANY_QUICKSTART: string, OEM_COMPANY_SHORT: string, OEM_COMPANY_SUPPORT_PHONE: string, OEM_COMPANY_SUPPORT_URL: string, OEM_COMPANY_URL: string, OEM_COPYRIGHT: string, OEM_COPYRIGHT_MATRIX: string, OEM_STYLE: string, OEM_SUPPORT_EMAIL: string, OEM_TRADEMARKS: string, QUICK_START_GUIDE_PATH: string } | null } };

export type SetStoreMutationVariables = Exact<{
  store: AppStoreInput;
}>;


export type SetStoreMutation = { __typename?: 'Mutation', setStore: boolean };

export type ImageMapSetFieldsFragment = { __typename?: 'ImageMapSet', id: string, name: string, layers: Array<{ __typename?: 'ImageMapLayer', id: string, name: string, maps: Array<{ __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> }> }> };

export type ImageMapLayerFieldsFragment = { __typename?: 'ImageMapLayer', id: string, name: string, maps: Array<{ __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> }> };

export type ImageMapFieldsFragment = { __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> };

export type ImageMapObjectFieldsFragment = { __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } };

export type ImageMapConfigQueryVariables = Exact<{
  version: Scalars['String'];
  lazyLoadImages?: InputMaybe<Scalars['Boolean']>;
}>;


export type ImageMapConfigQuery = { __typename?: 'Query', imageMapConfig: { __typename?: 'ImageMapConfig', sets: Array<{ __typename?: 'ImageMapSet', id: string, name: string, layers: Array<{ __typename?: 'ImageMapLayer', id: string, name: string, maps: Array<{ __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> }> }> }> } };

export type ImageMapImageQueryVariables = Exact<{
  version: Scalars['String'];
  mapId: Scalars['ID'];
}>;


export type ImageMapImageQuery = { __typename?: 'Query', imageMapImage: string };

export type InsertImageMapSetMutationVariables = Exact<{
  version: Scalars['String'];
  set: ImageMapSetInput;
  updateId: Scalars['ID'];
}>;


export type InsertImageMapSetMutation = { __typename?: 'Mutation', insertImageMapSet: boolean };

export type RenameImageMapSetMutationVariables = Exact<{
  version: Scalars['String'];
  setId: Scalars['ID'];
  name: Scalars['String'];
  updateId: Scalars['ID'];
}>;


export type RenameImageMapSetMutation = { __typename?: 'Mutation', renameImageMapSet: boolean };

export type DeleteImageMapSetMutationVariables = Exact<{
  version: Scalars['String'];
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
}>;


export type DeleteImageMapSetMutation = { __typename?: 'Mutation', deleteImageMapSet: boolean };

export type InsertImageMapLayerMutationVariables = Exact<{
  version: Scalars['String'];
  setId: Scalars['ID'];
  layer: ImageMapLayerInput;
  updateId: Scalars['ID'];
}>;


export type InsertImageMapLayerMutation = { __typename?: 'Mutation', insertImageMapLayer: boolean };

export type RenameImageMapLayerMutationVariables = Exact<{
  version: Scalars['String'];
  layerId: Scalars['ID'];
  name: Scalars['String'];
  updateId: Scalars['ID'];
}>;


export type RenameImageMapLayerMutation = { __typename?: 'Mutation', renameImageMapLayer: boolean };

export type DeleteImageMapLayerMutationVariables = Exact<{
  version: Scalars['String'];
  layerId: Scalars['ID'];
  updateId: Scalars['ID'];
}>;


export type DeleteImageMapLayerMutation = { __typename?: 'Mutation', deleteImageMapLayer: boolean };

export type UpdateImageMapMutationVariables = Exact<{
  version: Scalars['String'];
  map: ImageMapInput;
  updateId: Scalars['ID'];
}>;


export type UpdateImageMapMutation = { __typename?: 'Mutation', updateImageMap: boolean };

export type InsertImageMapObjectMutationVariables = Exact<{
  version: Scalars['String'];
  mapId: Scalars['ID'];
  object: ImageMapObjectInput;
  updateId: Scalars['ID'];
}>;


export type InsertImageMapObjectMutation = { __typename?: 'Mutation', insertImageMapObject: boolean };

export type UpdateImageMapObjectMutationVariables = Exact<{
  version: Scalars['String'];
  object: ImageMapObjectInput;
  updateId: Scalars['ID'];
}>;


export type UpdateImageMapObjectMutation = { __typename?: 'Mutation', updateImageMapObject: boolean };

export type DeleteImageMapObjectMutationVariables = Exact<{
  version: Scalars['String'];
  objectId: Scalars['ID'];
  updateId: Scalars['ID'];
}>;


export type DeleteImageMapObjectMutation = { __typename?: 'Mutation', deleteImageMapObject: boolean };

export type ImageMapUpdateSubscriptionVariables = Exact<{
  version: Scalars['String'];
}>;


export type ImageMapUpdateSubscription = { __typename?: 'Subscription', imageMapUpdate: { __typename?: 'ImageMapUpdateNotification', action: ImageMapUpdateAction, updateId: string, setName?: string | null, layerName?: string | null, setId?: string | null, layerId?: string | null, mapId?: string | null, objectId?: string | null, set?: { __typename?: 'ImageMapSet', id: string, name: string, layers: Array<{ __typename?: 'ImageMapLayer', id: string, name: string, maps: Array<{ __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> }> }> } | null, layer?: { __typename?: 'ImageMapLayer', id: string, name: string, maps: Array<{ __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> }> } | null, map?: { __typename?: 'ImageMap', id: string, name: string, order: number, base64: string, objects: Array<{ __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } }> } | null, object?: { __typename?: 'ImageMapObject', id: string, objectId: string, position: { __typename?: 'Position', x: number, y: number } } | null } };

export type RealmQueryVariables = Exact<{ [key: string]: never; }>;


export type RealmQuery = { __typename?: 'Query', realm?: { __typename?: 'Realm', name: string, id: string, maxDownloadTime?: number | null, adminEmail?: string | null, maxScheduledDeliveryDelay?: number | null, auditTtl?: string | null, mfAuth?: boolean | null, playerIdleTimeout?: number | null, emailEnabled?: boolean | null, emailHost?: string | null, emailPort?: number | null, emailTls?: boolean | null, emailFrom?: string | null, emailAuth?: EmailAuth | null, emailUser?: string | null, emailPass?: string | null, emailValidated?: boolean | null, jitterBufferLength?: number | null } | null };

export type GeoLayersQueryVariables = Exact<{ [key: string]: never; }>;


export type GeoLayersQuery = { __typename?: 'Query', geoLayers?: { __typename?: 'GEOLayers', geoLayers: Array<{ __typename?: 'GEOLayer', name: string, mime: string, data: string }> } | null };

export type RealmForPlayerQueryVariables = Exact<{ [key: string]: never; }>;


export type RealmForPlayerQuery = { __typename?: 'Query', realm?: { __typename?: 'Realm', jitterBufferLength?: number | null, playerIdleTimeout?: number | null } | null };

export type IdentityAttributeQueryVariables = Exact<{ [key: string]: never; }>;


export type IdentityAttributeQuery = { __typename?: 'Query', identityAttribute?: { __typename?: 'IdentityAttribute', contactUs: string } | null };

export type SessionInfoQueryVariables = Exact<{ [key: string]: never; }>;


export type SessionInfoQuery = { __typename?: 'Query', sessionInfo?: boolean | null };

export type BrandingQueryVariables = Exact<{ [key: string]: never; }>;


export type BrandingQuery = { __typename?: 'Query', branding?: { __typename?: 'Branding', crmRegistrationUrl?: string | null, iconPath?: string | null, loginBackgroundPath?: string | null, loginFooterColor?: string | null, logoPath?: string | null, oemBrand?: string | null, oemBrandName?: string | null, oemCompanyLong?: string | null, oemCompanyPhone?: string | null, oemCompanyPhoneInternational?: string | null, oemCompanyQuickstart?: string | null, oemCompanyShort?: string | null, oemCompanySupportPhone?: string | null, oemCompanySupportUrl?: string | null, oemCompanyUrl?: string | null, oemCopyright?: string | null, oemCopyrightMatrix?: string | null, oemStyle?: string | null, oemSupportEmail?: string | null, oemTrademarks?: string | null, quickStartGuidePath?: string | null } | null };

export type LanguagesQueryVariables = Exact<{ [key: string]: never; }>;


export type LanguagesQuery = { __typename?: 'Query', languages?: { __typename?: 'Languages', languages?: Array<{ __typename?: 'Language', tag: string, description: string, direction: string }> | null } | null };

export type EmailCanBeSendQueryVariables = Exact<{ [key: string]: never; }>;


export type EmailCanBeSendQuery = { __typename?: 'Query', emailCanBeSend?: boolean | null };

export type SystemParametersQueryVariables = Exact<{ [key: string]: never; }>;


export type SystemParametersQuery = { __typename?: 'Query', systemParameters?: { __typename?: 'SystemParameters', updatesHost?: string | null, solidAppVersion?: string | null, googleMapsApiKey?: string | null, mapDefaultLayer?: string | null, googleYouTubeApiKey?: string | null, googleYouTubePlaylistId?: string | null, geoDefaultPosition?: { __typename?: 'DefaultGeoPosition', lat: number, lng: number } | null } | null };

export type ActivateAvatarMutationVariables = Exact<{
  avatarId: Scalars['ID'];
}>;


export type ActivateAvatarMutation = { __typename?: 'Mutation', activateAvatar?: boolean | null };

export type VerifyCodeMutationVariables = Exact<{
  code: Scalars['String'];
}>;


export type VerifyCodeMutation = { __typename?: 'Mutation', verifyCode?: boolean | null };

export type ActivateEmailMutationVariables = Exact<{
  input: SecretPassword;
}>;


export type ActivateEmailMutation = { __typename?: 'Mutation', activateEmail?: boolean | null };

export type RestorePasswordMutationVariables = Exact<{
  input: SecretPassword;
}>;


export type RestorePasswordMutation = { __typename?: 'Mutation', restorePassword?: boolean | null };

export type ChangeCurrentPasswordMutationVariables = Exact<{
  input: ChangeCurrentPasswordInput;
}>;


export type ChangeCurrentPasswordMutation = { __typename?: 'Mutation', changeCurrentPassword?: boolean | null };

export type UpdateGeoLayersMutationVariables = Exact<{
  input: GeoLayersInput;
}>;


export type UpdateGeoLayersMutation = { __typename?: 'Mutation', updateGeoLayers?: boolean | null };

export type UpdateRealmMutationVariables = Exact<{
  realm: RealmInput;
}>;


export type UpdateRealmMutation = { __typename?: 'Mutation', updateRealm?: boolean | null };

export type ValidateEmailMutationVariables = Exact<{
  addresses: EmailAddresses;
}>;


export type ValidateEmailMutation = { __typename?: 'Mutation', validateEmail?: boolean | null };

export type RealmFieldsFragment = { __typename?: 'Realm', name: string, id: string, maxDownloadTime?: number | null, adminEmail?: string | null, maxScheduledDeliveryDelay?: number | null, auditTtl?: string | null, mfAuth?: boolean | null, playerIdleTimeout?: number | null, emailEnabled?: boolean | null, emailHost?: string | null, emailPort?: number | null, emailTls?: boolean | null, emailFrom?: string | null, emailAuth?: EmailAuth | null, emailUser?: string | null, emailPass?: string | null, emailValidated?: boolean | null, jitterBufferLength?: number | null };

export type RealmObjectsQueryVariables = Exact<{ [key: string]: never; }>;


export type RealmObjectsQuery = { __typename?: 'Query', realmObjects: Array<{ __typename?: 'CurrentRealm', id: string, name: string } | { __typename?: 'Device', id: string, name: string } | { __typename?: 'GenericObject', id: string, name: string } | { __typename?: 'Group', id: string, name: string } | { __typename?: 'Policy', id: string, name: string } | { __typename?: 'Set', id: string, name: string } | { __typename?: 'User', id: string, name: string } | { __typename?: 'Zone', id: string, name: string }> };

export type ObjectUpdateSubscriptionVariables = Exact<{
  filter?: InputMaybe<ObjectUpdateFilter>;
}>;


export type ObjectUpdateSubscription = { __typename?: 'Subscription', objectUpdate: { __typename?: 'ObjectUpdateEvent', id: string, type: string, action: ObjectAction, healthStatus?: HealthStatus | null } };

export type AvatarReportQueryVariables = Exact<{
  id: Scalars['ID'];
  from: Scalars['DateTime'];
  to: Scalars['DateTime'];
  metricName: AvatarMetricName;
}>;


export type AvatarReportQuery = { __typename?: 'Query', avatarReport: Array<{ __typename?: 'NumericReport', time: number, value: number }> };

export type CameraReportQueryVariables = Exact<{
  id: Scalars['ID'];
  from: Scalars['DateTime'];
  to: Scalars['DateTime'];
  metricName: CameraMetricName;
  dfaId: Scalars['Int'];
}>;


export type CameraReportQuery = { __typename?: 'Query', numeric: Array<{ __typename?: 'NumericReport', time: number, value: number } | { __typename?: 'StatusReport' }>, status: Array<{ __typename?: 'NumericReport' } | { __typename?: 'StatusReport', time: number, value: StatusMetric }> };

export type AvatarMetricsQueryVariables = Exact<{ [key: string]: never; }>;


export type AvatarMetricsQuery = { __typename?: 'Query', avatarMetrics: Array<{ __typename?: 'AvatarMetric', key: AvatarMetricName, name: string, dimension: MetricDimension }> };

export type CameraMetricsQueryVariables = Exact<{
  id: Scalars['ID'];
  from?: InputMaybe<Scalars['DateTime']>;
  to?: InputMaybe<Scalars['DateTime']>;
}>;


export type CameraMetricsQuery = { __typename?: 'Query', cameraMetrics: Array<{ __typename?: 'CameraMetric', key: CameraMetricName, name: string, dimension: MetricDimension, dfaId: number }> };

export type SystemStatusQueryVariables = Exact<{ [key: string]: never; }>;


export type SystemStatusQuery = { __typename?: 'Query', serverTime: Date, systemStatus: { __typename?: 'SystemStatusInfo', status: SystemStatus, description?: string | null, reasons: Array<{ __typename?: 'SystemStatusReason', message: string, object?: { __typename?: 'SystemStatusReasonObject', id: string, name: string, type: string } | null }> } };

export type SolidConfigQueryVariables = Exact<{
  userId: Scalars['ID'];
}>;


export type SolidConfigQuery = { __typename?: 'Query', solidConfig?: string | null };

export type UpdateSolidConfigMutationVariables = Exact<{
  userId: Scalars['ID'];
  solidConfig?: InputMaybe<Scalars['String']>;
}>;


export type UpdateSolidConfigMutation = { __typename?: 'Mutation', updateSolidConfig: boolean };

export type UpdateSolidConfigCurrentViewMutationVariables = Exact<{
  input: SolidConfigCurrentViewInput;
}>;


export type UpdateSolidConfigCurrentViewMutation = { __typename?: 'Mutation', updateSolidConfigCurrentView: boolean };

export type SolidConfigUpdateSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type SolidConfigUpdateSubscription = { __typename?: 'Subscription', solidConfigUpdate: { __typename?: 'SolidConfigUpdateEvent', userId: string, solidConfig?: string | null } };

export type UserFieldsFragment = { __typename?: 'User', id: string, name: string, email?: string | null, emailConfirmed?: boolean | null, sendNotification?: boolean | null, groups: Array<{ __typename?: 'Group', id: string, name: string, isSystemManaged: boolean }> };

export type UserInfoFieldsFragment = { __typename?: 'UserInfo', realm: { __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType, maxDownloadLength?: number | null }, user: { __typename?: 'UserData', id: string, name: string, isAdmin: boolean, solidConfiguration: { __typename?: 'SolidConfiguration', config: any, activities: Array<ActivityId>, widgets: Array<{ __typename?: 'WidgetConfig', widgetId: WidgetId, config: any }>, views: Array<{ __typename?: 'ViewConfig', viewId: ViewId, config: any }> } } };

export type UserIdsQueryVariables = Exact<{ [key: string]: never; }>;


export type UserIdsQuery = { __typename?: 'Query', users: Array<{ __typename?: 'User', id: string }> };

export type UserWitnessesQueryVariables = Exact<{ [key: string]: never; }>;


export type UserWitnessesQuery = { __typename?: 'Query', users: Array<{ __typename?: 'User', id: string, name: string }> };

export type UserQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type UserQuery = { __typename?: 'Query', user?: { __typename?: 'User', id: string, name: string, email?: string | null, emailConfirmed?: boolean | null, sendNotification?: boolean | null, groups: Array<{ __typename?: 'Group', id: string, name: string, isSystemManaged: boolean }> } | null };

export type UserInfoQueryVariables = Exact<{ [key: string]: never; }>;


export type UserInfoQuery = { __typename?: 'Query', userInfo: { __typename?: 'UserInfo', realm: { __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType, maxDownloadLength?: number | null }, user: { __typename?: 'UserData', id: string, name: string, isAdmin: boolean, solidConfiguration: { __typename?: 'SolidConfiguration', config: any, activities: Array<ActivityId>, widgets: Array<{ __typename?: 'WidgetConfig', widgetId: WidgetId, config: any }>, views: Array<{ __typename?: 'ViewConfig', viewId: ViewId, config: any }> } } } };

export type UsersQueryVariables = Exact<{ [key: string]: never; }>;


export type UsersQuery = { __typename?: 'Query', users: Array<{ __typename?: 'User', id: string, name: string, email?: string | null, emailConfirmed?: boolean | null, sendNotification?: boolean | null, groups: Array<{ __typename?: 'Group', id: string, name: string, isSystemManaged: boolean }> }> };

export type CreateUserMutationVariables = Exact<{
  user: UserInput;
}>;


export type CreateUserMutation = { __typename?: 'Mutation', createUser: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdateUserMutationVariables = Exact<{
  id: Scalars['ID'];
  user: UserInput;
}>;


export type UpdateUserMutation = { __typename?: 'Mutation', updateUser: boolean };

export type DeleteUserMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteUserMutation = { __typename?: 'Mutation', deleteUser: boolean };

export type UnblockUserMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type UnblockUserMutation = { __typename?: 'Mutation', unblockUser: boolean };

export type ChangePasswordMutationVariables = Exact<{
  input: ChangePasswordInput;
}>;


export type ChangePasswordMutation = { __typename?: 'Mutation', changePassword: boolean };

export type SetPasswordMutationVariables = Exact<{
  input: SetPasswordInput;
}>;


export type SetPasswordMutation = { __typename?: 'Mutation', setPassword: boolean };

export type GroupsQueryVariables = Exact<{ [key: string]: never; }>;


export type GroupsQuery = { __typename?: 'Query', groups: Array<{ __typename?: 'Group', id: string, name: string, isSystemManaged: boolean, users: Array<{ __typename?: 'User', id: string, name: string }>, policies: Array<{ __typename?: 'Policy', id: string, name: string, isSystemManaged: boolean }> }> };

export type CreateGroupMutationVariables = Exact<{
  group: GroupInput;
}>;


export type CreateGroupMutation = { __typename?: 'Mutation', createGroup: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdateGroupMutationVariables = Exact<{
  id: Scalars['ID'];
  group: GroupInput;
}>;


export type UpdateGroupMutation = { __typename?: 'Mutation', updateGroup: boolean };

export type DeleteGroupMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteGroupMutation = { __typename?: 'Mutation', deleteGroup: boolean };

export type PoliciesQueryVariables = Exact<{ [key: string]: never; }>;


export type PoliciesQuery = { __typename?: 'Query', policies: Array<{ __typename?: 'Policy', id: string, name: string, isSystemManaged: boolean, statements: Array<{ __typename?: 'PolicyStatement', id: string, name: string, effect: StatementEffect, actions: Array<string>, allResources: boolean, resources: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, type: RealmObjectType }> }> }> };

export type CreatePolicyMutationVariables = Exact<{
  policy: PolicyInput;
}>;


export type CreatePolicyMutation = { __typename?: 'Mutation', createPolicy: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdatePolicyMutationVariables = Exact<{
  id: Scalars['ID'];
  policy: PolicyInput;
}>;


export type UpdatePolicyMutation = { __typename?: 'Mutation', updatePolicy: boolean };

export type DeletePolicyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeletePolicyMutation = { __typename?: 'Mutation', deletePolicy: boolean };

export type CreatePolicyStatementMutationVariables = Exact<{
  policyId: Scalars['ID'];
  statement: PolicyStatementInput;
}>;


export type CreatePolicyStatementMutation = { __typename?: 'Mutation', createPolicyStatement: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdatePolicyStatementMutationVariables = Exact<{
  statementId: Scalars['ID'];
  statement: PolicyStatementInput;
}>;


export type UpdatePolicyStatementMutation = { __typename?: 'Mutation', updatePolicyStatement: boolean };

export type DeletePolicyStatementMutationVariables = Exact<{
  statementId: Scalars['ID'];
}>;


export type DeletePolicyStatementMutation = { __typename?: 'Mutation', deletePolicyStatement: boolean };

export type ActionsQueryVariables = Exact<{ [key: string]: never; }>;


export type ActionsQuery = { __typename?: 'Query', actions: Array<{ __typename?: 'Action', action: string, description: string, resourceTypes: Array<RealmObjectType>, deviceFunctionalAspectTypes: Array<DeviceFunctionalAspectType>, accessLevel: { __typename?: 'AccessLevel', level: string, description: string, order: number } }> };

export type AccessLevelsQueryVariables = Exact<{ [key: string]: never; }>;


export type AccessLevelsQuery = { __typename?: 'Query', accessLevels: Array<{ __typename?: 'AccessLevel', level: string, description: string, order: number }> };

export type ZonesQueryVariables = Exact<{ [key: string]: never; }>;


export type ZonesQuery = { __typename?: 'Query', zones: Array<{ __typename?: 'Zone', id: string, name: string, devices: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string }> }> };

export type SetsQueryVariables = Exact<{ [key: string]: never; }>;


export type SetsQuery = { __typename?: 'Query', sets: Array<{ __typename?: 'Set', id: string, name: string, isSystemManaged: boolean, devices: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string }> }> };

export type GuisQueryVariables = Exact<{ [key: string]: never; }>;


export type GuisQuery = { __typename?: 'Query', guis: Array<{ __typename?: 'Gui', id: string, name: string }> };

export type UserRealmsQueryVariables = Exact<{ [key: string]: never; }>;


export type UserRealmsQuery = { __typename?: 'Query', userRealms: Array<{ __typename?: 'CurrentRealm', id: string, name: string, type: RealmObjectType } | { __typename?: 'Device', id: string, name: string, type: RealmObjectType } | { __typename?: 'GenericObject', id: string, name: string, type: RealmObjectType } | { __typename?: 'Group', id: string, name: string, type: RealmObjectType } | { __typename?: 'Policy', id: string, name: string, type: RealmObjectType } | { __typename?: 'Set', id: string, name: string, type: RealmObjectType } | { __typename?: 'User', id: string, name: string, type: RealmObjectType } | { __typename?: 'Zone', id: string, name: string, type: RealmObjectType }> };

export type SetUserRealmMutationVariables = Exact<{
  userName: Scalars['String'];
  realmId: Scalars['ID'];
}>;


export type SetUserRealmMutation = { __typename?: 'Mutation', setUserRealm: boolean };

export type CreateZoneMutationVariables = Exact<{
  zone: ZoneInput;
}>;


export type CreateZoneMutation = { __typename?: 'Mutation', createZone: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdateZoneMutationVariables = Exact<{
  id: Scalars['ID'];
  zone: ZoneInput;
}>;


export type UpdateZoneMutation = { __typename?: 'Mutation', updateZone: boolean };

export type DeleteZoneMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteZoneMutation = { __typename?: 'Mutation', deleteZone: boolean };

export type CreateSetMutationVariables = Exact<{
  set: SetInput;
}>;


export type CreateSetMutation = { __typename?: 'Mutation', createSet: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdateSetMutationVariables = Exact<{
  id: Scalars['ID'];
  set: SetInput;
}>;


export type UpdateSetMutation = { __typename?: 'Mutation', updateSet: boolean };

export type DeleteSetMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteSetMutation = { __typename?: 'Mutation', deleteSet: boolean };

export const AodRequestFieldsFragmentDoc = gql`
    fragment aodRequestFields on AodRequest {
  id
  realmId
  avatarId
  deviceId
  userId
  status
  startTime
  endTime
  streamNumber
  createdAt
  expiredAt
  size
  downloaded
  type
  eta
  note
  files {
    expired
    list {
      href
      size
      startTime
      endTime
    }
  }
}
    `;
export const AuditEntryMetadataFieldsFragmentDoc = gql`
    fragment auditEntryMetadataFields on AuditEntry {
  metadata {
    key
    metaClass {
      value
      attributes {
        key
        value
      }
    }
  }
}
    `;
export const AuditEntryFieldsFragmentDoc = gql`
    fragment auditEntryFields on AuditEntry {
  context
  message
  triggeredAt
  modifiedAt
  category {
    id
    shortName
    digest
  }
  witnesses {
    id
    name
    type
  }
  isAcknowledged
  note
  ...auditEntryMetadataFields
}
    ${AuditEntryMetadataFieldsFragmentDoc}`;
export const AuditEntrySnapshotFieldsFragmentDoc = gql`
    fragment auditEntrySnapshotFields on AuditEntry {
  snapshots {
    type
    default
    snapshot
    tags {
      key
      value
    }
  }
}
    `;
export const ConnectFieldsFragmentDoc = gql`
    fragment connectFields on NetworkConnectDescriptor {
  authType
  URL
  host
  user
  pass
  port
  rtspPort
  protocol
}
    `;
export const DeviceConfigFieldsFragmentDoc = gql`
    fragment deviceConfigFields on DeviceBaseConfig {
  configType
  connect {
    ...connectFields
  }
  make
  model
  firmware
  onvifServices
}
    ${ConnectFieldsFragmentDoc}`;
export const SetsFieldsFragmentDoc = gql`
    fragment setsFields on ObjectDescriptor {
  id
  name
  isSystemManaged
}
    `;
export const StoragePoolFieldsFragmentDoc = gql`
    fragment storagePoolFields on StoragePool {
  id
  name
  ttlHours
}
    `;
export const StorageConfigFieldsFragmentDoc = gql`
    fragment storageConfigFields on DeviceStorageConfig {
  storagePool {
    ...storagePoolFields
  }
}
    ${StoragePoolFieldsFragmentDoc}`;
export const AspectTemplateFieldsFragmentDoc = gql`
    fragment aspectTemplateFields on FunctionalAspectTemplate {
  id
  type
  name
  order
  engine
  features {
    id
    name
    order
    exclusive
  }
}
    `;
export const AspectHealthFieldsFragmentDoc = gql`
    fragment aspectHealthFields on AspectHealth {
  gravity
  readinessTimeout
  livenessTimeout
  healthStatus
}
    `;
export const StatTimeFieldsFragmentDoc = gql`
    fragment statTimeFields on StatTime {
  avg
  max
  min
}
    `;
export const AspectFieldsFragmentDoc = gql`
    fragment aspectFields on DeviceFunctionalAspect {
  id
  type
  name
  template {
    ...aspectTemplateFields
  }
  device {
    id
    name
  }
  health {
    ...aspectHealthFields
  }
  inputAspects {
    id
    name
  }
  enabled
  ... on DFA_Media {
    streamType
    URL
    videoWidth
    videoHeight
    codec
    frameRate
    onvifProfile
    onvifProfiles
    edgeArchive
    cloudArchive
    consumedSpace
    spaceUsageHour
    spaceUsageDay
    FPS
    liveBitrate
    uptime
    averageFPS
    averageGOP
    averageInterArrivalJitter
    rtpPacketLost
    videoCodec
    videoSize
    audioCodec
    sharedStream {
      id
      url
      error
      status
    }
  }
  ... on DFA_PTZ {
    ptzPanInverted
    ptzTiltInverted
    ptzConfig
  }
  ... on DFA_VAE {
    vaeConfig {
      name
      description
      configuration
    }
    vaeFeatures
  }
  ... on DFA_Avatar {
    storageUsage {
      free
      requiredVolume
      localStorageVolume
    }
    isLink
    channelStatus
    dsConfiguredState
    dsRunningState
    lastStatusUpdate
    statusUpdateInterval
    vmxVideoStreamingMode
    vaeImageUpdate
    software {
      version
      updateAvailable
      lastUpdateTime
      lastUpdateSucceeded
    }
    webRtcEnabled
    channelBenchmark {
      startedAt
      error
      tcpDown {
        bytes
        bitsPerSecond
      }
      tcpUp {
        bytes
        bitsPerSecond
      }
    }
    uploadBandwidthCap
    encryptionKey {
      isValid
      issuedAt
    }
    platform
    upTime
    avatarLoad
    deliveryQueue
    deliveryQueueUploadTime
    turnaroundTime
    supportsReboot
    pushEventEndPoint
    channelTurnaroundTime {
      ...statTimeFields
    }
    packetArrivalJitterTime {
      ...statTimeFields
    }
    vaeUpdates {
      name
      status
      version
      log
    }
    apiKey
  }
  ... on DFA_Sensor {
    model
    serial
    userEvents
    sensorEvents {
      type
      description
    }
    associatedDevices
    category
  }
  ... on DFA_Gateway {
    lenelVersion
    directory {
      id
      name
    }
    oidcToken
    associatedGatewayDevices {
      id
      associatedDevices
    }
    subscribedEvents {
      id
      type
    }
    directories {
      id
      name
    }
    devices {
      id
      name
    }
    events {
      id
      name
    }
  }
}
    ${AspectTemplateFieldsFragmentDoc}
${AspectHealthFieldsFragmentDoc}
${StatTimeFieldsFragmentDoc}`;
export const DeviceFieldsFragmentDoc = gql`
    fragment deviceFields on Device {
  id
  name
  createdAt
  modifiedAt
  position {
    lat
    lng
    alt
  }
  config {
    ...deviceConfigFields
  }
  platform {
    id
    name
    aspects {
      type
      ... on DFA_Avatar {
        webRtcEnabled
      }
    }
  }
  enabled
  healthStatus
  version
  location
  zone {
    id
    name
  }
  set {
    ...setsFields
  }
  storageConfig {
    ...storageConfigFields
  }
  deliveryPriority
  aspects {
    ...aspectFields
  }
  eventType
  rtpOverTcp
  rtpTime
  deviceType
  acknowledgeRequired
}
    ${DeviceConfigFieldsFragmentDoc}
${SetsFieldsFragmentDoc}
${StorageConfigFieldsFragmentDoc}
${AspectFieldsFragmentDoc}`;
export const DevicePlayerFieldsFragmentDoc = gql`
    fragment devicePlayerFields on Device {
  id
  name
  cloudDirect
  aspects {
    enabled
    ... on DFA_Media {
      streamType
    }
  }
  platform {
    aspects {
      ... on DFA_Avatar {
        webRtcEnabled
      }
    }
  }
}
    `;
export const DeviceProbeFieldsFragmentDoc = gql`
    fragment deviceProbeFields on DeviceProbe {
  name
  config {
    ...deviceConfigFields
  }
  aspects {
    ...aspectFields
  }
  snapshots
  rtpTime
}
    ${DeviceConfigFieldsFragmentDoc}
${AspectFieldsFragmentDoc}`;
export const LocalStorageFieldsFragmentDoc = gql`
    fragment localStorageFields on LocalStorage {
  enabled
  pool {
    path
    size
    enforce
  }
  strategy
  ver
}
    `;
export const DeviceListFieldsFragmentDoc = gql`
    fragment deviceListFields on Device {
  id
  name
  enabled
  healthStatus
  deviceType
}
    `;
export const DeviceReportFieldsFragmentDoc = gql`
    fragment deviceReportFields on Device {
  id
  name
  healthStatus
  config {
    model
    configType
    connect {
      host
    }
  }
  aspects {
    type
    enabled
    ... on DFA_Media {
      codec
      cloudArchive
      consumedSpace
      spaceUsageDay
      FPS
      liveBitrate
    }
    ... on DFA_Avatar {
      channelStatus
      lastStatusUpdate
      statusUpdateInterval
      deliveryQueue
      deliveryQueueUploadTime
      turnaroundTime
      software {
        lastUpdateTime
      }
    }
  }
  platform {
    name
  }
}
    `;
export const DeviceShortFieldsFragmentDoc = gql`
    fragment deviceShortFields on Device {
  id
  name
  location
  enabled
  healthStatus
  deliveryPriority
  config {
    connect {
      host
      port
      URL
    }
  }
  aspects {
    type
    ... on DFA_Avatar {
      isLink
      channelStatus
      lastStatusUpdate
      statusUpdateInterval
    }
    ... on DFA_Media {
      cloudArchive
    }
  }
  position {
    lat
    lng
    alt
  }
  platform {
    id
    name
  }
  zone {
    id
    name
  }
  deviceType
}
    `;
export const SensorListFieldsFragmentDoc = gql`
    fragment sensorListFields on Device {
  id
  name
  enabled
  location
  healthStatus
  zone {
    id
    name
  }
  platform {
    id
    name
  }
  config {
    connect {
      host
      port
    }
  }
}
    `;
export const GatewayListFieldsFragmentDoc = gql`
    fragment gatewayListFields on Device {
  id
  name
  enabled
  healthStatus
  platform {
    id
    name
  }
  aspects {
    type
    ... on DFA_Gateway {
      associatedGatewayDevices {
        id
        name
        associatedDevices
      }
    }
  }
}
    `;
export const LabelFieldsFragmentDoc = gql`
    fragment LabelFields on Label {
  id
  name
  objects {
    objectId
    type
  }
  type
}
    `;
export const HierarchyLevelFieldsFragmentDoc = gql`
    fragment HierarchyLevelFields on HierarchyLevel {
  id
  name
  labelIds
}
    `;
export const HierarchyLevelRecursiveFragmentDoc = gql`
    fragment HierarchyLevelRecursive on HierarchyLevel {
  ...HierarchyLevelFields
  levels {
    ...HierarchyLevelFields
    levels {
      ...HierarchyLevelFields
      levels {
        ...HierarchyLevelFields
        levels {
          ...HierarchyLevelFields
        }
      }
    }
  }
}
    ${HierarchyLevelFieldsFragmentDoc}`;
export const HierarchyFieldsFragmentDoc = gql`
    fragment HierarchyFields on Hierarchy {
  id
  name
  level {
    ...HierarchyLevelRecursive
  }
}
    ${HierarchyLevelRecursiveFragmentDoc}`;
export const LabelOrHierarchyUpdateFieldsFragmentDoc = gql`
    fragment LabelOrHierarchyUpdateFields on LabelOrHierarchyUpdate {
  type
  itemIds
}
    `;
export const ImageMapObjectFieldsFragmentDoc = gql`
    fragment ImageMapObjectFields on ImageMapObject {
  id
  objectId
  position {
    x
    y
  }
}
    `;
export const ImageMapFieldsFragmentDoc = gql`
    fragment ImageMapFields on ImageMap {
  id
  name
  order
  base64
  objects {
    ...ImageMapObjectFields
  }
}
    ${ImageMapObjectFieldsFragmentDoc}`;
export const ImageMapLayerFieldsFragmentDoc = gql`
    fragment ImageMapLayerFields on ImageMapLayer {
  id
  name
  maps {
    ...ImageMapFields
  }
}
    ${ImageMapFieldsFragmentDoc}`;
export const ImageMapSetFieldsFragmentDoc = gql`
    fragment ImageMapSetFields on ImageMapSet {
  id
  name
  layers {
    ...ImageMapLayerFields
  }
}
    ${ImageMapLayerFieldsFragmentDoc}`;
export const RealmFieldsFragmentDoc = gql`
    fragment realmFields on Realm {
  name
  id
  maxDownloadTime
  adminEmail
  maxScheduledDeliveryDelay
  auditTtl
  mfAuth
  playerIdleTimeout
  emailEnabled
  emailHost
  emailPort
  emailTls
  emailFrom
  emailAuth
  emailUser
  emailPass
  emailValidated
  jitterBufferLength
}
    `;
export const UserFieldsFragmentDoc = gql`
    fragment userFields on User {
  id
  name
  email
  emailConfirmed
  sendNotification
  groups {
    id
    name
    isSystemManaged
  }
}
    `;
export const UserInfoFieldsFragmentDoc = gql`
    fragment userInfoFields on UserInfo {
  realm {
    id
    name
    type
    maxDownloadLength
  }
  user {
    id
    name
    isAdmin
    solidConfiguration {
      config
      widgets {
        widgetId
        config
      }
      views {
        viewId
        config
      }
      activities
    }
  }
}
    `;
export const AodListDocument = gql`
    query aodList($startTime: DateTime!, $endTime: DateTime!) {
  aodGetList(startTime: $startTime, endTime: $endTime) {
    ...aodRequestFields
  }
}
    ${AodRequestFieldsFragmentDoc}`;

/**
 * __useAodListQuery__
 *
 * To run a query within a React component, call `useAodListQuery` and pass it any options that fit your needs.
 * When your component renders, `useAodListQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAodListQuery({
 *   variables: {
 *      startTime: // value for 'startTime'
 *      endTime: // value for 'endTime'
 *   },
 * });
 */
export function useAodListQuery(baseOptions: Apollo.QueryHookOptions<AodListQuery, AodListQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AodListQuery, AodListQueryVariables>(AodListDocument, options);
      }
export function useAodListLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AodListQuery, AodListQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AodListQuery, AodListQueryVariables>(AodListDocument, options);
        }
export type AodListQueryHookResult = ReturnType<typeof useAodListQuery>;
export type AodListLazyQueryHookResult = ReturnType<typeof useAodListLazyQuery>;
export type AodListQueryResult = Apollo.QueryResult<AodListQuery, AodListQueryVariables>;
export const AodUpdatedListDocument = gql`
    query aodUpdatedList($updatedFrom: DateTime!) {
  aodGetUpdatedList(updatedFrom: $updatedFrom) {
    ...aodRequestFields
  }
}
    ${AodRequestFieldsFragmentDoc}`;

/**
 * __useAodUpdatedListQuery__
 *
 * To run a query within a React component, call `useAodUpdatedListQuery` and pass it any options that fit your needs.
 * When your component renders, `useAodUpdatedListQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAodUpdatedListQuery({
 *   variables: {
 *      updatedFrom: // value for 'updatedFrom'
 *   },
 * });
 */
export function useAodUpdatedListQuery(baseOptions: Apollo.QueryHookOptions<AodUpdatedListQuery, AodUpdatedListQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AodUpdatedListQuery, AodUpdatedListQueryVariables>(AodUpdatedListDocument, options);
      }
export function useAodUpdatedListLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AodUpdatedListQuery, AodUpdatedListQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AodUpdatedListQuery, AodUpdatedListQueryVariables>(AodUpdatedListDocument, options);
        }
export type AodUpdatedListQueryHookResult = ReturnType<typeof useAodUpdatedListQuery>;
export type AodUpdatedListLazyQueryHookResult = ReturnType<typeof useAodUpdatedListLazyQuery>;
export type AodUpdatedListQueryResult = Apollo.QueryResult<AodUpdatedListQuery, AodUpdatedListQueryVariables>;
export const AodSubmitDocument = gql`
    mutation aodSubmit($input: AodRequestInput!) {
  aodSubmit(input: $input) {
    ...aodRequestFields
  }
}
    ${AodRequestFieldsFragmentDoc}`;
export type AodSubmitMutationFn = Apollo.MutationFunction<AodSubmitMutation, AodSubmitMutationVariables>;

/**
 * __useAodSubmitMutation__
 *
 * To run a mutation, you first call `useAodSubmitMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAodSubmitMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [aodSubmitMutation, { data, loading, error }] = useAodSubmitMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAodSubmitMutation(baseOptions?: Apollo.MutationHookOptions<AodSubmitMutation, AodSubmitMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AodSubmitMutation, AodSubmitMutationVariables>(AodSubmitDocument, options);
      }
export type AodSubmitMutationHookResult = ReturnType<typeof useAodSubmitMutation>;
export type AodSubmitMutationResult = Apollo.MutationResult<AodSubmitMutation>;
export type AodSubmitMutationOptions = Apollo.BaseMutationOptions<AodSubmitMutation, AodSubmitMutationVariables>;
export const AodPauseDocument = gql`
    mutation aodPause($requestId: ID!) {
  aodPause(requestId: $requestId)
}
    `;
export type AodPauseMutationFn = Apollo.MutationFunction<AodPauseMutation, AodPauseMutationVariables>;

/**
 * __useAodPauseMutation__
 *
 * To run a mutation, you first call `useAodPauseMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAodPauseMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [aodPauseMutation, { data, loading, error }] = useAodPauseMutation({
 *   variables: {
 *      requestId: // value for 'requestId'
 *   },
 * });
 */
export function useAodPauseMutation(baseOptions?: Apollo.MutationHookOptions<AodPauseMutation, AodPauseMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AodPauseMutation, AodPauseMutationVariables>(AodPauseDocument, options);
      }
export type AodPauseMutationHookResult = ReturnType<typeof useAodPauseMutation>;
export type AodPauseMutationResult = Apollo.MutationResult<AodPauseMutation>;
export type AodPauseMutationOptions = Apollo.BaseMutationOptions<AodPauseMutation, AodPauseMutationVariables>;
export const AodResumeDocument = gql`
    mutation aodResume($requestId: ID!) {
  aodResume(requestId: $requestId)
}
    `;
export type AodResumeMutationFn = Apollo.MutationFunction<AodResumeMutation, AodResumeMutationVariables>;

/**
 * __useAodResumeMutation__
 *
 * To run a mutation, you first call `useAodResumeMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAodResumeMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [aodResumeMutation, { data, loading, error }] = useAodResumeMutation({
 *   variables: {
 *      requestId: // value for 'requestId'
 *   },
 * });
 */
export function useAodResumeMutation(baseOptions?: Apollo.MutationHookOptions<AodResumeMutation, AodResumeMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AodResumeMutation, AodResumeMutationVariables>(AodResumeDocument, options);
      }
export type AodResumeMutationHookResult = ReturnType<typeof useAodResumeMutation>;
export type AodResumeMutationResult = Apollo.MutationResult<AodResumeMutation>;
export type AodResumeMutationOptions = Apollo.BaseMutationOptions<AodResumeMutation, AodResumeMutationVariables>;
export const AodCancelDocument = gql`
    mutation aodCancel($requestIds: [ID!]!) {
  aodCancel(requestIds: $requestIds)
}
    `;
export type AodCancelMutationFn = Apollo.MutationFunction<AodCancelMutation, AodCancelMutationVariables>;

/**
 * __useAodCancelMutation__
 *
 * To run a mutation, you first call `useAodCancelMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAodCancelMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [aodCancelMutation, { data, loading, error }] = useAodCancelMutation({
 *   variables: {
 *      requestIds: // value for 'requestIds'
 *   },
 * });
 */
export function useAodCancelMutation(baseOptions?: Apollo.MutationHookOptions<AodCancelMutation, AodCancelMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AodCancelMutation, AodCancelMutationVariables>(AodCancelDocument, options);
      }
export type AodCancelMutationHookResult = ReturnType<typeof useAodCancelMutation>;
export type AodCancelMutationResult = Apollo.MutationResult<AodCancelMutation>;
export type AodCancelMutationOptions = Apollo.BaseMutationOptions<AodCancelMutation, AodCancelMutationVariables>;
export const AodUpdateDocument = gql`
    subscription aodUpdate($filter: AodRequestFilter!) {
  aodUpdate(filter: $filter) {
    ...aodRequestFields
  }
}
    ${AodRequestFieldsFragmentDoc}`;

/**
 * __useAodUpdateSubscription__
 *
 * To run a query within a React component, call `useAodUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useAodUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAodUpdateSubscription({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useAodUpdateSubscription(baseOptions: Apollo.SubscriptionHookOptions<AodUpdateSubscription, AodUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<AodUpdateSubscription, AodUpdateSubscriptionVariables>(AodUpdateDocument, options);
      }
export type AodUpdateSubscriptionHookResult = ReturnType<typeof useAodUpdateSubscription>;
export type AodUpdateSubscriptionResult = Apollo.SubscriptionResult<AodUpdateSubscription>;
export const AuditCategoriesDocument = gql`
    query auditCategories {
  auditCategories {
    id
    parent
    shortName
  }
}
    `;

/**
 * __useAuditCategoriesQuery__
 *
 * To run a query within a React component, call `useAuditCategoriesQuery` and pass it any options that fit your needs.
 * When your component renders, `useAuditCategoriesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAuditCategoriesQuery({
 *   variables: {
 *   },
 * });
 */
export function useAuditCategoriesQuery(baseOptions?: Apollo.QueryHookOptions<AuditCategoriesQuery, AuditCategoriesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AuditCategoriesQuery, AuditCategoriesQueryVariables>(AuditCategoriesDocument, options);
      }
export function useAuditCategoriesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AuditCategoriesQuery, AuditCategoriesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AuditCategoriesQuery, AuditCategoriesQueryVariables>(AuditCategoriesDocument, options);
        }
export type AuditCategoriesQueryHookResult = ReturnType<typeof useAuditCategoriesQuery>;
export type AuditCategoriesLazyQueryHookResult = ReturnType<typeof useAuditCategoriesLazyQuery>;
export type AuditCategoriesQueryResult = Apollo.QueryResult<AuditCategoriesQuery, AuditCategoriesQueryVariables>;
export const AuditEntriesDocument = gql`
    query auditEntries($filter: AuditEntryFilter!) {
  auditEntries(filter: $filter) {
    ...auditEntryFields
  }
}
    ${AuditEntryFieldsFragmentDoc}`;

/**
 * __useAuditEntriesQuery__
 *
 * To run a query within a React component, call `useAuditEntriesQuery` and pass it any options that fit your needs.
 * When your component renders, `useAuditEntriesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAuditEntriesQuery({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useAuditEntriesQuery(baseOptions: Apollo.QueryHookOptions<AuditEntriesQuery, AuditEntriesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AuditEntriesQuery, AuditEntriesQueryVariables>(AuditEntriesDocument, options);
      }
export function useAuditEntriesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AuditEntriesQuery, AuditEntriesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AuditEntriesQuery, AuditEntriesQueryVariables>(AuditEntriesDocument, options);
        }
export type AuditEntriesQueryHookResult = ReturnType<typeof useAuditEntriesQuery>;
export type AuditEntriesLazyQueryHookResult = ReturnType<typeof useAuditEntriesLazyQuery>;
export type AuditEntriesQueryResult = Apollo.QueryResult<AuditEntriesQuery, AuditEntriesQueryVariables>;
export const RequireAcknowledgeWithSnapshotsEntriesDocument = gql`
    query requireAcknowledgeWithSnapshotsEntries($filter: AuditEntryFilter!) {
  requireAcknowledgeEntries(filter: $filter) {
    ...auditEntryFields
    ...auditEntrySnapshotFields
  }
}
    ${AuditEntryFieldsFragmentDoc}
${AuditEntrySnapshotFieldsFragmentDoc}`;

/**
 * __useRequireAcknowledgeWithSnapshotsEntriesQuery__
 *
 * To run a query within a React component, call `useRequireAcknowledgeWithSnapshotsEntriesQuery` and pass it any options that fit your needs.
 * When your component renders, `useRequireAcknowledgeWithSnapshotsEntriesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRequireAcknowledgeWithSnapshotsEntriesQuery({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useRequireAcknowledgeWithSnapshotsEntriesQuery(baseOptions: Apollo.QueryHookOptions<RequireAcknowledgeWithSnapshotsEntriesQuery, RequireAcknowledgeWithSnapshotsEntriesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<RequireAcknowledgeWithSnapshotsEntriesQuery, RequireAcknowledgeWithSnapshotsEntriesQueryVariables>(RequireAcknowledgeWithSnapshotsEntriesDocument, options);
      }
export function useRequireAcknowledgeWithSnapshotsEntriesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<RequireAcknowledgeWithSnapshotsEntriesQuery, RequireAcknowledgeWithSnapshotsEntriesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<RequireAcknowledgeWithSnapshotsEntriesQuery, RequireAcknowledgeWithSnapshotsEntriesQueryVariables>(RequireAcknowledgeWithSnapshotsEntriesDocument, options);
        }
export type RequireAcknowledgeWithSnapshotsEntriesQueryHookResult = ReturnType<typeof useRequireAcknowledgeWithSnapshotsEntriesQuery>;
export type RequireAcknowledgeWithSnapshotsEntriesLazyQueryHookResult = ReturnType<typeof useRequireAcknowledgeWithSnapshotsEntriesLazyQuery>;
export type RequireAcknowledgeWithSnapshotsEntriesQueryResult = Apollo.QueryResult<RequireAcknowledgeWithSnapshotsEntriesQuery, RequireAcknowledgeWithSnapshotsEntriesQueryVariables>;
export const RequireAcknowledgeEntriesDocument = gql`
    query requireAcknowledgeEntries($filter: AuditEntryFilter!) {
  requireAcknowledgeEntries(filter: $filter) {
    ...auditEntryFields
  }
}
    ${AuditEntryFieldsFragmentDoc}`;

/**
 * __useRequireAcknowledgeEntriesQuery__
 *
 * To run a query within a React component, call `useRequireAcknowledgeEntriesQuery` and pass it any options that fit your needs.
 * When your component renders, `useRequireAcknowledgeEntriesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRequireAcknowledgeEntriesQuery({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useRequireAcknowledgeEntriesQuery(baseOptions: Apollo.QueryHookOptions<RequireAcknowledgeEntriesQuery, RequireAcknowledgeEntriesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<RequireAcknowledgeEntriesQuery, RequireAcknowledgeEntriesQueryVariables>(RequireAcknowledgeEntriesDocument, options);
      }
export function useRequireAcknowledgeEntriesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<RequireAcknowledgeEntriesQuery, RequireAcknowledgeEntriesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<RequireAcknowledgeEntriesQuery, RequireAcknowledgeEntriesQueryVariables>(RequireAcknowledgeEntriesDocument, options);
        }
export type RequireAcknowledgeEntriesQueryHookResult = ReturnType<typeof useRequireAcknowledgeEntriesQuery>;
export type RequireAcknowledgeEntriesLazyQueryHookResult = ReturnType<typeof useRequireAcknowledgeEntriesLazyQuery>;
export type RequireAcknowledgeEntriesQueryResult = Apollo.QueryResult<RequireAcknowledgeEntriesQuery, RequireAcknowledgeEntriesQueryVariables>;
export const AuditEntriesWithSnapshotsDocument = gql`
    query auditEntriesWithSnapshots($filter: AuditEntryFilter!) {
  auditEntries(filter: $filter) {
    ...auditEntryFields
    ...auditEntrySnapshotFields
  }
}
    ${AuditEntryFieldsFragmentDoc}
${AuditEntrySnapshotFieldsFragmentDoc}`;

/**
 * __useAuditEntriesWithSnapshotsQuery__
 *
 * To run a query within a React component, call `useAuditEntriesWithSnapshotsQuery` and pass it any options that fit your needs.
 * When your component renders, `useAuditEntriesWithSnapshotsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAuditEntriesWithSnapshotsQuery({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useAuditEntriesWithSnapshotsQuery(baseOptions: Apollo.QueryHookOptions<AuditEntriesWithSnapshotsQuery, AuditEntriesWithSnapshotsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AuditEntriesWithSnapshotsQuery, AuditEntriesWithSnapshotsQueryVariables>(AuditEntriesWithSnapshotsDocument, options);
      }
export function useAuditEntriesWithSnapshotsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AuditEntriesWithSnapshotsQuery, AuditEntriesWithSnapshotsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AuditEntriesWithSnapshotsQuery, AuditEntriesWithSnapshotsQueryVariables>(AuditEntriesWithSnapshotsDocument, options);
        }
export type AuditEntriesWithSnapshotsQueryHookResult = ReturnType<typeof useAuditEntriesWithSnapshotsQuery>;
export type AuditEntriesWithSnapshotsLazyQueryHookResult = ReturnType<typeof useAuditEntriesWithSnapshotsLazyQuery>;
export type AuditEntriesWithSnapshotsQueryResult = Apollo.QueryResult<AuditEntriesWithSnapshotsQuery, AuditEntriesWithSnapshotsQueryVariables>;
export const AuditEntriesTimeDocument = gql`
    query auditEntriesTime($filter: AuditEntryFilter!) {
  auditEntries(filter: $filter) {
    context
    triggeredAt
    witnesses {
      id
    }
  }
}
    `;

/**
 * __useAuditEntriesTimeQuery__
 *
 * To run a query within a React component, call `useAuditEntriesTimeQuery` and pass it any options that fit your needs.
 * When your component renders, `useAuditEntriesTimeQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAuditEntriesTimeQuery({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useAuditEntriesTimeQuery(baseOptions: Apollo.QueryHookOptions<AuditEntriesTimeQuery, AuditEntriesTimeQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AuditEntriesTimeQuery, AuditEntriesTimeQueryVariables>(AuditEntriesTimeDocument, options);
      }
export function useAuditEntriesTimeLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AuditEntriesTimeQuery, AuditEntriesTimeQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AuditEntriesTimeQuery, AuditEntriesTimeQueryVariables>(AuditEntriesTimeDocument, options);
        }
export type AuditEntriesTimeQueryHookResult = ReturnType<typeof useAuditEntriesTimeQuery>;
export type AuditEntriesTimeLazyQueryHookResult = ReturnType<typeof useAuditEntriesTimeLazyQuery>;
export type AuditEntriesTimeQueryResult = Apollo.QueryResult<AuditEntriesTimeQuery, AuditEntriesTimeQueryVariables>;
export const AuditEntriesSubscriptionDocument = gql`
    subscription auditEntriesSubscription($filter: AuditEntryFilter!) {
  auditEntries(filter: $filter) {
    ... on AuditEntry {
      ...auditEntryFields
      ...auditEntrySnapshotFields
    }
    ... on ErrorInfo {
      error
      createdAt
    }
  }
}
    ${AuditEntryFieldsFragmentDoc}
${AuditEntrySnapshotFieldsFragmentDoc}`;

/**
 * __useAuditEntriesSubscriptionSubscription__
 *
 * To run a query within a React component, call `useAuditEntriesSubscriptionSubscription` and pass it any options that fit your needs.
 * When your component renders, `useAuditEntriesSubscriptionSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAuditEntriesSubscriptionSubscription({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useAuditEntriesSubscriptionSubscription(baseOptions: Apollo.SubscriptionHookOptions<AuditEntriesSubscriptionSubscription, AuditEntriesSubscriptionSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<AuditEntriesSubscriptionSubscription, AuditEntriesSubscriptionSubscriptionVariables>(AuditEntriesSubscriptionDocument, options);
      }
export type AuditEntriesSubscriptionSubscriptionHookResult = ReturnType<typeof useAuditEntriesSubscriptionSubscription>;
export type AuditEntriesSubscriptionSubscriptionResult = Apollo.SubscriptionResult<AuditEntriesSubscriptionSubscription>;
export const AcknowledgeEventDocument = gql`
    mutation acknowledgeEvent($entry: AcknowledgeAuditEntryInput!) {
  acknowledgeAuditEntry(entry: $entry)
}
    `;
export type AcknowledgeEventMutationFn = Apollo.MutationFunction<AcknowledgeEventMutation, AcknowledgeEventMutationVariables>;

/**
 * __useAcknowledgeEventMutation__
 *
 * To run a mutation, you first call `useAcknowledgeEventMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAcknowledgeEventMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [acknowledgeEventMutation, { data, loading, error }] = useAcknowledgeEventMutation({
 *   variables: {
 *      entry: // value for 'entry'
 *   },
 * });
 */
export function useAcknowledgeEventMutation(baseOptions?: Apollo.MutationHookOptions<AcknowledgeEventMutation, AcknowledgeEventMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AcknowledgeEventMutation, AcknowledgeEventMutationVariables>(AcknowledgeEventDocument, options);
      }
export type AcknowledgeEventMutationHookResult = ReturnType<typeof useAcknowledgeEventMutation>;
export type AcknowledgeEventMutationResult = Apollo.MutationResult<AcknowledgeEventMutation>;
export type AcknowledgeEventMutationOptions = Apollo.BaseMutationOptions<AcknowledgeEventMutation, AcknowledgeEventMutationVariables>;
export const EventsAcknowledgementDocument = gql`
    mutation eventsAcknowledgement($entries: [AcknowledgeAuditEntryInput!]!) {
  auditEntriesAcknowledgment(entries: $entries)
}
    `;
export type EventsAcknowledgementMutationFn = Apollo.MutationFunction<EventsAcknowledgementMutation, EventsAcknowledgementMutationVariables>;

/**
 * __useEventsAcknowledgementMutation__
 *
 * To run a mutation, you first call `useEventsAcknowledgementMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEventsAcknowledgementMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [eventsAcknowledgementMutation, { data, loading, error }] = useEventsAcknowledgementMutation({
 *   variables: {
 *      entries: // value for 'entries'
 *   },
 * });
 */
export function useEventsAcknowledgementMutation(baseOptions?: Apollo.MutationHookOptions<EventsAcknowledgementMutation, EventsAcknowledgementMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<EventsAcknowledgementMutation, EventsAcknowledgementMutationVariables>(EventsAcknowledgementDocument, options);
      }
export type EventsAcknowledgementMutationHookResult = ReturnType<typeof useEventsAcknowledgementMutation>;
export type EventsAcknowledgementMutationResult = Apollo.MutationResult<EventsAcknowledgementMutation>;
export type EventsAcknowledgementMutationOptions = Apollo.BaseMutationOptions<EventsAcknowledgementMutation, EventsAcknowledgementMutationVariables>;
export const CurrentRealmDocument = gql`
    query currentRealm {
  currentRealm {
    id
    sharedViews
  }
}
    `;

/**
 * __useCurrentRealmQuery__
 *
 * To run a query within a React component, call `useCurrentRealmQuery` and pass it any options that fit your needs.
 * When your component renders, `useCurrentRealmQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useCurrentRealmQuery({
 *   variables: {
 *   },
 * });
 */
export function useCurrentRealmQuery(baseOptions?: Apollo.QueryHookOptions<CurrentRealmQuery, CurrentRealmQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<CurrentRealmQuery, CurrentRealmQueryVariables>(CurrentRealmDocument, options);
      }
export function useCurrentRealmLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<CurrentRealmQuery, CurrentRealmQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<CurrentRealmQuery, CurrentRealmQueryVariables>(CurrentRealmDocument, options);
        }
export type CurrentRealmQueryHookResult = ReturnType<typeof useCurrentRealmQuery>;
export type CurrentRealmLazyQueryHookResult = ReturnType<typeof useCurrentRealmLazyQuery>;
export type CurrentRealmQueryResult = Apollo.QueryResult<CurrentRealmQuery, CurrentRealmQueryVariables>;
export const UpdateCurrentRealmDocument = gql`
    mutation updateCurrentRealm($realm: CurrentRealmInput!) {
  updateCurrentRealm(realm: $realm)
}
    `;
export type UpdateCurrentRealmMutationFn = Apollo.MutationFunction<UpdateCurrentRealmMutation, UpdateCurrentRealmMutationVariables>;

/**
 * __useUpdateCurrentRealmMutation__
 *
 * To run a mutation, you first call `useUpdateCurrentRealmMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateCurrentRealmMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateCurrentRealmMutation, { data, loading, error }] = useUpdateCurrentRealmMutation({
 *   variables: {
 *      realm: // value for 'realm'
 *   },
 * });
 */
export function useUpdateCurrentRealmMutation(baseOptions?: Apollo.MutationHookOptions<UpdateCurrentRealmMutation, UpdateCurrentRealmMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateCurrentRealmMutation, UpdateCurrentRealmMutationVariables>(UpdateCurrentRealmDocument, options);
      }
export type UpdateCurrentRealmMutationHookResult = ReturnType<typeof useUpdateCurrentRealmMutation>;
export type UpdateCurrentRealmMutationResult = Apollo.MutationResult<UpdateCurrentRealmMutation>;
export type UpdateCurrentRealmMutationOptions = Apollo.BaseMutationOptions<UpdateCurrentRealmMutation, UpdateCurrentRealmMutationVariables>;
export const SharedViewsUpdateDocument = gql`
    subscription sharedViewsUpdate {
  sharedViewsUpdate {
    sharedViews
  }
}
    `;

/**
 * __useSharedViewsUpdateSubscription__
 *
 * To run a query within a React component, call `useSharedViewsUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useSharedViewsUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSharedViewsUpdateSubscription({
 *   variables: {
 *   },
 * });
 */
export function useSharedViewsUpdateSubscription(baseOptions?: Apollo.SubscriptionHookOptions<SharedViewsUpdateSubscription, SharedViewsUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<SharedViewsUpdateSubscription, SharedViewsUpdateSubscriptionVariables>(SharedViewsUpdateDocument, options);
      }
export type SharedViewsUpdateSubscriptionHookResult = ReturnType<typeof useSharedViewsUpdateSubscription>;
export type SharedViewsUpdateSubscriptionResult = Apollo.SubscriptionResult<SharedViewsUpdateSubscription>;
export const SessionCloseDocument = gql`
    subscription sessionClose {
  sessionClose {
    sessionId
    reason
  }
}
    `;

/**
 * __useSessionCloseSubscription__
 *
 * To run a query within a React component, call `useSessionCloseSubscription` and pass it any options that fit your needs.
 * When your component renders, `useSessionCloseSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSessionCloseSubscription({
 *   variables: {
 *   },
 * });
 */
export function useSessionCloseSubscription(baseOptions?: Apollo.SubscriptionHookOptions<SessionCloseSubscription, SessionCloseSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<SessionCloseSubscription, SessionCloseSubscriptionVariables>(SessionCloseDocument, options);
      }
export type SessionCloseSubscriptionHookResult = ReturnType<typeof useSessionCloseSubscription>;
export type SessionCloseSubscriptionResult = Apollo.SubscriptionResult<SessionCloseSubscription>;
export const GetDeviceSharedStreamDocument = gql`
    query getDeviceSharedStream($id: ID!) {
  device(id: $id) {
    aspects {
      ... on DFA_Media {
        sharedStream {
          id
          url
          status
          error
        }
      }
    }
  }
}
    `;

/**
 * __useGetDeviceSharedStreamQuery__
 *
 * To run a query within a React component, call `useGetDeviceSharedStreamQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetDeviceSharedStreamQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetDeviceSharedStreamQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetDeviceSharedStreamQuery(baseOptions: Apollo.QueryHookOptions<GetDeviceSharedStreamQuery, GetDeviceSharedStreamQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetDeviceSharedStreamQuery, GetDeviceSharedStreamQueryVariables>(GetDeviceSharedStreamDocument, options);
      }
export function useGetDeviceSharedStreamLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetDeviceSharedStreamQuery, GetDeviceSharedStreamQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetDeviceSharedStreamQuery, GetDeviceSharedStreamQueryVariables>(GetDeviceSharedStreamDocument, options);
        }
export type GetDeviceSharedStreamQueryHookResult = ReturnType<typeof useGetDeviceSharedStreamQuery>;
export type GetDeviceSharedStreamLazyQueryHookResult = ReturnType<typeof useGetDeviceSharedStreamLazyQuery>;
export type GetDeviceSharedStreamQueryResult = Apollo.QueryResult<GetDeviceSharedStreamQuery, GetDeviceSharedStreamQueryVariables>;
export const GetLocalStorageConfigDocument = gql`
    query getLocalStorageConfig($deviceId: ID!) {
  localStorage(deviceId: $deviceId) {
    ...localStorageFields
  }
}
    ${LocalStorageFieldsFragmentDoc}`;

/**
 * __useGetLocalStorageConfigQuery__
 *
 * To run a query within a React component, call `useGetLocalStorageConfigQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetLocalStorageConfigQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetLocalStorageConfigQuery({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *   },
 * });
 */
export function useGetLocalStorageConfigQuery(baseOptions: Apollo.QueryHookOptions<GetLocalStorageConfigQuery, GetLocalStorageConfigQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetLocalStorageConfigQuery, GetLocalStorageConfigQueryVariables>(GetLocalStorageConfigDocument, options);
      }
export function useGetLocalStorageConfigLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetLocalStorageConfigQuery, GetLocalStorageConfigQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetLocalStorageConfigQuery, GetLocalStorageConfigQueryVariables>(GetLocalStorageConfigDocument, options);
        }
export type GetLocalStorageConfigQueryHookResult = ReturnType<typeof useGetLocalStorageConfigQuery>;
export type GetLocalStorageConfigLazyQueryHookResult = ReturnType<typeof useGetLocalStorageConfigLazyQuery>;
export type GetLocalStorageConfigQueryResult = Apollo.QueryResult<GetLocalStorageConfigQuery, GetLocalStorageConfigQueryVariables>;
export const DeviceListByAspectTypesDocument = gql`
    query deviceListByAspectTypes($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    ...deviceListFields
  }
}
    ${DeviceListFieldsFragmentDoc}`;

/**
 * __useDeviceListByAspectTypesQuery__
 *
 * To run a query within a React component, call `useDeviceListByAspectTypesQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceListByAspectTypesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceListByAspectTypesQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useDeviceListByAspectTypesQuery(baseOptions: Apollo.QueryHookOptions<DeviceListByAspectTypesQuery, DeviceListByAspectTypesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceListByAspectTypesQuery, DeviceListByAspectTypesQueryVariables>(DeviceListByAspectTypesDocument, options);
      }
export function useDeviceListByAspectTypesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceListByAspectTypesQuery, DeviceListByAspectTypesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceListByAspectTypesQuery, DeviceListByAspectTypesQueryVariables>(DeviceListByAspectTypesDocument, options);
        }
export type DeviceListByAspectTypesQueryHookResult = ReturnType<typeof useDeviceListByAspectTypesQuery>;
export type DeviceListByAspectTypesLazyQueryHookResult = ReturnType<typeof useDeviceListByAspectTypesLazyQuery>;
export type DeviceListByAspectTypesQueryResult = Apollo.QueryResult<DeviceListByAspectTypesQuery, DeviceListByAspectTypesQueryVariables>;
export const DevicesByAspectTypesDocument = gql`
    query devicesByAspectTypes($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    ...deviceFields
  }
}
    ${DeviceFieldsFragmentDoc}`;

/**
 * __useDevicesByAspectTypesQuery__
 *
 * To run a query within a React component, call `useDevicesByAspectTypesQuery` and pass it any options that fit your needs.
 * When your component renders, `useDevicesByAspectTypesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDevicesByAspectTypesQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useDevicesByAspectTypesQuery(baseOptions: Apollo.QueryHookOptions<DevicesByAspectTypesQuery, DevicesByAspectTypesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DevicesByAspectTypesQuery, DevicesByAspectTypesQueryVariables>(DevicesByAspectTypesDocument, options);
      }
export function useDevicesByAspectTypesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DevicesByAspectTypesQuery, DevicesByAspectTypesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DevicesByAspectTypesQuery, DevicesByAspectTypesQueryVariables>(DevicesByAspectTypesDocument, options);
        }
export type DevicesByAspectTypesQueryHookResult = ReturnType<typeof useDevicesByAspectTypesQuery>;
export type DevicesByAspectTypesLazyQueryHookResult = ReturnType<typeof useDevicesByAspectTypesLazyQuery>;
export type DevicesByAspectTypesQueryResult = Apollo.QueryResult<DevicesByAspectTypesQuery, DevicesByAspectTypesQueryVariables>;
export const DevicesByAspectTypesReportDocument = gql`
    query devicesByAspectTypesReport($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    ...deviceReportFields
  }
}
    ${DeviceReportFieldsFragmentDoc}`;

/**
 * __useDevicesByAspectTypesReportQuery__
 *
 * To run a query within a React component, call `useDevicesByAspectTypesReportQuery` and pass it any options that fit your needs.
 * When your component renders, `useDevicesByAspectTypesReportQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDevicesByAspectTypesReportQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useDevicesByAspectTypesReportQuery(baseOptions: Apollo.QueryHookOptions<DevicesByAspectTypesReportQuery, DevicesByAspectTypesReportQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DevicesByAspectTypesReportQuery, DevicesByAspectTypesReportQueryVariables>(DevicesByAspectTypesReportDocument, options);
      }
export function useDevicesByAspectTypesReportLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DevicesByAspectTypesReportQuery, DevicesByAspectTypesReportQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DevicesByAspectTypesReportQuery, DevicesByAspectTypesReportQueryVariables>(DevicesByAspectTypesReportDocument, options);
        }
export type DevicesByAspectTypesReportQueryHookResult = ReturnType<typeof useDevicesByAspectTypesReportQuery>;
export type DevicesByAspectTypesReportLazyQueryHookResult = ReturnType<typeof useDevicesByAspectTypesReportLazyQuery>;
export type DevicesByAspectTypesReportQueryResult = Apollo.QueryResult<DevicesByAspectTypesReportQuery, DevicesByAspectTypesReportQueryVariables>;
export const SensorListByAspectTypeDocument = gql`
    query sensorListByAspectType($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    ...sensorListFields
  }
}
    ${SensorListFieldsFragmentDoc}`;

/**
 * __useSensorListByAspectTypeQuery__
 *
 * To run a query within a React component, call `useSensorListByAspectTypeQuery` and pass it any options that fit your needs.
 * When your component renders, `useSensorListByAspectTypeQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSensorListByAspectTypeQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useSensorListByAspectTypeQuery(baseOptions: Apollo.QueryHookOptions<SensorListByAspectTypeQuery, SensorListByAspectTypeQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<SensorListByAspectTypeQuery, SensorListByAspectTypeQueryVariables>(SensorListByAspectTypeDocument, options);
      }
export function useSensorListByAspectTypeLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<SensorListByAspectTypeQuery, SensorListByAspectTypeQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<SensorListByAspectTypeQuery, SensorListByAspectTypeQueryVariables>(SensorListByAspectTypeDocument, options);
        }
export type SensorListByAspectTypeQueryHookResult = ReturnType<typeof useSensorListByAspectTypeQuery>;
export type SensorListByAspectTypeLazyQueryHookResult = ReturnType<typeof useSensorListByAspectTypeLazyQuery>;
export type SensorListByAspectTypeQueryResult = Apollo.QueryResult<SensorListByAspectTypeQuery, SensorListByAspectTypeQueryVariables>;
export const GatewayListByAspectTypeDocument = gql`
    query gatewayListByAspectType($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    ...gatewayListFields
  }
}
    ${GatewayListFieldsFragmentDoc}`;

/**
 * __useGatewayListByAspectTypeQuery__
 *
 * To run a query within a React component, call `useGatewayListByAspectTypeQuery` and pass it any options that fit your needs.
 * When your component renders, `useGatewayListByAspectTypeQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGatewayListByAspectTypeQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useGatewayListByAspectTypeQuery(baseOptions: Apollo.QueryHookOptions<GatewayListByAspectTypeQuery, GatewayListByAspectTypeQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GatewayListByAspectTypeQuery, GatewayListByAspectTypeQueryVariables>(GatewayListByAspectTypeDocument, options);
      }
export function useGatewayListByAspectTypeLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GatewayListByAspectTypeQuery, GatewayListByAspectTypeQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GatewayListByAspectTypeQuery, GatewayListByAspectTypeQueryVariables>(GatewayListByAspectTypeDocument, options);
        }
export type GatewayListByAspectTypeQueryHookResult = ReturnType<typeof useGatewayListByAspectTypeQuery>;
export type GatewayListByAspectTypeLazyQueryHookResult = ReturnType<typeof useGatewayListByAspectTypeLazyQuery>;
export type GatewayListByAspectTypeQueryResult = Apollo.QueryResult<GatewayListByAspectTypeQuery, GatewayListByAspectTypeQueryVariables>;
export const DeviceWithPlatformByAspectTypeDocument = gql`
    query deviceWithPlatformByAspectType($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    id
    name
    platform {
      id
    }
  }
}
    `;

/**
 * __useDeviceWithPlatformByAspectTypeQuery__
 *
 * To run a query within a React component, call `useDeviceWithPlatformByAspectTypeQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceWithPlatformByAspectTypeQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceWithPlatformByAspectTypeQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useDeviceWithPlatformByAspectTypeQuery(baseOptions: Apollo.QueryHookOptions<DeviceWithPlatformByAspectTypeQuery, DeviceWithPlatformByAspectTypeQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceWithPlatformByAspectTypeQuery, DeviceWithPlatformByAspectTypeQueryVariables>(DeviceWithPlatformByAspectTypeDocument, options);
      }
export function useDeviceWithPlatformByAspectTypeLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceWithPlatformByAspectTypeQuery, DeviceWithPlatformByAspectTypeQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceWithPlatformByAspectTypeQuery, DeviceWithPlatformByAspectTypeQueryVariables>(DeviceWithPlatformByAspectTypeDocument, options);
        }
export type DeviceWithPlatformByAspectTypeQueryHookResult = ReturnType<typeof useDeviceWithPlatformByAspectTypeQuery>;
export type DeviceWithPlatformByAspectTypeLazyQueryHookResult = ReturnType<typeof useDeviceWithPlatformByAspectTypeLazyQuery>;
export type DeviceWithPlatformByAspectTypeQueryResult = Apollo.QueryResult<DeviceWithPlatformByAspectTypeQuery, DeviceWithPlatformByAspectTypeQueryVariables>;
export const DeviceWitnessesByAspectTypeDocument = gql`
    query deviceWitnessesByAspectType($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    id
    name
    enabled
    healthStatus
    deviceType
    platform {
      id
    }
  }
}
    `;

/**
 * __useDeviceWitnessesByAspectTypeQuery__
 *
 * To run a query within a React component, call `useDeviceWitnessesByAspectTypeQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceWitnessesByAspectTypeQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceWitnessesByAspectTypeQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useDeviceWitnessesByAspectTypeQuery(baseOptions: Apollo.QueryHookOptions<DeviceWitnessesByAspectTypeQuery, DeviceWitnessesByAspectTypeQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceWitnessesByAspectTypeQuery, DeviceWitnessesByAspectTypeQueryVariables>(DeviceWitnessesByAspectTypeDocument, options);
      }
export function useDeviceWitnessesByAspectTypeLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceWitnessesByAspectTypeQuery, DeviceWitnessesByAspectTypeQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceWitnessesByAspectTypeQuery, DeviceWitnessesByAspectTypeQueryVariables>(DeviceWitnessesByAspectTypeDocument, options);
        }
export type DeviceWitnessesByAspectTypeQueryHookResult = ReturnType<typeof useDeviceWitnessesByAspectTypeQuery>;
export type DeviceWitnessesByAspectTypeLazyQueryHookResult = ReturnType<typeof useDeviceWitnessesByAspectTypeLazyQuery>;
export type DeviceWitnessesByAspectTypeQueryResult = Apollo.QueryResult<DeviceWitnessesByAspectTypeQuery, DeviceWitnessesByAspectTypeQueryVariables>;
export const DevicesByAspectTypesShortDocument = gql`
    query devicesByAspectTypesShort($types: [DeviceFunctionalAspectFilter!]!) {
  devicesByAspectTypes(types: $types) {
    ...deviceShortFields
  }
}
    ${DeviceShortFieldsFragmentDoc}`;

/**
 * __useDevicesByAspectTypesShortQuery__
 *
 * To run a query within a React component, call `useDevicesByAspectTypesShortQuery` and pass it any options that fit your needs.
 * When your component renders, `useDevicesByAspectTypesShortQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDevicesByAspectTypesShortQuery({
 *   variables: {
 *      types: // value for 'types'
 *   },
 * });
 */
export function useDevicesByAspectTypesShortQuery(baseOptions: Apollo.QueryHookOptions<DevicesByAspectTypesShortQuery, DevicesByAspectTypesShortQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DevicesByAspectTypesShortQuery, DevicesByAspectTypesShortQueryVariables>(DevicesByAspectTypesShortDocument, options);
      }
export function useDevicesByAspectTypesShortLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DevicesByAspectTypesShortQuery, DevicesByAspectTypesShortQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DevicesByAspectTypesShortQuery, DevicesByAspectTypesShortQueryVariables>(DevicesByAspectTypesShortDocument, options);
        }
export type DevicesByAspectTypesShortQueryHookResult = ReturnType<typeof useDevicesByAspectTypesShortQuery>;
export type DevicesByAspectTypesShortLazyQueryHookResult = ReturnType<typeof useDevicesByAspectTypesShortLazyQuery>;
export type DevicesByAspectTypesShortQueryResult = Apollo.QueryResult<DevicesByAspectTypesShortQuery, DevicesByAspectTypesShortQueryVariables>;
export const DeviceDocument = gql`
    query device($id: ID!) {
  device(id: $id) {
    ...deviceFields
  }
}
    ${DeviceFieldsFragmentDoc}`;

/**
 * __useDeviceQuery__
 *
 * To run a query within a React component, call `useDeviceQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeviceQuery(baseOptions: Apollo.QueryHookOptions<DeviceQuery, DeviceQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceQuery, DeviceQueryVariables>(DeviceDocument, options);
      }
export function useDeviceLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceQuery, DeviceQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceQuery, DeviceQueryVariables>(DeviceDocument, options);
        }
export type DeviceQueryHookResult = ReturnType<typeof useDeviceQuery>;
export type DeviceLazyQueryHookResult = ReturnType<typeof useDeviceLazyQuery>;
export type DeviceQueryResult = Apollo.QueryResult<DeviceQuery, DeviceQueryVariables>;
export const DeviceForPlayerDocument = gql`
    query deviceForPlayer($id: ID!) {
  device(id: $id) {
    ...devicePlayerFields
  }
}
    ${DevicePlayerFieldsFragmentDoc}`;

/**
 * __useDeviceForPlayerQuery__
 *
 * To run a query within a React component, call `useDeviceForPlayerQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceForPlayerQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceForPlayerQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeviceForPlayerQuery(baseOptions: Apollo.QueryHookOptions<DeviceForPlayerQuery, DeviceForPlayerQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceForPlayerQuery, DeviceForPlayerQueryVariables>(DeviceForPlayerDocument, options);
      }
export function useDeviceForPlayerLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceForPlayerQuery, DeviceForPlayerQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceForPlayerQuery, DeviceForPlayerQueryVariables>(DeviceForPlayerDocument, options);
        }
export type DeviceForPlayerQueryHookResult = ReturnType<typeof useDeviceForPlayerQuery>;
export type DeviceForPlayerLazyQueryHookResult = ReturnType<typeof useDeviceForPlayerLazyQuery>;
export type DeviceForPlayerQueryResult = Apollo.QueryResult<DeviceForPlayerQuery, DeviceForPlayerQueryVariables>;
export const DevicesByIdsDocument = gql`
    query devicesByIds($ids: [ID!]!) {
  devicesByIds(ids: $ids) {
    ...deviceFields
  }
}
    ${DeviceFieldsFragmentDoc}`;

/**
 * __useDevicesByIdsQuery__
 *
 * To run a query within a React component, call `useDevicesByIdsQuery` and pass it any options that fit your needs.
 * When your component renders, `useDevicesByIdsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDevicesByIdsQuery({
 *   variables: {
 *      ids: // value for 'ids'
 *   },
 * });
 */
export function useDevicesByIdsQuery(baseOptions: Apollo.QueryHookOptions<DevicesByIdsQuery, DevicesByIdsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DevicesByIdsQuery, DevicesByIdsQueryVariables>(DevicesByIdsDocument, options);
      }
export function useDevicesByIdsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DevicesByIdsQuery, DevicesByIdsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DevicesByIdsQuery, DevicesByIdsQueryVariables>(DevicesByIdsDocument, options);
        }
export type DevicesByIdsQueryHookResult = ReturnType<typeof useDevicesByIdsQuery>;
export type DevicesByIdsLazyQueryHookResult = ReturnType<typeof useDevicesByIdsLazyQuery>;
export type DevicesByIdsQueryResult = Apollo.QueryResult<DevicesByIdsQuery, DevicesByIdsQueryVariables>;
export const DeviceNameDocument = gql`
    query deviceName($id: ID!) {
  device(id: $id) {
    id
    name
  }
}
    `;

/**
 * __useDeviceNameQuery__
 *
 * To run a query within a React component, call `useDeviceNameQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceNameQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceNameQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeviceNameQuery(baseOptions: Apollo.QueryHookOptions<DeviceNameQuery, DeviceNameQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceNameQuery, DeviceNameQueryVariables>(DeviceNameDocument, options);
      }
export function useDeviceNameLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceNameQuery, DeviceNameQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceNameQuery, DeviceNameQueryVariables>(DeviceNameDocument, options);
        }
export type DeviceNameQueryHookResult = ReturnType<typeof useDeviceNameQuery>;
export type DeviceNameLazyQueryHookResult = ReturnType<typeof useDeviceNameLazyQuery>;
export type DeviceNameQueryResult = Apollo.QueryResult<DeviceNameQuery, DeviceNameQueryVariables>;
export const ArchiveCoverageDocument = gql`
    query archiveCoverage($ids: [ID!]!, $startTime: DateTime!, $endTime: DateTime!) {
  archiveCoverage(ids: $ids, startTime: $startTime, endTime: $endTime) {
    coverage {
      deviceId
      streamNumber
      time
    }
    partialCoverage {
      deviceId
      streamNumber
      time
    }
    ttl {
      deviceId
      ttl
    }
  }
  aodGet(ids: $ids, startTime: $startTime, endTime: $endTime) {
    id
    deviceId
    startTime
    endTime
    streamNumber
    status
  }
}
    `;

/**
 * __useArchiveCoverageQuery__
 *
 * To run a query within a React component, call `useArchiveCoverageQuery` and pass it any options that fit your needs.
 * When your component renders, `useArchiveCoverageQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useArchiveCoverageQuery({
 *   variables: {
 *      ids: // value for 'ids'
 *      startTime: // value for 'startTime'
 *      endTime: // value for 'endTime'
 *   },
 * });
 */
export function useArchiveCoverageQuery(baseOptions: Apollo.QueryHookOptions<ArchiveCoverageQuery, ArchiveCoverageQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ArchiveCoverageQuery, ArchiveCoverageQueryVariables>(ArchiveCoverageDocument, options);
      }
export function useArchiveCoverageLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ArchiveCoverageQuery, ArchiveCoverageQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ArchiveCoverageQuery, ArchiveCoverageQueryVariables>(ArchiveCoverageDocument, options);
        }
export type ArchiveCoverageQueryHookResult = ReturnType<typeof useArchiveCoverageQuery>;
export type ArchiveCoverageLazyQueryHookResult = ReturnType<typeof useArchiveCoverageLazyQuery>;
export type ArchiveCoverageQueryResult = Apollo.QueryResult<ArchiveCoverageQuery, ArchiveCoverageQueryVariables>;
export const ArchiveBoundaryDocument = gql`
    query archiveBoundary($ids: [ID!]!, $streamNumbers: [Int!]!, $startTime: DateTime!, $find: BoundaryFind!) {
  archiveBoundary(
    ids: $ids
    streamNumbers: $streamNumbers
    startTime: $startTime
    find: $find
  ) {
    boundary
    timeInsideGap
  }
}
    `;

/**
 * __useArchiveBoundaryQuery__
 *
 * To run a query within a React component, call `useArchiveBoundaryQuery` and pass it any options that fit your needs.
 * When your component renders, `useArchiveBoundaryQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useArchiveBoundaryQuery({
 *   variables: {
 *      ids: // value for 'ids'
 *      streamNumbers: // value for 'streamNumbers'
 *      startTime: // value for 'startTime'
 *      find: // value for 'find'
 *   },
 * });
 */
export function useArchiveBoundaryQuery(baseOptions: Apollo.QueryHookOptions<ArchiveBoundaryQuery, ArchiveBoundaryQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ArchiveBoundaryQuery, ArchiveBoundaryQueryVariables>(ArchiveBoundaryDocument, options);
      }
export function useArchiveBoundaryLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ArchiveBoundaryQuery, ArchiveBoundaryQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ArchiveBoundaryQuery, ArchiveBoundaryQueryVariables>(ArchiveBoundaryDocument, options);
        }
export type ArchiveBoundaryQueryHookResult = ReturnType<typeof useArchiveBoundaryQuery>;
export type ArchiveBoundaryLazyQueryHookResult = ReturnType<typeof useArchiveBoundaryLazyQuery>;
export type ArchiveBoundaryQueryResult = Apollo.QueryResult<ArchiveBoundaryQuery, ArchiveBoundaryQueryVariables>;
export const ProbeDeviceDocument = gql`
    query probeDevice($input: DeviceProbeInput!) {
  probeDevice(input: $input) {
    ...deviceProbeFields
  }
}
    ${DeviceProbeFieldsFragmentDoc}`;

/**
 * __useProbeDeviceQuery__
 *
 * To run a query within a React component, call `useProbeDeviceQuery` and pass it any options that fit your needs.
 * When your component renders, `useProbeDeviceQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useProbeDeviceQuery({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useProbeDeviceQuery(baseOptions: Apollo.QueryHookOptions<ProbeDeviceQuery, ProbeDeviceQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ProbeDeviceQuery, ProbeDeviceQueryVariables>(ProbeDeviceDocument, options);
      }
export function useProbeDeviceLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ProbeDeviceQuery, ProbeDeviceQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ProbeDeviceQuery, ProbeDeviceQueryVariables>(ProbeDeviceDocument, options);
        }
export type ProbeDeviceQueryHookResult = ReturnType<typeof useProbeDeviceQuery>;
export type ProbeDeviceLazyQueryHookResult = ReturnType<typeof useProbeDeviceLazyQuery>;
export type ProbeDeviceQueryResult = Apollo.QueryResult<ProbeDeviceQuery, ProbeDeviceQueryVariables>;
export const DiscoverDevicesDocument = gql`
    query discoverDevices($platformId: ID!) {
  discoverDevices(platformId: $platformId) {
    ...deviceProbeFields
  }
}
    ${DeviceProbeFieldsFragmentDoc}`;

/**
 * __useDiscoverDevicesQuery__
 *
 * To run a query within a React component, call `useDiscoverDevicesQuery` and pass it any options that fit your needs.
 * When your component renders, `useDiscoverDevicesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDiscoverDevicesQuery({
 *   variables: {
 *      platformId: // value for 'platformId'
 *   },
 * });
 */
export function useDiscoverDevicesQuery(baseOptions: Apollo.QueryHookOptions<DiscoverDevicesQuery, DiscoverDevicesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DiscoverDevicesQuery, DiscoverDevicesQueryVariables>(DiscoverDevicesDocument, options);
      }
export function useDiscoverDevicesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DiscoverDevicesQuery, DiscoverDevicesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DiscoverDevicesQuery, DiscoverDevicesQueryVariables>(DiscoverDevicesDocument, options);
        }
export type DiscoverDevicesQueryHookResult = ReturnType<typeof useDiscoverDevicesQuery>;
export type DiscoverDevicesLazyQueryHookResult = ReturnType<typeof useDiscoverDevicesLazyQuery>;
export type DiscoverDevicesQueryResult = Apollo.QueryResult<DiscoverDevicesQuery, DiscoverDevicesQueryVariables>;
export const ProbeSensorDocument = gql`
    query probeSensor($input: DeviceProbeInput!) {
  probeSensorDevice(input: $input) {
    ...deviceProbeFields
  }
}
    ${DeviceProbeFieldsFragmentDoc}`;

/**
 * __useProbeSensorQuery__
 *
 * To run a query within a React component, call `useProbeSensorQuery` and pass it any options that fit your needs.
 * When your component renders, `useProbeSensorQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useProbeSensorQuery({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useProbeSensorQuery(baseOptions: Apollo.QueryHookOptions<ProbeSensorQuery, ProbeSensorQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ProbeSensorQuery, ProbeSensorQueryVariables>(ProbeSensorDocument, options);
      }
export function useProbeSensorLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ProbeSensorQuery, ProbeSensorQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ProbeSensorQuery, ProbeSensorQueryVariables>(ProbeSensorDocument, options);
        }
export type ProbeSensorQueryHookResult = ReturnType<typeof useProbeSensorQuery>;
export type ProbeSensorLazyQueryHookResult = ReturnType<typeof useProbeSensorLazyQuery>;
export type ProbeSensorQueryResult = Apollo.QueryResult<ProbeSensorQuery, ProbeSensorQueryVariables>;
export const StoragePoolsDocument = gql`
    query storagePools {
  storagePools {
    ...storagePoolFields
  }
}
    ${StoragePoolFieldsFragmentDoc}`;

/**
 * __useStoragePoolsQuery__
 *
 * To run a query within a React component, call `useStoragePoolsQuery` and pass it any options that fit your needs.
 * When your component renders, `useStoragePoolsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useStoragePoolsQuery({
 *   variables: {
 *   },
 * });
 */
export function useStoragePoolsQuery(baseOptions?: Apollo.QueryHookOptions<StoragePoolsQuery, StoragePoolsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<StoragePoolsQuery, StoragePoolsQueryVariables>(StoragePoolsDocument, options);
      }
export function useStoragePoolsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<StoragePoolsQuery, StoragePoolsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<StoragePoolsQuery, StoragePoolsQueryVariables>(StoragePoolsDocument, options);
        }
export type StoragePoolsQueryHookResult = ReturnType<typeof useStoragePoolsQuery>;
export type StoragePoolsLazyQueryHookResult = ReturnType<typeof useStoragePoolsLazyQuery>;
export type StoragePoolsQueryResult = Apollo.QueryResult<StoragePoolsQuery, StoragePoolsQueryVariables>;
export const AspectTemplatesDocument = gql`
    query aspectTemplates {
  aspectTemplates {
    ...aspectTemplateFields
  }
}
    ${AspectTemplateFieldsFragmentDoc}`;

/**
 * __useAspectTemplatesQuery__
 *
 * To run a query within a React component, call `useAspectTemplatesQuery` and pass it any options that fit your needs.
 * When your component renders, `useAspectTemplatesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAspectTemplatesQuery({
 *   variables: {
 *   },
 * });
 */
export function useAspectTemplatesQuery(baseOptions?: Apollo.QueryHookOptions<AspectTemplatesQuery, AspectTemplatesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AspectTemplatesQuery, AspectTemplatesQueryVariables>(AspectTemplatesDocument, options);
      }
export function useAspectTemplatesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AspectTemplatesQuery, AspectTemplatesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AspectTemplatesQuery, AspectTemplatesQueryVariables>(AspectTemplatesDocument, options);
        }
export type AspectTemplatesQueryHookResult = ReturnType<typeof useAspectTemplatesQuery>;
export type AspectTemplatesLazyQueryHookResult = ReturnType<typeof useAspectTemplatesLazyQuery>;
export type AspectTemplatesQueryResult = Apollo.QueryResult<AspectTemplatesQuery, AspectTemplatesQueryVariables>;
export const DeviceTemplatesDocument = gql`
    query deviceTemplates {
  deviceTemplates {
    make
    models {
      model
      url
    }
  }
}
    `;

/**
 * __useDeviceTemplatesQuery__
 *
 * To run a query within a React component, call `useDeviceTemplatesQuery` and pass it any options that fit your needs.
 * When your component renders, `useDeviceTemplatesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDeviceTemplatesQuery({
 *   variables: {
 *   },
 * });
 */
export function useDeviceTemplatesQuery(baseOptions?: Apollo.QueryHookOptions<DeviceTemplatesQuery, DeviceTemplatesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<DeviceTemplatesQuery, DeviceTemplatesQueryVariables>(DeviceTemplatesDocument, options);
      }
export function useDeviceTemplatesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<DeviceTemplatesQuery, DeviceTemplatesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<DeviceTemplatesQuery, DeviceTemplatesQueryVariables>(DeviceTemplatesDocument, options);
        }
export type DeviceTemplatesQueryHookResult = ReturnType<typeof useDeviceTemplatesQuery>;
export type DeviceTemplatesLazyQueryHookResult = ReturnType<typeof useDeviceTemplatesLazyQuery>;
export type DeviceTemplatesQueryResult = Apollo.QueryResult<DeviceTemplatesQuery, DeviceTemplatesQueryVariables>;
export const VaeTemplatesDocument = gql`
    query vaeTemplates($deviceId: ID!) {
  vaeTemplates(deviceId: $deviceId) {
    ...aspectTemplateFields
  }
}
    ${AspectTemplateFieldsFragmentDoc}`;

/**
 * __useVaeTemplatesQuery__
 *
 * To run a query within a React component, call `useVaeTemplatesQuery` and pass it any options that fit your needs.
 * When your component renders, `useVaeTemplatesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useVaeTemplatesQuery({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *   },
 * });
 */
export function useVaeTemplatesQuery(baseOptions: Apollo.QueryHookOptions<VaeTemplatesQuery, VaeTemplatesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<VaeTemplatesQuery, VaeTemplatesQueryVariables>(VaeTemplatesDocument, options);
      }
export function useVaeTemplatesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<VaeTemplatesQuery, VaeTemplatesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<VaeTemplatesQuery, VaeTemplatesQueryVariables>(VaeTemplatesDocument, options);
        }
export type VaeTemplatesQueryHookResult = ReturnType<typeof useVaeTemplatesQuery>;
export type VaeTemplatesLazyQueryHookResult = ReturnType<typeof useVaeTemplatesLazyQuery>;
export type VaeTemplatesQueryResult = Apollo.QueryResult<VaeTemplatesQuery, VaeTemplatesQueryVariables>;
export const CameraLogDocument = gql`
    query cameraLog($deviceId: ID!) {
  cameraLog(deviceId: $deviceId) {
    time
    severity
    message
  }
}
    `;

/**
 * __useCameraLogQuery__
 *
 * To run a query within a React component, call `useCameraLogQuery` and pass it any options that fit your needs.
 * When your component renders, `useCameraLogQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useCameraLogQuery({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *   },
 * });
 */
export function useCameraLogQuery(baseOptions: Apollo.QueryHookOptions<CameraLogQuery, CameraLogQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<CameraLogQuery, CameraLogQueryVariables>(CameraLogDocument, options);
      }
export function useCameraLogLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<CameraLogQuery, CameraLogQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<CameraLogQuery, CameraLogQueryVariables>(CameraLogDocument, options);
        }
export type CameraLogQueryHookResult = ReturnType<typeof useCameraLogQuery>;
export type CameraLogLazyQueryHookResult = ReturnType<typeof useCameraLogLazyQuery>;
export type CameraLogQueryResult = Apollo.QueryResult<CameraLogQuery, CameraLogQueryVariables>;
export const VaeConfigsDocument = gql`
    query vaeConfigs($deviceId: ID!, $engine: String!) {
  vaeConfigs(deviceId: $deviceId, engine: $engine) {
    name
  }
}
    `;

/**
 * __useVaeConfigsQuery__
 *
 * To run a query within a React component, call `useVaeConfigsQuery` and pass it any options that fit your needs.
 * When your component renders, `useVaeConfigsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useVaeConfigsQuery({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *      engine: // value for 'engine'
 *   },
 * });
 */
export function useVaeConfigsQuery(baseOptions: Apollo.QueryHookOptions<VaeConfigsQuery, VaeConfigsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<VaeConfigsQuery, VaeConfigsQueryVariables>(VaeConfigsDocument, options);
      }
export function useVaeConfigsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<VaeConfigsQuery, VaeConfigsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<VaeConfigsQuery, VaeConfigsQueryVariables>(VaeConfigsDocument, options);
        }
export type VaeConfigsQueryHookResult = ReturnType<typeof useVaeConfigsQuery>;
export type VaeConfigsLazyQueryHookResult = ReturnType<typeof useVaeConfigsLazyQuery>;
export type VaeConfigsQueryResult = Apollo.QueryResult<VaeConfigsQuery, VaeConfigsQueryVariables>;
export const ProbeGatewayDirectoriesDocument = gql`
    query probeGatewayDirectories($input: GatewayDirectoriesProbeInput!) {
  probeGatewayDirectories(input: $input) {
    deviceProbe {
      ...deviceProbeFields
    }
    directories {
      id
      name
    }
  }
}
    ${DeviceProbeFieldsFragmentDoc}`;

/**
 * __useProbeGatewayDirectoriesQuery__
 *
 * To run a query within a React component, call `useProbeGatewayDirectoriesQuery` and pass it any options that fit your needs.
 * When your component renders, `useProbeGatewayDirectoriesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useProbeGatewayDirectoriesQuery({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useProbeGatewayDirectoriesQuery(baseOptions: Apollo.QueryHookOptions<ProbeGatewayDirectoriesQuery, ProbeGatewayDirectoriesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ProbeGatewayDirectoriesQuery, ProbeGatewayDirectoriesQueryVariables>(ProbeGatewayDirectoriesDocument, options);
      }
export function useProbeGatewayDirectoriesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ProbeGatewayDirectoriesQuery, ProbeGatewayDirectoriesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ProbeGatewayDirectoriesQuery, ProbeGatewayDirectoriesQueryVariables>(ProbeGatewayDirectoriesDocument, options);
        }
export type ProbeGatewayDirectoriesQueryHookResult = ReturnType<typeof useProbeGatewayDirectoriesQuery>;
export type ProbeGatewayDirectoriesLazyQueryHookResult = ReturnType<typeof useProbeGatewayDirectoriesLazyQuery>;
export type ProbeGatewayDirectoriesQueryResult = Apollo.QueryResult<ProbeGatewayDirectoriesQuery, ProbeGatewayDirectoriesQueryVariables>;
export const ProbeGatewayDocument = gql`
    query probeGateway($input: GatewayProbeInput!) {
  probeGateway(input: $input) {
    devices {
      id
      name
    }
    events {
      id
      name
    }
  }
}
    `;

/**
 * __useProbeGatewayQuery__
 *
 * To run a query within a React component, call `useProbeGatewayQuery` and pass it any options that fit your needs.
 * When your component renders, `useProbeGatewayQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useProbeGatewayQuery({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useProbeGatewayQuery(baseOptions: Apollo.QueryHookOptions<ProbeGatewayQuery, ProbeGatewayQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ProbeGatewayQuery, ProbeGatewayQueryVariables>(ProbeGatewayDocument, options);
      }
export function useProbeGatewayLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ProbeGatewayQuery, ProbeGatewayQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ProbeGatewayQuery, ProbeGatewayQueryVariables>(ProbeGatewayDocument, options);
        }
export type ProbeGatewayQueryHookResult = ReturnType<typeof useProbeGatewayQuery>;
export type ProbeGatewayLazyQueryHookResult = ReturnType<typeof useProbeGatewayLazyQuery>;
export type ProbeGatewayQueryResult = Apollo.QueryResult<ProbeGatewayQuery, ProbeGatewayQueryVariables>;
export const CreateGatewayDocument = gql`
    mutation createGateway($device: DeviceInput!) {
  createGatewayDevice(device: $device) {
    id
    warning
  }
}
    `;
export type CreateGatewayMutationFn = Apollo.MutationFunction<CreateGatewayMutation, CreateGatewayMutationVariables>;

/**
 * __useCreateGatewayMutation__
 *
 * To run a mutation, you first call `useCreateGatewayMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateGatewayMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createGatewayMutation, { data, loading, error }] = useCreateGatewayMutation({
 *   variables: {
 *      device: // value for 'device'
 *   },
 * });
 */
export function useCreateGatewayMutation(baseOptions?: Apollo.MutationHookOptions<CreateGatewayMutation, CreateGatewayMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateGatewayMutation, CreateGatewayMutationVariables>(CreateGatewayDocument, options);
      }
export type CreateGatewayMutationHookResult = ReturnType<typeof useCreateGatewayMutation>;
export type CreateGatewayMutationResult = Apollo.MutationResult<CreateGatewayMutation>;
export type CreateGatewayMutationOptions = Apollo.BaseMutationOptions<CreateGatewayMutation, CreateGatewayMutationVariables>;
export const CreateSensorDocument = gql`
    mutation createSensor($device: DeviceInput!) {
  createSensorDevice(device: $device) {
    id
    warning
  }
}
    `;
export type CreateSensorMutationFn = Apollo.MutationFunction<CreateSensorMutation, CreateSensorMutationVariables>;

/**
 * __useCreateSensorMutation__
 *
 * To run a mutation, you first call `useCreateSensorMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateSensorMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createSensorMutation, { data, loading, error }] = useCreateSensorMutation({
 *   variables: {
 *      device: // value for 'device'
 *   },
 * });
 */
export function useCreateSensorMutation(baseOptions?: Apollo.MutationHookOptions<CreateSensorMutation, CreateSensorMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateSensorMutation, CreateSensorMutationVariables>(CreateSensorDocument, options);
      }
export type CreateSensorMutationHookResult = ReturnType<typeof useCreateSensorMutation>;
export type CreateSensorMutationResult = Apollo.MutationResult<CreateSensorMutation>;
export type CreateSensorMutationOptions = Apollo.BaseMutationOptions<CreateSensorMutation, CreateSensorMutationVariables>;
export const CreateDeviceDocument = gql`
    mutation createDevice($device: DeviceInput!) {
  createDevice(device: $device) {
    id
    warning
  }
}
    `;
export type CreateDeviceMutationFn = Apollo.MutationFunction<CreateDeviceMutation, CreateDeviceMutationVariables>;

/**
 * __useCreateDeviceMutation__
 *
 * To run a mutation, you first call `useCreateDeviceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateDeviceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createDeviceMutation, { data, loading, error }] = useCreateDeviceMutation({
 *   variables: {
 *      device: // value for 'device'
 *   },
 * });
 */
export function useCreateDeviceMutation(baseOptions?: Apollo.MutationHookOptions<CreateDeviceMutation, CreateDeviceMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateDeviceMutation, CreateDeviceMutationVariables>(CreateDeviceDocument, options);
      }
export type CreateDeviceMutationHookResult = ReturnType<typeof useCreateDeviceMutation>;
export type CreateDeviceMutationResult = Apollo.MutationResult<CreateDeviceMutation>;
export type CreateDeviceMutationOptions = Apollo.BaseMutationOptions<CreateDeviceMutation, CreateDeviceMutationVariables>;
export const UpdateDeviceDocument = gql`
    mutation updateDevice($id: ID!, $device: DeviceInput!) {
  updateDevice(id: $id, device: $device) {
    updated
    warning
    warningFields {
      field
      value
    }
  }
}
    `;
export type UpdateDeviceMutationFn = Apollo.MutationFunction<UpdateDeviceMutation, UpdateDeviceMutationVariables>;

/**
 * __useUpdateDeviceMutation__
 *
 * To run a mutation, you first call `useUpdateDeviceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateDeviceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateDeviceMutation, { data, loading, error }] = useUpdateDeviceMutation({
 *   variables: {
 *      id: // value for 'id'
 *      device: // value for 'device'
 *   },
 * });
 */
export function useUpdateDeviceMutation(baseOptions?: Apollo.MutationHookOptions<UpdateDeviceMutation, UpdateDeviceMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateDeviceMutation, UpdateDeviceMutationVariables>(UpdateDeviceDocument, options);
      }
export type UpdateDeviceMutationHookResult = ReturnType<typeof useUpdateDeviceMutation>;
export type UpdateDeviceMutationResult = Apollo.MutationResult<UpdateDeviceMutation>;
export type UpdateDeviceMutationOptions = Apollo.BaseMutationOptions<UpdateDeviceMutation, UpdateDeviceMutationVariables>;
export const UpdatePositionDocument = gql`
    mutation updatePosition($id: ID!, $position: LatLngInput!) {
  updatePosition(id: $id, position: $position)
}
    `;
export type UpdatePositionMutationFn = Apollo.MutationFunction<UpdatePositionMutation, UpdatePositionMutationVariables>;

/**
 * __useUpdatePositionMutation__
 *
 * To run a mutation, you first call `useUpdatePositionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdatePositionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updatePositionMutation, { data, loading, error }] = useUpdatePositionMutation({
 *   variables: {
 *      id: // value for 'id'
 *      position: // value for 'position'
 *   },
 * });
 */
export function useUpdatePositionMutation(baseOptions?: Apollo.MutationHookOptions<UpdatePositionMutation, UpdatePositionMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdatePositionMutation, UpdatePositionMutationVariables>(UpdatePositionDocument, options);
      }
export type UpdatePositionMutationHookResult = ReturnType<typeof useUpdatePositionMutation>;
export type UpdatePositionMutationResult = Apollo.MutationResult<UpdatePositionMutation>;
export type UpdatePositionMutationOptions = Apollo.BaseMutationOptions<UpdatePositionMutation, UpdatePositionMutationVariables>;
export const DeleteDeviceDocument = gql`
    mutation deleteDevice($id: ID!) {
  deleteDevice(id: $id)
}
    `;
export type DeleteDeviceMutationFn = Apollo.MutationFunction<DeleteDeviceMutation, DeleteDeviceMutationVariables>;

/**
 * __useDeleteDeviceMutation__
 *
 * To run a mutation, you first call `useDeleteDeviceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteDeviceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteDeviceMutation, { data, loading, error }] = useDeleteDeviceMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteDeviceMutation(baseOptions?: Apollo.MutationHookOptions<DeleteDeviceMutation, DeleteDeviceMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteDeviceMutation, DeleteDeviceMutationVariables>(DeleteDeviceDocument, options);
      }
export type DeleteDeviceMutationHookResult = ReturnType<typeof useDeleteDeviceMutation>;
export type DeleteDeviceMutationResult = Apollo.MutationResult<DeleteDeviceMutation>;
export type DeleteDeviceMutationOptions = Apollo.BaseMutationOptions<DeleteDeviceMutation, DeleteDeviceMutationVariables>;
export const DeviceCommandDocument = gql`
    mutation deviceCommand($id: ID!, $command: DeviceCommand!) {
  deviceCommand(id: $id, command: $command)
}
    `;
export type DeviceCommandMutationFn = Apollo.MutationFunction<DeviceCommandMutation, DeviceCommandMutationVariables>;

/**
 * __useDeviceCommandMutation__
 *
 * To run a mutation, you first call `useDeviceCommandMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeviceCommandMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deviceCommandMutation, { data, loading, error }] = useDeviceCommandMutation({
 *   variables: {
 *      id: // value for 'id'
 *      command: // value for 'command'
 *   },
 * });
 */
export function useDeviceCommandMutation(baseOptions?: Apollo.MutationHookOptions<DeviceCommandMutation, DeviceCommandMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeviceCommandMutation, DeviceCommandMutationVariables>(DeviceCommandDocument, options);
      }
export type DeviceCommandMutationHookResult = ReturnType<typeof useDeviceCommandMutation>;
export type DeviceCommandMutationResult = Apollo.MutationResult<DeviceCommandMutation>;
export type DeviceCommandMutationOptions = Apollo.BaseMutationOptions<DeviceCommandMutation, DeviceCommandMutationVariables>;
export const ChangeDeliveryPriorityDocument = gql`
    mutation changeDeliveryPriority($devices: [DeliveryPriorityInput!]!) {
  changeDeliveryPriority(devices: $devices)
}
    `;
export type ChangeDeliveryPriorityMutationFn = Apollo.MutationFunction<ChangeDeliveryPriorityMutation, ChangeDeliveryPriorityMutationVariables>;

/**
 * __useChangeDeliveryPriorityMutation__
 *
 * To run a mutation, you first call `useChangeDeliveryPriorityMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useChangeDeliveryPriorityMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [changeDeliveryPriorityMutation, { data, loading, error }] = useChangeDeliveryPriorityMutation({
 *   variables: {
 *      devices: // value for 'devices'
 *   },
 * });
 */
export function useChangeDeliveryPriorityMutation(baseOptions?: Apollo.MutationHookOptions<ChangeDeliveryPriorityMutation, ChangeDeliveryPriorityMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ChangeDeliveryPriorityMutation, ChangeDeliveryPriorityMutationVariables>(ChangeDeliveryPriorityDocument, options);
      }
export type ChangeDeliveryPriorityMutationHookResult = ReturnType<typeof useChangeDeliveryPriorityMutation>;
export type ChangeDeliveryPriorityMutationResult = Apollo.MutationResult<ChangeDeliveryPriorityMutation>;
export type ChangeDeliveryPriorityMutationOptions = Apollo.BaseMutationOptions<ChangeDeliveryPriorityMutation, ChangeDeliveryPriorityMutationVariables>;
export const CreateVaeConfigDocument = gql`
    mutation createVaeConfig($deviceId: ID!, $engine: String!, $name: String!) {
  createVaeConfig(deviceId: $deviceId, engine: $engine, name: $name)
}
    `;
export type CreateVaeConfigMutationFn = Apollo.MutationFunction<CreateVaeConfigMutation, CreateVaeConfigMutationVariables>;

/**
 * __useCreateVaeConfigMutation__
 *
 * To run a mutation, you first call `useCreateVaeConfigMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateVaeConfigMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createVaeConfigMutation, { data, loading, error }] = useCreateVaeConfigMutation({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *      engine: // value for 'engine'
 *      name: // value for 'name'
 *   },
 * });
 */
export function useCreateVaeConfigMutation(baseOptions?: Apollo.MutationHookOptions<CreateVaeConfigMutation, CreateVaeConfigMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateVaeConfigMutation, CreateVaeConfigMutationVariables>(CreateVaeConfigDocument, options);
      }
export type CreateVaeConfigMutationHookResult = ReturnType<typeof useCreateVaeConfigMutation>;
export type CreateVaeConfigMutationResult = Apollo.MutationResult<CreateVaeConfigMutation>;
export type CreateVaeConfigMutationOptions = Apollo.BaseMutationOptions<CreateVaeConfigMutation, CreateVaeConfigMutationVariables>;
export const RenameVaeConfigDocument = gql`
    mutation renameVaeConfig($deviceId: ID!, $engine: String!, $name: String!, $newName: String!) {
  renameVaeConfig(
    deviceId: $deviceId
    engine: $engine
    name: $name
    newName: $newName
  )
}
    `;
export type RenameVaeConfigMutationFn = Apollo.MutationFunction<RenameVaeConfigMutation, RenameVaeConfigMutationVariables>;

/**
 * __useRenameVaeConfigMutation__
 *
 * To run a mutation, you first call `useRenameVaeConfigMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRenameVaeConfigMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [renameVaeConfigMutation, { data, loading, error }] = useRenameVaeConfigMutation({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *      engine: // value for 'engine'
 *      name: // value for 'name'
 *      newName: // value for 'newName'
 *   },
 * });
 */
export function useRenameVaeConfigMutation(baseOptions?: Apollo.MutationHookOptions<RenameVaeConfigMutation, RenameVaeConfigMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RenameVaeConfigMutation, RenameVaeConfigMutationVariables>(RenameVaeConfigDocument, options);
      }
export type RenameVaeConfigMutationHookResult = ReturnType<typeof useRenameVaeConfigMutation>;
export type RenameVaeConfigMutationResult = Apollo.MutationResult<RenameVaeConfigMutation>;
export type RenameVaeConfigMutationOptions = Apollo.BaseMutationOptions<RenameVaeConfigMutation, RenameVaeConfigMutationVariables>;
export const DeleteVaeConfigDocument = gql`
    mutation deleteVaeConfig($deviceId: ID!, $engine: String!, $name: String!) {
  deleteVaeConfig(deviceId: $deviceId, engine: $engine, name: $name)
}
    `;
export type DeleteVaeConfigMutationFn = Apollo.MutationFunction<DeleteVaeConfigMutation, DeleteVaeConfigMutationVariables>;

/**
 * __useDeleteVaeConfigMutation__
 *
 * To run a mutation, you first call `useDeleteVaeConfigMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteVaeConfigMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteVaeConfigMutation, { data, loading, error }] = useDeleteVaeConfigMutation({
 *   variables: {
 *      deviceId: // value for 'deviceId'
 *      engine: // value for 'engine'
 *      name: // value for 'name'
 *   },
 * });
 */
export function useDeleteVaeConfigMutation(baseOptions?: Apollo.MutationHookOptions<DeleteVaeConfigMutation, DeleteVaeConfigMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteVaeConfigMutation, DeleteVaeConfigMutationVariables>(DeleteVaeConfigDocument, options);
      }
export type DeleteVaeConfigMutationHookResult = ReturnType<typeof useDeleteVaeConfigMutation>;
export type DeleteVaeConfigMutationResult = Apollo.MutationResult<DeleteVaeConfigMutation>;
export type DeleteVaeConfigMutationOptions = Apollo.BaseMutationOptions<DeleteVaeConfigMutation, DeleteVaeConfigMutationVariables>;
export const PurgeAvatarQueueDocument = gql`
    mutation purgeAvatarQueue($id: ID!) {
  purgeAvatarQueue(id: $id)
}
    `;
export type PurgeAvatarQueueMutationFn = Apollo.MutationFunction<PurgeAvatarQueueMutation, PurgeAvatarQueueMutationVariables>;

/**
 * __usePurgeAvatarQueueMutation__
 *
 * To run a mutation, you first call `usePurgeAvatarQueueMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePurgeAvatarQueueMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [purgeAvatarQueueMutation, { data, loading, error }] = usePurgeAvatarQueueMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function usePurgeAvatarQueueMutation(baseOptions?: Apollo.MutationHookOptions<PurgeAvatarQueueMutation, PurgeAvatarQueueMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<PurgeAvatarQueueMutation, PurgeAvatarQueueMutationVariables>(PurgeAvatarQueueDocument, options);
      }
export type PurgeAvatarQueueMutationHookResult = ReturnType<typeof usePurgeAvatarQueueMutation>;
export type PurgeAvatarQueueMutationResult = Apollo.MutationResult<PurgeAvatarQueueMutation>;
export type PurgeAvatarQueueMutationOptions = Apollo.BaseMutationOptions<PurgeAvatarQueueMutation, PurgeAvatarQueueMutationVariables>;
export const PtzStepDocument = gql`
    mutation ptzStep($id: ID!, $command: PTZ_StepInput!, $priority: Int) {
  ptzStep(id: $id, input: $command, priority: $priority)
}
    `;
export type PtzStepMutationFn = Apollo.MutationFunction<PtzStepMutation, PtzStepMutationVariables>;

/**
 * __usePtzStepMutation__
 *
 * To run a mutation, you first call `usePtzStepMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePtzStepMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [ptzStepMutation, { data, loading, error }] = usePtzStepMutation({
 *   variables: {
 *      id: // value for 'id'
 *      command: // value for 'command'
 *      priority: // value for 'priority'
 *   },
 * });
 */
export function usePtzStepMutation(baseOptions?: Apollo.MutationHookOptions<PtzStepMutation, PtzStepMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<PtzStepMutation, PtzStepMutationVariables>(PtzStepDocument, options);
      }
export type PtzStepMutationHookResult = ReturnType<typeof usePtzStepMutation>;
export type PtzStepMutationResult = Apollo.MutationResult<PtzStepMutation>;
export type PtzStepMutationOptions = Apollo.BaseMutationOptions<PtzStepMutation, PtzStepMutationVariables>;
export const PtzSpeedDocument = gql`
    mutation ptzSpeed($id: ID!, $command: PTZ_SpeedInput!, $priority: Int) {
  ptzSpeed(id: $id, input: $command, priority: $priority)
}
    `;
export type PtzSpeedMutationFn = Apollo.MutationFunction<PtzSpeedMutation, PtzSpeedMutationVariables>;

/**
 * __usePtzSpeedMutation__
 *
 * To run a mutation, you first call `usePtzSpeedMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePtzSpeedMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [ptzSpeedMutation, { data, loading, error }] = usePtzSpeedMutation({
 *   variables: {
 *      id: // value for 'id'
 *      command: // value for 'command'
 *      priority: // value for 'priority'
 *   },
 * });
 */
export function usePtzSpeedMutation(baseOptions?: Apollo.MutationHookOptions<PtzSpeedMutation, PtzSpeedMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<PtzSpeedMutation, PtzSpeedMutationVariables>(PtzSpeedDocument, options);
      }
export type PtzSpeedMutationHookResult = ReturnType<typeof usePtzSpeedMutation>;
export type PtzSpeedMutationResult = Apollo.MutationResult<PtzSpeedMutation>;
export type PtzSpeedMutationOptions = Apollo.BaseMutationOptions<PtzSpeedMutation, PtzSpeedMutationVariables>;
export const PtzPresetDocument = gql`
    mutation ptzPreset($id: ID!, $command: PTZ_PresetInput!, $priority: Int) {
  ptzPreset(id: $id, input: $command, priority: $priority)
}
    `;
export type PtzPresetMutationFn = Apollo.MutationFunction<PtzPresetMutation, PtzPresetMutationVariables>;

/**
 * __usePtzPresetMutation__
 *
 * To run a mutation, you first call `usePtzPresetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePtzPresetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [ptzPresetMutation, { data, loading, error }] = usePtzPresetMutation({
 *   variables: {
 *      id: // value for 'id'
 *      command: // value for 'command'
 *      priority: // value for 'priority'
 *   },
 * });
 */
export function usePtzPresetMutation(baseOptions?: Apollo.MutationHookOptions<PtzPresetMutation, PtzPresetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<PtzPresetMutation, PtzPresetMutationVariables>(PtzPresetDocument, options);
      }
export type PtzPresetMutationHookResult = ReturnType<typeof usePtzPresetMutation>;
export type PtzPresetMutationResult = Apollo.MutationResult<PtzPresetMutation>;
export type PtzPresetMutationOptions = Apollo.BaseMutationOptions<PtzPresetMutation, PtzPresetMutationVariables>;
export const PtzRelDocument = gql`
    mutation ptzRel($id: ID!, $command: PTZ_RelInput!, $priority: Int) {
  ptzRel(id: $id, input: $command, priority: $priority)
}
    `;
export type PtzRelMutationFn = Apollo.MutationFunction<PtzRelMutation, PtzRelMutationVariables>;

/**
 * __usePtzRelMutation__
 *
 * To run a mutation, you first call `usePtzRelMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePtzRelMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [ptzRelMutation, { data, loading, error }] = usePtzRelMutation({
 *   variables: {
 *      id: // value for 'id'
 *      command: // value for 'command'
 *      priority: // value for 'priority'
 *   },
 * });
 */
export function usePtzRelMutation(baseOptions?: Apollo.MutationHookOptions<PtzRelMutation, PtzRelMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<PtzRelMutation, PtzRelMutationVariables>(PtzRelDocument, options);
      }
export type PtzRelMutationHookResult = ReturnType<typeof usePtzRelMutation>;
export type PtzRelMutationResult = Apollo.MutationResult<PtzRelMutation>;
export type PtzRelMutationOptions = Apollo.BaseMutationOptions<PtzRelMutation, PtzRelMutationVariables>;
export const ChangeLocalStorageConfigDocument = gql`
    mutation changeLocalStorageConfig($id: ID!, $input: LocalStorageInput!) {
  changeLocalStorage(id: $id, input: $input)
}
    `;
export type ChangeLocalStorageConfigMutationFn = Apollo.MutationFunction<ChangeLocalStorageConfigMutation, ChangeLocalStorageConfigMutationVariables>;

/**
 * __useChangeLocalStorageConfigMutation__
 *
 * To run a mutation, you first call `useChangeLocalStorageConfigMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useChangeLocalStorageConfigMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [changeLocalStorageConfigMutation, { data, loading, error }] = useChangeLocalStorageConfigMutation({
 *   variables: {
 *      id: // value for 'id'
 *      input: // value for 'input'
 *   },
 * });
 */
export function useChangeLocalStorageConfigMutation(baseOptions?: Apollo.MutationHookOptions<ChangeLocalStorageConfigMutation, ChangeLocalStorageConfigMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ChangeLocalStorageConfigMutation, ChangeLocalStorageConfigMutationVariables>(ChangeLocalStorageConfigDocument, options);
      }
export type ChangeLocalStorageConfigMutationHookResult = ReturnType<typeof useChangeLocalStorageConfigMutation>;
export type ChangeLocalStorageConfigMutationResult = Apollo.MutationResult<ChangeLocalStorageConfigMutation>;
export type ChangeLocalStorageConfigMutationOptions = Apollo.BaseMutationOptions<ChangeLocalStorageConfigMutation, ChangeLocalStorageConfigMutationVariables>;
export const CreateAvatarApiKeyDocument = gql`
    mutation createAvatarApiKey($id: ID!) {
  createAvatarApiKey(id: $id)
}
    `;
export type CreateAvatarApiKeyMutationFn = Apollo.MutationFunction<CreateAvatarApiKeyMutation, CreateAvatarApiKeyMutationVariables>;

/**
 * __useCreateAvatarApiKeyMutation__
 *
 * To run a mutation, you first call `useCreateAvatarApiKeyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateAvatarApiKeyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createAvatarApiKeyMutation, { data, loading, error }] = useCreateAvatarApiKeyMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useCreateAvatarApiKeyMutation(baseOptions?: Apollo.MutationHookOptions<CreateAvatarApiKeyMutation, CreateAvatarApiKeyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateAvatarApiKeyMutation, CreateAvatarApiKeyMutationVariables>(CreateAvatarApiKeyDocument, options);
      }
export type CreateAvatarApiKeyMutationHookResult = ReturnType<typeof useCreateAvatarApiKeyMutation>;
export type CreateAvatarApiKeyMutationResult = Apollo.MutationResult<CreateAvatarApiKeyMutation>;
export type CreateAvatarApiKeyMutationOptions = Apollo.BaseMutationOptions<CreateAvatarApiKeyMutation, CreateAvatarApiKeyMutationVariables>;
export const RegenerateAvatarApiKeyDocument = gql`
    mutation regenerateAvatarApiKey($id: ID!) {
  regenerateAvatarApiKey(id: $id)
}
    `;
export type RegenerateAvatarApiKeyMutationFn = Apollo.MutationFunction<RegenerateAvatarApiKeyMutation, RegenerateAvatarApiKeyMutationVariables>;

/**
 * __useRegenerateAvatarApiKeyMutation__
 *
 * To run a mutation, you first call `useRegenerateAvatarApiKeyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRegenerateAvatarApiKeyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [regenerateAvatarApiKeyMutation, { data, loading, error }] = useRegenerateAvatarApiKeyMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useRegenerateAvatarApiKeyMutation(baseOptions?: Apollo.MutationHookOptions<RegenerateAvatarApiKeyMutation, RegenerateAvatarApiKeyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RegenerateAvatarApiKeyMutation, RegenerateAvatarApiKeyMutationVariables>(RegenerateAvatarApiKeyDocument, options);
      }
export type RegenerateAvatarApiKeyMutationHookResult = ReturnType<typeof useRegenerateAvatarApiKeyMutation>;
export type RegenerateAvatarApiKeyMutationResult = Apollo.MutationResult<RegenerateAvatarApiKeyMutation>;
export type RegenerateAvatarApiKeyMutationOptions = Apollo.BaseMutationOptions<RegenerateAvatarApiKeyMutation, RegenerateAvatarApiKeyMutationVariables>;
export const RemoveAvatarApiKeyDocument = gql`
    mutation removeAvatarApiKey($id: ID!) {
  removeAvatarApiKey(id: $id)
}
    `;
export type RemoveAvatarApiKeyMutationFn = Apollo.MutationFunction<RemoveAvatarApiKeyMutation, RemoveAvatarApiKeyMutationVariables>;

/**
 * __useRemoveAvatarApiKeyMutation__
 *
 * To run a mutation, you first call `useRemoveAvatarApiKeyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRemoveAvatarApiKeyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [removeAvatarApiKeyMutation, { data, loading, error }] = useRemoveAvatarApiKeyMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useRemoveAvatarApiKeyMutation(baseOptions?: Apollo.MutationHookOptions<RemoveAvatarApiKeyMutation, RemoveAvatarApiKeyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RemoveAvatarApiKeyMutation, RemoveAvatarApiKeyMutationVariables>(RemoveAvatarApiKeyDocument, options);
      }
export type RemoveAvatarApiKeyMutationHookResult = ReturnType<typeof useRemoveAvatarApiKeyMutation>;
export type RemoveAvatarApiKeyMutationResult = Apollo.MutationResult<RemoveAvatarApiKeyMutation>;
export type RemoveAvatarApiKeyMutationOptions = Apollo.BaseMutationOptions<RemoveAvatarApiKeyMutation, RemoveAvatarApiKeyMutationVariables>;
export const GetGuisDocument = gql`
    query getGuis {
  guis {
    id
    name
    url
    description
  }
}
    `;

/**
 * __useGetGuisQuery__
 *
 * To run a query within a React component, call `useGetGuisQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetGuisQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetGuisQuery({
 *   variables: {
 *   },
 * });
 */
export function useGetGuisQuery(baseOptions?: Apollo.QueryHookOptions<GetGuisQuery, GetGuisQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetGuisQuery, GetGuisQueryVariables>(GetGuisDocument, options);
      }
export function useGetGuisLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetGuisQuery, GetGuisQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetGuisQuery, GetGuisQueryVariables>(GetGuisDocument, options);
        }
export type GetGuisQueryHookResult = ReturnType<typeof useGetGuisQuery>;
export type GetGuisLazyQueryHookResult = ReturnType<typeof useGetGuisLazyQuery>;
export type GetGuisQueryResult = Apollo.QueryResult<GetGuisQuery, GetGuisQueryVariables>;
export const LabelsDocument = gql`
    query labels {
  labels {
    ...LabelFields
  }
}
    ${LabelFieldsFragmentDoc}`;

/**
 * __useLabelsQuery__
 *
 * To run a query within a React component, call `useLabelsQuery` and pass it any options that fit your needs.
 * When your component renders, `useLabelsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLabelsQuery({
 *   variables: {
 *   },
 * });
 */
export function useLabelsQuery(baseOptions?: Apollo.QueryHookOptions<LabelsQuery, LabelsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<LabelsQuery, LabelsQueryVariables>(LabelsDocument, options);
      }
export function useLabelsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<LabelsQuery, LabelsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<LabelsQuery, LabelsQueryVariables>(LabelsDocument, options);
        }
export type LabelsQueryHookResult = ReturnType<typeof useLabelsQuery>;
export type LabelsLazyQueryHookResult = ReturnType<typeof useLabelsLazyQuery>;
export type LabelsQueryResult = Apollo.QueryResult<LabelsQuery, LabelsQueryVariables>;
export const LabelDocument = gql`
    query label($id: ID!) {
  label(id: $id) {
    ...LabelFields
  }
}
    ${LabelFieldsFragmentDoc}`;

/**
 * __useLabelQuery__
 *
 * To run a query within a React component, call `useLabelQuery` and pass it any options that fit your needs.
 * When your component renders, `useLabelQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLabelQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useLabelQuery(baseOptions: Apollo.QueryHookOptions<LabelQuery, LabelQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<LabelQuery, LabelQueryVariables>(LabelDocument, options);
      }
export function useLabelLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<LabelQuery, LabelQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<LabelQuery, LabelQueryVariables>(LabelDocument, options);
        }
export type LabelQueryHookResult = ReturnType<typeof useLabelQuery>;
export type LabelLazyQueryHookResult = ReturnType<typeof useLabelLazyQuery>;
export type LabelQueryResult = Apollo.QueryResult<LabelQuery, LabelQueryVariables>;
export const LabelsForObjectDocument = gql`
    query labelsForObject($objectId: ID!) {
  labelsForObject(objectId: $objectId) {
    ...LabelFields
  }
}
    ${LabelFieldsFragmentDoc}`;

/**
 * __useLabelsForObjectQuery__
 *
 * To run a query within a React component, call `useLabelsForObjectQuery` and pass it any options that fit your needs.
 * When your component renders, `useLabelsForObjectQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLabelsForObjectQuery({
 *   variables: {
 *      objectId: // value for 'objectId'
 *   },
 * });
 */
export function useLabelsForObjectQuery(baseOptions: Apollo.QueryHookOptions<LabelsForObjectQuery, LabelsForObjectQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<LabelsForObjectQuery, LabelsForObjectQueryVariables>(LabelsForObjectDocument, options);
      }
export function useLabelsForObjectLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<LabelsForObjectQuery, LabelsForObjectQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<LabelsForObjectQuery, LabelsForObjectQueryVariables>(LabelsForObjectDocument, options);
        }
export type LabelsForObjectQueryHookResult = ReturnType<typeof useLabelsForObjectQuery>;
export type LabelsForObjectLazyQueryHookResult = ReturnType<typeof useLabelsForObjectLazyQuery>;
export type LabelsForObjectQueryResult = Apollo.QueryResult<LabelsForObjectQuery, LabelsForObjectQueryVariables>;
export const HierarchiesDocument = gql`
    query hierarchies {
  hierarchies {
    ...HierarchyFields
  }
}
    ${HierarchyFieldsFragmentDoc}`;

/**
 * __useHierarchiesQuery__
 *
 * To run a query within a React component, call `useHierarchiesQuery` and pass it any options that fit your needs.
 * When your component renders, `useHierarchiesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useHierarchiesQuery({
 *   variables: {
 *   },
 * });
 */
export function useHierarchiesQuery(baseOptions?: Apollo.QueryHookOptions<HierarchiesQuery, HierarchiesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<HierarchiesQuery, HierarchiesQueryVariables>(HierarchiesDocument, options);
      }
export function useHierarchiesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<HierarchiesQuery, HierarchiesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<HierarchiesQuery, HierarchiesQueryVariables>(HierarchiesDocument, options);
        }
export type HierarchiesQueryHookResult = ReturnType<typeof useHierarchiesQuery>;
export type HierarchiesLazyQueryHookResult = ReturnType<typeof useHierarchiesLazyQuery>;
export type HierarchiesQueryResult = Apollo.QueryResult<HierarchiesQuery, HierarchiesQueryVariables>;
export const HierarchyDocument = gql`
    query hierarchy($id: ID!) {
  hierarchy(id: $id) {
    ...HierarchyFields
  }
}
    ${HierarchyFieldsFragmentDoc}`;

/**
 * __useHierarchyQuery__
 *
 * To run a query within a React component, call `useHierarchyQuery` and pass it any options that fit your needs.
 * When your component renders, `useHierarchyQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useHierarchyQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useHierarchyQuery(baseOptions: Apollo.QueryHookOptions<HierarchyQuery, HierarchyQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<HierarchyQuery, HierarchyQueryVariables>(HierarchyDocument, options);
      }
export function useHierarchyLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<HierarchyQuery, HierarchyQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<HierarchyQuery, HierarchyQueryVariables>(HierarchyDocument, options);
        }
export type HierarchyQueryHookResult = ReturnType<typeof useHierarchyQuery>;
export type HierarchyLazyQueryHookResult = ReturnType<typeof useHierarchyLazyQuery>;
export type HierarchyQueryResult = Apollo.QueryResult<HierarchyQuery, HierarchyQueryVariables>;
export const InsertLabelsDocument = gql`
    mutation insertLabels($labels: [LabelInput!]!) {
  insertLabels(labels: $labels) {
    ...LabelFields
  }
}
    ${LabelFieldsFragmentDoc}`;
export type InsertLabelsMutationFn = Apollo.MutationFunction<InsertLabelsMutation, InsertLabelsMutationVariables>;

/**
 * __useInsertLabelsMutation__
 *
 * To run a mutation, you first call `useInsertLabelsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useInsertLabelsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [insertLabelsMutation, { data, loading, error }] = useInsertLabelsMutation({
 *   variables: {
 *      labels: // value for 'labels'
 *   },
 * });
 */
export function useInsertLabelsMutation(baseOptions?: Apollo.MutationHookOptions<InsertLabelsMutation, InsertLabelsMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<InsertLabelsMutation, InsertLabelsMutationVariables>(InsertLabelsDocument, options);
      }
export type InsertLabelsMutationHookResult = ReturnType<typeof useInsertLabelsMutation>;
export type InsertLabelsMutationResult = Apollo.MutationResult<InsertLabelsMutation>;
export type InsertLabelsMutationOptions = Apollo.BaseMutationOptions<InsertLabelsMutation, InsertLabelsMutationVariables>;
export const UpdateLabelDocument = gql`
    mutation updateLabel($label: LabelInput!) {
  updateLabel(label: $label)
}
    `;
export type UpdateLabelMutationFn = Apollo.MutationFunction<UpdateLabelMutation, UpdateLabelMutationVariables>;

/**
 * __useUpdateLabelMutation__
 *
 * To run a mutation, you first call `useUpdateLabelMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateLabelMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateLabelMutation, { data, loading, error }] = useUpdateLabelMutation({
 *   variables: {
 *      label: // value for 'label'
 *   },
 * });
 */
export function useUpdateLabelMutation(baseOptions?: Apollo.MutationHookOptions<UpdateLabelMutation, UpdateLabelMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateLabelMutation, UpdateLabelMutationVariables>(UpdateLabelDocument, options);
      }
export type UpdateLabelMutationHookResult = ReturnType<typeof useUpdateLabelMutation>;
export type UpdateLabelMutationResult = Apollo.MutationResult<UpdateLabelMutation>;
export type UpdateLabelMutationOptions = Apollo.BaseMutationOptions<UpdateLabelMutation, UpdateLabelMutationVariables>;
export const DeleteLabelDocument = gql`
    mutation deleteLabel($id: ID!) {
  deleteLabel(id: $id)
}
    `;
export type DeleteLabelMutationFn = Apollo.MutationFunction<DeleteLabelMutation, DeleteLabelMutationVariables>;

/**
 * __useDeleteLabelMutation__
 *
 * To run a mutation, you first call `useDeleteLabelMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteLabelMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteLabelMutation, { data, loading, error }] = useDeleteLabelMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteLabelMutation(baseOptions?: Apollo.MutationHookOptions<DeleteLabelMutation, DeleteLabelMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteLabelMutation, DeleteLabelMutationVariables>(DeleteLabelDocument, options);
      }
export type DeleteLabelMutationHookResult = ReturnType<typeof useDeleteLabelMutation>;
export type DeleteLabelMutationResult = Apollo.MutationResult<DeleteLabelMutation>;
export type DeleteLabelMutationOptions = Apollo.BaseMutationOptions<DeleteLabelMutation, DeleteLabelMutationVariables>;
export const AssignLabelsDocument = gql`
    mutation assignLabels($objectId: ID!, $ids: [ID!]!) {
  assignLabels(objectId: $objectId, ids: $ids)
}
    `;
export type AssignLabelsMutationFn = Apollo.MutationFunction<AssignLabelsMutation, AssignLabelsMutationVariables>;

/**
 * __useAssignLabelsMutation__
 *
 * To run a mutation, you first call `useAssignLabelsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAssignLabelsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [assignLabelsMutation, { data, loading, error }] = useAssignLabelsMutation({
 *   variables: {
 *      objectId: // value for 'objectId'
 *      ids: // value for 'ids'
 *   },
 * });
 */
export function useAssignLabelsMutation(baseOptions?: Apollo.MutationHookOptions<AssignLabelsMutation, AssignLabelsMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AssignLabelsMutation, AssignLabelsMutationVariables>(AssignLabelsDocument, options);
      }
export type AssignLabelsMutationHookResult = ReturnType<typeof useAssignLabelsMutation>;
export type AssignLabelsMutationResult = Apollo.MutationResult<AssignLabelsMutation>;
export type AssignLabelsMutationOptions = Apollo.BaseMutationOptions<AssignLabelsMutation, AssignLabelsMutationVariables>;
export const RemoveLabelsDocument = gql`
    mutation removeLabels($objectId: ID!, $ids: [ID!]!) {
  removeLabels(objectId: $objectId, ids: $ids)
}
    `;
export type RemoveLabelsMutationFn = Apollo.MutationFunction<RemoveLabelsMutation, RemoveLabelsMutationVariables>;

/**
 * __useRemoveLabelsMutation__
 *
 * To run a mutation, you first call `useRemoveLabelsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRemoveLabelsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [removeLabelsMutation, { data, loading, error }] = useRemoveLabelsMutation({
 *   variables: {
 *      objectId: // value for 'objectId'
 *      ids: // value for 'ids'
 *   },
 * });
 */
export function useRemoveLabelsMutation(baseOptions?: Apollo.MutationHookOptions<RemoveLabelsMutation, RemoveLabelsMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RemoveLabelsMutation, RemoveLabelsMutationVariables>(RemoveLabelsDocument, options);
      }
export type RemoveLabelsMutationHookResult = ReturnType<typeof useRemoveLabelsMutation>;
export type RemoveLabelsMutationResult = Apollo.MutationResult<RemoveLabelsMutation>;
export type RemoveLabelsMutationOptions = Apollo.BaseMutationOptions<RemoveLabelsMutation, RemoveLabelsMutationVariables>;
export const InsertHierarchyDocument = gql`
    mutation insertHierarchy($hierarchy: HierarchyInput!) {
  insertHierarchy(hierarchy: $hierarchy) {
    ...HierarchyFields
  }
}
    ${HierarchyFieldsFragmentDoc}`;
export type InsertHierarchyMutationFn = Apollo.MutationFunction<InsertHierarchyMutation, InsertHierarchyMutationVariables>;

/**
 * __useInsertHierarchyMutation__
 *
 * To run a mutation, you first call `useInsertHierarchyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useInsertHierarchyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [insertHierarchyMutation, { data, loading, error }] = useInsertHierarchyMutation({
 *   variables: {
 *      hierarchy: // value for 'hierarchy'
 *   },
 * });
 */
export function useInsertHierarchyMutation(baseOptions?: Apollo.MutationHookOptions<InsertHierarchyMutation, InsertHierarchyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<InsertHierarchyMutation, InsertHierarchyMutationVariables>(InsertHierarchyDocument, options);
      }
export type InsertHierarchyMutationHookResult = ReturnType<typeof useInsertHierarchyMutation>;
export type InsertHierarchyMutationResult = Apollo.MutationResult<InsertHierarchyMutation>;
export type InsertHierarchyMutationOptions = Apollo.BaseMutationOptions<InsertHierarchyMutation, InsertHierarchyMutationVariables>;
export const UpdateHierarchyDocument = gql`
    mutation updateHierarchy($hierarchy: HierarchyInput!) {
  updateHierarchy(hierarchy: $hierarchy)
}
    `;
export type UpdateHierarchyMutationFn = Apollo.MutationFunction<UpdateHierarchyMutation, UpdateHierarchyMutationVariables>;

/**
 * __useUpdateHierarchyMutation__
 *
 * To run a mutation, you first call `useUpdateHierarchyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateHierarchyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateHierarchyMutation, { data, loading, error }] = useUpdateHierarchyMutation({
 *   variables: {
 *      hierarchy: // value for 'hierarchy'
 *   },
 * });
 */
export function useUpdateHierarchyMutation(baseOptions?: Apollo.MutationHookOptions<UpdateHierarchyMutation, UpdateHierarchyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateHierarchyMutation, UpdateHierarchyMutationVariables>(UpdateHierarchyDocument, options);
      }
export type UpdateHierarchyMutationHookResult = ReturnType<typeof useUpdateHierarchyMutation>;
export type UpdateHierarchyMutationResult = Apollo.MutationResult<UpdateHierarchyMutation>;
export type UpdateHierarchyMutationOptions = Apollo.BaseMutationOptions<UpdateHierarchyMutation, UpdateHierarchyMutationVariables>;
export const DeleteHierarchyDocument = gql`
    mutation deleteHierarchy($id: ID!) {
  deleteHierarchy(id: $id)
}
    `;
export type DeleteHierarchyMutationFn = Apollo.MutationFunction<DeleteHierarchyMutation, DeleteHierarchyMutationVariables>;

/**
 * __useDeleteHierarchyMutation__
 *
 * To run a mutation, you first call `useDeleteHierarchyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteHierarchyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteHierarchyMutation, { data, loading, error }] = useDeleteHierarchyMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteHierarchyMutation(baseOptions?: Apollo.MutationHookOptions<DeleteHierarchyMutation, DeleteHierarchyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteHierarchyMutation, DeleteHierarchyMutationVariables>(DeleteHierarchyDocument, options);
      }
export type DeleteHierarchyMutationHookResult = ReturnType<typeof useDeleteHierarchyMutation>;
export type DeleteHierarchyMutationResult = Apollo.MutationResult<DeleteHierarchyMutation>;
export type DeleteHierarchyMutationOptions = Apollo.BaseMutationOptions<DeleteHierarchyMutation, DeleteHierarchyMutationVariables>;
export const LabelUpdateDocument = gql`
    subscription labelUpdate {
  labelUpdate {
    ...LabelOrHierarchyUpdateFields
  }
}
    ${LabelOrHierarchyUpdateFieldsFragmentDoc}`;

/**
 * __useLabelUpdateSubscription__
 *
 * To run a query within a React component, call `useLabelUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useLabelUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLabelUpdateSubscription({
 *   variables: {
 *   },
 * });
 */
export function useLabelUpdateSubscription(baseOptions?: Apollo.SubscriptionHookOptions<LabelUpdateSubscription, LabelUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<LabelUpdateSubscription, LabelUpdateSubscriptionVariables>(LabelUpdateDocument, options);
      }
export type LabelUpdateSubscriptionHookResult = ReturnType<typeof useLabelUpdateSubscription>;
export type LabelUpdateSubscriptionResult = Apollo.SubscriptionResult<LabelUpdateSubscription>;
export const HierarchyUpdateDocument = gql`
    subscription hierarchyUpdate {
  hierarchyUpdate {
    ...LabelOrHierarchyUpdateFields
  }
}
    ${LabelOrHierarchyUpdateFieldsFragmentDoc}`;

/**
 * __useHierarchyUpdateSubscription__
 *
 * To run a query within a React component, call `useHierarchyUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useHierarchyUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useHierarchyUpdateSubscription({
 *   variables: {
 *   },
 * });
 */
export function useHierarchyUpdateSubscription(baseOptions?: Apollo.SubscriptionHookOptions<HierarchyUpdateSubscription, HierarchyUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<HierarchyUpdateSubscription, HierarchyUpdateSubscriptionVariables>(HierarchyUpdateDocument, options);
      }
export type HierarchyUpdateSubscriptionHookResult = ReturnType<typeof useHierarchyUpdateSubscription>;
export type HierarchyUpdateSubscriptionResult = Apollo.SubscriptionResult<HierarchyUpdateSubscription>;
export const LicenseTextDocument = gql`
    query licenseText {
  license {
    text
  }
}
    `;

/**
 * __useLicenseTextQuery__
 *
 * To run a query within a React component, call `useLicenseTextQuery` and pass it any options that fit your needs.
 * When your component renders, `useLicenseTextQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLicenseTextQuery({
 *   variables: {
 *   },
 * });
 */
export function useLicenseTextQuery(baseOptions?: Apollo.QueryHookOptions<LicenseTextQuery, LicenseTextQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<LicenseTextQuery, LicenseTextQueryVariables>(LicenseTextDocument, options);
      }
export function useLicenseTextLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<LicenseTextQuery, LicenseTextQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<LicenseTextQuery, LicenseTextQueryVariables>(LicenseTextDocument, options);
        }
export type LicenseTextQueryHookResult = ReturnType<typeof useLicenseTextQuery>;
export type LicenseTextLazyQueryHookResult = ReturnType<typeof useLicenseTextLazyQuery>;
export type LicenseTextQueryResult = Apollo.QueryResult<LicenseTextQuery, LicenseTextQueryVariables>;
export const LicenseAcceptedDocument = gql`
    query licenseAccepted {
  license {
    isAccepted
  }
}
    `;

/**
 * __useLicenseAcceptedQuery__
 *
 * To run a query within a React component, call `useLicenseAcceptedQuery` and pass it any options that fit your needs.
 * When your component renders, `useLicenseAcceptedQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLicenseAcceptedQuery({
 *   variables: {
 *   },
 * });
 */
export function useLicenseAcceptedQuery(baseOptions?: Apollo.QueryHookOptions<LicenseAcceptedQuery, LicenseAcceptedQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<LicenseAcceptedQuery, LicenseAcceptedQueryVariables>(LicenseAcceptedDocument, options);
      }
export function useLicenseAcceptedLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<LicenseAcceptedQuery, LicenseAcceptedQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<LicenseAcceptedQuery, LicenseAcceptedQueryVariables>(LicenseAcceptedDocument, options);
        }
export type LicenseAcceptedQueryHookResult = ReturnType<typeof useLicenseAcceptedQuery>;
export type LicenseAcceptedLazyQueryHookResult = ReturnType<typeof useLicenseAcceptedLazyQuery>;
export type LicenseAcceptedQueryResult = Apollo.QueryResult<LicenseAcceptedQuery, LicenseAcceptedQueryVariables>;
export const AcceptLicenseDocument = gql`
    mutation acceptLicense {
  acceptLicense
}
    `;
export type AcceptLicenseMutationFn = Apollo.MutationFunction<AcceptLicenseMutation, AcceptLicenseMutationVariables>;

/**
 * __useAcceptLicenseMutation__
 *
 * To run a mutation, you first call `useAcceptLicenseMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAcceptLicenseMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [acceptLicenseMutation, { data, loading, error }] = useAcceptLicenseMutation({
 *   variables: {
 *   },
 * });
 */
export function useAcceptLicenseMutation(baseOptions?: Apollo.MutationHookOptions<AcceptLicenseMutation, AcceptLicenseMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<AcceptLicenseMutation, AcceptLicenseMutationVariables>(AcceptLicenseDocument, options);
      }
export type AcceptLicenseMutationHookResult = ReturnType<typeof useAcceptLicenseMutation>;
export type AcceptLicenseMutationResult = Apollo.MutationResult<AcceptLicenseMutation>;
export type AcceptLicenseMutationOptions = Apollo.BaseMutationOptions<AcceptLicenseMutation, AcceptLicenseMutationVariables>;
export const StoreDocument = gql`
    query store {
  store @client {
    session {
      isAdmin
      isLoggedIn
      info {
        ...userInfoFields
      }
    }
    select {
      obj
    }
    workspace {
      event {
        entry {
          ...auditEntryFields
          ...auditEntrySnapshotFields
        }
        hasSnapshots
      }
      updatedEvent {
        ...auditEntryFields
        ...auditEntrySnapshotFields
      }
      creatingViews {
        viewId
        name
        template
        layout
        widgets {
          widgetId
          index
          propsJSON
        }
        selectedWidget {
          widgetId
          index
          propsJSON
        }
        layoutJSON
      }
      solidConfigJSON
      localViewsJSON
      sharedViewsJSON
      cameraWidgetProps {
        viewId
        index
        deviceId
        name
        time
      }
    }
    socketEvent {
      type
      timeStamp
    }
    branding {
      CRM_REGISTRATION_URL
      ICON_PATH
      LOGIN_BACKGROUND_PATH
      LOGIN_FOOTER_COLOR
      LOGO_PATH
      OEM_BRAND
      OEM_BRAND_NAME
      OEM_COMPANY_LONG
      OEM_COMPANY_PHONE
      OEM_COMPANY_PHONE_INTERNATIONAL
      OEM_COMPANY_QUICKSTART
      OEM_COMPANY_SHORT
      OEM_COMPANY_SUPPORT_PHONE
      OEM_COMPANY_SUPPORT_URL
      OEM_COMPANY_URL
      OEM_COPYRIGHT
      OEM_COPYRIGHT_MATRIX
      OEM_STYLE
      OEM_SUPPORT_EMAIL
      OEM_TRADEMARKS
      QUICK_START_GUIDE_PATH
    }
  }
}
    ${UserInfoFieldsFragmentDoc}
${AuditEntryFieldsFragmentDoc}
${AuditEntrySnapshotFieldsFragmentDoc}`;

/**
 * __useStoreQuery__
 *
 * To run a query within a React component, call `useStoreQuery` and pass it any options that fit your needs.
 * When your component renders, `useStoreQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useStoreQuery({
 *   variables: {
 *   },
 * });
 */
export function useStoreQuery(baseOptions?: Apollo.QueryHookOptions<StoreQuery, StoreQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<StoreQuery, StoreQueryVariables>(StoreDocument, options);
      }
export function useStoreLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<StoreQuery, StoreQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<StoreQuery, StoreQueryVariables>(StoreDocument, options);
        }
export type StoreQueryHookResult = ReturnType<typeof useStoreQuery>;
export type StoreLazyQueryHookResult = ReturnType<typeof useStoreLazyQuery>;
export type StoreQueryResult = Apollo.QueryResult<StoreQuery, StoreQueryVariables>;
export const SetStoreDocument = gql`
    mutation setStore($store: AppStoreInput!) {
  setStore(store: $store) @client
}
    `;
export type SetStoreMutationFn = Apollo.MutationFunction<SetStoreMutation, SetStoreMutationVariables>;

/**
 * __useSetStoreMutation__
 *
 * To run a mutation, you first call `useSetStoreMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useSetStoreMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [setStoreMutation, { data, loading, error }] = useSetStoreMutation({
 *   variables: {
 *      store: // value for 'store'
 *   },
 * });
 */
export function useSetStoreMutation(baseOptions?: Apollo.MutationHookOptions<SetStoreMutation, SetStoreMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<SetStoreMutation, SetStoreMutationVariables>(SetStoreDocument, options);
      }
export type SetStoreMutationHookResult = ReturnType<typeof useSetStoreMutation>;
export type SetStoreMutationResult = Apollo.MutationResult<SetStoreMutation>;
export type SetStoreMutationOptions = Apollo.BaseMutationOptions<SetStoreMutation, SetStoreMutationVariables>;
export const ImageMapConfigDocument = gql`
    query imageMapConfig($version: String!, $lazyLoadImages: Boolean) {
  imageMapConfig(version: $version, lazyLoadImages: $lazyLoadImages) {
    sets {
      ...ImageMapSetFields
    }
  }
}
    ${ImageMapSetFieldsFragmentDoc}`;

/**
 * __useImageMapConfigQuery__
 *
 * To run a query within a React component, call `useImageMapConfigQuery` and pass it any options that fit your needs.
 * When your component renders, `useImageMapConfigQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useImageMapConfigQuery({
 *   variables: {
 *      version: // value for 'version'
 *      lazyLoadImages: // value for 'lazyLoadImages'
 *   },
 * });
 */
export function useImageMapConfigQuery(baseOptions: Apollo.QueryHookOptions<ImageMapConfigQuery, ImageMapConfigQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ImageMapConfigQuery, ImageMapConfigQueryVariables>(ImageMapConfigDocument, options);
      }
export function useImageMapConfigLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ImageMapConfigQuery, ImageMapConfigQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ImageMapConfigQuery, ImageMapConfigQueryVariables>(ImageMapConfigDocument, options);
        }
export type ImageMapConfigQueryHookResult = ReturnType<typeof useImageMapConfigQuery>;
export type ImageMapConfigLazyQueryHookResult = ReturnType<typeof useImageMapConfigLazyQuery>;
export type ImageMapConfigQueryResult = Apollo.QueryResult<ImageMapConfigQuery, ImageMapConfigQueryVariables>;
export const ImageMapImageDocument = gql`
    query imageMapImage($version: String!, $mapId: ID!) {
  imageMapImage(version: $version, mapId: $mapId)
}
    `;

/**
 * __useImageMapImageQuery__
 *
 * To run a query within a React component, call `useImageMapImageQuery` and pass it any options that fit your needs.
 * When your component renders, `useImageMapImageQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useImageMapImageQuery({
 *   variables: {
 *      version: // value for 'version'
 *      mapId: // value for 'mapId'
 *   },
 * });
 */
export function useImageMapImageQuery(baseOptions: Apollo.QueryHookOptions<ImageMapImageQuery, ImageMapImageQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ImageMapImageQuery, ImageMapImageQueryVariables>(ImageMapImageDocument, options);
      }
export function useImageMapImageLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ImageMapImageQuery, ImageMapImageQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ImageMapImageQuery, ImageMapImageQueryVariables>(ImageMapImageDocument, options);
        }
export type ImageMapImageQueryHookResult = ReturnType<typeof useImageMapImageQuery>;
export type ImageMapImageLazyQueryHookResult = ReturnType<typeof useImageMapImageLazyQuery>;
export type ImageMapImageQueryResult = Apollo.QueryResult<ImageMapImageQuery, ImageMapImageQueryVariables>;
export const InsertImageMapSetDocument = gql`
    mutation insertImageMapSet($version: String!, $set: ImageMapSetInput!, $updateId: ID!) {
  insertImageMapSet(version: $version, set: $set, updateId: $updateId)
}
    `;
export type InsertImageMapSetMutationFn = Apollo.MutationFunction<InsertImageMapSetMutation, InsertImageMapSetMutationVariables>;

/**
 * __useInsertImageMapSetMutation__
 *
 * To run a mutation, you first call `useInsertImageMapSetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useInsertImageMapSetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [insertImageMapSetMutation, { data, loading, error }] = useInsertImageMapSetMutation({
 *   variables: {
 *      version: // value for 'version'
 *      set: // value for 'set'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useInsertImageMapSetMutation(baseOptions?: Apollo.MutationHookOptions<InsertImageMapSetMutation, InsertImageMapSetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<InsertImageMapSetMutation, InsertImageMapSetMutationVariables>(InsertImageMapSetDocument, options);
      }
export type InsertImageMapSetMutationHookResult = ReturnType<typeof useInsertImageMapSetMutation>;
export type InsertImageMapSetMutationResult = Apollo.MutationResult<InsertImageMapSetMutation>;
export type InsertImageMapSetMutationOptions = Apollo.BaseMutationOptions<InsertImageMapSetMutation, InsertImageMapSetMutationVariables>;
export const RenameImageMapSetDocument = gql`
    mutation renameImageMapSet($version: String!, $setId: ID!, $name: String!, $updateId: ID!) {
  renameImageMapSet(
    version: $version
    setId: $setId
    name: $name
    updateId: $updateId
  )
}
    `;
export type RenameImageMapSetMutationFn = Apollo.MutationFunction<RenameImageMapSetMutation, RenameImageMapSetMutationVariables>;

/**
 * __useRenameImageMapSetMutation__
 *
 * To run a mutation, you first call `useRenameImageMapSetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRenameImageMapSetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [renameImageMapSetMutation, { data, loading, error }] = useRenameImageMapSetMutation({
 *   variables: {
 *      version: // value for 'version'
 *      setId: // value for 'setId'
 *      name: // value for 'name'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useRenameImageMapSetMutation(baseOptions?: Apollo.MutationHookOptions<RenameImageMapSetMutation, RenameImageMapSetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RenameImageMapSetMutation, RenameImageMapSetMutationVariables>(RenameImageMapSetDocument, options);
      }
export type RenameImageMapSetMutationHookResult = ReturnType<typeof useRenameImageMapSetMutation>;
export type RenameImageMapSetMutationResult = Apollo.MutationResult<RenameImageMapSetMutation>;
export type RenameImageMapSetMutationOptions = Apollo.BaseMutationOptions<RenameImageMapSetMutation, RenameImageMapSetMutationVariables>;
export const DeleteImageMapSetDocument = gql`
    mutation deleteImageMapSet($version: String!, $setId: ID!, $updateId: ID!) {
  deleteImageMapSet(version: $version, setId: $setId, updateId: $updateId)
}
    `;
export type DeleteImageMapSetMutationFn = Apollo.MutationFunction<DeleteImageMapSetMutation, DeleteImageMapSetMutationVariables>;

/**
 * __useDeleteImageMapSetMutation__
 *
 * To run a mutation, you first call `useDeleteImageMapSetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteImageMapSetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteImageMapSetMutation, { data, loading, error }] = useDeleteImageMapSetMutation({
 *   variables: {
 *      version: // value for 'version'
 *      setId: // value for 'setId'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useDeleteImageMapSetMutation(baseOptions?: Apollo.MutationHookOptions<DeleteImageMapSetMutation, DeleteImageMapSetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteImageMapSetMutation, DeleteImageMapSetMutationVariables>(DeleteImageMapSetDocument, options);
      }
export type DeleteImageMapSetMutationHookResult = ReturnType<typeof useDeleteImageMapSetMutation>;
export type DeleteImageMapSetMutationResult = Apollo.MutationResult<DeleteImageMapSetMutation>;
export type DeleteImageMapSetMutationOptions = Apollo.BaseMutationOptions<DeleteImageMapSetMutation, DeleteImageMapSetMutationVariables>;
export const InsertImageMapLayerDocument = gql`
    mutation insertImageMapLayer($version: String!, $setId: ID!, $layer: ImageMapLayerInput!, $updateId: ID!) {
  insertImageMapLayer(
    version: $version
    setId: $setId
    layer: $layer
    updateId: $updateId
  )
}
    `;
export type InsertImageMapLayerMutationFn = Apollo.MutationFunction<InsertImageMapLayerMutation, InsertImageMapLayerMutationVariables>;

/**
 * __useInsertImageMapLayerMutation__
 *
 * To run a mutation, you first call `useInsertImageMapLayerMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useInsertImageMapLayerMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [insertImageMapLayerMutation, { data, loading, error }] = useInsertImageMapLayerMutation({
 *   variables: {
 *      version: // value for 'version'
 *      setId: // value for 'setId'
 *      layer: // value for 'layer'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useInsertImageMapLayerMutation(baseOptions?: Apollo.MutationHookOptions<InsertImageMapLayerMutation, InsertImageMapLayerMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<InsertImageMapLayerMutation, InsertImageMapLayerMutationVariables>(InsertImageMapLayerDocument, options);
      }
export type InsertImageMapLayerMutationHookResult = ReturnType<typeof useInsertImageMapLayerMutation>;
export type InsertImageMapLayerMutationResult = Apollo.MutationResult<InsertImageMapLayerMutation>;
export type InsertImageMapLayerMutationOptions = Apollo.BaseMutationOptions<InsertImageMapLayerMutation, InsertImageMapLayerMutationVariables>;
export const RenameImageMapLayerDocument = gql`
    mutation renameImageMapLayer($version: String!, $layerId: ID!, $name: String!, $updateId: ID!) {
  renameImageMapLayer(
    version: $version
    layerId: $layerId
    name: $name
    updateId: $updateId
  )
}
    `;
export type RenameImageMapLayerMutationFn = Apollo.MutationFunction<RenameImageMapLayerMutation, RenameImageMapLayerMutationVariables>;

/**
 * __useRenameImageMapLayerMutation__
 *
 * To run a mutation, you first call `useRenameImageMapLayerMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRenameImageMapLayerMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [renameImageMapLayerMutation, { data, loading, error }] = useRenameImageMapLayerMutation({
 *   variables: {
 *      version: // value for 'version'
 *      layerId: // value for 'layerId'
 *      name: // value for 'name'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useRenameImageMapLayerMutation(baseOptions?: Apollo.MutationHookOptions<RenameImageMapLayerMutation, RenameImageMapLayerMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RenameImageMapLayerMutation, RenameImageMapLayerMutationVariables>(RenameImageMapLayerDocument, options);
      }
export type RenameImageMapLayerMutationHookResult = ReturnType<typeof useRenameImageMapLayerMutation>;
export type RenameImageMapLayerMutationResult = Apollo.MutationResult<RenameImageMapLayerMutation>;
export type RenameImageMapLayerMutationOptions = Apollo.BaseMutationOptions<RenameImageMapLayerMutation, RenameImageMapLayerMutationVariables>;
export const DeleteImageMapLayerDocument = gql`
    mutation deleteImageMapLayer($version: String!, $layerId: ID!, $updateId: ID!) {
  deleteImageMapLayer(version: $version, layerId: $layerId, updateId: $updateId)
}
    `;
export type DeleteImageMapLayerMutationFn = Apollo.MutationFunction<DeleteImageMapLayerMutation, DeleteImageMapLayerMutationVariables>;

/**
 * __useDeleteImageMapLayerMutation__
 *
 * To run a mutation, you first call `useDeleteImageMapLayerMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteImageMapLayerMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteImageMapLayerMutation, { data, loading, error }] = useDeleteImageMapLayerMutation({
 *   variables: {
 *      version: // value for 'version'
 *      layerId: // value for 'layerId'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useDeleteImageMapLayerMutation(baseOptions?: Apollo.MutationHookOptions<DeleteImageMapLayerMutation, DeleteImageMapLayerMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteImageMapLayerMutation, DeleteImageMapLayerMutationVariables>(DeleteImageMapLayerDocument, options);
      }
export type DeleteImageMapLayerMutationHookResult = ReturnType<typeof useDeleteImageMapLayerMutation>;
export type DeleteImageMapLayerMutationResult = Apollo.MutationResult<DeleteImageMapLayerMutation>;
export type DeleteImageMapLayerMutationOptions = Apollo.BaseMutationOptions<DeleteImageMapLayerMutation, DeleteImageMapLayerMutationVariables>;
export const UpdateImageMapDocument = gql`
    mutation updateImageMap($version: String!, $map: ImageMapInput!, $updateId: ID!) {
  updateImageMap(version: $version, map: $map, updateId: $updateId)
}
    `;
export type UpdateImageMapMutationFn = Apollo.MutationFunction<UpdateImageMapMutation, UpdateImageMapMutationVariables>;

/**
 * __useUpdateImageMapMutation__
 *
 * To run a mutation, you first call `useUpdateImageMapMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateImageMapMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateImageMapMutation, { data, loading, error }] = useUpdateImageMapMutation({
 *   variables: {
 *      version: // value for 'version'
 *      map: // value for 'map'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useUpdateImageMapMutation(baseOptions?: Apollo.MutationHookOptions<UpdateImageMapMutation, UpdateImageMapMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateImageMapMutation, UpdateImageMapMutationVariables>(UpdateImageMapDocument, options);
      }
export type UpdateImageMapMutationHookResult = ReturnType<typeof useUpdateImageMapMutation>;
export type UpdateImageMapMutationResult = Apollo.MutationResult<UpdateImageMapMutation>;
export type UpdateImageMapMutationOptions = Apollo.BaseMutationOptions<UpdateImageMapMutation, UpdateImageMapMutationVariables>;
export const InsertImageMapObjectDocument = gql`
    mutation insertImageMapObject($version: String!, $mapId: ID!, $object: ImageMapObjectInput!, $updateId: ID!) {
  insertImageMapObject(
    version: $version
    mapId: $mapId
    object: $object
    updateId: $updateId
  )
}
    `;
export type InsertImageMapObjectMutationFn = Apollo.MutationFunction<InsertImageMapObjectMutation, InsertImageMapObjectMutationVariables>;

/**
 * __useInsertImageMapObjectMutation__
 *
 * To run a mutation, you first call `useInsertImageMapObjectMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useInsertImageMapObjectMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [insertImageMapObjectMutation, { data, loading, error }] = useInsertImageMapObjectMutation({
 *   variables: {
 *      version: // value for 'version'
 *      mapId: // value for 'mapId'
 *      object: // value for 'object'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useInsertImageMapObjectMutation(baseOptions?: Apollo.MutationHookOptions<InsertImageMapObjectMutation, InsertImageMapObjectMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<InsertImageMapObjectMutation, InsertImageMapObjectMutationVariables>(InsertImageMapObjectDocument, options);
      }
export type InsertImageMapObjectMutationHookResult = ReturnType<typeof useInsertImageMapObjectMutation>;
export type InsertImageMapObjectMutationResult = Apollo.MutationResult<InsertImageMapObjectMutation>;
export type InsertImageMapObjectMutationOptions = Apollo.BaseMutationOptions<InsertImageMapObjectMutation, InsertImageMapObjectMutationVariables>;
export const UpdateImageMapObjectDocument = gql`
    mutation updateImageMapObject($version: String!, $object: ImageMapObjectInput!, $updateId: ID!) {
  updateImageMapObject(version: $version, object: $object, updateId: $updateId)
}
    `;
export type UpdateImageMapObjectMutationFn = Apollo.MutationFunction<UpdateImageMapObjectMutation, UpdateImageMapObjectMutationVariables>;

/**
 * __useUpdateImageMapObjectMutation__
 *
 * To run a mutation, you first call `useUpdateImageMapObjectMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateImageMapObjectMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateImageMapObjectMutation, { data, loading, error }] = useUpdateImageMapObjectMutation({
 *   variables: {
 *      version: // value for 'version'
 *      object: // value for 'object'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useUpdateImageMapObjectMutation(baseOptions?: Apollo.MutationHookOptions<UpdateImageMapObjectMutation, UpdateImageMapObjectMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateImageMapObjectMutation, UpdateImageMapObjectMutationVariables>(UpdateImageMapObjectDocument, options);
      }
export type UpdateImageMapObjectMutationHookResult = ReturnType<typeof useUpdateImageMapObjectMutation>;
export type UpdateImageMapObjectMutationResult = Apollo.MutationResult<UpdateImageMapObjectMutation>;
export type UpdateImageMapObjectMutationOptions = Apollo.BaseMutationOptions<UpdateImageMapObjectMutation, UpdateImageMapObjectMutationVariables>;
export const DeleteImageMapObjectDocument = gql`
    mutation deleteImageMapObject($version: String!, $objectId: ID!, $updateId: ID!) {
  deleteImageMapObject(
    version: $version
    objectId: $objectId
    updateId: $updateId
  )
}
    `;
export type DeleteImageMapObjectMutationFn = Apollo.MutationFunction<DeleteImageMapObjectMutation, DeleteImageMapObjectMutationVariables>;

/**
 * __useDeleteImageMapObjectMutation__
 *
 * To run a mutation, you first call `useDeleteImageMapObjectMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteImageMapObjectMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteImageMapObjectMutation, { data, loading, error }] = useDeleteImageMapObjectMutation({
 *   variables: {
 *      version: // value for 'version'
 *      objectId: // value for 'objectId'
 *      updateId: // value for 'updateId'
 *   },
 * });
 */
export function useDeleteImageMapObjectMutation(baseOptions?: Apollo.MutationHookOptions<DeleteImageMapObjectMutation, DeleteImageMapObjectMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteImageMapObjectMutation, DeleteImageMapObjectMutationVariables>(DeleteImageMapObjectDocument, options);
      }
export type DeleteImageMapObjectMutationHookResult = ReturnType<typeof useDeleteImageMapObjectMutation>;
export type DeleteImageMapObjectMutationResult = Apollo.MutationResult<DeleteImageMapObjectMutation>;
export type DeleteImageMapObjectMutationOptions = Apollo.BaseMutationOptions<DeleteImageMapObjectMutation, DeleteImageMapObjectMutationVariables>;
export const ImageMapUpdateDocument = gql`
    subscription imageMapUpdate($version: String!) {
  imageMapUpdate(version: $version) {
    action
    updateId
    set {
      ...ImageMapSetFields
    }
    layer {
      ...ImageMapLayerFields
    }
    map {
      ...ImageMapFields
    }
    object {
      ...ImageMapObjectFields
    }
    setName
    layerName
    setId
    layerId
    mapId
    objectId
  }
}
    ${ImageMapSetFieldsFragmentDoc}
${ImageMapLayerFieldsFragmentDoc}
${ImageMapFieldsFragmentDoc}
${ImageMapObjectFieldsFragmentDoc}`;

/**
 * __useImageMapUpdateSubscription__
 *
 * To run a query within a React component, call `useImageMapUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useImageMapUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useImageMapUpdateSubscription({
 *   variables: {
 *      version: // value for 'version'
 *   },
 * });
 */
export function useImageMapUpdateSubscription(baseOptions: Apollo.SubscriptionHookOptions<ImageMapUpdateSubscription, ImageMapUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<ImageMapUpdateSubscription, ImageMapUpdateSubscriptionVariables>(ImageMapUpdateDocument, options);
      }
export type ImageMapUpdateSubscriptionHookResult = ReturnType<typeof useImageMapUpdateSubscription>;
export type ImageMapUpdateSubscriptionResult = Apollo.SubscriptionResult<ImageMapUpdateSubscription>;
export const RealmDocument = gql`
    query realm {
  realm {
    ...realmFields
  }
}
    ${RealmFieldsFragmentDoc}`;

/**
 * __useRealmQuery__
 *
 * To run a query within a React component, call `useRealmQuery` and pass it any options that fit your needs.
 * When your component renders, `useRealmQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRealmQuery({
 *   variables: {
 *   },
 * });
 */
export function useRealmQuery(baseOptions?: Apollo.QueryHookOptions<RealmQuery, RealmQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<RealmQuery, RealmQueryVariables>(RealmDocument, options);
      }
export function useRealmLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<RealmQuery, RealmQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<RealmQuery, RealmQueryVariables>(RealmDocument, options);
        }
export type RealmQueryHookResult = ReturnType<typeof useRealmQuery>;
export type RealmLazyQueryHookResult = ReturnType<typeof useRealmLazyQuery>;
export type RealmQueryResult = Apollo.QueryResult<RealmQuery, RealmQueryVariables>;
export const GeoLayersDocument = gql`
    query geoLayers {
  geoLayers {
    geoLayers {
      name
      mime
      data
    }
  }
}
    `;

/**
 * __useGeoLayersQuery__
 *
 * To run a query within a React component, call `useGeoLayersQuery` and pass it any options that fit your needs.
 * When your component renders, `useGeoLayersQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGeoLayersQuery({
 *   variables: {
 *   },
 * });
 */
export function useGeoLayersQuery(baseOptions?: Apollo.QueryHookOptions<GeoLayersQuery, GeoLayersQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GeoLayersQuery, GeoLayersQueryVariables>(GeoLayersDocument, options);
      }
export function useGeoLayersLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GeoLayersQuery, GeoLayersQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GeoLayersQuery, GeoLayersQueryVariables>(GeoLayersDocument, options);
        }
export type GeoLayersQueryHookResult = ReturnType<typeof useGeoLayersQuery>;
export type GeoLayersLazyQueryHookResult = ReturnType<typeof useGeoLayersLazyQuery>;
export type GeoLayersQueryResult = Apollo.QueryResult<GeoLayersQuery, GeoLayersQueryVariables>;
export const RealmForPlayerDocument = gql`
    query realmForPlayer {
  realm {
    jitterBufferLength
    playerIdleTimeout
  }
}
    `;

/**
 * __useRealmForPlayerQuery__
 *
 * To run a query within a React component, call `useRealmForPlayerQuery` and pass it any options that fit your needs.
 * When your component renders, `useRealmForPlayerQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRealmForPlayerQuery({
 *   variables: {
 *   },
 * });
 */
export function useRealmForPlayerQuery(baseOptions?: Apollo.QueryHookOptions<RealmForPlayerQuery, RealmForPlayerQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<RealmForPlayerQuery, RealmForPlayerQueryVariables>(RealmForPlayerDocument, options);
      }
export function useRealmForPlayerLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<RealmForPlayerQuery, RealmForPlayerQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<RealmForPlayerQuery, RealmForPlayerQueryVariables>(RealmForPlayerDocument, options);
        }
export type RealmForPlayerQueryHookResult = ReturnType<typeof useRealmForPlayerQuery>;
export type RealmForPlayerLazyQueryHookResult = ReturnType<typeof useRealmForPlayerLazyQuery>;
export type RealmForPlayerQueryResult = Apollo.QueryResult<RealmForPlayerQuery, RealmForPlayerQueryVariables>;
export const IdentityAttributeDocument = gql`
    query identityAttribute {
  identityAttribute {
    contactUs
  }
}
    `;

/**
 * __useIdentityAttributeQuery__
 *
 * To run a query within a React component, call `useIdentityAttributeQuery` and pass it any options that fit your needs.
 * When your component renders, `useIdentityAttributeQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useIdentityAttributeQuery({
 *   variables: {
 *   },
 * });
 */
export function useIdentityAttributeQuery(baseOptions?: Apollo.QueryHookOptions<IdentityAttributeQuery, IdentityAttributeQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<IdentityAttributeQuery, IdentityAttributeQueryVariables>(IdentityAttributeDocument, options);
      }
export function useIdentityAttributeLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<IdentityAttributeQuery, IdentityAttributeQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<IdentityAttributeQuery, IdentityAttributeQueryVariables>(IdentityAttributeDocument, options);
        }
export type IdentityAttributeQueryHookResult = ReturnType<typeof useIdentityAttributeQuery>;
export type IdentityAttributeLazyQueryHookResult = ReturnType<typeof useIdentityAttributeLazyQuery>;
export type IdentityAttributeQueryResult = Apollo.QueryResult<IdentityAttributeQuery, IdentityAttributeQueryVariables>;
export const SessionInfoDocument = gql`
    query sessionInfo {
  sessionInfo
}
    `;

/**
 * __useSessionInfoQuery__
 *
 * To run a query within a React component, call `useSessionInfoQuery` and pass it any options that fit your needs.
 * When your component renders, `useSessionInfoQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSessionInfoQuery({
 *   variables: {
 *   },
 * });
 */
export function useSessionInfoQuery(baseOptions?: Apollo.QueryHookOptions<SessionInfoQuery, SessionInfoQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<SessionInfoQuery, SessionInfoQueryVariables>(SessionInfoDocument, options);
      }
export function useSessionInfoLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<SessionInfoQuery, SessionInfoQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<SessionInfoQuery, SessionInfoQueryVariables>(SessionInfoDocument, options);
        }
export type SessionInfoQueryHookResult = ReturnType<typeof useSessionInfoQuery>;
export type SessionInfoLazyQueryHookResult = ReturnType<typeof useSessionInfoLazyQuery>;
export type SessionInfoQueryResult = Apollo.QueryResult<SessionInfoQuery, SessionInfoQueryVariables>;
export const BrandingDocument = gql`
    query branding {
  branding {
    crmRegistrationUrl
    iconPath
    loginBackgroundPath
    loginFooterColor
    logoPath
    oemBrand
    oemBrandName
    oemCompanyLong
    oemCompanyPhone
    oemCompanyPhoneInternational
    oemCompanyQuickstart
    oemCompanyShort
    oemCompanySupportPhone
    oemCompanySupportUrl
    oemCompanyUrl
    oemCopyright
    oemCopyrightMatrix
    oemStyle
    oemSupportEmail
    oemTrademarks
    quickStartGuidePath
  }
}
    `;

/**
 * __useBrandingQuery__
 *
 * To run a query within a React component, call `useBrandingQuery` and pass it any options that fit your needs.
 * When your component renders, `useBrandingQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useBrandingQuery({
 *   variables: {
 *   },
 * });
 */
export function useBrandingQuery(baseOptions?: Apollo.QueryHookOptions<BrandingQuery, BrandingQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<BrandingQuery, BrandingQueryVariables>(BrandingDocument, options);
      }
export function useBrandingLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<BrandingQuery, BrandingQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<BrandingQuery, BrandingQueryVariables>(BrandingDocument, options);
        }
export type BrandingQueryHookResult = ReturnType<typeof useBrandingQuery>;
export type BrandingLazyQueryHookResult = ReturnType<typeof useBrandingLazyQuery>;
export type BrandingQueryResult = Apollo.QueryResult<BrandingQuery, BrandingQueryVariables>;
export const LanguagesDocument = gql`
    query languages {
  languages {
    languages {
      tag
      description
      direction
    }
  }
}
    `;

/**
 * __useLanguagesQuery__
 *
 * To run a query within a React component, call `useLanguagesQuery` and pass it any options that fit your needs.
 * When your component renders, `useLanguagesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLanguagesQuery({
 *   variables: {
 *   },
 * });
 */
export function useLanguagesQuery(baseOptions?: Apollo.QueryHookOptions<LanguagesQuery, LanguagesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<LanguagesQuery, LanguagesQueryVariables>(LanguagesDocument, options);
      }
export function useLanguagesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<LanguagesQuery, LanguagesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<LanguagesQuery, LanguagesQueryVariables>(LanguagesDocument, options);
        }
export type LanguagesQueryHookResult = ReturnType<typeof useLanguagesQuery>;
export type LanguagesLazyQueryHookResult = ReturnType<typeof useLanguagesLazyQuery>;
export type LanguagesQueryResult = Apollo.QueryResult<LanguagesQuery, LanguagesQueryVariables>;
export const EmailCanBeSendDocument = gql`
    query emailCanBeSend {
  emailCanBeSend
}
    `;

/**
 * __useEmailCanBeSendQuery__
 *
 * To run a query within a React component, call `useEmailCanBeSendQuery` and pass it any options that fit your needs.
 * When your component renders, `useEmailCanBeSendQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useEmailCanBeSendQuery({
 *   variables: {
 *   },
 * });
 */
export function useEmailCanBeSendQuery(baseOptions?: Apollo.QueryHookOptions<EmailCanBeSendQuery, EmailCanBeSendQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<EmailCanBeSendQuery, EmailCanBeSendQueryVariables>(EmailCanBeSendDocument, options);
      }
export function useEmailCanBeSendLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<EmailCanBeSendQuery, EmailCanBeSendQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<EmailCanBeSendQuery, EmailCanBeSendQueryVariables>(EmailCanBeSendDocument, options);
        }
export type EmailCanBeSendQueryHookResult = ReturnType<typeof useEmailCanBeSendQuery>;
export type EmailCanBeSendLazyQueryHookResult = ReturnType<typeof useEmailCanBeSendLazyQuery>;
export type EmailCanBeSendQueryResult = Apollo.QueryResult<EmailCanBeSendQuery, EmailCanBeSendQueryVariables>;
export const SystemParametersDocument = gql`
    query systemParameters {
  systemParameters {
    updatesHost
    solidAppVersion
    googleMapsApiKey
    mapDefaultLayer
    googleYouTubeApiKey
    googleYouTubePlaylistId
    geoDefaultPosition {
      lat
      lng
    }
  }
}
    `;

/**
 * __useSystemParametersQuery__
 *
 * To run a query within a React component, call `useSystemParametersQuery` and pass it any options that fit your needs.
 * When your component renders, `useSystemParametersQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSystemParametersQuery({
 *   variables: {
 *   },
 * });
 */
export function useSystemParametersQuery(baseOptions?: Apollo.QueryHookOptions<SystemParametersQuery, SystemParametersQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<SystemParametersQuery, SystemParametersQueryVariables>(SystemParametersDocument, options);
      }
export function useSystemParametersLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<SystemParametersQuery, SystemParametersQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<SystemParametersQuery, SystemParametersQueryVariables>(SystemParametersDocument, options);
        }
export type SystemParametersQueryHookResult = ReturnType<typeof useSystemParametersQuery>;
export type SystemParametersLazyQueryHookResult = ReturnType<typeof useSystemParametersLazyQuery>;
export type SystemParametersQueryResult = Apollo.QueryResult<SystemParametersQuery, SystemParametersQueryVariables>;
export const ActivateAvatarDocument = gql`
    mutation activateAvatar($avatarId: ID!) {
  activateAvatar(avatarId: $avatarId)
}
    `;
export type ActivateAvatarMutationFn = Apollo.MutationFunction<ActivateAvatarMutation, ActivateAvatarMutationVariables>;

/**
 * __useActivateAvatarMutation__
 *
 * To run a mutation, you first call `useActivateAvatarMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useActivateAvatarMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [activateAvatarMutation, { data, loading, error }] = useActivateAvatarMutation({
 *   variables: {
 *      avatarId: // value for 'avatarId'
 *   },
 * });
 */
export function useActivateAvatarMutation(baseOptions?: Apollo.MutationHookOptions<ActivateAvatarMutation, ActivateAvatarMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ActivateAvatarMutation, ActivateAvatarMutationVariables>(ActivateAvatarDocument, options);
      }
export type ActivateAvatarMutationHookResult = ReturnType<typeof useActivateAvatarMutation>;
export type ActivateAvatarMutationResult = Apollo.MutationResult<ActivateAvatarMutation>;
export type ActivateAvatarMutationOptions = Apollo.BaseMutationOptions<ActivateAvatarMutation, ActivateAvatarMutationVariables>;
export const VerifyCodeDocument = gql`
    mutation verifyCode($code: String!) {
  verifyCode(code: $code)
}
    `;
export type VerifyCodeMutationFn = Apollo.MutationFunction<VerifyCodeMutation, VerifyCodeMutationVariables>;

/**
 * __useVerifyCodeMutation__
 *
 * To run a mutation, you first call `useVerifyCodeMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useVerifyCodeMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [verifyCodeMutation, { data, loading, error }] = useVerifyCodeMutation({
 *   variables: {
 *      code: // value for 'code'
 *   },
 * });
 */
export function useVerifyCodeMutation(baseOptions?: Apollo.MutationHookOptions<VerifyCodeMutation, VerifyCodeMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<VerifyCodeMutation, VerifyCodeMutationVariables>(VerifyCodeDocument, options);
      }
export type VerifyCodeMutationHookResult = ReturnType<typeof useVerifyCodeMutation>;
export type VerifyCodeMutationResult = Apollo.MutationResult<VerifyCodeMutation>;
export type VerifyCodeMutationOptions = Apollo.BaseMutationOptions<VerifyCodeMutation, VerifyCodeMutationVariables>;
export const ActivateEmailDocument = gql`
    mutation activateEmail($input: SecretPassword!) {
  activateEmail(input: $input)
}
    `;
export type ActivateEmailMutationFn = Apollo.MutationFunction<ActivateEmailMutation, ActivateEmailMutationVariables>;

/**
 * __useActivateEmailMutation__
 *
 * To run a mutation, you first call `useActivateEmailMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useActivateEmailMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [activateEmailMutation, { data, loading, error }] = useActivateEmailMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useActivateEmailMutation(baseOptions?: Apollo.MutationHookOptions<ActivateEmailMutation, ActivateEmailMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ActivateEmailMutation, ActivateEmailMutationVariables>(ActivateEmailDocument, options);
      }
export type ActivateEmailMutationHookResult = ReturnType<typeof useActivateEmailMutation>;
export type ActivateEmailMutationResult = Apollo.MutationResult<ActivateEmailMutation>;
export type ActivateEmailMutationOptions = Apollo.BaseMutationOptions<ActivateEmailMutation, ActivateEmailMutationVariables>;
export const RestorePasswordDocument = gql`
    mutation restorePassword($input: SecretPassword!) {
  restorePassword(input: $input)
}
    `;
export type RestorePasswordMutationFn = Apollo.MutationFunction<RestorePasswordMutation, RestorePasswordMutationVariables>;

/**
 * __useRestorePasswordMutation__
 *
 * To run a mutation, you first call `useRestorePasswordMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRestorePasswordMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [restorePasswordMutation, { data, loading, error }] = useRestorePasswordMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useRestorePasswordMutation(baseOptions?: Apollo.MutationHookOptions<RestorePasswordMutation, RestorePasswordMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<RestorePasswordMutation, RestorePasswordMutationVariables>(RestorePasswordDocument, options);
      }
export type RestorePasswordMutationHookResult = ReturnType<typeof useRestorePasswordMutation>;
export type RestorePasswordMutationResult = Apollo.MutationResult<RestorePasswordMutation>;
export type RestorePasswordMutationOptions = Apollo.BaseMutationOptions<RestorePasswordMutation, RestorePasswordMutationVariables>;
export const ChangeCurrentPasswordDocument = gql`
    mutation changeCurrentPassword($input: ChangeCurrentPasswordInput!) {
  changeCurrentPassword(input: $input)
}
    `;
export type ChangeCurrentPasswordMutationFn = Apollo.MutationFunction<ChangeCurrentPasswordMutation, ChangeCurrentPasswordMutationVariables>;

/**
 * __useChangeCurrentPasswordMutation__
 *
 * To run a mutation, you first call `useChangeCurrentPasswordMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useChangeCurrentPasswordMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [changeCurrentPasswordMutation, { data, loading, error }] = useChangeCurrentPasswordMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useChangeCurrentPasswordMutation(baseOptions?: Apollo.MutationHookOptions<ChangeCurrentPasswordMutation, ChangeCurrentPasswordMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ChangeCurrentPasswordMutation, ChangeCurrentPasswordMutationVariables>(ChangeCurrentPasswordDocument, options);
      }
export type ChangeCurrentPasswordMutationHookResult = ReturnType<typeof useChangeCurrentPasswordMutation>;
export type ChangeCurrentPasswordMutationResult = Apollo.MutationResult<ChangeCurrentPasswordMutation>;
export type ChangeCurrentPasswordMutationOptions = Apollo.BaseMutationOptions<ChangeCurrentPasswordMutation, ChangeCurrentPasswordMutationVariables>;
export const UpdateGeoLayersDocument = gql`
    mutation updateGeoLayers($input: GEOLayersInput!) {
  updateGeoLayers(input: $input)
}
    `;
export type UpdateGeoLayersMutationFn = Apollo.MutationFunction<UpdateGeoLayersMutation, UpdateGeoLayersMutationVariables>;

/**
 * __useUpdateGeoLayersMutation__
 *
 * To run a mutation, you first call `useUpdateGeoLayersMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateGeoLayersMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateGeoLayersMutation, { data, loading, error }] = useUpdateGeoLayersMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useUpdateGeoLayersMutation(baseOptions?: Apollo.MutationHookOptions<UpdateGeoLayersMutation, UpdateGeoLayersMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateGeoLayersMutation, UpdateGeoLayersMutationVariables>(UpdateGeoLayersDocument, options);
      }
export type UpdateGeoLayersMutationHookResult = ReturnType<typeof useUpdateGeoLayersMutation>;
export type UpdateGeoLayersMutationResult = Apollo.MutationResult<UpdateGeoLayersMutation>;
export type UpdateGeoLayersMutationOptions = Apollo.BaseMutationOptions<UpdateGeoLayersMutation, UpdateGeoLayersMutationVariables>;
export const UpdateRealmDocument = gql`
    mutation updateRealm($realm: RealmInput!) {
  updateRealm(realmInput: $realm)
}
    `;
export type UpdateRealmMutationFn = Apollo.MutationFunction<UpdateRealmMutation, UpdateRealmMutationVariables>;

/**
 * __useUpdateRealmMutation__
 *
 * To run a mutation, you first call `useUpdateRealmMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateRealmMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateRealmMutation, { data, loading, error }] = useUpdateRealmMutation({
 *   variables: {
 *      realm: // value for 'realm'
 *   },
 * });
 */
export function useUpdateRealmMutation(baseOptions?: Apollo.MutationHookOptions<UpdateRealmMutation, UpdateRealmMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateRealmMutation, UpdateRealmMutationVariables>(UpdateRealmDocument, options);
      }
export type UpdateRealmMutationHookResult = ReturnType<typeof useUpdateRealmMutation>;
export type UpdateRealmMutationResult = Apollo.MutationResult<UpdateRealmMutation>;
export type UpdateRealmMutationOptions = Apollo.BaseMutationOptions<UpdateRealmMutation, UpdateRealmMutationVariables>;
export const ValidateEmailDocument = gql`
    mutation validateEmail($addresses: EmailAddresses!) {
  validateEmail(addresses: $addresses)
}
    `;
export type ValidateEmailMutationFn = Apollo.MutationFunction<ValidateEmailMutation, ValidateEmailMutationVariables>;

/**
 * __useValidateEmailMutation__
 *
 * To run a mutation, you first call `useValidateEmailMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useValidateEmailMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [validateEmailMutation, { data, loading, error }] = useValidateEmailMutation({
 *   variables: {
 *      addresses: // value for 'addresses'
 *   },
 * });
 */
export function useValidateEmailMutation(baseOptions?: Apollo.MutationHookOptions<ValidateEmailMutation, ValidateEmailMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ValidateEmailMutation, ValidateEmailMutationVariables>(ValidateEmailDocument, options);
      }
export type ValidateEmailMutationHookResult = ReturnType<typeof useValidateEmailMutation>;
export type ValidateEmailMutationResult = Apollo.MutationResult<ValidateEmailMutation>;
export type ValidateEmailMutationOptions = Apollo.BaseMutationOptions<ValidateEmailMutation, ValidateEmailMutationVariables>;
export const RealmObjectsDocument = gql`
    query realmObjects {
  realmObjects {
    id
    name
  }
}
    `;

/**
 * __useRealmObjectsQuery__
 *
 * To run a query within a React component, call `useRealmObjectsQuery` and pass it any options that fit your needs.
 * When your component renders, `useRealmObjectsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRealmObjectsQuery({
 *   variables: {
 *   },
 * });
 */
export function useRealmObjectsQuery(baseOptions?: Apollo.QueryHookOptions<RealmObjectsQuery, RealmObjectsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<RealmObjectsQuery, RealmObjectsQueryVariables>(RealmObjectsDocument, options);
      }
export function useRealmObjectsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<RealmObjectsQuery, RealmObjectsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<RealmObjectsQuery, RealmObjectsQueryVariables>(RealmObjectsDocument, options);
        }
export type RealmObjectsQueryHookResult = ReturnType<typeof useRealmObjectsQuery>;
export type RealmObjectsLazyQueryHookResult = ReturnType<typeof useRealmObjectsLazyQuery>;
export type RealmObjectsQueryResult = Apollo.QueryResult<RealmObjectsQuery, RealmObjectsQueryVariables>;
export const ObjectUpdateDocument = gql`
    subscription objectUpdate($filter: ObjectUpdateFilter) {
  objectUpdate(filter: $filter) {
    id
    type
    action
    healthStatus
  }
}
    `;

/**
 * __useObjectUpdateSubscription__
 *
 * To run a query within a React component, call `useObjectUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useObjectUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useObjectUpdateSubscription({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useObjectUpdateSubscription(baseOptions?: Apollo.SubscriptionHookOptions<ObjectUpdateSubscription, ObjectUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<ObjectUpdateSubscription, ObjectUpdateSubscriptionVariables>(ObjectUpdateDocument, options);
      }
export type ObjectUpdateSubscriptionHookResult = ReturnType<typeof useObjectUpdateSubscription>;
export type ObjectUpdateSubscriptionResult = Apollo.SubscriptionResult<ObjectUpdateSubscription>;
export const AvatarReportDocument = gql`
    query avatarReport($id: ID!, $from: DateTime!, $to: DateTime!, $metricName: AvatarMetricName!) {
  avatarReport(id: $id, from: $from, to: $to, metricName: $metricName) {
    time
    value
  }
}
    `;

/**
 * __useAvatarReportQuery__
 *
 * To run a query within a React component, call `useAvatarReportQuery` and pass it any options that fit your needs.
 * When your component renders, `useAvatarReportQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAvatarReportQuery({
 *   variables: {
 *      id: // value for 'id'
 *      from: // value for 'from'
 *      to: // value for 'to'
 *      metricName: // value for 'metricName'
 *   },
 * });
 */
export function useAvatarReportQuery(baseOptions: Apollo.QueryHookOptions<AvatarReportQuery, AvatarReportQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AvatarReportQuery, AvatarReportQueryVariables>(AvatarReportDocument, options);
      }
export function useAvatarReportLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AvatarReportQuery, AvatarReportQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AvatarReportQuery, AvatarReportQueryVariables>(AvatarReportDocument, options);
        }
export type AvatarReportQueryHookResult = ReturnType<typeof useAvatarReportQuery>;
export type AvatarReportLazyQueryHookResult = ReturnType<typeof useAvatarReportLazyQuery>;
export type AvatarReportQueryResult = Apollo.QueryResult<AvatarReportQuery, AvatarReportQueryVariables>;
export const CameraReportDocument = gql`
    query cameraReport($id: ID!, $from: DateTime!, $to: DateTime!, $metricName: CameraMetricName!, $dfaId: Int!) {
  numeric: cameraReport(
    id: $id
    from: $from
    to: $to
    metricName: $metricName
    dfaId: $dfaId
  ) {
    ... on NumericReport {
      time
      value
    }
  }
  status: cameraReport(
    id: $id
    from: $from
    to: $to
    metricName: $metricName
    dfaId: $dfaId
  ) {
    ... on StatusReport {
      time
      value
    }
  }
}
    `;

/**
 * __useCameraReportQuery__
 *
 * To run a query within a React component, call `useCameraReportQuery` and pass it any options that fit your needs.
 * When your component renders, `useCameraReportQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useCameraReportQuery({
 *   variables: {
 *      id: // value for 'id'
 *      from: // value for 'from'
 *      to: // value for 'to'
 *      metricName: // value for 'metricName'
 *      dfaId: // value for 'dfaId'
 *   },
 * });
 */
export function useCameraReportQuery(baseOptions: Apollo.QueryHookOptions<CameraReportQuery, CameraReportQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<CameraReportQuery, CameraReportQueryVariables>(CameraReportDocument, options);
      }
export function useCameraReportLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<CameraReportQuery, CameraReportQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<CameraReportQuery, CameraReportQueryVariables>(CameraReportDocument, options);
        }
export type CameraReportQueryHookResult = ReturnType<typeof useCameraReportQuery>;
export type CameraReportLazyQueryHookResult = ReturnType<typeof useCameraReportLazyQuery>;
export type CameraReportQueryResult = Apollo.QueryResult<CameraReportQuery, CameraReportQueryVariables>;
export const AvatarMetricsDocument = gql`
    query avatarMetrics {
  avatarMetrics {
    key
    name
    dimension
  }
}
    `;

/**
 * __useAvatarMetricsQuery__
 *
 * To run a query within a React component, call `useAvatarMetricsQuery` and pass it any options that fit your needs.
 * When your component renders, `useAvatarMetricsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAvatarMetricsQuery({
 *   variables: {
 *   },
 * });
 */
export function useAvatarMetricsQuery(baseOptions?: Apollo.QueryHookOptions<AvatarMetricsQuery, AvatarMetricsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AvatarMetricsQuery, AvatarMetricsQueryVariables>(AvatarMetricsDocument, options);
      }
export function useAvatarMetricsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AvatarMetricsQuery, AvatarMetricsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AvatarMetricsQuery, AvatarMetricsQueryVariables>(AvatarMetricsDocument, options);
        }
export type AvatarMetricsQueryHookResult = ReturnType<typeof useAvatarMetricsQuery>;
export type AvatarMetricsLazyQueryHookResult = ReturnType<typeof useAvatarMetricsLazyQuery>;
export type AvatarMetricsQueryResult = Apollo.QueryResult<AvatarMetricsQuery, AvatarMetricsQueryVariables>;
export const CameraMetricsDocument = gql`
    query cameraMetrics($id: ID!, $from: DateTime, $to: DateTime) {
  cameraMetrics(id: $id, from: $from, to: $to) {
    key
    name
    dimension
    dfaId
  }
}
    `;

/**
 * __useCameraMetricsQuery__
 *
 * To run a query within a React component, call `useCameraMetricsQuery` and pass it any options that fit your needs.
 * When your component renders, `useCameraMetricsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useCameraMetricsQuery({
 *   variables: {
 *      id: // value for 'id'
 *      from: // value for 'from'
 *      to: // value for 'to'
 *   },
 * });
 */
export function useCameraMetricsQuery(baseOptions: Apollo.QueryHookOptions<CameraMetricsQuery, CameraMetricsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<CameraMetricsQuery, CameraMetricsQueryVariables>(CameraMetricsDocument, options);
      }
export function useCameraMetricsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<CameraMetricsQuery, CameraMetricsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<CameraMetricsQuery, CameraMetricsQueryVariables>(CameraMetricsDocument, options);
        }
export type CameraMetricsQueryHookResult = ReturnType<typeof useCameraMetricsQuery>;
export type CameraMetricsLazyQueryHookResult = ReturnType<typeof useCameraMetricsLazyQuery>;
export type CameraMetricsQueryResult = Apollo.QueryResult<CameraMetricsQuery, CameraMetricsQueryVariables>;
export const SystemStatusDocument = gql`
    query systemStatus {
  systemStatus {
    status
    description
    reasons {
      message
      object {
        id
        name
        type
      }
    }
  }
  serverTime
}
    `;

/**
 * __useSystemStatusQuery__
 *
 * To run a query within a React component, call `useSystemStatusQuery` and pass it any options that fit your needs.
 * When your component renders, `useSystemStatusQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSystemStatusQuery({
 *   variables: {
 *   },
 * });
 */
export function useSystemStatusQuery(baseOptions?: Apollo.QueryHookOptions<SystemStatusQuery, SystemStatusQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<SystemStatusQuery, SystemStatusQueryVariables>(SystemStatusDocument, options);
      }
export function useSystemStatusLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<SystemStatusQuery, SystemStatusQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<SystemStatusQuery, SystemStatusQueryVariables>(SystemStatusDocument, options);
        }
export type SystemStatusQueryHookResult = ReturnType<typeof useSystemStatusQuery>;
export type SystemStatusLazyQueryHookResult = ReturnType<typeof useSystemStatusLazyQuery>;
export type SystemStatusQueryResult = Apollo.QueryResult<SystemStatusQuery, SystemStatusQueryVariables>;
export const SolidConfigDocument = gql`
    query solidConfig($userId: ID!) {
  solidConfig(userId: $userId)
}
    `;

/**
 * __useSolidConfigQuery__
 *
 * To run a query within a React component, call `useSolidConfigQuery` and pass it any options that fit your needs.
 * When your component renders, `useSolidConfigQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSolidConfigQuery({
 *   variables: {
 *      userId: // value for 'userId'
 *   },
 * });
 */
export function useSolidConfigQuery(baseOptions: Apollo.QueryHookOptions<SolidConfigQuery, SolidConfigQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<SolidConfigQuery, SolidConfigQueryVariables>(SolidConfigDocument, options);
      }
export function useSolidConfigLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<SolidConfigQuery, SolidConfigQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<SolidConfigQuery, SolidConfigQueryVariables>(SolidConfigDocument, options);
        }
export type SolidConfigQueryHookResult = ReturnType<typeof useSolidConfigQuery>;
export type SolidConfigLazyQueryHookResult = ReturnType<typeof useSolidConfigLazyQuery>;
export type SolidConfigQueryResult = Apollo.QueryResult<SolidConfigQuery, SolidConfigQueryVariables>;
export const UpdateSolidConfigDocument = gql`
    mutation updateSolidConfig($userId: ID!, $solidConfig: String) {
  updateSolidConfig(userId: $userId, solidConfig: $solidConfig)
}
    `;
export type UpdateSolidConfigMutationFn = Apollo.MutationFunction<UpdateSolidConfigMutation, UpdateSolidConfigMutationVariables>;

/**
 * __useUpdateSolidConfigMutation__
 *
 * To run a mutation, you first call `useUpdateSolidConfigMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateSolidConfigMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateSolidConfigMutation, { data, loading, error }] = useUpdateSolidConfigMutation({
 *   variables: {
 *      userId: // value for 'userId'
 *      solidConfig: // value for 'solidConfig'
 *   },
 * });
 */
export function useUpdateSolidConfigMutation(baseOptions?: Apollo.MutationHookOptions<UpdateSolidConfigMutation, UpdateSolidConfigMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateSolidConfigMutation, UpdateSolidConfigMutationVariables>(UpdateSolidConfigDocument, options);
      }
export type UpdateSolidConfigMutationHookResult = ReturnType<typeof useUpdateSolidConfigMutation>;
export type UpdateSolidConfigMutationResult = Apollo.MutationResult<UpdateSolidConfigMutation>;
export type UpdateSolidConfigMutationOptions = Apollo.BaseMutationOptions<UpdateSolidConfigMutation, UpdateSolidConfigMutationVariables>;
export const UpdateSolidConfigCurrentViewDocument = gql`
    mutation updateSolidConfigCurrentView($input: SolidConfigCurrentViewInput!) {
  updateSolidConfigCurrentView(input: $input)
}
    `;
export type UpdateSolidConfigCurrentViewMutationFn = Apollo.MutationFunction<UpdateSolidConfigCurrentViewMutation, UpdateSolidConfigCurrentViewMutationVariables>;

/**
 * __useUpdateSolidConfigCurrentViewMutation__
 *
 * To run a mutation, you first call `useUpdateSolidConfigCurrentViewMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateSolidConfigCurrentViewMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateSolidConfigCurrentViewMutation, { data, loading, error }] = useUpdateSolidConfigCurrentViewMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useUpdateSolidConfigCurrentViewMutation(baseOptions?: Apollo.MutationHookOptions<UpdateSolidConfigCurrentViewMutation, UpdateSolidConfigCurrentViewMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateSolidConfigCurrentViewMutation, UpdateSolidConfigCurrentViewMutationVariables>(UpdateSolidConfigCurrentViewDocument, options);
      }
export type UpdateSolidConfigCurrentViewMutationHookResult = ReturnType<typeof useUpdateSolidConfigCurrentViewMutation>;
export type UpdateSolidConfigCurrentViewMutationResult = Apollo.MutationResult<UpdateSolidConfigCurrentViewMutation>;
export type UpdateSolidConfigCurrentViewMutationOptions = Apollo.BaseMutationOptions<UpdateSolidConfigCurrentViewMutation, UpdateSolidConfigCurrentViewMutationVariables>;
export const SolidConfigUpdateDocument = gql`
    subscription solidConfigUpdate {
  solidConfigUpdate {
    userId
    solidConfig
  }
}
    `;

/**
 * __useSolidConfigUpdateSubscription__
 *
 * To run a query within a React component, call `useSolidConfigUpdateSubscription` and pass it any options that fit your needs.
 * When your component renders, `useSolidConfigUpdateSubscription` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the subscription, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSolidConfigUpdateSubscription({
 *   variables: {
 *   },
 * });
 */
export function useSolidConfigUpdateSubscription(baseOptions?: Apollo.SubscriptionHookOptions<SolidConfigUpdateSubscription, SolidConfigUpdateSubscriptionVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useSubscription<SolidConfigUpdateSubscription, SolidConfigUpdateSubscriptionVariables>(SolidConfigUpdateDocument, options);
      }
export type SolidConfigUpdateSubscriptionHookResult = ReturnType<typeof useSolidConfigUpdateSubscription>;
export type SolidConfigUpdateSubscriptionResult = Apollo.SubscriptionResult<SolidConfigUpdateSubscription>;
export const UserIdsDocument = gql`
    query userIds {
  users {
    id
  }
}
    `;

/**
 * __useUserIdsQuery__
 *
 * To run a query within a React component, call `useUserIdsQuery` and pass it any options that fit your needs.
 * When your component renders, `useUserIdsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useUserIdsQuery({
 *   variables: {
 *   },
 * });
 */
export function useUserIdsQuery(baseOptions?: Apollo.QueryHookOptions<UserIdsQuery, UserIdsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<UserIdsQuery, UserIdsQueryVariables>(UserIdsDocument, options);
      }
export function useUserIdsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<UserIdsQuery, UserIdsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<UserIdsQuery, UserIdsQueryVariables>(UserIdsDocument, options);
        }
export type UserIdsQueryHookResult = ReturnType<typeof useUserIdsQuery>;
export type UserIdsLazyQueryHookResult = ReturnType<typeof useUserIdsLazyQuery>;
export type UserIdsQueryResult = Apollo.QueryResult<UserIdsQuery, UserIdsQueryVariables>;
export const UserWitnessesDocument = gql`
    query userWitnesses {
  users {
    id
    name
  }
}
    `;

/**
 * __useUserWitnessesQuery__
 *
 * To run a query within a React component, call `useUserWitnessesQuery` and pass it any options that fit your needs.
 * When your component renders, `useUserWitnessesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useUserWitnessesQuery({
 *   variables: {
 *   },
 * });
 */
export function useUserWitnessesQuery(baseOptions?: Apollo.QueryHookOptions<UserWitnessesQuery, UserWitnessesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<UserWitnessesQuery, UserWitnessesQueryVariables>(UserWitnessesDocument, options);
      }
export function useUserWitnessesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<UserWitnessesQuery, UserWitnessesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<UserWitnessesQuery, UserWitnessesQueryVariables>(UserWitnessesDocument, options);
        }
export type UserWitnessesQueryHookResult = ReturnType<typeof useUserWitnessesQuery>;
export type UserWitnessesLazyQueryHookResult = ReturnType<typeof useUserWitnessesLazyQuery>;
export type UserWitnessesQueryResult = Apollo.QueryResult<UserWitnessesQuery, UserWitnessesQueryVariables>;
export const UserDocument = gql`
    query user($id: ID!) {
  user(id: $id) {
    ...userFields
  }
}
    ${UserFieldsFragmentDoc}`;

/**
 * __useUserQuery__
 *
 * To run a query within a React component, call `useUserQuery` and pass it any options that fit your needs.
 * When your component renders, `useUserQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useUserQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUserQuery(baseOptions: Apollo.QueryHookOptions<UserQuery, UserQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<UserQuery, UserQueryVariables>(UserDocument, options);
      }
export function useUserLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<UserQuery, UserQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<UserQuery, UserQueryVariables>(UserDocument, options);
        }
export type UserQueryHookResult = ReturnType<typeof useUserQuery>;
export type UserLazyQueryHookResult = ReturnType<typeof useUserLazyQuery>;
export type UserQueryResult = Apollo.QueryResult<UserQuery, UserQueryVariables>;
export const UserInfoDocument = gql`
    query userInfo {
  userInfo {
    ...userInfoFields
  }
}
    ${UserInfoFieldsFragmentDoc}`;

/**
 * __useUserInfoQuery__
 *
 * To run a query within a React component, call `useUserInfoQuery` and pass it any options that fit your needs.
 * When your component renders, `useUserInfoQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useUserInfoQuery({
 *   variables: {
 *   },
 * });
 */
export function useUserInfoQuery(baseOptions?: Apollo.QueryHookOptions<UserInfoQuery, UserInfoQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<UserInfoQuery, UserInfoQueryVariables>(UserInfoDocument, options);
      }
export function useUserInfoLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<UserInfoQuery, UserInfoQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<UserInfoQuery, UserInfoQueryVariables>(UserInfoDocument, options);
        }
export type UserInfoQueryHookResult = ReturnType<typeof useUserInfoQuery>;
export type UserInfoLazyQueryHookResult = ReturnType<typeof useUserInfoLazyQuery>;
export type UserInfoQueryResult = Apollo.QueryResult<UserInfoQuery, UserInfoQueryVariables>;
export const UsersDocument = gql`
    query users {
  users {
    ...userFields
  }
}
    ${UserFieldsFragmentDoc}`;

/**
 * __useUsersQuery__
 *
 * To run a query within a React component, call `useUsersQuery` and pass it any options that fit your needs.
 * When your component renders, `useUsersQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useUsersQuery({
 *   variables: {
 *   },
 * });
 */
export function useUsersQuery(baseOptions?: Apollo.QueryHookOptions<UsersQuery, UsersQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<UsersQuery, UsersQueryVariables>(UsersDocument, options);
      }
export function useUsersLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<UsersQuery, UsersQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<UsersQuery, UsersQueryVariables>(UsersDocument, options);
        }
export type UsersQueryHookResult = ReturnType<typeof useUsersQuery>;
export type UsersLazyQueryHookResult = ReturnType<typeof useUsersLazyQuery>;
export type UsersQueryResult = Apollo.QueryResult<UsersQuery, UsersQueryVariables>;
export const CreateUserDocument = gql`
    mutation createUser($user: UserInput!) {
  createUser(user: $user) {
    id
    warning
  }
}
    `;
export type CreateUserMutationFn = Apollo.MutationFunction<CreateUserMutation, CreateUserMutationVariables>;

/**
 * __useCreateUserMutation__
 *
 * To run a mutation, you first call `useCreateUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createUserMutation, { data, loading, error }] = useCreateUserMutation({
 *   variables: {
 *      user: // value for 'user'
 *   },
 * });
 */
export function useCreateUserMutation(baseOptions?: Apollo.MutationHookOptions<CreateUserMutation, CreateUserMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateUserMutation, CreateUserMutationVariables>(CreateUserDocument, options);
      }
export type CreateUserMutationHookResult = ReturnType<typeof useCreateUserMutation>;
export type CreateUserMutationResult = Apollo.MutationResult<CreateUserMutation>;
export type CreateUserMutationOptions = Apollo.BaseMutationOptions<CreateUserMutation, CreateUserMutationVariables>;
export const UpdateUserDocument = gql`
    mutation updateUser($id: ID!, $user: UserInput!) {
  updateUser(id: $id, user: $user)
}
    `;
export type UpdateUserMutationFn = Apollo.MutationFunction<UpdateUserMutation, UpdateUserMutationVariables>;

/**
 * __useUpdateUserMutation__
 *
 * To run a mutation, you first call `useUpdateUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateUserMutation, { data, loading, error }] = useUpdateUserMutation({
 *   variables: {
 *      id: // value for 'id'
 *      user: // value for 'user'
 *   },
 * });
 */
export function useUpdateUserMutation(baseOptions?: Apollo.MutationHookOptions<UpdateUserMutation, UpdateUserMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateUserMutation, UpdateUserMutationVariables>(UpdateUserDocument, options);
      }
export type UpdateUserMutationHookResult = ReturnType<typeof useUpdateUserMutation>;
export type UpdateUserMutationResult = Apollo.MutationResult<UpdateUserMutation>;
export type UpdateUserMutationOptions = Apollo.BaseMutationOptions<UpdateUserMutation, UpdateUserMutationVariables>;
export const DeleteUserDocument = gql`
    mutation deleteUser($id: ID!) {
  deleteUser(id: $id)
}
    `;
export type DeleteUserMutationFn = Apollo.MutationFunction<DeleteUserMutation, DeleteUserMutationVariables>;

/**
 * __useDeleteUserMutation__
 *
 * To run a mutation, you first call `useDeleteUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteUserMutation, { data, loading, error }] = useDeleteUserMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteUserMutation(baseOptions?: Apollo.MutationHookOptions<DeleteUserMutation, DeleteUserMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteUserMutation, DeleteUserMutationVariables>(DeleteUserDocument, options);
      }
export type DeleteUserMutationHookResult = ReturnType<typeof useDeleteUserMutation>;
export type DeleteUserMutationResult = Apollo.MutationResult<DeleteUserMutation>;
export type DeleteUserMutationOptions = Apollo.BaseMutationOptions<DeleteUserMutation, DeleteUserMutationVariables>;
export const UnblockUserDocument = gql`
    mutation unblockUser($id: ID!) {
  unblockUser(id: $id)
}
    `;
export type UnblockUserMutationFn = Apollo.MutationFunction<UnblockUserMutation, UnblockUserMutationVariables>;

/**
 * __useUnblockUserMutation__
 *
 * To run a mutation, you first call `useUnblockUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUnblockUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [unblockUserMutation, { data, loading, error }] = useUnblockUserMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUnblockUserMutation(baseOptions?: Apollo.MutationHookOptions<UnblockUserMutation, UnblockUserMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UnblockUserMutation, UnblockUserMutationVariables>(UnblockUserDocument, options);
      }
export type UnblockUserMutationHookResult = ReturnType<typeof useUnblockUserMutation>;
export type UnblockUserMutationResult = Apollo.MutationResult<UnblockUserMutation>;
export type UnblockUserMutationOptions = Apollo.BaseMutationOptions<UnblockUserMutation, UnblockUserMutationVariables>;
export const ChangePasswordDocument = gql`
    mutation changePassword($input: ChangePasswordInput!) {
  changePassword(input: $input)
}
    `;
export type ChangePasswordMutationFn = Apollo.MutationFunction<ChangePasswordMutation, ChangePasswordMutationVariables>;

/**
 * __useChangePasswordMutation__
 *
 * To run a mutation, you first call `useChangePasswordMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useChangePasswordMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [changePasswordMutation, { data, loading, error }] = useChangePasswordMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useChangePasswordMutation(baseOptions?: Apollo.MutationHookOptions<ChangePasswordMutation, ChangePasswordMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<ChangePasswordMutation, ChangePasswordMutationVariables>(ChangePasswordDocument, options);
      }
export type ChangePasswordMutationHookResult = ReturnType<typeof useChangePasswordMutation>;
export type ChangePasswordMutationResult = Apollo.MutationResult<ChangePasswordMutation>;
export type ChangePasswordMutationOptions = Apollo.BaseMutationOptions<ChangePasswordMutation, ChangePasswordMutationVariables>;
export const SetPasswordDocument = gql`
    mutation setPassword($input: SetPasswordInput!) {
  setPassword(input: $input)
}
    `;
export type SetPasswordMutationFn = Apollo.MutationFunction<SetPasswordMutation, SetPasswordMutationVariables>;

/**
 * __useSetPasswordMutation__
 *
 * To run a mutation, you first call `useSetPasswordMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useSetPasswordMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [setPasswordMutation, { data, loading, error }] = useSetPasswordMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useSetPasswordMutation(baseOptions?: Apollo.MutationHookOptions<SetPasswordMutation, SetPasswordMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<SetPasswordMutation, SetPasswordMutationVariables>(SetPasswordDocument, options);
      }
export type SetPasswordMutationHookResult = ReturnType<typeof useSetPasswordMutation>;
export type SetPasswordMutationResult = Apollo.MutationResult<SetPasswordMutation>;
export type SetPasswordMutationOptions = Apollo.BaseMutationOptions<SetPasswordMutation, SetPasswordMutationVariables>;
export const GroupsDocument = gql`
    query groups {
  groups {
    id
    name
    isSystemManaged
    users {
      id
      name
    }
    policies {
      id
      name
      isSystemManaged
    }
  }
}
    `;

/**
 * __useGroupsQuery__
 *
 * To run a query within a React component, call `useGroupsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGroupsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGroupsQuery({
 *   variables: {
 *   },
 * });
 */
export function useGroupsQuery(baseOptions?: Apollo.QueryHookOptions<GroupsQuery, GroupsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GroupsQuery, GroupsQueryVariables>(GroupsDocument, options);
      }
export function useGroupsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GroupsQuery, GroupsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GroupsQuery, GroupsQueryVariables>(GroupsDocument, options);
        }
export type GroupsQueryHookResult = ReturnType<typeof useGroupsQuery>;
export type GroupsLazyQueryHookResult = ReturnType<typeof useGroupsLazyQuery>;
export type GroupsQueryResult = Apollo.QueryResult<GroupsQuery, GroupsQueryVariables>;
export const CreateGroupDocument = gql`
    mutation createGroup($group: GroupInput!) {
  createGroup(group: $group) {
    id
    warning
  }
}
    `;
export type CreateGroupMutationFn = Apollo.MutationFunction<CreateGroupMutation, CreateGroupMutationVariables>;

/**
 * __useCreateGroupMutation__
 *
 * To run a mutation, you first call `useCreateGroupMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateGroupMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createGroupMutation, { data, loading, error }] = useCreateGroupMutation({
 *   variables: {
 *      group: // value for 'group'
 *   },
 * });
 */
export function useCreateGroupMutation(baseOptions?: Apollo.MutationHookOptions<CreateGroupMutation, CreateGroupMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateGroupMutation, CreateGroupMutationVariables>(CreateGroupDocument, options);
      }
export type CreateGroupMutationHookResult = ReturnType<typeof useCreateGroupMutation>;
export type CreateGroupMutationResult = Apollo.MutationResult<CreateGroupMutation>;
export type CreateGroupMutationOptions = Apollo.BaseMutationOptions<CreateGroupMutation, CreateGroupMutationVariables>;
export const UpdateGroupDocument = gql`
    mutation updateGroup($id: ID!, $group: GroupInput!) {
  updateGroup(id: $id, group: $group)
}
    `;
export type UpdateGroupMutationFn = Apollo.MutationFunction<UpdateGroupMutation, UpdateGroupMutationVariables>;

/**
 * __useUpdateGroupMutation__
 *
 * To run a mutation, you first call `useUpdateGroupMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateGroupMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateGroupMutation, { data, loading, error }] = useUpdateGroupMutation({
 *   variables: {
 *      id: // value for 'id'
 *      group: // value for 'group'
 *   },
 * });
 */
export function useUpdateGroupMutation(baseOptions?: Apollo.MutationHookOptions<UpdateGroupMutation, UpdateGroupMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateGroupMutation, UpdateGroupMutationVariables>(UpdateGroupDocument, options);
      }
export type UpdateGroupMutationHookResult = ReturnType<typeof useUpdateGroupMutation>;
export type UpdateGroupMutationResult = Apollo.MutationResult<UpdateGroupMutation>;
export type UpdateGroupMutationOptions = Apollo.BaseMutationOptions<UpdateGroupMutation, UpdateGroupMutationVariables>;
export const DeleteGroupDocument = gql`
    mutation deleteGroup($id: ID!) {
  deleteGroup(id: $id)
}
    `;
export type DeleteGroupMutationFn = Apollo.MutationFunction<DeleteGroupMutation, DeleteGroupMutationVariables>;

/**
 * __useDeleteGroupMutation__
 *
 * To run a mutation, you first call `useDeleteGroupMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteGroupMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteGroupMutation, { data, loading, error }] = useDeleteGroupMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteGroupMutation(baseOptions?: Apollo.MutationHookOptions<DeleteGroupMutation, DeleteGroupMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteGroupMutation, DeleteGroupMutationVariables>(DeleteGroupDocument, options);
      }
export type DeleteGroupMutationHookResult = ReturnType<typeof useDeleteGroupMutation>;
export type DeleteGroupMutationResult = Apollo.MutationResult<DeleteGroupMutation>;
export type DeleteGroupMutationOptions = Apollo.BaseMutationOptions<DeleteGroupMutation, DeleteGroupMutationVariables>;
export const PoliciesDocument = gql`
    query policies {
  policies {
    id
    name
    isSystemManaged
    statements {
      id
      name
      effect
      actions
      resources {
        id
        name
        type
      }
      allResources
    }
  }
}
    `;

/**
 * __usePoliciesQuery__
 *
 * To run a query within a React component, call `usePoliciesQuery` and pass it any options that fit your needs.
 * When your component renders, `usePoliciesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = usePoliciesQuery({
 *   variables: {
 *   },
 * });
 */
export function usePoliciesQuery(baseOptions?: Apollo.QueryHookOptions<PoliciesQuery, PoliciesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<PoliciesQuery, PoliciesQueryVariables>(PoliciesDocument, options);
      }
export function usePoliciesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<PoliciesQuery, PoliciesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<PoliciesQuery, PoliciesQueryVariables>(PoliciesDocument, options);
        }
export type PoliciesQueryHookResult = ReturnType<typeof usePoliciesQuery>;
export type PoliciesLazyQueryHookResult = ReturnType<typeof usePoliciesLazyQuery>;
export type PoliciesQueryResult = Apollo.QueryResult<PoliciesQuery, PoliciesQueryVariables>;
export const CreatePolicyDocument = gql`
    mutation createPolicy($policy: PolicyInput!) {
  createPolicy(policy: $policy) {
    id
    warning
  }
}
    `;
export type CreatePolicyMutationFn = Apollo.MutationFunction<CreatePolicyMutation, CreatePolicyMutationVariables>;

/**
 * __useCreatePolicyMutation__
 *
 * To run a mutation, you first call `useCreatePolicyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreatePolicyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createPolicyMutation, { data, loading, error }] = useCreatePolicyMutation({
 *   variables: {
 *      policy: // value for 'policy'
 *   },
 * });
 */
export function useCreatePolicyMutation(baseOptions?: Apollo.MutationHookOptions<CreatePolicyMutation, CreatePolicyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreatePolicyMutation, CreatePolicyMutationVariables>(CreatePolicyDocument, options);
      }
export type CreatePolicyMutationHookResult = ReturnType<typeof useCreatePolicyMutation>;
export type CreatePolicyMutationResult = Apollo.MutationResult<CreatePolicyMutation>;
export type CreatePolicyMutationOptions = Apollo.BaseMutationOptions<CreatePolicyMutation, CreatePolicyMutationVariables>;
export const UpdatePolicyDocument = gql`
    mutation updatePolicy($id: ID!, $policy: PolicyInput!) {
  updatePolicy(id: $id, policy: $policy)
}
    `;
export type UpdatePolicyMutationFn = Apollo.MutationFunction<UpdatePolicyMutation, UpdatePolicyMutationVariables>;

/**
 * __useUpdatePolicyMutation__
 *
 * To run a mutation, you first call `useUpdatePolicyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdatePolicyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updatePolicyMutation, { data, loading, error }] = useUpdatePolicyMutation({
 *   variables: {
 *      id: // value for 'id'
 *      policy: // value for 'policy'
 *   },
 * });
 */
export function useUpdatePolicyMutation(baseOptions?: Apollo.MutationHookOptions<UpdatePolicyMutation, UpdatePolicyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdatePolicyMutation, UpdatePolicyMutationVariables>(UpdatePolicyDocument, options);
      }
export type UpdatePolicyMutationHookResult = ReturnType<typeof useUpdatePolicyMutation>;
export type UpdatePolicyMutationResult = Apollo.MutationResult<UpdatePolicyMutation>;
export type UpdatePolicyMutationOptions = Apollo.BaseMutationOptions<UpdatePolicyMutation, UpdatePolicyMutationVariables>;
export const DeletePolicyDocument = gql`
    mutation deletePolicy($id: ID!) {
  deletePolicy(id: $id)
}
    `;
export type DeletePolicyMutationFn = Apollo.MutationFunction<DeletePolicyMutation, DeletePolicyMutationVariables>;

/**
 * __useDeletePolicyMutation__
 *
 * To run a mutation, you first call `useDeletePolicyMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeletePolicyMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deletePolicyMutation, { data, loading, error }] = useDeletePolicyMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeletePolicyMutation(baseOptions?: Apollo.MutationHookOptions<DeletePolicyMutation, DeletePolicyMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeletePolicyMutation, DeletePolicyMutationVariables>(DeletePolicyDocument, options);
      }
export type DeletePolicyMutationHookResult = ReturnType<typeof useDeletePolicyMutation>;
export type DeletePolicyMutationResult = Apollo.MutationResult<DeletePolicyMutation>;
export type DeletePolicyMutationOptions = Apollo.BaseMutationOptions<DeletePolicyMutation, DeletePolicyMutationVariables>;
export const CreatePolicyStatementDocument = gql`
    mutation createPolicyStatement($policyId: ID!, $statement: PolicyStatementInput!) {
  createPolicyStatement(policyId: $policyId, statement: $statement) {
    id
    warning
  }
}
    `;
export type CreatePolicyStatementMutationFn = Apollo.MutationFunction<CreatePolicyStatementMutation, CreatePolicyStatementMutationVariables>;

/**
 * __useCreatePolicyStatementMutation__
 *
 * To run a mutation, you first call `useCreatePolicyStatementMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreatePolicyStatementMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createPolicyStatementMutation, { data, loading, error }] = useCreatePolicyStatementMutation({
 *   variables: {
 *      policyId: // value for 'policyId'
 *      statement: // value for 'statement'
 *   },
 * });
 */
export function useCreatePolicyStatementMutation(baseOptions?: Apollo.MutationHookOptions<CreatePolicyStatementMutation, CreatePolicyStatementMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreatePolicyStatementMutation, CreatePolicyStatementMutationVariables>(CreatePolicyStatementDocument, options);
      }
export type CreatePolicyStatementMutationHookResult = ReturnType<typeof useCreatePolicyStatementMutation>;
export type CreatePolicyStatementMutationResult = Apollo.MutationResult<CreatePolicyStatementMutation>;
export type CreatePolicyStatementMutationOptions = Apollo.BaseMutationOptions<CreatePolicyStatementMutation, CreatePolicyStatementMutationVariables>;
export const UpdatePolicyStatementDocument = gql`
    mutation updatePolicyStatement($statementId: ID!, $statement: PolicyStatementInput!) {
  updatePolicyStatement(statementId: $statementId, statement: $statement)
}
    `;
export type UpdatePolicyStatementMutationFn = Apollo.MutationFunction<UpdatePolicyStatementMutation, UpdatePolicyStatementMutationVariables>;

/**
 * __useUpdatePolicyStatementMutation__
 *
 * To run a mutation, you first call `useUpdatePolicyStatementMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdatePolicyStatementMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updatePolicyStatementMutation, { data, loading, error }] = useUpdatePolicyStatementMutation({
 *   variables: {
 *      statementId: // value for 'statementId'
 *      statement: // value for 'statement'
 *   },
 * });
 */
export function useUpdatePolicyStatementMutation(baseOptions?: Apollo.MutationHookOptions<UpdatePolicyStatementMutation, UpdatePolicyStatementMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdatePolicyStatementMutation, UpdatePolicyStatementMutationVariables>(UpdatePolicyStatementDocument, options);
      }
export type UpdatePolicyStatementMutationHookResult = ReturnType<typeof useUpdatePolicyStatementMutation>;
export type UpdatePolicyStatementMutationResult = Apollo.MutationResult<UpdatePolicyStatementMutation>;
export type UpdatePolicyStatementMutationOptions = Apollo.BaseMutationOptions<UpdatePolicyStatementMutation, UpdatePolicyStatementMutationVariables>;
export const DeletePolicyStatementDocument = gql`
    mutation deletePolicyStatement($statementId: ID!) {
  deletePolicyStatement(statementId: $statementId)
}
    `;
export type DeletePolicyStatementMutationFn = Apollo.MutationFunction<DeletePolicyStatementMutation, DeletePolicyStatementMutationVariables>;

/**
 * __useDeletePolicyStatementMutation__
 *
 * To run a mutation, you first call `useDeletePolicyStatementMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeletePolicyStatementMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deletePolicyStatementMutation, { data, loading, error }] = useDeletePolicyStatementMutation({
 *   variables: {
 *      statementId: // value for 'statementId'
 *   },
 * });
 */
export function useDeletePolicyStatementMutation(baseOptions?: Apollo.MutationHookOptions<DeletePolicyStatementMutation, DeletePolicyStatementMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeletePolicyStatementMutation, DeletePolicyStatementMutationVariables>(DeletePolicyStatementDocument, options);
      }
export type DeletePolicyStatementMutationHookResult = ReturnType<typeof useDeletePolicyStatementMutation>;
export type DeletePolicyStatementMutationResult = Apollo.MutationResult<DeletePolicyStatementMutation>;
export type DeletePolicyStatementMutationOptions = Apollo.BaseMutationOptions<DeletePolicyStatementMutation, DeletePolicyStatementMutationVariables>;
export const ActionsDocument = gql`
    query actions {
  actions {
    action
    description
    resourceTypes
    deviceFunctionalAspectTypes
    accessLevel {
      level
      description
      order
    }
  }
}
    `;

/**
 * __useActionsQuery__
 *
 * To run a query within a React component, call `useActionsQuery` and pass it any options that fit your needs.
 * When your component renders, `useActionsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useActionsQuery({
 *   variables: {
 *   },
 * });
 */
export function useActionsQuery(baseOptions?: Apollo.QueryHookOptions<ActionsQuery, ActionsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ActionsQuery, ActionsQueryVariables>(ActionsDocument, options);
      }
export function useActionsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ActionsQuery, ActionsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ActionsQuery, ActionsQueryVariables>(ActionsDocument, options);
        }
export type ActionsQueryHookResult = ReturnType<typeof useActionsQuery>;
export type ActionsLazyQueryHookResult = ReturnType<typeof useActionsLazyQuery>;
export type ActionsQueryResult = Apollo.QueryResult<ActionsQuery, ActionsQueryVariables>;
export const AccessLevelsDocument = gql`
    query accessLevels {
  accessLevels {
    level
    description
    order
  }
}
    `;

/**
 * __useAccessLevelsQuery__
 *
 * To run a query within a React component, call `useAccessLevelsQuery` and pass it any options that fit your needs.
 * When your component renders, `useAccessLevelsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAccessLevelsQuery({
 *   variables: {
 *   },
 * });
 */
export function useAccessLevelsQuery(baseOptions?: Apollo.QueryHookOptions<AccessLevelsQuery, AccessLevelsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<AccessLevelsQuery, AccessLevelsQueryVariables>(AccessLevelsDocument, options);
      }
export function useAccessLevelsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<AccessLevelsQuery, AccessLevelsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<AccessLevelsQuery, AccessLevelsQueryVariables>(AccessLevelsDocument, options);
        }
export type AccessLevelsQueryHookResult = ReturnType<typeof useAccessLevelsQuery>;
export type AccessLevelsLazyQueryHookResult = ReturnType<typeof useAccessLevelsLazyQuery>;
export type AccessLevelsQueryResult = Apollo.QueryResult<AccessLevelsQuery, AccessLevelsQueryVariables>;
export const ZonesDocument = gql`
    query zones {
  zones {
    id
    name
    devices {
      id
      name
    }
  }
}
    `;

/**
 * __useZonesQuery__
 *
 * To run a query within a React component, call `useZonesQuery` and pass it any options that fit your needs.
 * When your component renders, `useZonesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useZonesQuery({
 *   variables: {
 *   },
 * });
 */
export function useZonesQuery(baseOptions?: Apollo.QueryHookOptions<ZonesQuery, ZonesQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<ZonesQuery, ZonesQueryVariables>(ZonesDocument, options);
      }
export function useZonesLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<ZonesQuery, ZonesQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<ZonesQuery, ZonesQueryVariables>(ZonesDocument, options);
        }
export type ZonesQueryHookResult = ReturnType<typeof useZonesQuery>;
export type ZonesLazyQueryHookResult = ReturnType<typeof useZonesLazyQuery>;
export type ZonesQueryResult = Apollo.QueryResult<ZonesQuery, ZonesQueryVariables>;
export const SetsDocument = gql`
    query sets {
  sets {
    id
    name
    isSystemManaged
    devices {
      id
      name
    }
  }
}
    `;

/**
 * __useSetsQuery__
 *
 * To run a query within a React component, call `useSetsQuery` and pass it any options that fit your needs.
 * When your component renders, `useSetsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSetsQuery({
 *   variables: {
 *   },
 * });
 */
export function useSetsQuery(baseOptions?: Apollo.QueryHookOptions<SetsQuery, SetsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<SetsQuery, SetsQueryVariables>(SetsDocument, options);
      }
export function useSetsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<SetsQuery, SetsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<SetsQuery, SetsQueryVariables>(SetsDocument, options);
        }
export type SetsQueryHookResult = ReturnType<typeof useSetsQuery>;
export type SetsLazyQueryHookResult = ReturnType<typeof useSetsLazyQuery>;
export type SetsQueryResult = Apollo.QueryResult<SetsQuery, SetsQueryVariables>;
export const GuisDocument = gql`
    query guis {
  guis {
    id
    name
  }
}
    `;

/**
 * __useGuisQuery__
 *
 * To run a query within a React component, call `useGuisQuery` and pass it any options that fit your needs.
 * When your component renders, `useGuisQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGuisQuery({
 *   variables: {
 *   },
 * });
 */
export function useGuisQuery(baseOptions?: Apollo.QueryHookOptions<GuisQuery, GuisQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GuisQuery, GuisQueryVariables>(GuisDocument, options);
      }
export function useGuisLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GuisQuery, GuisQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GuisQuery, GuisQueryVariables>(GuisDocument, options);
        }
export type GuisQueryHookResult = ReturnType<typeof useGuisQuery>;
export type GuisLazyQueryHookResult = ReturnType<typeof useGuisLazyQuery>;
export type GuisQueryResult = Apollo.QueryResult<GuisQuery, GuisQueryVariables>;
export const UserRealmsDocument = gql`
    query userRealms {
  userRealms {
    id
    name
    type
  }
}
    `;

/**
 * __useUserRealmsQuery__
 *
 * To run a query within a React component, call `useUserRealmsQuery` and pass it any options that fit your needs.
 * When your component renders, `useUserRealmsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useUserRealmsQuery({
 *   variables: {
 *   },
 * });
 */
export function useUserRealmsQuery(baseOptions?: Apollo.QueryHookOptions<UserRealmsQuery, UserRealmsQueryVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<UserRealmsQuery, UserRealmsQueryVariables>(UserRealmsDocument, options);
      }
export function useUserRealmsLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<UserRealmsQuery, UserRealmsQueryVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<UserRealmsQuery, UserRealmsQueryVariables>(UserRealmsDocument, options);
        }
export type UserRealmsQueryHookResult = ReturnType<typeof useUserRealmsQuery>;
export type UserRealmsLazyQueryHookResult = ReturnType<typeof useUserRealmsLazyQuery>;
export type UserRealmsQueryResult = Apollo.QueryResult<UserRealmsQuery, UserRealmsQueryVariables>;
export const SetUserRealmDocument = gql`
    mutation setUserRealm($userName: String!, $realmId: ID!) {
  setUserRealm(userName: $userName, realmId: $realmId)
}
    `;
export type SetUserRealmMutationFn = Apollo.MutationFunction<SetUserRealmMutation, SetUserRealmMutationVariables>;

/**
 * __useSetUserRealmMutation__
 *
 * To run a mutation, you first call `useSetUserRealmMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useSetUserRealmMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [setUserRealmMutation, { data, loading, error }] = useSetUserRealmMutation({
 *   variables: {
 *      userName: // value for 'userName'
 *      realmId: // value for 'realmId'
 *   },
 * });
 */
export function useSetUserRealmMutation(baseOptions?: Apollo.MutationHookOptions<SetUserRealmMutation, SetUserRealmMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<SetUserRealmMutation, SetUserRealmMutationVariables>(SetUserRealmDocument, options);
      }
export type SetUserRealmMutationHookResult = ReturnType<typeof useSetUserRealmMutation>;
export type SetUserRealmMutationResult = Apollo.MutationResult<SetUserRealmMutation>;
export type SetUserRealmMutationOptions = Apollo.BaseMutationOptions<SetUserRealmMutation, SetUserRealmMutationVariables>;
export const CreateZoneDocument = gql`
    mutation createZone($zone: ZoneInput!) {
  createZone(zone: $zone) {
    id
    warning
  }
}
    `;
export type CreateZoneMutationFn = Apollo.MutationFunction<CreateZoneMutation, CreateZoneMutationVariables>;

/**
 * __useCreateZoneMutation__
 *
 * To run a mutation, you first call `useCreateZoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateZoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createZoneMutation, { data, loading, error }] = useCreateZoneMutation({
 *   variables: {
 *      zone: // value for 'zone'
 *   },
 * });
 */
export function useCreateZoneMutation(baseOptions?: Apollo.MutationHookOptions<CreateZoneMutation, CreateZoneMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateZoneMutation, CreateZoneMutationVariables>(CreateZoneDocument, options);
      }
export type CreateZoneMutationHookResult = ReturnType<typeof useCreateZoneMutation>;
export type CreateZoneMutationResult = Apollo.MutationResult<CreateZoneMutation>;
export type CreateZoneMutationOptions = Apollo.BaseMutationOptions<CreateZoneMutation, CreateZoneMutationVariables>;
export const UpdateZoneDocument = gql`
    mutation updateZone($id: ID!, $zone: ZoneInput!) {
  updateZone(id: $id, zone: $zone)
}
    `;
export type UpdateZoneMutationFn = Apollo.MutationFunction<UpdateZoneMutation, UpdateZoneMutationVariables>;

/**
 * __useUpdateZoneMutation__
 *
 * To run a mutation, you first call `useUpdateZoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateZoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateZoneMutation, { data, loading, error }] = useUpdateZoneMutation({
 *   variables: {
 *      id: // value for 'id'
 *      zone: // value for 'zone'
 *   },
 * });
 */
export function useUpdateZoneMutation(baseOptions?: Apollo.MutationHookOptions<UpdateZoneMutation, UpdateZoneMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateZoneMutation, UpdateZoneMutationVariables>(UpdateZoneDocument, options);
      }
export type UpdateZoneMutationHookResult = ReturnType<typeof useUpdateZoneMutation>;
export type UpdateZoneMutationResult = Apollo.MutationResult<UpdateZoneMutation>;
export type UpdateZoneMutationOptions = Apollo.BaseMutationOptions<UpdateZoneMutation, UpdateZoneMutationVariables>;
export const DeleteZoneDocument = gql`
    mutation deleteZone($id: ID!) {
  deleteZone(id: $id)
}
    `;
export type DeleteZoneMutationFn = Apollo.MutationFunction<DeleteZoneMutation, DeleteZoneMutationVariables>;

/**
 * __useDeleteZoneMutation__
 *
 * To run a mutation, you first call `useDeleteZoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteZoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteZoneMutation, { data, loading, error }] = useDeleteZoneMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteZoneMutation(baseOptions?: Apollo.MutationHookOptions<DeleteZoneMutation, DeleteZoneMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteZoneMutation, DeleteZoneMutationVariables>(DeleteZoneDocument, options);
      }
export type DeleteZoneMutationHookResult = ReturnType<typeof useDeleteZoneMutation>;
export type DeleteZoneMutationResult = Apollo.MutationResult<DeleteZoneMutation>;
export type DeleteZoneMutationOptions = Apollo.BaseMutationOptions<DeleteZoneMutation, DeleteZoneMutationVariables>;
export const CreateSetDocument = gql`
    mutation createSet($set: SetInput!) {
  createSet(set: $set) {
    id
    warning
  }
}
    `;
export type CreateSetMutationFn = Apollo.MutationFunction<CreateSetMutation, CreateSetMutationVariables>;

/**
 * __useCreateSetMutation__
 *
 * To run a mutation, you first call `useCreateSetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateSetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createSetMutation, { data, loading, error }] = useCreateSetMutation({
 *   variables: {
 *      set: // value for 'set'
 *   },
 * });
 */
export function useCreateSetMutation(baseOptions?: Apollo.MutationHookOptions<CreateSetMutation, CreateSetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateSetMutation, CreateSetMutationVariables>(CreateSetDocument, options);
      }
export type CreateSetMutationHookResult = ReturnType<typeof useCreateSetMutation>;
export type CreateSetMutationResult = Apollo.MutationResult<CreateSetMutation>;
export type CreateSetMutationOptions = Apollo.BaseMutationOptions<CreateSetMutation, CreateSetMutationVariables>;
export const UpdateSetDocument = gql`
    mutation updateSet($id: ID!, $set: SetInput!) {
  updateSet(id: $id, set: $set)
}
    `;
export type UpdateSetMutationFn = Apollo.MutationFunction<UpdateSetMutation, UpdateSetMutationVariables>;

/**
 * __useUpdateSetMutation__
 *
 * To run a mutation, you first call `useUpdateSetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateSetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateSetMutation, { data, loading, error }] = useUpdateSetMutation({
 *   variables: {
 *      id: // value for 'id'
 *      set: // value for 'set'
 *   },
 * });
 */
export function useUpdateSetMutation(baseOptions?: Apollo.MutationHookOptions<UpdateSetMutation, UpdateSetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<UpdateSetMutation, UpdateSetMutationVariables>(UpdateSetDocument, options);
      }
export type UpdateSetMutationHookResult = ReturnType<typeof useUpdateSetMutation>;
export type UpdateSetMutationResult = Apollo.MutationResult<UpdateSetMutation>;
export type UpdateSetMutationOptions = Apollo.BaseMutationOptions<UpdateSetMutation, UpdateSetMutationVariables>;
export const DeleteSetDocument = gql`
    mutation deleteSet($id: ID!) {
  deleteSet(id: $id)
}
    `;
export type DeleteSetMutationFn = Apollo.MutationFunction<DeleteSetMutation, DeleteSetMutationVariables>;

/**
 * __useDeleteSetMutation__
 *
 * To run a mutation, you first call `useDeleteSetMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteSetMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteSetMutation, { data, loading, error }] = useDeleteSetMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteSetMutation(baseOptions?: Apollo.MutationHookOptions<DeleteSetMutation, DeleteSetMutationVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<DeleteSetMutation, DeleteSetMutationVariables>(DeleteSetDocument, options);
      }
export type DeleteSetMutationHookResult = ReturnType<typeof useDeleteSetMutation>;
export type DeleteSetMutationResult = Apollo.MutationResult<DeleteSetMutation>;
export type DeleteSetMutationOptions = Apollo.BaseMutationOptions<DeleteSetMutation, DeleteSetMutationVariables>;

      export interface PossibleTypesResultData {
        possibleTypes: {
          [key: string]: string[]
        }
      }
      const result: PossibleTypesResultData = {
  "possibleTypes": {
    "AuditEntryEvent": [
      "AuditEntry",
      "ErrorInfo"
    ],
    "DeviceFunctionalAspect": [
      "DFA_Avatar",
      "DFA_Gateway",
      "DFA_Media",
      "DFA_PTZ",
      "DFA_Sensor",
      "DFA_VAE"
    ],
    "RealmObject": [
      "CurrentRealm",
      "Device",
      "GenericObject",
      "Group",
      "Policy",
      "Set",
      "User",
      "Zone"
    ],
    "Report": [
      "NumericReport",
      "StatusReport"
    ]
  }
};
      export default result;
    
export type WithIndex<TObject> = TObject & Record<string, any>;
export type ResolversObject<TObject> = WithIndex<TObject>;

export type ResolverTypeWrapper<T> = Promise<T> | T;


export type ResolverWithResolve<TResult, TParent, TContext, TArgs> = {
  resolve: ResolverFn<TResult, TParent, TContext, TArgs>;
};
export type Resolver<TResult, TParent = {}, TContext = {}, TArgs = {}> = ResolverFn<TResult, TParent, TContext, TArgs> | ResolverWithResolve<TResult, TParent, TContext, TArgs>;

export type ResolverFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => Promise<TResult> | TResult;

export type SubscriptionSubscribeFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => AsyncIterable<TResult> | Promise<AsyncIterable<TResult>>;

export type SubscriptionResolveFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => TResult | Promise<TResult>;

export interface SubscriptionSubscriberObject<TResult, TKey extends string, TParent, TContext, TArgs> {
  subscribe: SubscriptionSubscribeFn<{ [key in TKey]: TResult }, TParent, TContext, TArgs>;
  resolve?: SubscriptionResolveFn<TResult, { [key in TKey]: TResult }, TContext, TArgs>;
}

export interface SubscriptionResolverObject<TResult, TParent, TContext, TArgs> {
  subscribe: SubscriptionSubscribeFn<any, TParent, TContext, TArgs>;
  resolve: SubscriptionResolveFn<TResult, any, TContext, TArgs>;
}

export type SubscriptionObject<TResult, TKey extends string, TParent, TContext, TArgs> =
  | SubscriptionSubscriberObject<TResult, TKey, TParent, TContext, TArgs>
  | SubscriptionResolverObject<TResult, TParent, TContext, TArgs>;

export type SubscriptionResolver<TResult, TKey extends string, TParent = {}, TContext = {}, TArgs = {}> =
  | ((...args: any[]) => SubscriptionObject<TResult, TKey, TParent, TContext, TArgs>)
  | SubscriptionObject<TResult, TKey, TParent, TContext, TArgs>;

export type TypeResolveFn<TTypes, TParent = {}, TContext = {}> = (
  parent: TParent,
  context: TContext,
  info: GraphQLResolveInfo
) => Maybe<TTypes> | Promise<Maybe<TTypes>>;

export type IsTypeOfResolverFn<T = {}, TContext = {}> = (obj: T, context: TContext, info: GraphQLResolveInfo) => boolean | Promise<boolean>;

export type NextResolverFn<T> = () => Promise<T>;

export type DirectiveResolverFn<TResult = {}, TParent = {}, TContext = {}, TArgs = {}> = (
  next: NextResolverFn<TResult>,
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => TResult | Promise<TResult>;

/** Mapping between all available schema types and the resolvers types */
export type ResolversTypes = ResolversObject<{
  AccessLevel: ResolverTypeWrapper<AccessLevel>;
  AcknowledgeAuditEntryInput: AcknowledgeAuditEntryInput;
  AcknowledgementEntry: AcknowledgementEntry;
  Action: ResolverTypeWrapper<Action>;
  ActivityId: ActivityId;
  AodRequest: ResolverTypeWrapper<AodRequest>;
  AodRequestFiles: ResolverTypeWrapper<AodRequestFiles>;
  AodRequestFilesListEntry: ResolverTypeWrapper<AodRequestFilesListEntry>;
  AodRequestFilter: AodRequestFilter;
  AodRequestInput: AodRequestInput;
  AodRequestStatus: AodRequestStatus;
  AodRequestType: AodRequestType;
  AppStore: ResolverTypeWrapper<AppStore>;
  AppStoreInput: AppStoreInput;
  ArchiveBoundary: ResolverTypeWrapper<ArchiveBoundary>;
  ArchiveCoverage: ResolverTypeWrapper<ArchiveCoverage>;
  ArchiveCoverageItem: ResolverTypeWrapper<ArchiveCoverageItem>;
  ArchiveCoverageTTL: ResolverTypeWrapper<ArchiveCoverageTtl>;
  AspectHealth: ResolverTypeWrapper<AspectHealth>;
  AspectHealthFilter: AspectHealthFilter;
  AspectSensorCategory: AspectSensorCategory;
  AspectSensorModel: AspectSensorModel;
  AssociatedGatewayDevice: ResolverTypeWrapper<AssociatedGatewayDevice>;
  AssociatedGatewayDeviceInput: AssociatedGatewayDeviceInput;
  AuditCategory: ResolverTypeWrapper<AuditCategory>;
  AuditEntry: ResolverTypeWrapper<AuditEntry>;
  AuditEntryEvent: ResolversTypes['AuditEntry'] | ResolversTypes['ErrorInfo'];
  AuditEntryFilter: AuditEntryFilter;
  AuditEntryInput: AuditEntryInput;
  AuditSnapshot: ResolverTypeWrapper<AuditSnapshot>;
  AuditSnapshotInput: AuditSnapshotInput;
  AuthType: AuthType;
  AvatarMetric: ResolverTypeWrapper<AvatarMetric>;
  AvatarMetricName: AvatarMetricName;
  BaseDeviceType: BaseDeviceType;
  BasicAccessConfiguration: BasicAccessConfiguration;
  Boolean: ResolverTypeWrapper<Scalars['Boolean']>;
  BoundaryFind: BoundaryFind;
  BrandInfo: ResolverTypeWrapper<BrandInfo>;
  Branding: ResolverTypeWrapper<Branding>;
  BrandingInput: BrandingInput;
  CameraLog: ResolverTypeWrapper<CameraLog>;
  CameraMetric: ResolverTypeWrapper<CameraMetric>;
  CameraMetricName: CameraMetricName;
  CameraWidgetProps: ResolverTypeWrapper<CameraWidgetProps>;
  CameraWidgetPropsInput: CameraWidgetPropsInput;
  ChangeCurrentPasswordInput: ChangeCurrentPasswordInput;
  ChangePasswordInput: ChangePasswordInput;
  ChannelBenchmark: ResolverTypeWrapper<ChannelBenchmark>;
  ChannelStatistics: ResolverTypeWrapper<ChannelStatistics>;
  ChannelStatus: ChannelStatus;
  CreateResult: ResolverTypeWrapper<CreateResult>;
  CreatingView: ResolverTypeWrapper<CreatingView>;
  CreatingViewInput: CreatingViewInput;
  CurrentRealm: ResolverTypeWrapper<CurrentRealm>;
  CurrentRealmInput: CurrentRealmInput;
  DFA_Avatar: ResolverTypeWrapper<Dfa_Avatar>;
  DFA_Gateway: ResolverTypeWrapper<Dfa_Gateway>;
  DFA_Media: ResolverTypeWrapper<Dfa_Media>;
  DFA_PTZ: ResolverTypeWrapper<Dfa_Ptz>;
  DFA_Sensor: ResolverTypeWrapper<Dfa_Sensor>;
  DFA_VAE: ResolverTypeWrapper<Dfa_Vae>;
  DSConfiguredState: DsConfiguredState;
  DSRunningState: DsRunningState;
  DateTime: ResolverTypeWrapper<Scalars['DateTime']>;
  DefaultGeoPosition: ResolverTypeWrapper<DefaultGeoPosition>;
  DeliveryPriorityInput: DeliveryPriorityInput;
  Device: ResolverTypeWrapper<Device>;
  DeviceBaseConfig: ResolverTypeWrapper<DeviceBaseConfig>;
  DeviceBaseConfigInput: DeviceBaseConfigInput;
  DeviceBaseConfigType: DeviceBaseConfigType;
  DeviceCommand: DeviceCommand;
  DeviceEventType: DeviceEventType;
  DeviceFunctionalAspect: ResolversTypes['DFA_Avatar'] | ResolversTypes['DFA_Gateway'] | ResolversTypes['DFA_Media'] | ResolversTypes['DFA_PTZ'] | ResolversTypes['DFA_Sensor'] | ResolversTypes['DFA_VAE'];
  DeviceFunctionalAspectFilter: DeviceFunctionalAspectFilter;
  DeviceFunctionalAspectInput: DeviceFunctionalAspectInput;
  DeviceFunctionalAspectType: DeviceFunctionalAspectType;
  DeviceInput: DeviceInput;
  DeviceProbe: ResolverTypeWrapper<DeviceProbe>;
  DeviceProbeInput: DeviceProbeInput;
  DeviceStorageConfig: ResolverTypeWrapper<DeviceStorageConfig>;
  DeviceStorageConfigInput: DeviceStorageConfigInput;
  DeviceTemplate: ResolverTypeWrapper<DeviceTemplate>;
  DeviceTemplateModel: ResolverTypeWrapper<DeviceTemplateModel>;
  EmailAddresses: EmailAddresses;
  EmailAuth: EmailAuth;
  EncryptionKeyInfo: ResolverTypeWrapper<EncryptionKeyInfo>;
  ErrorInfo: ResolverTypeWrapper<ErrorInfo>;
  EventInfo: ResolverTypeWrapper<EventInfo>;
  EventInfoInput: EventInfoInput;
  FA_HealthGravity: Fa_HealthGravity;
  Feature: ResolverTypeWrapper<Feature>;
  FeatureDesc: ResolverTypeWrapper<FeatureDesc>;
  FeatureInput: FeatureInput;
  FeatureType: FeatureType;
  Filter: Filter;
  Float: ResolverTypeWrapper<Scalars['Float']>;
  FunctionalAspectTemplate: ResolverTypeWrapper<FunctionalAspectTemplate>;
  GEOLayer: ResolverTypeWrapper<GeoLayer>;
  GEOLayerInput: GeoLayerInput;
  GEOLayers: ResolverTypeWrapper<GeoLayers>;
  GEOLayersInput: GeoLayersInput;
  GatewayDeviceInput: GatewayDeviceInput;
  GatewayDirectoriesProbe: ResolverTypeWrapper<GatewayDirectoriesProbe>;
  GatewayDirectoriesProbeInput: GatewayDirectoriesProbeInput;
  GatewayDirectory: ResolverTypeWrapper<GatewayDirectory>;
  GatewayDirectoryInput: GatewayDirectoryInput;
  GatewayEvent: ResolverTypeWrapper<GatewayEvent>;
  GatewayEventInput: GatewayEventInput;
  GatewayModel: GatewayModel;
  GatewayProbe: ResolverTypeWrapper<GatewayProbe>;
  GatewayProbeDevice: ResolverTypeWrapper<GatewayProbeDevice>;
  GatewayProbeEvent: ResolverTypeWrapper<GatewayProbeEvent>;
  GatewayProbeInput: GatewayProbeInput;
  GenericObject: ResolverTypeWrapper<GenericObject>;
  GenericObjectInput: GenericObjectInput;
  Group: ResolverTypeWrapper<Group>;
  GroupInput: GroupInput;
  Gui: ResolverTypeWrapper<Gui>;
  HealthStatus: HealthStatus;
  Hierarchy: ResolverTypeWrapper<Hierarchy>;
  HierarchyInput: HierarchyInput;
  HierarchyLevel: ResolverTypeWrapper<HierarchyLevel>;
  HierarchyLevelInput: HierarchyLevelInput;
  ID: ResolverTypeWrapper<Scalars['ID']>;
  IdentityAttribute: ResolverTypeWrapper<IdentityAttribute>;
  ImageMap: ResolverTypeWrapper<ImageMap>;
  ImageMapConfig: ResolverTypeWrapper<ImageMapConfig>;
  ImageMapInput: ImageMapInput;
  ImageMapLayer: ResolverTypeWrapper<ImageMapLayer>;
  ImageMapLayerInput: ImageMapLayerInput;
  ImageMapObject: ResolverTypeWrapper<ImageMapObject>;
  ImageMapObjectInput: ImageMapObjectInput;
  ImageMapSet: ResolverTypeWrapper<ImageMapSet>;
  ImageMapSetInput: ImageMapSetInput;
  ImageMapUpdateAction: ImageMapUpdateAction;
  ImageMapUpdateNotification: ResolverTypeWrapper<ImageMapUpdateNotification>;
  Int: ResolverTypeWrapper<Scalars['Int']>;
  JSON: ResolverTypeWrapper<Scalars['JSON']>;
  JSONObject: ResolverTypeWrapper<Scalars['JSONObject']>;
  KeyValue: ResolverTypeWrapper<KeyValue>;
  KeyValueInput: KeyValueInput;
  Label: ResolverTypeWrapper<Label>;
  LabelInput: LabelInput;
  LabelObject: ResolverTypeWrapper<LabelObject>;
  LabelOrHierarchyUpdate: ResolverTypeWrapper<LabelOrHierarchyUpdate>;
  LabelOrHierarchyUpdateType: LabelOrHierarchyUpdateType;
  LabelType: LabelType;
  Language: ResolverTypeWrapper<Language>;
  Languages: ResolverTypeWrapper<Languages>;
  LatLng: ResolverTypeWrapper<LatLng>;
  LatLngInput: LatLngInput;
  License: ResolverTypeWrapper<License>;
  LocalStorage: ResolverTypeWrapper<LocalStorage>;
  LocalStorageInput: LocalStorageInput;
  LogSeverity: LogSeverity;
  MediaArchiveOption: MediaArchiveOption;
  MediaStreamType: MediaStreamType;
  MetaClassifier: ResolverTypeWrapper<MetaClassifier>;
  MetaEntry: ResolverTypeWrapper<MetaEntry>;
  MetricDimension: MetricDimension;
  ModifiedByInfo: ResolverTypeWrapper<ModifiedByInfo>;
  Mutation: ResolverTypeWrapper<{}>;
  NetworkConnectDescriptor: ResolverTypeWrapper<NetworkConnectDescriptor>;
  NetworkConnectDescriptorInput: NetworkConnectDescriptorInput;
  NumericReport: ResolverTypeWrapper<NumericReport>;
  ObjUUID: ResolverTypeWrapper<ObjUuid>;
  ObjUUIDAndName: ResolverTypeWrapper<ObjUuidAndName>;
  ObjUUIDAndNameInput: ObjUuidAndNameInput;
  ObjUUIDInput: ObjUuidInput;
  ObjectAction: ObjectAction;
  ObjectDescriptor: ResolverTypeWrapper<ObjectDescriptor>;
  ObjectUpdateEvent: ResolverTypeWrapper<ObjectUpdateEvent>;
  ObjectUpdateFilter: ObjectUpdateFilter;
  Owner: ResolverTypeWrapper<Owner>;
  OwnerInput: OwnerInput;
  PTZ_Class: Ptz_Class;
  PTZ_PresetInput: Ptz_PresetInput;
  PTZ_RelInput: Ptz_RelInput;
  PTZ_RelSizeInput: Ptz_RelSizeInput;
  PTZ_SpeedInput: Ptz_SpeedInput;
  PTZ_StepFocus: Ptz_StepFocus;
  PTZ_StepGain: Ptz_StepGain;
  PTZ_StepInput: Ptz_StepInput;
  PTZ_StepIris: Ptz_StepIris;
  PTZ_StepMove: Ptz_StepMove;
  PTZ_StepZoom: Ptz_StepZoom;
  Policy: ResolverTypeWrapper<Policy>;
  PolicyInput: PolicyInput;
  PolicyStatement: ResolverTypeWrapper<PolicyStatement>;
  PolicyStatementInput: PolicyStatementInput;
  PoolLocalStorage: ResolverTypeWrapper<PoolLocalStorage>;
  PoolLocalStorageInput: PoolLocalStorageInput;
  Position: ResolverTypeWrapper<Position>;
  PositionInput: PositionInput;
  ProtocolType: ProtocolType;
  Query: ResolverTypeWrapper<{}>;
  Realm: ResolverTypeWrapper<Realm>;
  RealmInput: RealmInput;
  RealmObject: ResolversTypes['CurrentRealm'] | ResolversTypes['Device'] | ResolversTypes['GenericObject'] | ResolversTypes['Group'] | ResolversTypes['Policy'] | ResolversTypes['Set'] | ResolversTypes['User'] | ResolversTypes['Zone'];
  RealmObjectInput: RealmObjectInput;
  RealmObjectType: RealmObjectType;
  RealmSubscription: ResolverTypeWrapper<RealmSubscription>;
  RealmSubscriptionInput: RealmSubscriptionInput;
  RealmSubscriptionType: RealmSubscriptionType;
  Report: ResolversTypes['NumericReport'] | ResolversTypes['StatusReport'];
  Reseller: ResolverTypeWrapper<Reseller>;
  SecretPassword: SecretPassword;
  SensorEvent: ResolverTypeWrapper<SensorEvent>;
  SensorEventInput: SensorEventInput;
  Session: ResolverTypeWrapper<Session>;
  SessionCloseEvent: ResolverTypeWrapper<SessionCloseEvent>;
  SessionCloseReason: SessionCloseReason;
  SessionInfo: ResolverTypeWrapper<SessionInfo>;
  SessionInfoInput: SessionInfoInput;
  SessionInput: SessionInput;
  Set: ResolverTypeWrapper<Set>;
  SetInput: SetInput;
  SetPasswordInput: SetPasswordInput;
  SharedViewsUpdateEvent: ResolverTypeWrapper<SharedViewsUpdateEvent>;
  SocketEvent: ResolverTypeWrapper<SocketEvent>;
  SocketEventInput: SocketEventInput;
  SocketEventType: SocketEventType;
  SoftwareInfo: ResolverTypeWrapper<SoftwareInfo>;
  SolidConfigCurrentViewInput: SolidConfigCurrentViewInput;
  SolidConfigUpdateEvent: ResolverTypeWrapper<SolidConfigUpdateEvent>;
  SolidConfiguration: ResolverTypeWrapper<SolidConfiguration>;
  SolidConfigurationInput: SolidConfigurationInput;
  StatTime: ResolverTypeWrapper<StatTime>;
  StatementEffect: StatementEffect;
  StatusMetric: StatusMetric;
  StatusReport: ResolverTypeWrapper<StatusReport>;
  StoragePool: ResolverTypeWrapper<StoragePool>;
  StorageUsage: ResolverTypeWrapper<StorageUsage>;
  StreamShare: ResolverTypeWrapper<StreamShare>;
  StreamUsagePeriod: StreamUsagePeriod;
  String: ResolverTypeWrapper<Scalars['String']>;
  SubStoragePool: ResolverTypeWrapper<SubStoragePool>;
  SubStoragePoolInput: SubStoragePoolInput;
  SubscribedGatewayEventInput: SubscribedGatewayEventInput;
  Subscription: ResolverTypeWrapper<{}>;
  SubscriptionStatus: SubscriptionStatus;
  SystemParameters: ResolverTypeWrapper<SystemParameters>;
  SystemStatus: SystemStatus;
  SystemStatusInfo: ResolverTypeWrapper<SystemStatusInfo>;
  SystemStatusReason: ResolverTypeWrapper<SystemStatusReason>;
  SystemStatusReasonObject: ResolverTypeWrapper<SystemStatusReasonObject>;
  UUID: ResolverTypeWrapper<Scalars['UUID']>;
  UnitType: UnitType;
  UpdateResult: ResolverTypeWrapper<UpdateResult>;
  User: ResolverTypeWrapper<User>;
  UserData: ResolverTypeWrapper<UserData>;
  UserDataInput: UserDataInput;
  UserInfo: ResolverTypeWrapper<UserInfo>;
  UserInfoInput: UserInfoInput;
  UserInput: UserInput;
  VMXVideoStreamingMode: VmxVideoStreamingMode;
  VaeConfigBrief: ResolverTypeWrapper<VaeConfigBrief>;
  VaeConfigFull: ResolverTypeWrapper<VaeConfigFull>;
  VaeFeature: ResolverTypeWrapper<VaeFeature>;
  VaeUpdate: ResolverTypeWrapper<VaeUpdate>;
  VaeUpdateStatus: VaeUpdateStatus;
  ViewConfig: ResolverTypeWrapper<ViewConfig>;
  ViewConfigInput: ViewConfigInput;
  ViewId: ViewId;
  WarningField: ResolverTypeWrapper<WarningField>;
  WidgetConfig: ResolverTypeWrapper<WidgetConfig>;
  WidgetConfigInput: WidgetConfigInput;
  WidgetId: WidgetId;
  WidgetInfo: ResolverTypeWrapper<WidgetInfo>;
  WidgetInfoInput: WidgetInfoInput;
  Workspace: ResolverTypeWrapper<Workspace>;
  WorkspaceInput: WorkspaceInput;
  Zone: ResolverTypeWrapper<Zone>;
  ZoneInput: ZoneInput;
}>;

/** Mapping between all available schema types and the resolvers parents */
export type ResolversParentTypes = ResolversObject<{
  AccessLevel: AccessLevel;
  AcknowledgeAuditEntryInput: AcknowledgeAuditEntryInput;
  AcknowledgementEntry: AcknowledgementEntry;
  Action: Action;
  AodRequest: AodRequest;
  AodRequestFiles: AodRequestFiles;
  AodRequestFilesListEntry: AodRequestFilesListEntry;
  AodRequestFilter: AodRequestFilter;
  AodRequestInput: AodRequestInput;
  AppStore: AppStore;
  AppStoreInput: AppStoreInput;
  ArchiveBoundary: ArchiveBoundary;
  ArchiveCoverage: ArchiveCoverage;
  ArchiveCoverageItem: ArchiveCoverageItem;
  ArchiveCoverageTTL: ArchiveCoverageTtl;
  AspectHealth: AspectHealth;
  AspectHealthFilter: AspectHealthFilter;
  AssociatedGatewayDevice: AssociatedGatewayDevice;
  AssociatedGatewayDeviceInput: AssociatedGatewayDeviceInput;
  AuditCategory: AuditCategory;
  AuditEntry: AuditEntry;
  AuditEntryEvent: ResolversParentTypes['AuditEntry'] | ResolversParentTypes['ErrorInfo'];
  AuditEntryFilter: AuditEntryFilter;
  AuditEntryInput: AuditEntryInput;
  AuditSnapshot: AuditSnapshot;
  AuditSnapshotInput: AuditSnapshotInput;
  AvatarMetric: AvatarMetric;
  Boolean: Scalars['Boolean'];
  BrandInfo: BrandInfo;
  Branding: Branding;
  BrandingInput: BrandingInput;
  CameraLog: CameraLog;
  CameraMetric: CameraMetric;
  CameraWidgetProps: CameraWidgetProps;
  CameraWidgetPropsInput: CameraWidgetPropsInput;
  ChangeCurrentPasswordInput: ChangeCurrentPasswordInput;
  ChangePasswordInput: ChangePasswordInput;
  ChannelBenchmark: ChannelBenchmark;
  ChannelStatistics: ChannelStatistics;
  CreateResult: CreateResult;
  CreatingView: CreatingView;
  CreatingViewInput: CreatingViewInput;
  CurrentRealm: CurrentRealm;
  CurrentRealmInput: CurrentRealmInput;
  DFA_Avatar: Dfa_Avatar;
  DFA_Gateway: Dfa_Gateway;
  DFA_Media: Dfa_Media;
  DFA_PTZ: Dfa_Ptz;
  DFA_Sensor: Dfa_Sensor;
  DFA_VAE: Dfa_Vae;
  DateTime: Scalars['DateTime'];
  DefaultGeoPosition: DefaultGeoPosition;
  DeliveryPriorityInput: DeliveryPriorityInput;
  Device: Device;
  DeviceBaseConfig: DeviceBaseConfig;
  DeviceBaseConfigInput: DeviceBaseConfigInput;
  DeviceFunctionalAspect: ResolversParentTypes['DFA_Avatar'] | ResolversParentTypes['DFA_Gateway'] | ResolversParentTypes['DFA_Media'] | ResolversParentTypes['DFA_PTZ'] | ResolversParentTypes['DFA_Sensor'] | ResolversParentTypes['DFA_VAE'];
  DeviceFunctionalAspectFilter: DeviceFunctionalAspectFilter;
  DeviceFunctionalAspectInput: DeviceFunctionalAspectInput;
  DeviceInput: DeviceInput;
  DeviceProbe: DeviceProbe;
  DeviceProbeInput: DeviceProbeInput;
  DeviceStorageConfig: DeviceStorageConfig;
  DeviceStorageConfigInput: DeviceStorageConfigInput;
  DeviceTemplate: DeviceTemplate;
  DeviceTemplateModel: DeviceTemplateModel;
  EmailAddresses: EmailAddresses;
  EncryptionKeyInfo: EncryptionKeyInfo;
  ErrorInfo: ErrorInfo;
  EventInfo: EventInfo;
  EventInfoInput: EventInfoInput;
  Feature: Feature;
  FeatureDesc: FeatureDesc;
  FeatureInput: FeatureInput;
  Filter: Filter;
  Float: Scalars['Float'];
  FunctionalAspectTemplate: FunctionalAspectTemplate;
  GEOLayer: GeoLayer;
  GEOLayerInput: GeoLayerInput;
  GEOLayers: GeoLayers;
  GEOLayersInput: GeoLayersInput;
  GatewayDeviceInput: GatewayDeviceInput;
  GatewayDirectoriesProbe: GatewayDirectoriesProbe;
  GatewayDirectoriesProbeInput: GatewayDirectoriesProbeInput;
  GatewayDirectory: GatewayDirectory;
  GatewayDirectoryInput: GatewayDirectoryInput;
  GatewayEvent: GatewayEvent;
  GatewayEventInput: GatewayEventInput;
  GatewayProbe: GatewayProbe;
  GatewayProbeDevice: GatewayProbeDevice;
  GatewayProbeEvent: GatewayProbeEvent;
  GatewayProbeInput: GatewayProbeInput;
  GenericObject: GenericObject;
  GenericObjectInput: GenericObjectInput;
  Group: Group;
  GroupInput: GroupInput;
  Gui: Gui;
  Hierarchy: Hierarchy;
  HierarchyInput: HierarchyInput;
  HierarchyLevel: HierarchyLevel;
  HierarchyLevelInput: HierarchyLevelInput;
  ID: Scalars['ID'];
  IdentityAttribute: IdentityAttribute;
  ImageMap: ImageMap;
  ImageMapConfig: ImageMapConfig;
  ImageMapInput: ImageMapInput;
  ImageMapLayer: ImageMapLayer;
  ImageMapLayerInput: ImageMapLayerInput;
  ImageMapObject: ImageMapObject;
  ImageMapObjectInput: ImageMapObjectInput;
  ImageMapSet: ImageMapSet;
  ImageMapSetInput: ImageMapSetInput;
  ImageMapUpdateNotification: ImageMapUpdateNotification;
  Int: Scalars['Int'];
  JSON: Scalars['JSON'];
  JSONObject: Scalars['JSONObject'];
  KeyValue: KeyValue;
  KeyValueInput: KeyValueInput;
  Label: Label;
  LabelInput: LabelInput;
  LabelObject: LabelObject;
  LabelOrHierarchyUpdate: LabelOrHierarchyUpdate;
  Language: Language;
  Languages: Languages;
  LatLng: LatLng;
  LatLngInput: LatLngInput;
  License: License;
  LocalStorage: LocalStorage;
  LocalStorageInput: LocalStorageInput;
  MetaClassifier: MetaClassifier;
  MetaEntry: MetaEntry;
  ModifiedByInfo: ModifiedByInfo;
  Mutation: {};
  NetworkConnectDescriptor: NetworkConnectDescriptor;
  NetworkConnectDescriptorInput: NetworkConnectDescriptorInput;
  NumericReport: NumericReport;
  ObjUUID: ObjUuid;
  ObjUUIDAndName: ObjUuidAndName;
  ObjUUIDAndNameInput: ObjUuidAndNameInput;
  ObjUUIDInput: ObjUuidInput;
  ObjectDescriptor: ObjectDescriptor;
  ObjectUpdateEvent: ObjectUpdateEvent;
  ObjectUpdateFilter: ObjectUpdateFilter;
  Owner: Owner;
  OwnerInput: OwnerInput;
  PTZ_PresetInput: Ptz_PresetInput;
  PTZ_RelInput: Ptz_RelInput;
  PTZ_RelSizeInput: Ptz_RelSizeInput;
  PTZ_SpeedInput: Ptz_SpeedInput;
  PTZ_StepInput: Ptz_StepInput;
  Policy: Policy;
  PolicyInput: PolicyInput;
  PolicyStatement: PolicyStatement;
  PolicyStatementInput: PolicyStatementInput;
  PoolLocalStorage: PoolLocalStorage;
  PoolLocalStorageInput: PoolLocalStorageInput;
  Position: Position;
  PositionInput: PositionInput;
  Query: {};
  Realm: Realm;
  RealmInput: RealmInput;
  RealmObject: ResolversParentTypes['CurrentRealm'] | ResolversParentTypes['Device'] | ResolversParentTypes['GenericObject'] | ResolversParentTypes['Group'] | ResolversParentTypes['Policy'] | ResolversParentTypes['Set'] | ResolversParentTypes['User'] | ResolversParentTypes['Zone'];
  RealmObjectInput: RealmObjectInput;
  RealmSubscription: RealmSubscription;
  RealmSubscriptionInput: RealmSubscriptionInput;
  Report: ResolversParentTypes['NumericReport'] | ResolversParentTypes['StatusReport'];
  Reseller: Reseller;
  SecretPassword: SecretPassword;
  SensorEvent: SensorEvent;
  SensorEventInput: SensorEventInput;
  Session: Session;
  SessionCloseEvent: SessionCloseEvent;
  SessionInfo: SessionInfo;
  SessionInfoInput: SessionInfoInput;
  SessionInput: SessionInput;
  Set: Set;
  SetInput: SetInput;
  SetPasswordInput: SetPasswordInput;
  SharedViewsUpdateEvent: SharedViewsUpdateEvent;
  SocketEvent: SocketEvent;
  SocketEventInput: SocketEventInput;
  SoftwareInfo: SoftwareInfo;
  SolidConfigCurrentViewInput: SolidConfigCurrentViewInput;
  SolidConfigUpdateEvent: SolidConfigUpdateEvent;
  SolidConfiguration: SolidConfiguration;
  SolidConfigurationInput: SolidConfigurationInput;
  StatTime: StatTime;
  StatusReport: StatusReport;
  StoragePool: StoragePool;
  StorageUsage: StorageUsage;
  StreamShare: StreamShare;
  StreamUsagePeriod: StreamUsagePeriod;
  String: Scalars['String'];
  SubStoragePool: SubStoragePool;
  SubStoragePoolInput: SubStoragePoolInput;
  SubscribedGatewayEventInput: SubscribedGatewayEventInput;
  Subscription: {};
  SystemParameters: SystemParameters;
  SystemStatusInfo: SystemStatusInfo;
  SystemStatusReason: SystemStatusReason;
  SystemStatusReasonObject: SystemStatusReasonObject;
  UUID: Scalars['UUID'];
  UpdateResult: UpdateResult;
  User: User;
  UserData: UserData;
  UserDataInput: UserDataInput;
  UserInfo: UserInfo;
  UserInfoInput: UserInfoInput;
  UserInput: UserInput;
  VaeConfigBrief: VaeConfigBrief;
  VaeConfigFull: VaeConfigFull;
  VaeFeature: VaeFeature;
  VaeUpdate: VaeUpdate;
  ViewConfig: ViewConfig;
  ViewConfigInput: ViewConfigInput;
  WarningField: WarningField;
  WidgetConfig: WidgetConfig;
  WidgetConfigInput: WidgetConfigInput;
  WidgetInfo: WidgetInfo;
  WidgetInfoInput: WidgetInfoInput;
  Workspace: Workspace;
  WorkspaceInput: WorkspaceInput;
  Zone: Zone;
  ZoneInput: ZoneInput;
}>;

export type AuthDirectiveArgs = { };

export type AuthDirectiveResolver<Result, Parent, ContextType = ClientContext, Args = AuthDirectiveArgs> = DirectiveResolverFn<Result, Parent, ContextType, Args>;

export type ComplexityDirectiveArgs = {
  multipliers?: Maybe<Array<Scalars['String']>>;
  value: Scalars['Int'];
};

export type ComplexityDirectiveResolver<Result, Parent, ContextType = ClientContext, Args = ComplexityDirectiveArgs> = DirectiveResolverFn<Result, Parent, ContextType, Args>;

export type KeyDirectiveArgs = {
  fields?: Maybe<Scalars['String']>;
};

export type KeyDirectiveResolver<Result, Parent, ContextType = ClientContext, Args = KeyDirectiveArgs> = DirectiveResolverFn<Result, Parent, ContextType, Args>;

export type ProvidesDirectiveArgs = {
  fields?: Maybe<Scalars['String']>;
};

export type ProvidesDirectiveResolver<Result, Parent, ContextType = ClientContext, Args = ProvidesDirectiveArgs> = DirectiveResolverFn<Result, Parent, ContextType, Args>;

export type AccessLevelResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AccessLevel'] = ResolversParentTypes['AccessLevel']> = ResolversObject<{
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  level?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  order?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ActionResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Action'] = ResolversParentTypes['Action']> = ResolversObject<{
  accessLevel?: Resolver<ResolversTypes['AccessLevel'], ParentType, ContextType>;
  action?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  deviceFunctionalAspectTypes?: Resolver<Array<ResolversTypes['DeviceFunctionalAspectType']>, ParentType, ContextType>;
  resourceTypes?: Resolver<Array<ResolversTypes['RealmObjectType']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AodRequestResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AodRequest'] = ResolversParentTypes['AodRequest']> = ResolversObject<{
  avatarId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  completedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  createdAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  deviceId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  downloaded?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  endTime?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  eta?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  eventId?: Resolver<Maybe<ResolversTypes['ID']>, ParentType, ContextType>;
  expiredAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  files?: Resolver<Maybe<ResolversTypes['AodRequestFiles']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  note?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  realmId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  size?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  startTime?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  status?: Resolver<ResolversTypes['AodRequestStatus'], ParentType, ContextType>;
  streamNumber?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  type?: Resolver<Maybe<ResolversTypes['AodRequestType']>, ParentType, ContextType>;
  updatedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  userId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AodRequestFilesResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AodRequestFiles'] = ResolversParentTypes['AodRequestFiles']> = ResolversObject<{
  expired?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  list?: Resolver<Array<ResolversTypes['AodRequestFilesListEntry']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AodRequestFilesListEntryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AodRequestFilesListEntry'] = ResolversParentTypes['AodRequestFilesListEntry']> = ResolversObject<{
  endTime?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  href?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  size?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  startTime?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AppStoreResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AppStore'] = ResolversParentTypes['AppStore']> = ResolversObject<{
  branding?: Resolver<Maybe<ResolversTypes['Branding']>, ParentType, ContextType>;
  select?: Resolver<Maybe<ResolversTypes['ObjUUID']>, ParentType, ContextType>;
  session?: Resolver<ResolversTypes['Session'], ParentType, ContextType>;
  socketEvent?: Resolver<Maybe<ResolversTypes['SocketEvent']>, ParentType, ContextType>;
  workspace?: Resolver<ResolversTypes['Workspace'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ArchiveBoundaryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ArchiveBoundary'] = ResolversParentTypes['ArchiveBoundary']> = ResolversObject<{
  boundary?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  timeInsideGap?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ArchiveCoverageResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ArchiveCoverage'] = ResolversParentTypes['ArchiveCoverage']> = ResolversObject<{
  coverage?: Resolver<Array<ResolversTypes['ArchiveCoverageItem']>, ParentType, ContextType>;
  partialCoverage?: Resolver<Array<ResolversTypes['ArchiveCoverageItem']>, ParentType, ContextType>;
  ttl?: Resolver<Array<ResolversTypes['ArchiveCoverageTTL']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ArchiveCoverageItemResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ArchiveCoverageItem'] = ResolversParentTypes['ArchiveCoverageItem']> = ResolversObject<{
  deviceId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  streamNumber?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  time?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ArchiveCoverageTtlResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ArchiveCoverageTTL'] = ResolversParentTypes['ArchiveCoverageTTL']> = ResolversObject<{
  deviceId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  ttl?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AspectHealthResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AspectHealth'] = ResolversParentTypes['AspectHealth']> = ResolversObject<{
  gravity?: Resolver<ResolversTypes['FA_HealthGravity'], ParentType, ContextType>;
  healthStatus?: Resolver<ResolversTypes['HealthStatus'], ParentType, ContextType>;
  livenessTimeout?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  readinessTimeout?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AssociatedGatewayDeviceResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AssociatedGatewayDevice'] = ResolversParentTypes['AssociatedGatewayDevice']> = ResolversObject<{
  associatedDevices?: Resolver<Array<ResolversTypes['String']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AuditCategoryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AuditCategory'] = ResolversParentTypes['AuditCategory']> = ResolversObject<{
  digest?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  parent?: Resolver<Maybe<ResolversTypes['ID']>, ParentType, ContextType>;
  shortName?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AuditEntryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AuditEntry'] = ResolversParentTypes['AuditEntry']> = ResolversObject<{
  category?: Resolver<ResolversTypes['AuditCategory'], ParentType, ContextType>;
  context?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  isAcknowledged?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  message?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  metadata?: Resolver<Array<ResolversTypes['MetaEntry']>, ParentType, ContextType>;
  modifiedAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  note?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  snapshots?: Resolver<Array<ResolversTypes['AuditSnapshot']>, ParentType, ContextType>;
  triggeredAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  witnesses?: Resolver<Array<ResolversTypes['RealmObject']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AuditEntryEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AuditEntryEvent'] = ResolversParentTypes['AuditEntryEvent']> = ResolversObject<{
  __resolveType: TypeResolveFn<'AuditEntry' | 'ErrorInfo', ParentType, ContextType>;
}>;

export type AuditSnapshotResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AuditSnapshot'] = ResolversParentTypes['AuditSnapshot']> = ResolversObject<{
  default?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  snapshot?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  tags?: Resolver<Array<ResolversTypes['KeyValue']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type AvatarMetricResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['AvatarMetric'] = ResolversParentTypes['AvatarMetric']> = ResolversObject<{
  dimension?: Resolver<ResolversTypes['MetricDimension'], ParentType, ContextType>;
  key?: Resolver<ResolversTypes['AvatarMetricName'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type BrandInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['BrandInfo'] = ResolversParentTypes['BrandInfo']> = ResolversObject<{
  iconUrl?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  logoUrl?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  shortName?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  website?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type BrandingResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Branding'] = ResolversParentTypes['Branding']> = ResolversObject<{
  CRM_REGISTRATION_URL?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  ICON_PATH?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  LOGIN_BACKGROUND_PATH?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  LOGIN_FOOTER_COLOR?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  LOGO_PATH?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_BRAND?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_BRAND_NAME?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_LONG?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_PHONE?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_PHONE_INTERNATIONAL?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_QUICKSTART?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_SHORT?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_SUPPORT_PHONE?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_SUPPORT_URL?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COMPANY_URL?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COPYRIGHT?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_COPYRIGHT_MATRIX?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_STYLE?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_SUPPORT_EMAIL?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  OEM_TRADEMARKS?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  QUICK_START_GUIDE_PATH?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  crmRegistrationUrl?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  iconPath?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  loginBackgroundPath?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  loginFooterColor?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  logoPath?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemBrand?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemBrandName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanyLong?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanyPhone?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanyPhoneInternational?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanyQuickstart?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanyShort?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanySupportPhone?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanySupportUrl?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCompanyUrl?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCopyright?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemCopyrightMatrix?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemStyle?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemSupportEmail?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  oemTrademarks?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  quickStartGuidePath?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CameraLogResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['CameraLog'] = ResolversParentTypes['CameraLog']> = ResolversObject<{
  message?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  severity?: Resolver<ResolversTypes['LogSeverity'], ParentType, ContextType>;
  time?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CameraMetricResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['CameraMetric'] = ResolversParentTypes['CameraMetric']> = ResolversObject<{
  dfaId?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  dimension?: Resolver<ResolversTypes['MetricDimension'], ParentType, ContextType>;
  key?: Resolver<ResolversTypes['CameraMetricName'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CameraWidgetPropsResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['CameraWidgetProps'] = ResolversParentTypes['CameraWidgetProps']> = ResolversObject<{
  deviceId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  index?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  time?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  viewId?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ChannelBenchmarkResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ChannelBenchmark'] = ResolversParentTypes['ChannelBenchmark']> = ResolversObject<{
  error?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  startedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  tcpDown?: Resolver<Maybe<ResolversTypes['ChannelStatistics']>, ParentType, ContextType>;
  tcpUp?: Resolver<Maybe<ResolversTypes['ChannelStatistics']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ChannelStatisticsResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ChannelStatistics'] = ResolversParentTypes['ChannelStatistics']> = ResolversObject<{
  bitsPerSecond?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  bytes?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  maxRtt?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  maxSndCwnd?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  meanRtt?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  minRtt?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  retransmits?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreateResultResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['CreateResult'] = ResolversParentTypes['CreateResult']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  warning?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  warningFields?: Resolver<Maybe<Array<ResolversTypes['WarningField']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CreatingViewResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['CreatingView'] = ResolversParentTypes['CreatingView']> = ResolversObject<{
  layout?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  layoutJSON?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  selectedWidget?: Resolver<Maybe<ResolversTypes['WidgetInfo']>, ParentType, ContextType>;
  template?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  viewId?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  widgets?: Resolver<Maybe<Array<ResolversTypes['WidgetInfo']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type CurrentRealmResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['CurrentRealm'] = ResolversParentTypes['CurrentRealm']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  imageMapConfig?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  maxDownloadLength?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  sharedViews?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Dfa_AvatarResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DFA_Avatar'] = ResolversParentTypes['DFA_Avatar']> = ResolversObject<{
  apiKey?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  avatarLoad?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  channelBenchmark?: Resolver<Maybe<ResolversTypes['ChannelBenchmark']>, ParentType, ContextType>;
  channelStatus?: Resolver<Maybe<ResolversTypes['ChannelStatus']>, ParentType, ContextType>;
  channelTurnaroundTime?: Resolver<Maybe<ResolversTypes['StatTime']>, ParentType, ContextType>;
  deliveryQueue?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  deliveryQueueUploadTime?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  dsConfiguredState?: Resolver<Maybe<ResolversTypes['DSConfiguredState']>, ParentType, ContextType>;
  dsRunningState?: Resolver<Maybe<ResolversTypes['DSRunningState']>, ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  encryptionKey?: Resolver<Maybe<ResolversTypes['EncryptionKeyInfo']>, ParentType, ContextType>;
  extended?: Resolver<Maybe<ResolversTypes['JSONObject']>, ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  isLink?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  lastStatusUpdate?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  localStorage?: Resolver<Maybe<ResolversTypes['LocalStorage']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  packetArrivalJitterTime?: Resolver<Maybe<ResolversTypes['StatTime']>, ParentType, ContextType>;
  platform?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  pushEventEndPoint?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  software?: Resolver<Maybe<ResolversTypes['SoftwareInfo']>, ParentType, ContextType>;
  statusUpdateInterval?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  storageUsage?: Resolver<Maybe<ResolversTypes['StorageUsage']>, ParentType, ContextType>;
  supportsReboot?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  turnaroundTime?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  upTime?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  uploadBandwidthCap?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  vaeImageUpdate?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  vaeUpdates?: Resolver<Maybe<Array<ResolversTypes['VaeUpdate']>>, ParentType, ContextType>;
  vmxVideoStreamingMode?: Resolver<Maybe<ResolversTypes['VMXVideoStreamingMode']>, ParentType, ContextType>;
  webRtcEnabled?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Dfa_GatewayResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DFA_Gateway'] = ResolversParentTypes['DFA_Gateway']> = ResolversObject<{
  associatedGatewayDevices?: Resolver<Array<ResolversTypes['AssociatedGatewayDevice']>, ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  devices?: Resolver<Array<ResolversTypes['GatewayProbeDevice']>, ParentType, ContextType>;
  directories?: Resolver<Array<ResolversTypes['GatewayDirectory']>, ParentType, ContextType>;
  directory?: Resolver<ResolversTypes['GatewayDirectory'], ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  events?: Resolver<Array<ResolversTypes['GatewayProbeEvent']>, ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  lenelVersion?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  oidcToken?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  subscribedEvents?: Resolver<Array<ResolversTypes['GatewayEvent']>, ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Dfa_MediaResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DFA_Media'] = ResolversParentTypes['DFA_Media']> = ResolversObject<{
  FPS?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  URL?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  audioCodec?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  averageFPS?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  averageGOP?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  averageInterArrivalJitter?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  cloudArchive?: Resolver<ResolversTypes['MediaArchiveOption'], ParentType, ContextType>;
  codec?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  consumedSpace?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  edgeArchive?: Resolver<ResolversTypes['MediaArchiveOption'], ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  frameRate?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  liveBitrate?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  onvifProfile?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  onvifProfiles?: Resolver<Maybe<ResolversTypes['JSONObject']>, ParentType, ContextType>;
  rtpPacketLost?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  sharedStream?: Resolver<Maybe<Array<ResolversTypes['StreamShare']>>, ParentType, ContextType>;
  spaceUsageDay?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  spaceUsageHour?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  streamType?: Resolver<ResolversTypes['MediaStreamType'], ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  uptime?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  videoCodec?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  videoHeight?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  videoSize?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  videoWidth?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Dfa_PtzResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DFA_PTZ'] = ResolversParentTypes['DFA_PTZ']> = ResolversObject<{
  cmdClassSupport?: Resolver<Maybe<Array<ResolversTypes['PTZ_Class']>>, ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  ptzConfig?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  ptzPanInverted?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  ptzTiltInverted?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Dfa_SensorResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DFA_Sensor'] = ResolversParentTypes['DFA_Sensor']> = ResolversObject<{
  associatedDevices?: Resolver<Maybe<Array<ResolversTypes['String']>>, ParentType, ContextType>;
  category?: Resolver<Maybe<ResolversTypes['AspectSensorCategory']>, ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  model?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  sensorEvents?: Resolver<Maybe<Array<ResolversTypes['SensorEvent']>>, ParentType, ContextType>;
  serial?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  userEvents?: Resolver<Maybe<Array<ResolversTypes['String']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Dfa_VaeResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DFA_VAE'] = ResolversParentTypes['DFA_VAE']> = ResolversObject<{
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  vaeConfig?: Resolver<Maybe<ResolversTypes['VaeConfigFull']>, ParentType, ContextType>;
  vaeFeatures?: Resolver<Maybe<Array<ResolversTypes['String']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export interface DateTimeScalarConfig extends GraphQLScalarTypeConfig<ResolversTypes['DateTime'], any> {
  name: 'DateTime';
}

export type DefaultGeoPositionResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DefaultGeoPosition'] = ResolversParentTypes['DefaultGeoPosition']> = ResolversObject<{
  lat?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  lng?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeviceResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Device'] = ResolversParentTypes['Device']> = ResolversObject<{
  acknowledgeRequired?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  aspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  cloudDirect?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  config?: Resolver<ResolversTypes['DeviceBaseConfig'], ParentType, ContextType>;
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  delivery?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  deliveryPriority?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  deviceType?: Resolver<Maybe<ResolversTypes['BaseDeviceType']>, ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  eventType?: Resolver<Maybe<ResolversTypes['DeviceEventType']>, ParentType, ContextType>;
  healthStatus?: Resolver<ResolversTypes['HealthStatus'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  location?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  platform?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  position?: Resolver<Maybe<ResolversTypes['LatLng']>, ParentType, ContextType>;
  rtpOverTcp?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  rtpTime?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  set?: Resolver<Maybe<Array<ResolversTypes['ObjectDescriptor']>>, ParentType, ContextType>;
  storageConfig?: Resolver<Maybe<ResolversTypes['DeviceStorageConfig']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  version?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  zone?: Resolver<Maybe<ResolversTypes['ObjectDescriptor']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeviceBaseConfigResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DeviceBaseConfig'] = ResolversParentTypes['DeviceBaseConfig']> = ResolversObject<{
  configType?: Resolver<ResolversTypes['DeviceBaseConfigType'], ParentType, ContextType>;
  connect?: Resolver<ResolversTypes['NetworkConnectDescriptor'], ParentType, ContextType>;
  firmware?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  make?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  model?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  onvifServices?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeviceFunctionalAspectResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DeviceFunctionalAspect'] = ResolversParentTypes['DeviceFunctionalAspect']> = ResolversObject<{
  __resolveType: TypeResolveFn<'DFA_Avatar' | 'DFA_Gateway' | 'DFA_Media' | 'DFA_PTZ' | 'DFA_Sensor' | 'DFA_VAE', ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType>;
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  health?: Resolver<ResolversTypes['AspectHealth'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  inputAspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  template?: Resolver<ResolversTypes['FunctionalAspectTemplate'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
}>;

export type DeviceProbeResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DeviceProbe'] = ResolversParentTypes['DeviceProbe']> = ResolversObject<{
  aspects?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType>;
  config?: Resolver<ResolversTypes['DeviceBaseConfig'], ParentType, ContextType>;
  name?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  rtpTime?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  snapshots?: Resolver<Array<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeviceStorageConfigResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DeviceStorageConfig'] = ResolversParentTypes['DeviceStorageConfig']> = ResolversObject<{
  storagePool?: Resolver<ResolversTypes['StoragePool'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeviceTemplateResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DeviceTemplate'] = ResolversParentTypes['DeviceTemplate']> = ResolversObject<{
  make?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  models?: Resolver<Array<ResolversTypes['DeviceTemplateModel']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type DeviceTemplateModelResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['DeviceTemplateModel'] = ResolversParentTypes['DeviceTemplateModel']> = ResolversObject<{
  model?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  url?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EncryptionKeyInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['EncryptionKeyInfo'] = ResolversParentTypes['EncryptionKeyInfo']> = ResolversObject<{
  isValid?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  issuedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ErrorInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ErrorInfo'] = ResolversParentTypes['ErrorInfo']> = ResolversObject<{
  createdAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  error?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type EventInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['EventInfo'] = ResolversParentTypes['EventInfo']> = ResolversObject<{
  entry?: Resolver<ResolversTypes['AuditEntry'], ParentType, ContextType>;
  hasSnapshots?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type FeatureResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Feature'] = ResolversParentTypes['Feature']> = ResolversObject<{
  desc?: Resolver<ResolversTypes['FeatureDesc'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  unitsSubscribed?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  unitsUsed?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type FeatureDescResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['FeatureDesc'] = ResolversParentTypes['FeatureDesc']> = ResolversObject<{
  displayName?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['FeatureType'], ParentType, ContextType>;
  unitType?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type FunctionalAspectTemplateResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['FunctionalAspectTemplate'] = ResolversParentTypes['FunctionalAspectTemplate']> = ResolversObject<{
  baseFeature?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  defaultFeature?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  engine?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  features?: Resolver<Maybe<Array<ResolversTypes['VaeFeature']>>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  order?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['DeviceFunctionalAspectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GeoLayerResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GEOLayer'] = ResolversParentTypes['GEOLayer']> = ResolversObject<{
  data?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  mime?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GeoLayersResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GEOLayers'] = ResolversParentTypes['GEOLayers']> = ResolversObject<{
  geoLayers?: Resolver<Array<ResolversTypes['GEOLayer']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GatewayDirectoriesProbeResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GatewayDirectoriesProbe'] = ResolversParentTypes['GatewayDirectoriesProbe']> = ResolversObject<{
  deviceProbe?: Resolver<ResolversTypes['DeviceProbe'], ParentType, ContextType>;
  directories?: Resolver<Array<ResolversTypes['GatewayDirectory']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GatewayDirectoryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GatewayDirectory'] = ResolversParentTypes['GatewayDirectory']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GatewayEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GatewayEvent'] = ResolversParentTypes['GatewayEvent']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GatewayProbeResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GatewayProbe'] = ResolversParentTypes['GatewayProbe']> = ResolversObject<{
  devices?: Resolver<Array<ResolversTypes['GatewayProbeDevice']>, ParentType, ContextType>;
  events?: Resolver<Array<ResolversTypes['GatewayProbeEvent']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GatewayProbeDeviceResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GatewayProbeDevice'] = ResolversParentTypes['GatewayProbeDevice']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GatewayProbeEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GatewayProbeEvent'] = ResolversParentTypes['GatewayProbeEvent']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GenericObjectResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['GenericObject'] = ResolversParentTypes['GenericObject']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GroupResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Group'] = ResolversParentTypes['Group']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  isSystemManaged?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  policies?: Resolver<Array<ResolversTypes['Policy']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  users?: Resolver<Array<ResolversTypes['User']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type GuiResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Gui'] = ResolversParentTypes['Gui']> = ResolversObject<{
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  url?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type HierarchyResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Hierarchy'] = ResolversParentTypes['Hierarchy']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  level?: Resolver<ResolversTypes['HierarchyLevel'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type HierarchyLevelResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['HierarchyLevel'] = ResolversParentTypes['HierarchyLevel']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  labelIds?: Resolver<Array<ResolversTypes['ID']>, ParentType, ContextType>;
  levels?: Resolver<Maybe<Array<ResolversTypes['HierarchyLevel']>>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type IdentityAttributeResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['IdentityAttribute'] = ResolversParentTypes['IdentityAttribute']> = ResolversObject<{
  contactUs?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ImageMapResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ImageMap'] = ResolversParentTypes['ImageMap']> = ResolversObject<{
  base64?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  objects?: Resolver<Array<ResolversTypes['ImageMapObject']>, ParentType, ContextType>;
  order?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ImageMapConfigResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ImageMapConfig'] = ResolversParentTypes['ImageMapConfig']> = ResolversObject<{
  sets?: Resolver<Array<ResolversTypes['ImageMapSet']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ImageMapLayerResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ImageMapLayer'] = ResolversParentTypes['ImageMapLayer']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  maps?: Resolver<Array<ResolversTypes['ImageMap']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ImageMapObjectResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ImageMapObject'] = ResolversParentTypes['ImageMapObject']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  objectId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  position?: Resolver<ResolversTypes['Position'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ImageMapSetResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ImageMapSet'] = ResolversParentTypes['ImageMapSet']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  layers?: Resolver<Array<ResolversTypes['ImageMapLayer']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ImageMapUpdateNotificationResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ImageMapUpdateNotification'] = ResolversParentTypes['ImageMapUpdateNotification']> = ResolversObject<{
  action?: Resolver<ResolversTypes['ImageMapUpdateAction'], ParentType, ContextType>;
  layer?: Resolver<Maybe<ResolversTypes['ImageMapLayer']>, ParentType, ContextType>;
  layerId?: Resolver<Maybe<ResolversTypes['ID']>, ParentType, ContextType>;
  layerName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  map?: Resolver<Maybe<ResolversTypes['ImageMap']>, ParentType, ContextType>;
  mapId?: Resolver<Maybe<ResolversTypes['ID']>, ParentType, ContextType>;
  object?: Resolver<Maybe<ResolversTypes['ImageMapObject']>, ParentType, ContextType>;
  objectId?: Resolver<Maybe<ResolversTypes['ID']>, ParentType, ContextType>;
  realmId?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  set?: Resolver<Maybe<ResolversTypes['ImageMapSet']>, ParentType, ContextType>;
  setId?: Resolver<Maybe<ResolversTypes['ID']>, ParentType, ContextType>;
  setName?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  updateId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  version?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export interface JsonScalarConfig extends GraphQLScalarTypeConfig<ResolversTypes['JSON'], any> {
  name: 'JSON';
}

export interface JsonObjectScalarConfig extends GraphQLScalarTypeConfig<ResolversTypes['JSONObject'], any> {
  name: 'JSONObject';
}

export type KeyValueResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['KeyValue'] = ResolversParentTypes['KeyValue']> = ResolversObject<{
  key?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  value?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LabelResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Label'] = ResolversParentTypes['Label']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  objects?: Resolver<Array<ResolversTypes['LabelObject']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['LabelType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LabelObjectResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['LabelObject'] = ResolversParentTypes['LabelObject']> = ResolversObject<{
  objectId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LabelOrHierarchyUpdateResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['LabelOrHierarchyUpdate'] = ResolversParentTypes['LabelOrHierarchyUpdate']> = ResolversObject<{
  itemIds?: Resolver<Array<ResolversTypes['ID']>, ParentType, ContextType>;
  realmId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['LabelOrHierarchyUpdateType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LanguageResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Language'] = ResolversParentTypes['Language']> = ResolversObject<{
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  direction?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  tag?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LanguagesResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Languages'] = ResolversParentTypes['Languages']> = ResolversObject<{
  languages?: Resolver<Maybe<Array<ResolversTypes['Language']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LatLngResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['LatLng'] = ResolversParentTypes['LatLng']> = ResolversObject<{
  alt?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  lat?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  lng?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LicenseResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['License'] = ResolversParentTypes['License']> = ResolversObject<{
  isAccepted?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  text?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type LocalStorageResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['LocalStorage'] = ResolversParentTypes['LocalStorage']> = ResolversObject<{
  enabled?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  pool?: Resolver<ResolversTypes['PoolLocalStorage'], ParentType, ContextType>;
  strategy?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  ver?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MetaClassifierResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['MetaClassifier'] = ResolversParentTypes['MetaClassifier']> = ResolversObject<{
  attributes?: Resolver<Array<ResolversTypes['KeyValue']>, ParentType, ContextType>;
  value?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MetaEntryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['MetaEntry'] = ResolversParentTypes['MetaEntry']> = ResolversObject<{
  key?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  metaClass?: Resolver<ResolversTypes['MetaClassifier'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ModifiedByInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ModifiedByInfo'] = ResolversParentTypes['ModifiedByInfo']> = ResolversObject<{
  realmId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  userId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type MutationResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Mutation'] = ResolversParentTypes['Mutation']> = ResolversObject<{
  acceptLicense?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  acknowledgeAuditEntry?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationAcknowledgeAuditEntryArgs, 'entry'>>;
  acknowledgeEvent?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationAcknowledgeEventArgs, 'context' | 'triggeredAt'>>;
  activateAvatar?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationActivateAvatarArgs, 'avatarId'>>;
  activateEmail?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationActivateEmailArgs, 'input'>>;
  addSubscription?: Resolver<Maybe<ResolversTypes['RealmSubscription']>, ParentType, ContextType, RequireFields<MutationAddSubscriptionArgs, 'realmSubscription'>>;
  aodCancel?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationAodCancelArgs, 'requestIds'>>;
  aodPause?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationAodPauseArgs, 'requestId'>>;
  aodResume?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationAodResumeArgs, 'requestId'>>;
  aodSubmit?: Resolver<Array<ResolversTypes['AodRequest']>, ParentType, ContextType, RequireFields<MutationAodSubmitArgs, 'input'>>;
  assignLabels?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationAssignLabelsArgs, 'ids' | 'objectId'>>;
  auditEntriesAcknowledgment?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationAuditEntriesAcknowledgmentArgs, 'entries'>>;
  changeCurrentPassword?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationChangeCurrentPasswordArgs, 'input'>>;
  changeDeliveryPriority?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationChangeDeliveryPriorityArgs, 'devices'>>;
  changeLocalStorage?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationChangeLocalStorageArgs, 'id' | 'input'>>;
  changePassword?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationChangePasswordArgs, 'input'>>;
  createAvatarApiKey?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationCreateAvatarApiKeyArgs, 'id'>>;
  createDevice?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateDeviceArgs, 'device'>>;
  createGatewayDevice?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateGatewayDeviceArgs, 'device'>>;
  createGroup?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateGroupArgs, 'group'>>;
  createPolicy?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreatePolicyArgs, 'policy'>>;
  createPolicyStatement?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreatePolicyStatementArgs, 'policyId' | 'statement'>>;
  createSensorDevice?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateSensorDeviceArgs, 'device'>>;
  createSet?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateSetArgs, 'set'>>;
  createUser?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateUserArgs, 'user'>>;
  createVaeConfig?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationCreateVaeConfigArgs, 'deviceId' | 'engine' | 'name'>>;
  createZone?: Resolver<ResolversTypes['CreateResult'], ParentType, ContextType, RequireFields<MutationCreateZoneArgs, 'zone'>>;
  deleteDevice?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteDeviceArgs, 'id'>>;
  deleteGroup?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteGroupArgs, 'id'>>;
  deleteHierarchy?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteHierarchyArgs, 'id'>>;
  deleteImageMapLayer?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteImageMapLayerArgs, 'layerId' | 'updateId' | 'version'>>;
  deleteImageMapObject?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteImageMapObjectArgs, 'objectId' | 'updateId' | 'version'>>;
  deleteImageMapSet?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteImageMapSetArgs, 'setId' | 'updateId' | 'version'>>;
  deleteLabel?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteLabelArgs, 'id'>>;
  deletePolicy?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeletePolicyArgs, 'id'>>;
  deletePolicyStatement?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeletePolicyStatementArgs, 'statementId'>>;
  deleteSet?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteSetArgs, 'id'>>;
  deleteSubscription?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType, RequireFields<MutationDeleteSubscriptionArgs, 'id'>>;
  deleteUser?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteUserArgs, 'id'>>;
  deleteVaeConfig?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteVaeConfigArgs, 'deviceId' | 'engine' | 'name'>>;
  deleteZone?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeleteZoneArgs, 'id'>>;
  deviceCommand?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationDeviceCommandArgs, 'command' | 'id'>>;
  eventsAcknowledgement?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationEventsAcknowledgementArgs, 'entries'>>;
  insertHierarchy?: Resolver<ResolversTypes['Hierarchy'], ParentType, ContextType, RequireFields<MutationInsertHierarchyArgs, 'hierarchy'>>;
  insertImageMapLayer?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationInsertImageMapLayerArgs, 'layer' | 'setId' | 'updateId' | 'version'>>;
  insertImageMapObject?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationInsertImageMapObjectArgs, 'mapId' | 'object' | 'updateId' | 'version'>>;
  insertImageMapSet?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationInsertImageMapSetArgs, 'set' | 'updateId' | 'version'>>;
  insertLabels?: Resolver<Array<ResolversTypes['Label']>, ParentType, ContextType, RequireFields<MutationInsertLabelsArgs, 'labels'>>;
  modifySubscription?: Resolver<Maybe<ResolversTypes['RealmSubscription']>, ParentType, ContextType, RequireFields<MutationModifySubscriptionArgs, 'realmSubscription'>>;
  ptzPreset?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationPtzPresetArgs, 'id' | 'input'>>;
  ptzRel?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationPtzRelArgs, 'id' | 'input'>>;
  ptzSpeed?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationPtzSpeedArgs, 'id' | 'input'>>;
  ptzStep?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationPtzStepArgs, 'id' | 'input'>>;
  purgeAvatarQueue?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationPurgeAvatarQueueArgs, 'id'>>;
  regenerateAvatarApiKey?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationRegenerateAvatarApiKeyArgs, 'id'>>;
  removeAvatarApiKey?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationRemoveAvatarApiKeyArgs, 'id'>>;
  removeLabels?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationRemoveLabelsArgs, 'ids' | 'objectId'>>;
  renameImageMapLayer?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationRenameImageMapLayerArgs, 'layerId' | 'name' | 'updateId' | 'version'>>;
  renameImageMapSet?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationRenameImageMapSetArgs, 'name' | 'setId' | 'updateId' | 'version'>>;
  renameVaeConfig?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationRenameVaeConfigArgs, 'deviceId' | 'engine' | 'name' | 'newName'>>;
  restorePassword?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationRestorePasswordArgs, 'input'>>;
  setPassword?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationSetPasswordArgs, 'input'>>;
  setStore?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationSetStoreArgs, 'store'>>;
  setUserRealm?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationSetUserRealmArgs, 'realmId' | 'userName'>>;
  unblockUser?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUnblockUserArgs, 'id'>>;
  updateCurrentRealm?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateCurrentRealmArgs, 'realm'>>;
  updateDevice?: Resolver<ResolversTypes['UpdateResult'], ParentType, ContextType, RequireFields<MutationUpdateDeviceArgs, 'device' | 'id'>>;
  updateGeoLayers?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationUpdateGeoLayersArgs, 'input'>>;
  updateGroup?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateGroupArgs, 'group' | 'id'>>;
  updateHierarchy?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateHierarchyArgs, 'hierarchy'>>;
  updateImageMap?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateImageMapArgs, 'map' | 'updateId' | 'version'>>;
  updateImageMapLayer?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateImageMapLayerArgs, 'layer' | 'updateId' | 'version'>>;
  updateImageMapObject?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateImageMapObjectArgs, 'object' | 'updateId' | 'version'>>;
  updateImageMapSet?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateImageMapSetArgs, 'set' | 'updateId' | 'version'>>;
  updateLabel?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateLabelArgs, 'label'>>;
  updatePolicy?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdatePolicyArgs, 'id' | 'policy'>>;
  updatePolicyStatement?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdatePolicyStatementArgs, 'statement' | 'statementId'>>;
  updatePosition?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdatePositionArgs, 'id' | 'position'>>;
  updateRealm?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationUpdateRealmArgs, 'realmInput'>>;
  updateSet?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateSetArgs, 'id' | 'set'>>;
  updateSolidConfig?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateSolidConfigArgs, 'userId'>>;
  updateSolidConfigCurrentView?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateSolidConfigCurrentViewArgs, 'input'>>;
  updateUser?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateUserArgs, 'id' | 'user'>>;
  updateZone?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType, RequireFields<MutationUpdateZoneArgs, 'id' | 'zone'>>;
  validateAddSubscription?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType, RequireFields<MutationValidateAddSubscriptionArgs, 'realmSubscription'>>;
  validateEmail?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationValidateEmailArgs, 'addresses'>>;
  validateModifySubscription?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType, RequireFields<MutationValidateModifySubscriptionArgs, 'realmSubscription'>>;
  verifyCode?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType, RequireFields<MutationVerifyCodeArgs, 'code'>>;
}>;

export type NetworkConnectDescriptorResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['NetworkConnectDescriptor'] = ResolversParentTypes['NetworkConnectDescriptor']> = ResolversObject<{
  URL?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  authType?: Resolver<ResolversTypes['AuthType'], ParentType, ContextType>;
  host?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  pass?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  port?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  protocol?: Resolver<Maybe<ResolversTypes['ProtocolType']>, ParentType, ContextType>;
  rtspPort?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  user?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type NumericReportResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['NumericReport'] = ResolversParentTypes['NumericReport']> = ResolversObject<{
  time?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  value?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ObjUuidResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ObjUUID'] = ResolversParentTypes['ObjUUID']> = ResolversObject<{
  obj?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ObjUuidAndNameResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ObjUUIDAndName'] = ResolversParentTypes['ObjUUIDAndName']> = ResolversObject<{
  isAdmin?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  obj?: Resolver<ResolversTypes['UUID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ObjectDescriptorResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ObjectDescriptor'] = ResolversParentTypes['ObjectDescriptor']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  isSystemManaged?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ObjectUpdateEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ObjectUpdateEvent'] = ResolversParentTypes['ObjectUpdateEvent']> = ResolversObject<{
  action?: Resolver<ResolversTypes['ObjectAction'], ParentType, ContextType>;
  childObjects?: Resolver<Maybe<Array<ResolversTypes['ID']>>, ParentType, ContextType>;
  healthStatus?: Resolver<Maybe<ResolversTypes['HealthStatus']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  realmId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  systemStatus?: Resolver<Maybe<ResolversTypes['SystemStatus']>, ParentType, ContextType>;
  time?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type OwnerResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Owner'] = ResolversParentTypes['Owner']> = ResolversObject<{
  createdAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  displayName?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  email?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  updatedAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type PolicyResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Policy'] = ResolversParentTypes['Policy']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  groups?: Resolver<Array<ResolversTypes['Group']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  isSystemManaged?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  statements?: Resolver<Array<ResolversTypes['PolicyStatement']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type PolicyStatementResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['PolicyStatement'] = ResolversParentTypes['PolicyStatement']> = ResolversObject<{
  actions?: Resolver<Array<ResolversTypes['String']>, ParentType, ContextType>;
  allResources?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  effect?: Resolver<ResolversTypes['StatementEffect'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  resources?: Resolver<Array<ResolversTypes['ObjectDescriptor']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type PoolLocalStorageResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['PoolLocalStorage'] = ResolversParentTypes['PoolLocalStorage']> = ResolversObject<{
  enforce?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  path?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  size?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type PositionResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Position'] = ResolversParentTypes['Position']> = ResolversObject<{
  x?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  y?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type QueryResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Query'] = ResolversParentTypes['Query']> = ResolversObject<{
  accessLevels?: Resolver<Array<ResolversTypes['AccessLevel']>, ParentType, ContextType>;
  actions?: Resolver<Array<ResolversTypes['Action']>, ParentType, ContextType>;
  aodGet?: Resolver<Array<ResolversTypes['AodRequest']>, ParentType, ContextType, RequireFields<QueryAodGetArgs, 'endTime' | 'ids' | 'startTime'>>;
  aodGetList?: Resolver<Array<ResolversTypes['AodRequest']>, ParentType, ContextType, RequireFields<QueryAodGetListArgs, 'endTime' | 'startTime'>>;
  aodGetUpdatedList?: Resolver<Array<ResolversTypes['AodRequest']>, ParentType, ContextType, RequireFields<QueryAodGetUpdatedListArgs, 'updatedFrom'>>;
  archiveBoundary?: Resolver<ResolversTypes['ArchiveBoundary'], ParentType, ContextType, RequireFields<QueryArchiveBoundaryArgs, 'find' | 'ids' | 'startTime' | 'streamNumbers'>>;
  archiveCoverage?: Resolver<ResolversTypes['ArchiveCoverage'], ParentType, ContextType, RequireFields<QueryArchiveCoverageArgs, 'endTime' | 'ids' | 'startTime'>>;
  aspectTemplates?: Resolver<Array<ResolversTypes['FunctionalAspectTemplate']>, ParentType, ContextType>;
  auditCategories?: Resolver<Array<ResolversTypes['AuditCategory']>, ParentType, ContextType>;
  auditEntries?: Resolver<Array<ResolversTypes['AuditEntry']>, ParentType, ContextType, RequireFields<QueryAuditEntriesArgs, 'filter'>>;
  availableFeatures?: Resolver<Maybe<Array<ResolversTypes['FeatureDesc']>>, ParentType, ContextType>;
  avatarMetrics?: Resolver<Array<ResolversTypes['AvatarMetric']>, ParentType, ContextType>;
  avatarReport?: Resolver<Array<ResolversTypes['NumericReport']>, ParentType, ContextType, RequireFields<QueryAvatarReportArgs, 'from' | 'id' | 'metricName' | 'to'>>;
  branding?: Resolver<Maybe<ResolversTypes['Branding']>, ParentType, ContextType>;
  cameraLog?: Resolver<Array<ResolversTypes['CameraLog']>, ParentType, ContextType, RequireFields<QueryCameraLogArgs, 'deviceId'>>;
  cameraMetrics?: Resolver<Array<ResolversTypes['CameraMetric']>, ParentType, ContextType, RequireFields<QueryCameraMetricsArgs, 'id'>>;
  cameraReport?: Resolver<Array<ResolversTypes['Report']>, ParentType, ContextType, RequireFields<QueryCameraReportArgs, 'dfaId' | 'from' | 'id' | 'metricName' | 'to'>>;
  currentRealm?: Resolver<ResolversTypes['CurrentRealm'], ParentType, ContextType>;
  device?: Resolver<Maybe<ResolversTypes['Device']>, ParentType, ContextType, RequireFields<QueryDeviceArgs, 'id'>>;
  deviceFunctionalAspectsByAspectTypes?: Resolver<Array<ResolversTypes['DeviceFunctionalAspect']>, ParentType, ContextType, RequireFields<QueryDeviceFunctionalAspectsByAspectTypesArgs, 'types'>>;
  deviceTemplates?: Resolver<Array<ResolversTypes['DeviceTemplate']>, ParentType, ContextType>;
  devices?: Resolver<Array<ResolversTypes['Device']>, ParentType, ContextType>;
  devicesByAspectTypes?: Resolver<Array<ResolversTypes['Device']>, ParentType, ContextType, RequireFields<QueryDevicesByAspectTypesArgs, 'types'>>;
  devicesByIds?: Resolver<Array<ResolversTypes['Device']>, ParentType, ContextType, RequireFields<QueryDevicesByIdsArgs, 'ids'>>;
  discoverDevices?: Resolver<Array<ResolversTypes['DeviceProbe']>, ParentType, ContextType, RequireFields<QueryDiscoverDevicesArgs, 'platformId'>>;
  emailCanBeSend?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  geoLayers?: Resolver<Maybe<ResolversTypes['GEOLayers']>, ParentType, ContextType>;
  group?: Resolver<Maybe<ResolversTypes['Group']>, ParentType, ContextType, RequireFields<QueryGroupArgs, 'id'>>;
  groups?: Resolver<Array<ResolversTypes['Group']>, ParentType, ContextType>;
  guis?: Resolver<Array<ResolversTypes['Gui']>, ParentType, ContextType>;
  hierarchies?: Resolver<Array<ResolversTypes['Hierarchy']>, ParentType, ContextType>;
  hierarchy?: Resolver<Maybe<ResolversTypes['Hierarchy']>, ParentType, ContextType, RequireFields<QueryHierarchyArgs, 'id'>>;
  identityAttribute?: Resolver<Maybe<ResolversTypes['IdentityAttribute']>, ParentType, ContextType>;
  imageMapConfig?: Resolver<ResolversTypes['ImageMapConfig'], ParentType, ContextType, RequireFields<QueryImageMapConfigArgs, 'version'>>;
  imageMapImage?: Resolver<ResolversTypes['String'], ParentType, ContextType, RequireFields<QueryImageMapImageArgs, 'mapId' | 'version'>>;
  label?: Resolver<Maybe<ResolversTypes['Label']>, ParentType, ContextType, RequireFields<QueryLabelArgs, 'id'>>;
  labels?: Resolver<Array<ResolversTypes['Label']>, ParentType, ContextType>;
  labelsForObject?: Resolver<Array<ResolversTypes['Label']>, ParentType, ContextType, RequireFields<QueryLabelsForObjectArgs, 'objectId'>>;
  languages?: Resolver<Maybe<ResolversTypes['Languages']>, ParentType, ContextType>;
  license?: Resolver<ResolversTypes['License'], ParentType, ContextType>;
  localStorage?: Resolver<Maybe<ResolversTypes['LocalStorage']>, ParentType, ContextType, RequireFields<QueryLocalStorageArgs, 'deviceId'>>;
  policies?: Resolver<Array<ResolversTypes['Policy']>, ParentType, ContextType>;
  policy?: Resolver<Maybe<ResolversTypes['Policy']>, ParentType, ContextType, RequireFields<QueryPolicyArgs, 'id'>>;
  probeDevice?: Resolver<ResolversTypes['DeviceProbe'], ParentType, ContextType, RequireFields<QueryProbeDeviceArgs, 'input'>>;
  probeGateway?: Resolver<ResolversTypes['GatewayProbe'], ParentType, ContextType, RequireFields<QueryProbeGatewayArgs, 'input'>>;
  probeGatewayDirectories?: Resolver<ResolversTypes['GatewayDirectoriesProbe'], ParentType, ContextType, RequireFields<QueryProbeGatewayDirectoriesArgs, 'input'>>;
  probeSensorDevice?: Resolver<ResolversTypes['DeviceProbe'], ParentType, ContextType, RequireFields<QueryProbeSensorDeviceArgs, 'input'>>;
  realm?: Resolver<Maybe<ResolversTypes['Realm']>, ParentType, ContextType>;
  realmObject?: Resolver<Maybe<ResolversTypes['RealmObject']>, ParentType, ContextType, RequireFields<QueryRealmObjectArgs, 'id'>>;
  realmObjects?: Resolver<Array<ResolversTypes['RealmObject']>, ParentType, ContextType>;
  realmSubscription?: Resolver<ResolversTypes['RealmSubscription'], ParentType, ContextType, Partial<QueryRealmSubscriptionArgs>>;
  realmSubscriptions?: Resolver<Maybe<Array<ResolversTypes['RealmSubscription']>>, ParentType, ContextType, Partial<QueryRealmSubscriptionsArgs>>;
  requireAcknowledgeEntries?: Resolver<Array<ResolversTypes['AuditEntry']>, ParentType, ContextType, RequireFields<QueryRequireAcknowledgeEntriesArgs, 'filter'>>;
  serverTime?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  sessionInfo?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  set?: Resolver<Maybe<ResolversTypes['Set']>, ParentType, ContextType, RequireFields<QuerySetArgs, 'id'>>;
  sets?: Resolver<Array<ResolversTypes['Set']>, ParentType, ContextType>;
  solidConfig?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType, RequireFields<QuerySolidConfigArgs, 'userId'>>;
  storagePools?: Resolver<Array<ResolversTypes['StoragePool']>, ParentType, ContextType>;
  storageUsage?: Resolver<Maybe<ResolversTypes['StorageUsage']>, ParentType, ContextType, RequireFields<QueryStorageUsageArgs, 'deviceId'>>;
  store?: Resolver<ResolversTypes['AppStore'], ParentType, ContextType>;
  systemParameters?: Resolver<Maybe<ResolversTypes['SystemParameters']>, ParentType, ContextType>;
  systemStatus?: Resolver<ResolversTypes['SystemStatusInfo'], ParentType, ContextType>;
  user?: Resolver<Maybe<ResolversTypes['User']>, ParentType, ContextType, RequireFields<QueryUserArgs, 'id'>>;
  userInfo?: Resolver<ResolversTypes['UserInfo'], ParentType, ContextType>;
  userRealms?: Resolver<Array<ResolversTypes['RealmObject']>, ParentType, ContextType>;
  users?: Resolver<Array<ResolversTypes['User']>, ParentType, ContextType>;
  vaeConfigs?: Resolver<Array<ResolversTypes['VaeConfigBrief']>, ParentType, ContextType, RequireFields<QueryVaeConfigsArgs, 'deviceId' | 'engine'>>;
  vaeTemplates?: Resolver<Array<ResolversTypes['FunctionalAspectTemplate']>, ParentType, ContextType, RequireFields<QueryVaeTemplatesArgs, 'deviceId'>>;
  zone?: Resolver<Maybe<ResolversTypes['Zone']>, ParentType, ContextType, RequireFields<QueryZoneArgs, 'id'>>;
  zones?: Resolver<Array<ResolversTypes['Zone']>, ParentType, ContextType>;
}>;

export type RealmResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Realm'] = ResolversParentTypes['Realm']> = ResolversObject<{
  adminEmail?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  auditTtl?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  avatarLocalStreaming?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  emailAuth?: Resolver<Maybe<ResolversTypes['EmailAuth']>, ParentType, ContextType>;
  emailEnabled?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  emailFrom?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailHost?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailPass?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailPort?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  emailTls?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  emailUser?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailValidated?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  jitterBufferLength?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  maxDownloadTime?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  maxScheduledDeliveryDelay?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  maxVideoPlayers?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  mfAuth?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  playerIdleTimeout?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  realmObjects?: Resolver<Maybe<Array<ResolversTypes['RealmObject']>>, ParentType, ContextType>;
  resellerParent?: Resolver<Maybe<ResolversTypes['Reseller']>, ParentType, ContextType>;
  updatedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  warnVideoPlayers?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type RealmObjectResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['RealmObject'] = ResolversParentTypes['RealmObject']> = ResolversObject<{
  __resolveType: TypeResolveFn<'CurrentRealm' | 'Device' | 'GenericObject' | 'Group' | 'Policy' | 'Set' | 'User' | 'Zone', ParentType, ContextType>;
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
}>;

export type RealmSubscriptionResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['RealmSubscription'] = ResolversParentTypes['RealmSubscription']> = ResolversObject<{
  createdAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  features?: Resolver<Array<ResolversTypes['Feature']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  owner?: Resolver<ResolversTypes['Owner'], ParentType, ContextType>;
  periodExpiresAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  periodStartedAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  simpleui?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  status?: Resolver<ResolversTypes['SubscriptionStatus'], ParentType, ContextType>;
  storagePools?: Resolver<Array<ResolversTypes['SubStoragePool']>, ParentType, ContextType>;
  title?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<Maybe<ResolversTypes['RealmSubscriptionType']>, ParentType, ContextType>;
  updatedAt?: Resolver<ResolversTypes['DateTime'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ReportResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Report'] = ResolversParentTypes['Report']> = ResolversObject<{
  __resolveType: TypeResolveFn<'NumericReport' | 'StatusReport', ParentType, ContextType>;
}>;

export type ResellerResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Reseller'] = ResolversParentTypes['Reseller']> = ResolversObject<{
  brandInfo?: Resolver<Maybe<ResolversTypes['BrandInfo']>, ParentType, ContextType>;
  children?: Resolver<Array<ResolversTypes['Reseller']>, ParentType, ContextType>;
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  displayName?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  owner?: Resolver<Maybe<ResolversTypes['User']>, ParentType, ContextType>;
  parent?: Resolver<Maybe<ResolversTypes['Reseller']>, ParentType, ContextType>;
  realms?: Resolver<Array<ResolversTypes['Realm']>, ParentType, ContextType>;
  updatedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SensorEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SensorEvent'] = ResolversParentTypes['SensorEvent']> = ResolversObject<{
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SessionResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Session'] = ResolversParentTypes['Session']> = ResolversObject<{
  info?: Resolver<Maybe<ResolversTypes['UserInfo']>, ParentType, ContextType>;
  isAdmin?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  isLoggedIn?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SessionCloseEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SessionCloseEvent'] = ResolversParentTypes['SessionCloseEvent']> = ResolversObject<{
  reason?: Resolver<ResolversTypes['SessionCloseReason'], ParentType, ContextType>;
  sessionId?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SessionInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SessionInfo'] = ResolversParentTypes['SessionInfo']> = ResolversObject<{
  realm?: Resolver<ResolversTypes['ObjUUIDAndName'], ParentType, ContextType>;
  role?: Resolver<ResolversTypes['ObjUUIDAndName'], ParentType, ContextType>;
  user?: Resolver<ResolversTypes['ObjUUIDAndName'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SetResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Set'] = ResolversParentTypes['Set']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  devices?: Resolver<Array<ResolversTypes['ObjectDescriptor']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  isSystemManaged?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SharedViewsUpdateEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SharedViewsUpdateEvent'] = ResolversParentTypes['SharedViewsUpdateEvent']> = ResolversObject<{
  modifiedBy?: Resolver<ResolversTypes['ModifiedByInfo'], ParentType, ContextType>;
  sharedViews?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SocketEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SocketEvent'] = ResolversParentTypes['SocketEvent']> = ResolversObject<{
  timeStamp?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['SocketEventType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SoftwareInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SoftwareInfo'] = ResolversParentTypes['SoftwareInfo']> = ResolversObject<{
  lastUpdateSucceeded?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  lastUpdateTime?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  updateAvailable?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  version?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SolidConfigUpdateEventResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SolidConfigUpdateEvent'] = ResolversParentTypes['SolidConfigUpdateEvent']> = ResolversObject<{
  solidConfig?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  userId?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SolidConfigurationResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SolidConfiguration'] = ResolversParentTypes['SolidConfiguration']> = ResolversObject<{
  activities?: Resolver<Array<ResolversTypes['ActivityId']>, ParentType, ContextType>;
  config?: Resolver<ResolversTypes['JSON'], ParentType, ContextType>;
  views?: Resolver<Array<ResolversTypes['ViewConfig']>, ParentType, ContextType>;
  widgets?: Resolver<Array<ResolversTypes['WidgetConfig']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StatTimeResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['StatTime'] = ResolversParentTypes['StatTime']> = ResolversObject<{
  avg?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  max?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  min?: Resolver<ResolversTypes['Float'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StatusReportResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['StatusReport'] = ResolversParentTypes['StatusReport']> = ResolversObject<{
  time?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  value?: Resolver<ResolversTypes['StatusMetric'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StoragePoolResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['StoragePool'] = ResolversParentTypes['StoragePool']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  ttlHours?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StorageUsageResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['StorageUsage'] = ResolversParentTypes['StorageUsage']> = ResolversObject<{
  free?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  localStorageVolume?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  requiredVolume?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type StreamShareResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['StreamShare'] = ResolversParentTypes['StreamShare']> = ResolversObject<{
  error?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  status?: Resolver<Maybe<ResolversTypes['HealthStatus']>, ParentType, ContextType>;
  url?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SubStoragePoolResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SubStoragePool'] = ResolversParentTypes['SubStoragePool']> = ResolversObject<{
  features?: Resolver<Array<ResolversTypes['Feature']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  ttlHrs?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SubscriptionResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Subscription'] = ResolversParentTypes['Subscription']> = ResolversObject<{
  aodUpdate?: SubscriptionResolver<Maybe<Array<ResolversTypes['AodRequest']>>, "aodUpdate", ParentType, ContextType, RequireFields<SubscriptionAodUpdateArgs, 'filter'>>;
  auditEntries?: SubscriptionResolver<ResolversTypes['AuditEntryEvent'], "auditEntries", ParentType, ContextType, RequireFields<SubscriptionAuditEntriesArgs, 'filter'>>;
  hierarchyUpdate?: SubscriptionResolver<ResolversTypes['LabelOrHierarchyUpdate'], "hierarchyUpdate", ParentType, ContextType>;
  imageMapUpdate?: SubscriptionResolver<ResolversTypes['ImageMapUpdateNotification'], "imageMapUpdate", ParentType, ContextType, RequireFields<SubscriptionImageMapUpdateArgs, 'version'>>;
  labelUpdate?: SubscriptionResolver<ResolversTypes['LabelOrHierarchyUpdate'], "labelUpdate", ParentType, ContextType>;
  objectUpdate?: SubscriptionResolver<ResolversTypes['ObjectUpdateEvent'], "objectUpdate", ParentType, ContextType, Partial<SubscriptionObjectUpdateArgs>>;
  sessionClose?: SubscriptionResolver<ResolversTypes['SessionCloseEvent'], "sessionClose", ParentType, ContextType>;
  sharedViewsUpdate?: SubscriptionResolver<ResolversTypes['SharedViewsUpdateEvent'], "sharedViewsUpdate", ParentType, ContextType>;
  solidConfigUpdate?: SubscriptionResolver<ResolversTypes['SolidConfigUpdateEvent'], "solidConfigUpdate", ParentType, ContextType>;
}>;

export type SystemParametersResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SystemParameters'] = ResolversParentTypes['SystemParameters']> = ResolversObject<{
  geoDefaultPosition?: Resolver<Maybe<ResolversTypes['DefaultGeoPosition']>, ParentType, ContextType>;
  googleMapsApiKey?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  googleYouTubeApiKey?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  googleYouTubePlaylistId?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  mapDefaultLayer?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  solidAppVersion?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  updatesHost?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SystemStatusInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SystemStatusInfo'] = ResolversParentTypes['SystemStatusInfo']> = ResolversObject<{
  description?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  reasons?: Resolver<Array<ResolversTypes['SystemStatusReason']>, ParentType, ContextType>;
  status?: Resolver<ResolversTypes['SystemStatus'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SystemStatusReasonResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SystemStatusReason'] = ResolversParentTypes['SystemStatusReason']> = ResolversObject<{
  message?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  object?: Resolver<Maybe<ResolversTypes['SystemStatusReasonObject']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type SystemStatusReasonObjectResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['SystemStatusReasonObject'] = ResolversParentTypes['SystemStatusReasonObject']> = ResolversObject<{
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export interface UuidScalarConfig extends GraphQLScalarTypeConfig<ResolversTypes['UUID'], any> {
  name: 'UUID';
}

export type UpdateResultResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['UpdateResult'] = ResolversParentTypes['UpdateResult']> = ResolversObject<{
  updated?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  warning?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  warningFields?: Resolver<Maybe<Array<ResolversTypes['WarningField']>>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UserResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['User'] = ResolversParentTypes['User']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  email?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  emailConfirmed?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  groups?: Resolver<Array<ResolversTypes['Group']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  loggedOnAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  sendNotification?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UserDataResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['UserData'] = ResolversParentTypes['UserData']> = ResolversObject<{
  id?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  isAdmin?: Resolver<ResolversTypes['Boolean'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  solidConfiguration?: Resolver<ResolversTypes['SolidConfiguration'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type UserInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['UserInfo'] = ResolversParentTypes['UserInfo']> = ResolversObject<{
  realm?: Resolver<ResolversTypes['CurrentRealm'], ParentType, ContextType>;
  user?: Resolver<ResolversTypes['UserData'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type VaeConfigBriefResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['VaeConfigBrief'] = ResolversParentTypes['VaeConfigBrief']> = ResolversObject<{
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type VaeConfigFullResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['VaeConfigFull'] = ResolversParentTypes['VaeConfigFull']> = ResolversObject<{
  configuration?: Resolver<ResolversTypes['JSONObject'], ParentType, ContextType>;
  description?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type VaeFeatureResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['VaeFeature'] = ResolversParentTypes['VaeFeature']> = ResolversObject<{
  exclusive?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  order?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type VaeUpdateResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['VaeUpdate'] = ResolversParentTypes['VaeUpdate']> = ResolversObject<{
  log?: Resolver<Maybe<Array<ResolversTypes['String']>>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  status?: Resolver<ResolversTypes['VaeUpdateStatus'], ParentType, ContextType>;
  version?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ViewConfigResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['ViewConfig'] = ResolversParentTypes['ViewConfig']> = ResolversObject<{
  config?: Resolver<ResolversTypes['JSON'], ParentType, ContextType>;
  viewId?: Resolver<ResolversTypes['ViewId'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type WarningFieldResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['WarningField'] = ResolversParentTypes['WarningField']> = ResolversObject<{
  field?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  value?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type WidgetConfigResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['WidgetConfig'] = ResolversParentTypes['WidgetConfig']> = ResolversObject<{
  config?: Resolver<ResolversTypes['JSON'], ParentType, ContextType>;
  widgetId?: Resolver<ResolversTypes['WidgetId'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type WidgetIdResolvers = { AdminAvatars: 'undefined', AdminDevices: 'undefined', AdminGateways: 'undefined', AdminSensors: 'undefined', ArchiveEventList: 'undefined', ArchiveViewer: 'undefined', AvatarProvision: 'undefined', CameraLive: 'undefined', DeviceList: 'undefined', DownloadManager: 'undefined', EventDetails: 'undefined', EventList: 'undefined', EventVideo: 'undefined', GeoMap: 'GEOMap', Groups: 'undefined', HierarchyEdit: 'undefined', ImageMap: 'undefined', LabelEdit: 'undefined', LinkProvision: 'undefined', ManageAvatars: 'undefined', NotificationPolicies: 'undefined', Policies: 'undefined', QuickStart: 'undefined', RealmSettings: 'undefined', Reports: 'undefined', Sets: 'undefined', Subscription: 'undefined', Timeline: 'undefined', TrainingVideos: 'undefined', Users: 'undefined', VideoTouring: 'undefined', VideoWalls: 'undefined', Vmx: 'VMX', WatchlistFacial: 'undefined', WatchlistLPR: 'undefined', Zones: 'undefined' };

export type WidgetInfoResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['WidgetInfo'] = ResolversParentTypes['WidgetInfo']> = ResolversObject<{
  index?: Resolver<ResolversTypes['Int'], ParentType, ContextType>;
  propsJSON?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  widgetId?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type WorkspaceResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Workspace'] = ResolversParentTypes['Workspace']> = ResolversObject<{
  cameraWidgetProps?: Resolver<Maybe<Array<ResolversTypes['CameraWidgetProps']>>, ParentType, ContextType>;
  creatingViews?: Resolver<Maybe<Array<ResolversTypes['CreatingView']>>, ParentType, ContextType>;
  event?: Resolver<Maybe<ResolversTypes['EventInfo']>, ParentType, ContextType>;
  localViewsJSON?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  sharedViewsJSON?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  solidConfigJSON?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  updatedEvent?: Resolver<Maybe<ResolversTypes['AuditEntry']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type ZoneResolvers<ContextType = ClientContext, ParentType extends ResolversParentTypes['Zone'] = ResolversParentTypes['Zone']> = ResolversObject<{
  createdAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  devices?: Resolver<Array<ResolversTypes['ObjectDescriptor']>, ParentType, ContextType>;
  id?: Resolver<ResolversTypes['ID'], ParentType, ContextType>;
  modifiedAt?: Resolver<Maybe<ResolversTypes['DateTime']>, ParentType, ContextType>;
  name?: Resolver<ResolversTypes['String'], ParentType, ContextType>;
  type?: Resolver<ResolversTypes['RealmObjectType'], ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
}>;

export type Resolvers<ContextType = ClientContext> = ResolversObject<{
  AccessLevel?: AccessLevelResolvers<ContextType>;
  Action?: ActionResolvers<ContextType>;
  AodRequest?: AodRequestResolvers<ContextType>;
  AodRequestFiles?: AodRequestFilesResolvers<ContextType>;
  AodRequestFilesListEntry?: AodRequestFilesListEntryResolvers<ContextType>;
  AppStore?: AppStoreResolvers<ContextType>;
  ArchiveBoundary?: ArchiveBoundaryResolvers<ContextType>;
  ArchiveCoverage?: ArchiveCoverageResolvers<ContextType>;
  ArchiveCoverageItem?: ArchiveCoverageItemResolvers<ContextType>;
  ArchiveCoverageTTL?: ArchiveCoverageTtlResolvers<ContextType>;
  AspectHealth?: AspectHealthResolvers<ContextType>;
  AssociatedGatewayDevice?: AssociatedGatewayDeviceResolvers<ContextType>;
  AuditCategory?: AuditCategoryResolvers<ContextType>;
  AuditEntry?: AuditEntryResolvers<ContextType>;
  AuditEntryEvent?: AuditEntryEventResolvers<ContextType>;
  AuditSnapshot?: AuditSnapshotResolvers<ContextType>;
  AvatarMetric?: AvatarMetricResolvers<ContextType>;
  BrandInfo?: BrandInfoResolvers<ContextType>;
  Branding?: BrandingResolvers<ContextType>;
  CameraLog?: CameraLogResolvers<ContextType>;
  CameraMetric?: CameraMetricResolvers<ContextType>;
  CameraWidgetProps?: CameraWidgetPropsResolvers<ContextType>;
  ChannelBenchmark?: ChannelBenchmarkResolvers<ContextType>;
  ChannelStatistics?: ChannelStatisticsResolvers<ContextType>;
  CreateResult?: CreateResultResolvers<ContextType>;
  CreatingView?: CreatingViewResolvers<ContextType>;
  CurrentRealm?: CurrentRealmResolvers<ContextType>;
  DFA_Avatar?: Dfa_AvatarResolvers<ContextType>;
  DFA_Gateway?: Dfa_GatewayResolvers<ContextType>;
  DFA_Media?: Dfa_MediaResolvers<ContextType>;
  DFA_PTZ?: Dfa_PtzResolvers<ContextType>;
  DFA_Sensor?: Dfa_SensorResolvers<ContextType>;
  DFA_VAE?: Dfa_VaeResolvers<ContextType>;
  DateTime?: GraphQLScalarType;
  DefaultGeoPosition?: DefaultGeoPositionResolvers<ContextType>;
  Device?: DeviceResolvers<ContextType>;
  DeviceBaseConfig?: DeviceBaseConfigResolvers<ContextType>;
  DeviceFunctionalAspect?: DeviceFunctionalAspectResolvers<ContextType>;
  DeviceProbe?: DeviceProbeResolvers<ContextType>;
  DeviceStorageConfig?: DeviceStorageConfigResolvers<ContextType>;
  DeviceTemplate?: DeviceTemplateResolvers<ContextType>;
  DeviceTemplateModel?: DeviceTemplateModelResolvers<ContextType>;
  EncryptionKeyInfo?: EncryptionKeyInfoResolvers<ContextType>;
  ErrorInfo?: ErrorInfoResolvers<ContextType>;
  EventInfo?: EventInfoResolvers<ContextType>;
  Feature?: FeatureResolvers<ContextType>;
  FeatureDesc?: FeatureDescResolvers<ContextType>;
  FunctionalAspectTemplate?: FunctionalAspectTemplateResolvers<ContextType>;
  GEOLayer?: GeoLayerResolvers<ContextType>;
  GEOLayers?: GeoLayersResolvers<ContextType>;
  GatewayDirectoriesProbe?: GatewayDirectoriesProbeResolvers<ContextType>;
  GatewayDirectory?: GatewayDirectoryResolvers<ContextType>;
  GatewayEvent?: GatewayEventResolvers<ContextType>;
  GatewayProbe?: GatewayProbeResolvers<ContextType>;
  GatewayProbeDevice?: GatewayProbeDeviceResolvers<ContextType>;
  GatewayProbeEvent?: GatewayProbeEventResolvers<ContextType>;
  GenericObject?: GenericObjectResolvers<ContextType>;
  Group?: GroupResolvers<ContextType>;
  Gui?: GuiResolvers<ContextType>;
  Hierarchy?: HierarchyResolvers<ContextType>;
  HierarchyLevel?: HierarchyLevelResolvers<ContextType>;
  IdentityAttribute?: IdentityAttributeResolvers<ContextType>;
  ImageMap?: ImageMapResolvers<ContextType>;
  ImageMapConfig?: ImageMapConfigResolvers<ContextType>;
  ImageMapLayer?: ImageMapLayerResolvers<ContextType>;
  ImageMapObject?: ImageMapObjectResolvers<ContextType>;
  ImageMapSet?: ImageMapSetResolvers<ContextType>;
  ImageMapUpdateNotification?: ImageMapUpdateNotificationResolvers<ContextType>;
  JSON?: GraphQLScalarType;
  JSONObject?: GraphQLScalarType;
  KeyValue?: KeyValueResolvers<ContextType>;
  Label?: LabelResolvers<ContextType>;
  LabelObject?: LabelObjectResolvers<ContextType>;
  LabelOrHierarchyUpdate?: LabelOrHierarchyUpdateResolvers<ContextType>;
  Language?: LanguageResolvers<ContextType>;
  Languages?: LanguagesResolvers<ContextType>;
  LatLng?: LatLngResolvers<ContextType>;
  License?: LicenseResolvers<ContextType>;
  LocalStorage?: LocalStorageResolvers<ContextType>;
  MetaClassifier?: MetaClassifierResolvers<ContextType>;
  MetaEntry?: MetaEntryResolvers<ContextType>;
  ModifiedByInfo?: ModifiedByInfoResolvers<ContextType>;
  Mutation?: MutationResolvers<ContextType>;
  NetworkConnectDescriptor?: NetworkConnectDescriptorResolvers<ContextType>;
  NumericReport?: NumericReportResolvers<ContextType>;
  ObjUUID?: ObjUuidResolvers<ContextType>;
  ObjUUIDAndName?: ObjUuidAndNameResolvers<ContextType>;
  ObjectDescriptor?: ObjectDescriptorResolvers<ContextType>;
  ObjectUpdateEvent?: ObjectUpdateEventResolvers<ContextType>;
  Owner?: OwnerResolvers<ContextType>;
  Policy?: PolicyResolvers<ContextType>;
  PolicyStatement?: PolicyStatementResolvers<ContextType>;
  PoolLocalStorage?: PoolLocalStorageResolvers<ContextType>;
  Position?: PositionResolvers<ContextType>;
  Query?: QueryResolvers<ContextType>;
  Realm?: RealmResolvers<ContextType>;
  RealmObject?: RealmObjectResolvers<ContextType>;
  RealmSubscription?: RealmSubscriptionResolvers<ContextType>;
  Report?: ReportResolvers<ContextType>;
  Reseller?: ResellerResolvers<ContextType>;
  SensorEvent?: SensorEventResolvers<ContextType>;
  Session?: SessionResolvers<ContextType>;
  SessionCloseEvent?: SessionCloseEventResolvers<ContextType>;
  SessionInfo?: SessionInfoResolvers<ContextType>;
  Set?: SetResolvers<ContextType>;
  SharedViewsUpdateEvent?: SharedViewsUpdateEventResolvers<ContextType>;
  SocketEvent?: SocketEventResolvers<ContextType>;
  SoftwareInfo?: SoftwareInfoResolvers<ContextType>;
  SolidConfigUpdateEvent?: SolidConfigUpdateEventResolvers<ContextType>;
  SolidConfiguration?: SolidConfigurationResolvers<ContextType>;
  StatTime?: StatTimeResolvers<ContextType>;
  StatusReport?: StatusReportResolvers<ContextType>;
  StoragePool?: StoragePoolResolvers<ContextType>;
  StorageUsage?: StorageUsageResolvers<ContextType>;
  StreamShare?: StreamShareResolvers<ContextType>;
  SubStoragePool?: SubStoragePoolResolvers<ContextType>;
  Subscription?: SubscriptionResolvers<ContextType>;
  SystemParameters?: SystemParametersResolvers<ContextType>;
  SystemStatusInfo?: SystemStatusInfoResolvers<ContextType>;
  SystemStatusReason?: SystemStatusReasonResolvers<ContextType>;
  SystemStatusReasonObject?: SystemStatusReasonObjectResolvers<ContextType>;
  UUID?: GraphQLScalarType;
  UpdateResult?: UpdateResultResolvers<ContextType>;
  User?: UserResolvers<ContextType>;
  UserData?: UserDataResolvers<ContextType>;
  UserInfo?: UserInfoResolvers<ContextType>;
  VaeConfigBrief?: VaeConfigBriefResolvers<ContextType>;
  VaeConfigFull?: VaeConfigFullResolvers<ContextType>;
  VaeFeature?: VaeFeatureResolvers<ContextType>;
  VaeUpdate?: VaeUpdateResolvers<ContextType>;
  ViewConfig?: ViewConfigResolvers<ContextType>;
  WarningField?: WarningFieldResolvers<ContextType>;
  WidgetConfig?: WidgetConfigResolvers<ContextType>;
  WidgetId?: WidgetIdResolvers;
  WidgetInfo?: WidgetInfoResolvers<ContextType>;
  Workspace?: WorkspaceResolvers<ContextType>;
  Zone?: ZoneResolvers<ContextType>;
}>;

export type DirectiveResolvers<ContextType = ClientContext> = ResolversObject<{
  auth?: AuthDirectiveResolver<any, any, ContextType>;
  complexity?: ComplexityDirectiveResolver<any, any, ContextType>;
  key?: KeyDirectiveResolver<any, any, ContextType>;
  provides?: ProvidesDirectiveResolver<any, any, ContextType>;
}>;
