import { API, Auth } from "@solid/libs";
import { Apollo } from "@core/api";
import { useStore } from "@core/store";
import { useNavigate } from "react-router-dom";
import { useCallback, useEffect } from "react";
import { SessionCloseReason } from "@generated/graphql";

type SessionCloseEvent = {
  reason: SessionCloseReason
};

const logoutChannel = "logout";

const useLogout = () => {
  const { store: { session: { isLoggedIn } } } = useStore();
  const navigate = useNavigate();

  useEffect(() => {
    const bc = new BroadcastChannel(logoutChannel);
    bc.onmessage = (event: MessageEvent<SessionCloseEvent>) => {
      if (event.origin !== window.origin) {
        return;
      }

      console.log(event.origin, "logout reason", event.data.reason);
      if (isLoggedIn) {
        logout();
      }
    };

    return () => {
      bc.close();
    };
  }, [isLoggedIn]);

  const logout = async () => {
    const api = new API();
    Auth.setAPI(api);
    try {
      if (Apollo.subscriptionClient) {
        Apollo.subscriptionClient.unsubscribeAll();
        Apollo.subscriptionClient.close(false, true);
      }
      await Auth.logout();
      Apollo.client?.resetStore();

      const bc = new BroadcastChannel(logoutChannel);
      const message: SessionCloseEvent = { reason: SessionCloseReason.SessionTerminated };
      bc.postMessage(message);

      navigate("/");
    }
    catch (error) {
      console.error("useLogout", error);
    }
  };

  return {
    logout: useCallback(() => logout(), []),
    onLogout: useCallback(() => {}, [])
  };
};

export default useLogout;
