import { StreamGeoPosition } from "@solid/player-cell/cell";
import type { UUID } from "@solid/types";
import {MSEMediaPlayerConnection, MSEMediaPlayerMetadataType} from "@solid/types/player";
import { PlayerMode } from "@solid/types/player_widget";
import {WidgetEvent} from "components/Widgets";

export type PlayerProps = {
  obj: UUID;
  header: string;
  onClose: () => void;
  isLiveOnly?: boolean;
  time?: Date;
  isActive?: boolean;
  hideHeader?: boolean;
  onStop?: () => void;
  onChangeMode?: (mode: PlayerMode) => void;
  onAddDownloadJob?: (start: number) => void;
  onArchiveLengthChange?: (hours: number) => void;
  widgetEvent?: WidgetEvent;
  widgetIndex?: number;
  muted?: boolean;
} & PlayerOptions;

export type PlayerOptions = {
  isArchive?: boolean,
  metadataType?: MetadataDrawType;
  ptzControls?: boolean;
  digitalZoom?: boolean;
  fullScreenControl?: boolean;
  stepBackControl?: boolean;
  calendar?: boolean;
  allowExport?: boolean;
  userDefinedEvent?: boolean;
  onClipEnd?: PlayerOnClipEnd;
  playOnStart?: boolean;
  showPauseButton?: boolean;
  disableLocalTransport?: boolean;
};

export enum MetadataDrawType {
  Alert = "Alert",
  All = "All",
  None = "None"
}

export enum PlayerStartFrom {
  Event = "Event",
  Live = "Live"
}

export enum PlayerOnClipEnd {
  Clear = "Clear",
  Stop = "Stop",
  Loop = "Loop"
}

export function toPlayerMetadataDrawType(type: MetadataDrawType): MSEMediaPlayerMetadataType {
  switch (type) {
    case MetadataDrawType.Alert: return MSEMediaPlayerMetadataType.TRIGGERED;
    case MetadataDrawType.All: return MSEMediaPlayerMetadataType.ALL;
    case MetadataDrawType.None: return MSEMediaPlayerMetadataType.NONE;
    default: return MSEMediaPlayerMetadataType.NONE;
  }
}

export function fromPlayerMetadataDrawType(type: MSEMediaPlayerMetadataType): MetadataDrawType {
  switch (type) {
    case MSEMediaPlayerMetadataType.TRIGGERED: return MetadataDrawType.Alert;
    case MSEMediaPlayerMetadataType.ALL: return MetadataDrawType.All;
    case MSEMediaPlayerMetadataType.NONE:
    default:
      return MetadataDrawType.None;
  }
}

export enum PlayerCommand {
  Play = "PlayCmd",
  Pause = "PauseCmd",
  SetTime = "SetTimeCmd",
  SetSpeed = "SetSpeedCmd",
  SetSelected = "SetSelectedCmd",
  ClearSelected = "ClearSelectedCmd",
  OutOfSync = "OutOfSyncCmd",
  BackToSync = "BackToSyncCmd",
  FullScreen = "FullScreenCmd",
  PreferredConnectionType = "PreferredConnectionTypeCmd",
  Backward = "BackwardCmd",
  Forward = "ForwardCmd",
  GetAOD = "GetAODCmd",
  AddDownloadJob = "AddDownloadJobCmd",
  MuteAudio = "MuteAudioCmd"
}

export type PlayerCommandArgs = {
  objs?: UUID[];
  time?: Date;
  widgetIndices?: number[];
  speed?: number;
  byUser?: boolean,
  isPlay?: boolean,
  preferredConnectionType?: MSEMediaPlayerConnection,
  deviceId?: UUID,
  start?: number,
  duration?: number,
  muted?: boolean
};

export enum PlayerEvent {
  PausedByUser = "PausedByUser",
  Play = "Play",
  Stop = "Stop",
  Pause = "Pause",
  Frame = "Frame",
  AODDone = "AODDone",
  GeoPosition = "GeoPosition",
  Mode = "Mode"
}

export type PlayerEventArgs = {
  obj: UUID;
  widgetIndex: number;
  time?: number;
  geo?: StreamGeoPosition,
  mode?: PlayerMode
};
