import React, { useState, useEffect } from "react";
import { Segment } from "semantic-ui-react";
import { ReactSVG } from "react-svg";
import { WidgetProps, Widgets, WidgetWarning, WidgetWarningEventArgs, CommonWidgetEvent, WidgetEventArgs } from "components/Widgets";
import { __ } from "@solid/libs";

import "./style.css";

type WidgetStubProps = {
  isAllow?: boolean;
} & WidgetProps;

const WidgetStub = ({ widgetId, widgetEvent, index: widgetIndex, isAllow = true }: WidgetStubProps) => {
  const [widgetWarning, setWidgetWarning] = useState<WidgetWarning | undefined>();

  useEffect(() => {
    const id = `${Date.now()}.${Math.random()}`;
    widgetEvent?.subscribe(id, onWidgetEvent);

    return function cleanup() {
      widgetEvent?.unsubscribe(id);
    };
  });

  function onWidgetEvent(args: WidgetEventArgs): void {
    if (args.event === CommonWidgetEvent.WidgetWarning) {
      const evArgs = args.args as WidgetWarningEventArgs;
      if (evArgs.widgetIndex === widgetIndex) {
        setWidgetWarning(evArgs.warning);
      }
    }
  }

  const widget = Widgets.find(w => w.id === widgetId);
  if (!widget) {
    console.error(`Widget stub error: widget with ID='${widgetId}' is not found.`);
    return null;
  }

  const { title, icon } = widget;
  return (
    <Segment className="WidgetStub">
      <ReactSVG role="icon" src={icon}/>
      <p>{title}</p>
      {!!widgetWarning && <p className="WidgetStub-Warning">{widgetWarning.text}</p>}
      {!isAllow && <p>{__("Access restricted")}</p>}
    </Segment>
  );
};

export default WidgetStub;
