import React from "react";
import {WidgetProps} from "../index";
import {copyObject} from "utils";
import LazyComponent from "components/LazyComponent";
import {getModule} from "@core/utils";

export type WidgetRenderContentProps = {
  renderModule: boolean;
  module: string;
  moduleProps?: object;
  component?: React.ComponentType<WidgetProps>;
  componentProps?: object;
  widgetProps: WidgetProps;
  alwaysUpdate?: boolean;
};

type WidgetRenderContentState = {};

export class WidgetRenderContent extends React.Component<WidgetRenderContentProps, WidgetRenderContentState> {
  constructor(props: WidgetRenderContentProps) {
    super(props);
    this.state = {};
  }

  override shouldComponentUpdate(nextProps: WidgetRenderContentProps, nextState: WidgetRenderContentState): boolean {
    return this.props.alwaysUpdate || JSON.stringify(copyObject(this.props)) !== JSON.stringify(copyObject(nextProps));
  }

  override render() {
    const { moduleProps, widgetProps, renderModule, module, component: Component, componentProps } = this.props;
    const contentProps = { ...moduleProps, ...widgetProps };
    return (
      <div className="WidgetRender-Content">
        { renderModule && <LazyComponent render={getModule(module)} props={contentProps} /> }
        { !renderModule && Component && <Component {...contentProps} {...componentProps} /> }
      </div>
    );
  }
}
