import React from "react";
import { useNavigate } from "react-router-dom";
import { Icon, Popup, StrictPopupProps } from "semantic-ui-react";
import { ModuleInfo } from "@core/types";
import { PropType } from "utils";
import {__} from "@solid/libs/i18n";

import "./style.css";

type EditButtonProps = {
  view: ModuleInfo;
  editView: (view: ModuleInfo) => void;
  disabled?: boolean;
  popupPosition?: PropType<StrictPopupProps, "position">;
  popupOffset?: PropType<StrictPopupProps, "offset">;
};

const EditButton = ({ view, editView, disabled, popupPosition = "top right", popupOffset }: EditButtonProps) => {
  const opacityElement = document.getElementById("main_right");
  const navigate = useNavigate();

  const removeOpacity = () => {
    if (opacityElement) {
      opacityElement.classList.remove("active");
    }
  };

  return (
    <Popup position={popupPosition} offset={popupOffset} content={__("Edit View")} trigger={
      <Icon name="edit" className="ViewList-RightButton" disabled={disabled} onClick={(e: React.MouseEvent) => {
        e.stopPropagation();
        editView(view);
        removeOpacity();
        navigate("/view");
      }}/>}
    />
  );
};

export default EditButton;
