import React, { Dispatch, SetStateAction, useState } from "react";
import { List, Segment } from "semantic-ui-react";
import { __ } from "@solid/libs/i18n";

import "./style.css";

type DelayTouringProps = {
  changeInterval: Dispatch<SetStateAction<number>>;
  interval: number
};

const DelayTouring = ({changeInterval, interval}: DelayTouringProps) => {
  const [delay, setDelay] = useState<number>(interval);

  function onChangeDelay(delay: number) {
    setDelay(delay);
    changeInterval(delay);
  }

  return (
    <Segment className="DelayTouring">
      <List>
        <List.Content>{__("Delay time: {{number}} sec", {number: delay})}</List.Content>
        <input
          type="range"
          min={5}
          max={105}
          value={delay}
          className="DelayTouring-Range"
          onChange={(e) => onChangeDelay(Number(e.target.value))}
        />
      </List>
    </Segment>
  );
};

export default DelayTouring;
