import React, { useState } from "react";
import {  WidgetId } from "@generated/graphql";
import { Widgets } from "components/Widgets";
import VDMHeader from "components/WidgetHeader";
import VDMContent from "./VDMContent";

const defaultTitle = "Video Delivery Manager";

type VideoDeliveryManagerProp = {
  onWindowClose: () => void;
};

const VideoDeliveryManager = ({ onWindowClose }: VideoDeliveryManagerProp) => {
  const VDMWidget = Widgets?.find(w => w.id === WidgetId.DownloadManager);
  const [title, setTitle] = useState<string>(VDMWidget?.name || defaultTitle);

  function onChangeTitle(title?: string) {
    let newTitle = defaultTitle;
    if (!title && VDMWidget) {
      newTitle = VDMWidget.title;
    }
    if (title) {
      newTitle = title;
    }
    setTitle(newTitle);
  }

  return (
    <>
      <VDMHeader icon={VDMWidget?.icon} title={title} onWindowClose={onWindowClose}/>
      <VDMContent changeTitle={onChangeTitle} />
    </>
  );
};

export default VideoDeliveryManager;
