import { MSEMediaPlayerConnection } from "@solid/types";

export type TimelineGlobalStore = {
  isPlay: boolean,
  time: number,
  connectionType?: MSEMediaPlayerConnection,
};

const store: TimelineGlobalStore = {
  isPlay: true,
  time: 0
};

export const setTimelineStore = (state: Partial<TimelineGlobalStore>): void => {
  Object.assign(store, state);
};

export const getTimelineStore = (): TimelineGlobalStore => {
  return store;
};
