export class Interval {
  constructor(public from: Date, public to: Date) {
  }

  intersectsWith(from: Date, to: Date): boolean {
    return (from >= this.from && from <= this.to) || (this.from >= from && this.from <= to);
  }

  empty(): boolean {
    return this.from.getTime() === this.to.getTime();
  }
}

export function findGaps(from: Date, to: Date, intervals: Interval[], nowDelta = 0): Interval[] {
  const gaps: Interval[] = [new Interval(from, to)];
  for (const int of intervals) {
    for (let i = gaps.length - 1; i >= 0; i--) {
      const gap = gaps[i];
      if (int.from.getTime() <= gap.from.getTime() && gap.to.getTime() <= int.to.getTime()) {
        gaps.splice(i, 1);
      } else
      if (int.from.getTime() <= gap.from.getTime() && gap.from.getTime() < int.to.getTime()) {
        gap.from = int.to;
      } else
      if (int.from.getTime() < gap.to.getTime() && gap.to.getTime() <= int.to.getTime()) {
        gap.to = int.from;
      } else
      if (gap.from.getTime() < int.from.getTime() && int.to.getTime() < gap.to.getTime()) {
        gaps.push(new Interval(int.to, gap.to));
        gap.to = int.from;
      }
    }
  }
  return gaps.filter(gap => (gap.to.getTime() - gap.from.getTime() > 0) &&
    !(gap.to.getTime() - gap.from.getTime() < nowDelta && Date.now() - gap.to.getTime() < nowDelta));
}

export function maxInterval(intervals: Interval[]): Interval {
  if (intervals.length === 0) {
    return new Interval(new Date(0), new Date(0));
  }
  const min = intervals.reduce((acc, int) => Math.min(acc, int.from.getTime()), intervals[0].from.getTime());
  const max = intervals.reduce((acc, int) => Math.max(acc, int.to.getTime()), intervals[0].to.getTime());
  return new Interval(new Date(min), new Date(max));
}
