import React from "react";
import { gql, useQuery } from "@apollo/client";
import "./style.css";

export const GET_DOG_QUERY = gql`
  query GetDog($name: String) {
    dog(name: $name) {
      id
      name
      breed
    }
  }
`;

type SomeProps = {
  name: string;
};

export const Some = ({ name }: SomeProps) => {
  const { loading, error, data } = useQuery(
    GET_DOG_QUERY,
    { variables: { name } }
  );
  if (loading) return <p>Loading...</p>;
  if (error) return <p>Error!</p>;
  return (
    <p>
      {data.dog.name} is a {data.dog.breed}
    </p>
  );
};

export default Some;
