import React, {useEffect, useRef} from "react";
import {UUID} from "@solid/types";
import {YUVPlayer} from "@libs/player-native";
import {isElectron} from "@solid/libs/utils";
import {PlayerOptions} from "core/playerTypes";

import "@libs/player-native/yuvplayer.css";
import "./PlayerNative.css";

type PlayerNativeProps = {
  obj: UUID,
  time?: Date,
} & PlayerOptions;

const PlayerNative = (props: PlayerNativeProps) => {
  console.assert(isElectron(), "This component for Electron only");

  const playerNodeRef = useRef<HTMLDivElement>(null);
  const playerRef = useRef<YUVPlayer | null>(null);

  // on mount
  useEffect(() => {
    const {obj, time, playOnStart} = props;
    createPlayer(obj, time, playOnStart);

    return () => {
      playerRef.current && playerRef.current.destroy();
    };
  }, []);

  const createPlayer = async (obj: UUID, time?: Date, isActive?: boolean) => {
    if (!playerNodeRef.current) {
      return;
    }

    const playerNode = playerNodeRef.current;

    let player = playerRef.current;
    if (player) {
      player.destroy();
    }

    playerRef.current = new YUVPlayer({node: playerNode});

    player = playerRef.current;

    throw new Error("not implemented");
    /*
    await player.init();
    if (isActive) {
      player.play(obj);
    }
    */
  };

  return (
    <div className="video" ref={playerNodeRef}/>
  );
};

export default PlayerNative;
