/* eslint-disable react/no-danger */
import React, { useEffect, useState } from "react";
import { Header, Image, List } from "semantic-ui-react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { useStore } from "@core/store";
import LanguageSelector from "components/LanguageSelector";
import { Activity, ActivityItem, ActivityItemProps } from "components/Activity";
import { origin } from "core/api";
import useLogout from "@core/useLogout";

import "./style.css";

type PageWrapperProps = {
  children: React.ReactNode,
  showLanguageSelector?: boolean;
};

type CopyrightType = {
  __html: string
};

const PageWrapper = (props: PageWrapperProps) => {
  const [copyright, setCopyright] = useState<CopyrightType>();
  const { store: { session: { isLoggedIn }, branding }} = useStore();
  const { logout } = useLogout();

  useEffect(() => {
    if (!branding) {
      return;
    }

    const copyright = {__html: branding.OEM_COPYRIGHT ?? ""};
    setCopyright(copyright);

    const footer = document.getElementsByClassName("footer")[0] as HTMLElement;
    if (footer) {
      footer.style.backgroundColor = branding.LOGIN_FOOTER_COLOR;
    }

    const head = document.head.getElementsByClassName("favicon")[0] as HTMLLinkElement;
    if (head) {
      head.href = branding.ICON_PATH;
    }
  }, [branding]);

  const items: React.ReactElement<ActivityItemProps, typeof ActivityItem>[] = [
    <ActivityItem key="Logout" name="" holdSideBar icon={<FontAwesomeIcon icon="sign-out-alt" onClick={() => logout()}/>}/>
  ];

  return (
    <div className="page-wrapper">
      {isLoggedIn &&
      <div className="wrapper-logout">
        <Activity isSideBarVisible={false}>
          {items}
        </Activity>
      </div>
      }
      <div className="main">
        <div className="wrapper-header">
          <div className="label">
            <div className="icon-label">
              <Image src={`${origin}${branding?.LOGO_PATH ?? ""}`} size="tiny" />
            </div>
            <div className="title-label">
              <Header as="h3" disabled/>
            </div>
          </div>
          <div className="language-selector">
            {props.showLanguageSelector && <LanguageSelector/>}
          </div>
        </div>
        <div className="content-container">
          {props.children}
        </div>
        <div className="footer">
          <div className="footer-content">
            <List horizontal link>
              <List.Item>
                <div dangerouslySetInnerHTML={copyright}/>
              </List.Item>
            </List>
          </div>
        </div>
      </div>
    </div>
  );
};

export default PageWrapper;
