import { BoxPanel, Widget } from "@lumino/widgets";
import { Message } from "@lumino/messaging";
import { RBaseWidget, RBaseWidgetProps, WrapperHelper, IWrappedWidget, ILayoutWidget } from "./RBaseWidget";
import { LayoutType } from "components/Layout";

export class WrapperBoxPanel extends BoxPanel implements IWrappedWidget, ILayoutWidget {
  readonly wrapper: WrapperHelper;

  constructor(id: string, name?: string, options?: BoxPanel.IOptions) {
    super(options);
    this.wrapper = new WrapperHelper(this, id, name);
    this.addClass("BoxPanel");
  }

  override onCloseRequest(msg: Message) {
    super.onCloseRequest(msg);
    this.wrapper.publishClose();
  }

  getLayout(): LayoutType | undefined {
    return undefined;
  }

  restoreLayout(obj: LayoutType): void {
    this.wrapper.layoutRestored.publish({ id: this.id });
  }

  protected override onResize(msg: Widget.ResizeMessage): void {
    super.onResize(msg);
    this.wrapper.widgetResize.publish(msg);
  }
}

type RBoxPanelProps = RBaseWidgetProps & {
  direction: BoxPanel.Direction;
};

export class RBoxPanel extends RBaseWidget<RBoxPanelProps, WrapperBoxPanel> {
  protected createLayoutContainer(): WrapperBoxPanel {
    return new WrapperBoxPanel(this.props.id, this.props.name, { direction: this.props.direction });
  }

  override render() {
    return this.renderComponent();
  }
}
