import React, { useEffect, useState } from "react";
import { List } from "semantic-ui-react";
import { API, setCookie } from "@solid/libs";

import "./style.css";

const api = new API();

type Language = {
  tag: string,
  description: string,
  direction: string
};

const LanguageSelector = () => {
  const [languages, setLanguages] = useState<Language[]>([]);
  const [currentLanguage, setCurrentLanguage] = useState("");

  const getLanguages = async () => {
    try {
      const response = await api.getLanguageList();
      setLanguages(response.list as Language[]);
    } catch (e) {
      console.error(e);
    }
  };

  const handleChangeLanguage = (value: string) => {
    localStorage.setItem("language", value);
    // used in old guis
    setCookie("language", value, undefined, "/");

    window.location.reload();
    setCurrentLanguage(value);
  };

  useEffect(() => {
    if (!currentLanguage) {
      const language = localStorage.getItem("language") ?? "en_US";
      setCurrentLanguage(language);
    }
  }, [currentLanguage]);

  useEffect(() => {
    if (languages.length === 0) {
      getLanguages();
    }
  }, [languages]);

  useEffect(() => {
    return () => {
      setLanguages([]);
    };
  }, []);

  return (
    <List horizontal link>
      { languages.length > 0 && languages.map(language =>
        language.tag.includes(currentLanguage.replace("-", "_")) ?
          <List.Item
            key={language.tag}
            onClick={() => handleChangeLanguage(language.tag)}
            as="b"
            className="current-language">
            {language.description}
          </List.Item>
          :
          <List.Item
            key={language.tag}
            onClick={() => handleChangeLanguage(language.tag)}
            as="a">
            {language.description}
          </List.Item>
      )}
    </List>
  );
};

export default LanguageSelector;
