import React from "react";
import { DropdownItemProps } from "semantic-ui-react";
import { __ } from "@solid/libs";
import AutoTable from "./AutoTable";

export type FieldType = "boolean" | "label" | "dropdown" | "string" | "number" | "password";
export type FieldValue = boolean | string | number | null | undefined | Record<string, any>;
export type FieldDescription = {
  label: string;
  type: FieldType;
  value: FieldValue;
  disabled?: boolean;
  required?: boolean;
  hidden?: boolean;
  icon?: React.ReactNode;
  description?: string;
  error?: string;
  options?: DropdownItemProps[];
  max?: number;
  min?: number;
  onChange?: (value?: FieldValue) => void;
  onBlur?: (value?: FieldValue) => void;
  onFocus?: (value?: FieldValue) => void;
};

export type ViewSchema = {
  caption?: string;
  fields: string[];
};

export type FieldSchema = {
  viewType: "table";
  fields: {
    [fieldKey: string]: FieldDescription
  },
  views: ViewSchema[];
};

type FieldEditorProps = {
  schema: FieldSchema;
};

const FieldEditor = ({ schema }: FieldEditorProps) => {
  switch (schema.viewType) {
    case "table":
      return <AutoTable schema={schema} />;

    default:
      return <></>;
  }
};

export default FieldEditor;
