import React from "react";

import {__} from "@solid/libs/i18n";

import { WidgetProps } from "components/Widgets";
import Events, { EventsType } from "components/Events";

import "./style.css";

const UserEventList = (props: WidgetProps) => {
  return (
    <div className="UserEventList">
      <Events
        titleName={__("Users")}
        eventsType={EventsType.Users}
        filterSet={{ users: true, categories: true }}
        liveOnly={false}
        withFilter
        paginate
        {...props}
      />
    </div>
  );
};

export default UserEventList;
