import React from "react";
import { Form } from "semantic-ui-react";
import BaseField, { BaseFieldProps } from "../BaseField";

class CheckboxField extends BaseField {
  constructor(props: BaseFieldProps) {
    super(props);
    this.state = { value: false };
  }

  override getDefaultValue(): any {
    return false;
  }

  override compareValues(a: any, b: any): boolean {
    return (a ?? false) === (b ?? false);
  }

  override render() {
    const { field, value, error, hidden, disabled, readOnly } = this.state;
    if (!field || hidden) {
      return null;
    }
    return (
      <Form.Checkbox
        label={field.label}
        checked={value}
        error={error ? { content: error, pointing: "below" } : undefined}
        disabled={disabled}
        readOnly={readOnly}
        onChange={(e, data) => this.onChange(data.checked)}
        className={`CheckboxField__${field.name}`}
      />
    );
  }
}

export default CheckboxField;
