import React from "react";
import AutoForm, { AutoFormContext, FormSchema } from "../AutoForm";
import AutoField from "../AutoField";

type AutoLayoutProps = {
  names?: string[];
};

type AutoLayoutState = {
  fields: FormSchema;
};

class AutoLayout extends React.Component<AutoLayoutProps, AutoLayoutState> {
  static override contextType = AutoFormContext;
  private id = `${Date.now()}.${Math.random()}`;
  private form?: AutoForm;

  constructor(props: AutoLayoutProps) {
    super(props);
    this.state = { fields: [] };
  }

  override componentDidMount(): void {
    this.form = this.context?.form;
    this.form?.registerObserver(this.id, schema => {
      const fields = !this.props.names ? schema :
        this.props.names
          .map(name => schema.find(field => field?.name === name))
          .filter(field => !!field)
          .map(field => field!);
      this.setState({ fields });
    });
  }

  override componentWillUnmount(): void {
    this.form?.unregisterObserver(this.id);
  }

  override render() {
    const { fields } = this.state;
    if (!fields) {
      return null;
    }

    return (
      <>
        {fields.map(field => field?.name && <AutoField key={field.name} name={field.name}/>)}
      </>
    );
  }
}

export default AutoLayout;
