import React from "react";
import { Modal, Header, List, Button, Icon } from "semantic-ui-react";

import { __ } from "@solid/libs";

import "./style.css";

type SameDevicesModalProps = {
  deviceType: "camera" | "sensor";
  names: string[];
  open: boolean;
  okButtonTittle: string;
  onClose: () => void;
  onCancel: () => void;
  onOk: () => void;
};

const SameDevicesModal = React.memo((props: SameDevicesModalProps) => {
  const { deviceType, names, open, okButtonTittle, onClose, onCancel, onOk } = props;

  return (
    <Modal open={open} onClose={onClose}>
      <Header>
        {__("Warning")}
      </Header>
      <Modal.Content>
        {__("You are adding a new {{device}}, but we found it might have been registered before. Here is the list of other known registrations:", { device: deviceType })}
      </Modal.Content>
      <List celled className="SameDeviceList">
        { names.map((name, index) =>
          <List.Item key={`${name}_${index}`}>{name}</List.Item>) }
      </List>
      <Modal.Actions>
        <Button onClick={onCancel}>
          <Icon name="cancel"/>
          {__("Cancel")}
        </Button>
        <Button color="orange" onClick={onOk}>
          <Icon name="plus"/>
          {okButtonTittle}
        </Button>
      </Modal.Actions>
    </Modal>
  );
});

export default SameDevicesModal;
