import { RealmObjectType } from "@generated/graphql";

export const levelView = "view";
export const levelControl = "control";
export const levelManage = "manage";

export function compareResourceTypes(a: RealmObjectType, b: RealmObjectType): number {
  if (a === b) return 0;
  if (a === RealmObjectType.Zone && b === RealmObjectType.Device) return -1;
  if (a === RealmObjectType.Device && b === RealmObjectType.Zone) return 1;
  return a.toString().localeCompare(b.toString());
}
