import VaeManagement, {VaeManagementProps} from "./VaeManagement";
import React, {useEffect, useState} from "react";
import {Device} from "@core/actions";
import {UUID} from "@solid/types";
import {useDeviceQuery} from "@generated/graphql";
import WithQueryStatus from "components/WithQueryStatus";

type VaeManagementWrapperProps = {
  deviceId: UUID
} & Omit<VaeManagementProps, "device">;

const VaeManagementWrapper = (props: VaeManagementWrapperProps) => {
  const [device, setDevice] = useState<Device | null>(null);
  const {data: devicesData, error: devicesError, loading: devicesLoading} = useDeviceQuery({variables: {id: props.deviceId}});

  useEffect(() => {
    if (devicesData?.device) {
      const device = devicesData.device;
      setDevice(device);
    }
  }, [devicesData]);

  return (
    <WithQueryStatus loading={devicesLoading} error={devicesError}>
      {device && <VaeManagement device={device} {...props}/>}
    </WithQueryStatus>
  );
};

export default VaeManagementWrapper;
