import React, { useEffect, useRef, useState } from "react";
import {origin} from "@core/api";
import Loading from "components/Loading";

import "./style.css";

type VaeConfigIframeProp = {
  deviceId: string;
  engine: string;
  confValue: string;
};

const VaeConfigIframe = ({ deviceId, engine, confValue }: VaeConfigIframeProp) => {
  const [iframeLoading, setIframeLoading] = useState(true);
  const iframeRef = useRef<HTMLIFrameElement>(null);

  useEffect(() => {
    if (!iframeRef.current) {
      return;
    }

    if (iframeRef.current.contentWindow?.onVAELoad) {
      return;
    }

    (iframeRef.current.contentWindow as Window & {onVAELoad: (success: boolean) => void}).onVAELoad = (success: boolean) => {
      setIframeLoading(false);
      if (iframeRef.current &&
          iframeRef.current.contentDocument &&
          iframeRef.current.contentDocument.body) {
        iframeRef.current.contentDocument.body.style.background = "#FFFFFF";
      }
    };
  });

  useEffect(() => {
    return () => {
      if (iframeRef.current?.contentWindow?.onVAELoad) {
        iframeRef.current.contentWindow.onVAELoad = undefined;
      }
    };
  }, []);

  return (
    <div className="VaeConfig-Content">
      <iframe
        ref={iframeRef}
        title="Configuration"
        className="VaeConfig-IFrame"
        src={`${origin}/sdi/vae/${deviceId}/${engine}/index.html?conf=${encodeURIComponent(confValue)}`}
      />
      { iframeLoading && <div className="VaeConfig-IFrameLoading"><Loading/></div> }
    </div>
  );
};

export default VaeConfigIframe;
