import CreateUpdateCamera, {CreateUpdateCameraProps} from "./CreateUpdateCamera";
import React, {useEffect, useState} from "react";
import {Device} from "@core/actions";
import {UUID} from "@solid/types";
import {DevicesByAspectTypesShortQuery, useDeviceLazyQuery} from "@generated/graphql";
import WithQueryStatus from "components/WithQueryStatus";

type CreateUpdateCameraWrapperProps = {
  cameras?: DevicesByAspectTypesShortQuery;
  deviceId?: UUID
} & Omit<CreateUpdateCameraProps, "device">;

const CreateUpdateCameraWrapper = (props: CreateUpdateCameraWrapperProps) => {
  const [device, setDevice] = useState<Device | undefined>(undefined);
  const [getDevice, {data: deviceData, error: deviceError, loading: deviceLoading}] = useDeviceLazyQuery({fetchPolicy: "no-cache"});

  useEffect(() => {
    if (props.deviceId) {
      getDevice({variables: {id: props.deviceId}});
    }
  }, []);

  useEffect(() => {
    if (deviceData?.device) {
      const device = deviceData.device;
      setDevice(device);
    }
  }, [deviceData]);

  return (
    <WithQueryStatus loading={deviceLoading} error={deviceError}>
      <CreateUpdateCamera device={device} {...props} cameras={props.cameras}/>
    </WithQueryStatus>
  );
};

export default CreateUpdateCameraWrapper;
