module.exports = {
	contextSeparator: false,
	// Key separator used in your translation keys

	createOldCatalogs: false,
	// Save the \_old files

	defaultNamespace: 'translation',
	// Default namespace used in your i18next config

	defaultValue: '',
	// Default value to give to empty keys

	indentation: 2,
	// Indentation of the catalog files

	keepRemoved: false,
	// Keep keys from the catalog that are no longer in code

	keySeparator: false,
	// Key separator used in your translation keys
	// If you want to use plain english keys, separators such as `.` and `:` will conflict. You might want to set `keySeparator: false` and `namespaceSeparator: false`. That way, `t('Status: Loading...')` will not think that there are a namespace and three separator dots for instance.

	// see below for more details
	lexers: {
		/*hbs: ['HandlebarsLexer'],
		handlebars: ['HandlebarsLexer'],

		htm: ['HTMLLexer'],
		html: ['HTMLLexer'],

		mjs: ['JavascriptLexer'],*/
		js: [{
			lexer: 'JavascriptLexer',
			functions: ['__'],
		}], // if you're writing jsx inside .js files, change this to JsxLexer
		ts: [
			{
				lexer: 'JavascriptLexer',
				functions: ['__'],
			},
			{
				lexer: 'JsxLexer',
				//transSupportBasicHtmlNodes: true
			}
		],
		jsx: [
			{
				lexer: 'JavascriptLexer',
				functions: ['__'],
			},
			{
				lexer: 'JsxLexer',
				//transSupportBasicHtmlNodes: true
			}
		],
		tsx: [
			{
				lexer: 'JavascriptLexer',
				functions: ['__'],
			},
			{
				lexer: 'JsxLexer',
				//transSupportBasicHtmlNodes: true
			}
		],

		default: ['JavascriptLexer']
	},

	lineEnding: 'auto',
	// Control the line ending. See options at https://github.com/ryanve/eol

	locales: ["ar-AE"],
	// An array of the locales in your applications

	namespaceSeparator: false,
	// Namespace separator used in your translation keys
	// If you want to use plain english keys, separators such as `.` and `:` will conflict. You might want to set `keySeparator: false` and `namespaceSeparator: false`. That way, `t('Status: Loading...')` will not think that there are a namespace and three separator dots for instance.

	output: 'src/generated/locales/$LOCALE/$NAMESPACE.json',
	// Supports $LOCALE and $NAMESPACE injection
	// Supports JSON (.json) and YAML (.yml) file formats
	// Where to write the locale files relative to process.cwd()

	input: [
					'src/components/**/*.{js,ts,tsx}', 
					'src/core/**/*.{js,ts,tsx}',
					'src/electron/*.{js,ts,tsx}',
					'src/pages/**/*.{js,ts,tsx}',
					'src/tour/*.{js,ts,tsx}',
					'../joystick/*.{js,ts,tsx}',
					'../player/*.{js,ts,tsx}',
					'../player-cell/*.{js,ts,tsx}',
					'../timeline/*.{js,ts,tsx}'
				],
	// An array of globs that describe where to look for source files
	// relative to the location of the configuration file

	sort: true,
	// Whether or not to sort the catalog

	skipDefaultValues: true,
	// Whether to ignore default values.

	useKeysAsDefaultValue: false,
	// Whether to use the keys as the default value; ex. "Hello": "Hello", "World": "World"
	// This option takes precedence over the `defaultValue` and `skipDefaultValues` options

	verbose: true,
	// Display info about the parsing including some stats

	failOnWarnings: false,
	// Exit with an exit code of 1 on warnings

	customValueTemplate: null
	// If you wish to customize the value output the value as an object, you can set your own format.
	// ${defaultValue} is the default value you set in your translation function.
	// Any other custom property will be automatically extracted.
	//
	// Example:
	// {
	//   message: "${defaultValue}",
	//   description: "${maxLength}", // t('my-key', {maxLength: 150})
	// }
}
