import { buildClientSchema, getIntrospectionQuery } from "graphql";
import { loadENV } from "./env";
import fetch from "node-fetch";
import { API, Auth, getCookie } from "@solid/libs";

loadENV();

async function getSessionCookie(): Promise<string> {
  let cookie = "";

  const api = new API();
  Auth.setAPI(api);
  try {
    await Auth.login({
      username: process.env.API_USER ?? "",
      password: process.env.API_PASS ?? ""
    });
    const cookies = Auth.api?.lastResponseHeaders ? Auth.api?.lastResponseHeaders["set-cookie"] : [];
    const PHPSESSID = getCookie("PHPSESSID", cookies);

    cookie = `PHPSESSID=${PHPSESSID}`;

    console.log(cookie);
  }
  catch (e) {
    console.error("Cannot login", e);
  }

  return cookie;
}

export default async () => {
  const introspectionQuery = getIntrospectionQuery();
  const cookie = await getSessionCookie();
  const response = await fetch(process.env.API_GRAPHQL_CODEGEN, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      cookie
    },
    body: JSON.stringify({ query: introspectionQuery })
  });

  const data = await response.json() as {data: any};
  return buildClientSchema(data.data);
};
