#!/usr/bin/env node

const legally = require('legally');
const config = require('./config.json');

checkLicenses().then(() => {
  console.log('Licenses checked.');
  process.exit(0);
}).catch(e => {
  console.error('License check error:', e);
  process.exit(1);
});

const unique = (value, index, self) => self.indexOf(value) === index;
const toArray = lic => [...lic.package, ...lic.copying, ...lic.readme].filter(unique);
const plain = licenses => Object.entries(licenses).reduce((obj, [pack, lic]) => ({
  ...obj, [pack]: toArray(lic)
}), {});

async function checkLicenses() {
  console.log('Checking licenses...');
  const licenses = await legally();
  const packLic = plain(licenses);
  let passed = true;
  for (const pack in packLic) {
    if (config.allowedPackages.includes(pack)) {
      continue;
    }
    if (packLic[pack].length === 0) {
      passed = false;
      console.error('Package', pack, '> licenses are not found');
    }
    if (packLic[pack].some(lic => !config.allowedLicenses.includes(lic))) {
      passed = false;
      console.error('Package', pack, '> some of licenses are not allowed: [', packLic[pack].join(', '), ']');
    }
  }
  if (!passed) {
    throw new Error('License check is not passed.');
  }
}
